/*
 * Decompiled with CFR 0.152.
 */
package de.fhg.aisec.ids.idscp2.idscp_core.api.configuration;

import de.fhg.aisec.ids.idscp2.idscp_core.api.configuration.AttestationConfig;
import de.fhg.aisec.ids.idscp2.idscp_core.drivers.DapsDriver;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u0000 \u001a2\u00020\u0001:\u0002\u0019\u001aB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016R\u001e\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001e\u0010\t\u001a\u00020\b2\u0006\u0010\u0003\u001a\u00020\b@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001e\u0010\r\u001a\u00020\f2\u0006\u0010\u0003\u001a\u00020\f@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001e\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0007\u00a8\u0006\u001b"}, d2={"Lde/fhg/aisec/ids/idscp2/idscp_core/api/configuration/Idscp2Configuration;", "", "()V", "<set-?>", "", "ackTimeoutDelay", "getAckTimeoutDelay", "()J", "Lde/fhg/aisec/ids/idscp2/idscp_core/api/configuration/AttestationConfig;", "attestationConfig", "getAttestationConfig", "()Lde/fhg/aisec/ids/idscp2/idscp_core/api/configuration/AttestationConfig;", "Lde/fhg/aisec/ids/idscp2/idscp_core/drivers/DapsDriver;", "dapsDriver", "getDapsDriver", "()Lde/fhg/aisec/ids/idscp2/idscp_core/drivers/DapsDriver;", "handshakeTimeoutDelay", "getHandshakeTimeoutDelay", "equals", "", "other", "hashCode", "", "toString", "", "Builder", "Companion", "idscp2"})
public final class Idscp2Configuration {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private AttestationConfig attestationConfig;
    private DapsDriver dapsDriver;
    private long handshakeTimeoutDelay;
    private long ackTimeoutDelay;
    @NotNull
    public static final String DEFAULT_ACK_TIMEOUT_DELAY = "200";
    @NotNull
    public static final String DEFAULT_HANDSHAKE_TIMEOUT_DELAY = "5000";

    public Idscp2Configuration() {
        String string = DEFAULT_HANDSHAKE_TIMEOUT_DELAY;
        boolean bl = false;
        this.handshakeTimeoutDelay = Integer.parseInt(string);
        string = DEFAULT_ACK_TIMEOUT_DELAY;
        bl = false;
        this.ackTimeoutDelay = Integer.parseInt(string);
    }

    @NotNull
    public final AttestationConfig getAttestationConfig() {
        AttestationConfig attestationConfig = this.attestationConfig;
        if (attestationConfig != null) {
            return attestationConfig;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"attestationConfig");
        throw null;
    }

    @NotNull
    public final DapsDriver getDapsDriver() {
        DapsDriver dapsDriver = this.dapsDriver;
        if (dapsDriver != null) {
            return dapsDriver;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"dapsDriver");
        throw null;
    }

    public final long getHandshakeTimeoutDelay() {
        return this.handshakeTimeoutDelay;
    }

    public final long getAckTimeoutDelay() {
        return this.ackTimeoutDelay;
    }

    public boolean equals(@Nullable Object other) {
        Object object;
        if (this == other) {
            return true;
        }
        if (!Intrinsics.areEqual(this.getClass(), (object = other) == null ? null : object.getClass())) {
            return false;
        }
        if (other == null) {
            throw new NullPointerException("null cannot be cast to non-null type de.fhg.aisec.ids.idscp2.idscp_core.api.configuration.Idscp2Configuration");
        }
        Idscp2Configuration cfr_ignored_0 = (Idscp2Configuration)other;
        if (!Intrinsics.areEqual((Object)this.getAttestationConfig(), (Object)((Idscp2Configuration)other).getAttestationConfig())) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.getDapsDriver(), (Object)((Idscp2Configuration)other).getDapsDriver())) {
            return false;
        }
        if (this.handshakeTimeoutDelay != ((Idscp2Configuration)other).handshakeTimeoutDelay) {
            return false;
        }
        return this.ackTimeoutDelay == ((Idscp2Configuration)other).ackTimeoutDelay;
    }

    public int hashCode() {
        int result = this.getAttestationConfig().hashCode();
        result = 31 * result + this.getDapsDriver().hashCode();
        result = 31 * result + Long.hashCode(this.handshakeTimeoutDelay);
        result = 31 * result + Long.hashCode(this.ackTimeoutDelay);
        return result;
    }

    @NotNull
    public String toString() {
        return "Idscp2Configuration(attestationConfig=" + this.getAttestationConfig() + ", dapsDriver=" + this.getDapsDriver() + ", handshakeTimeoutDelay=" + this.handshakeTimeoutDelay + ", ackTimeoutDelay=" + this.ackTimeoutDelay + ")";
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0005\u001a\u00020\u0004J\u000e\u0010\u0006\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\t\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u000f\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lde/fhg/aisec/ids/idscp2/idscp_core/api/configuration/Idscp2Configuration$Builder;", "", "()V", "settings", "Lde/fhg/aisec/ids/idscp2/idscp_core/api/configuration/Idscp2Configuration;", "build", "setAckTimeoutDelay", "delay", "", "setAttestationConfig", "config", "Lde/fhg/aisec/ids/idscp2/idscp_core/api/configuration/AttestationConfig;", "setDapsDriver", "dapsDriver", "Lde/fhg/aisec/ids/idscp2/idscp_core/drivers/DapsDriver;", "setHandshakeTimeoutDelay", "idscp2"})
    public static final class Builder {
        @NotNull
        private final Idscp2Configuration settings = new Idscp2Configuration();

        @NotNull
        public final Builder setAttestationConfig(@NotNull AttestationConfig config) {
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            this.settings.attestationConfig = config;
            return this;
        }

        @NotNull
        public final Builder setDapsDriver(@NotNull DapsDriver dapsDriver) {
            Intrinsics.checkNotNullParameter((Object)dapsDriver, (String)"dapsDriver");
            this.settings.dapsDriver = dapsDriver;
            return this;
        }

        @NotNull
        public final Builder setHandshakeTimeoutDelay(long delay) {
            this.settings.handshakeTimeoutDelay = delay;
            return this;
        }

        @NotNull
        public final Builder setAckTimeoutDelay(long delay) {
            this.settings.ackTimeoutDelay = delay;
            return this;
        }

        @NotNull
        public final Idscp2Configuration build() {
            return this.settings;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lde/fhg/aisec/ids/idscp2/idscp_core/api/configuration/Idscp2Configuration$Companion;", "", "()V", "DEFAULT_ACK_TIMEOUT_DELAY", "", "DEFAULT_HANDSHAKE_TIMEOUT_DELAY", "idscp2"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

