/*
 * Decompiled with CFR 0.152.
 */
package de.fhg.aisec.ids.idscp2.idscp_core.fsm;

import de.fhg.aisec.ids.idscp2.idscp_core.api.configuration.AttestationConfig;
import de.fhg.aisec.ids.idscp2.idscp_core.fsm.Event;
import de.fhg.aisec.ids.idscp2.idscp_core.fsm.FSM;
import de.fhg.aisec.ids.idscp2.idscp_core.fsm.InternalControlMessage;
import de.fhg.aisec.ids.idscp2.idscp_core.fsm.State;
import de.fhg.aisec.ids.idscp2.idscp_core.fsm.Transition;
import de.fhg.aisec.ids.idscp2.idscp_core.messages.Idscp2MessageHelper;
import de.fhg.aisec.ids.idscp2.messages.IDSCP2;
import java.util.Arrays;
import java.util.concurrent.locks.Condition;
import java.util.stream.Collectors;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0002\u001a\u00020\u0003H\u0016J\u0010\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u00a8\u0006\r"}, d2={"Lde/fhg/aisec/ids/idscp2/idscp_core/fsm/StateClosed;", "Lde/fhg/aisec/ids/idscp2/idscp_core/fsm/State;", "fsm", "Lde/fhg/aisec/ids/idscp2/idscp_core/fsm/FSM;", "onMessageLock", "Ljava/util/concurrent/locks/Condition;", "attestationConfig", "Lde/fhg/aisec/ids/idscp2/idscp_core/api/configuration/AttestationConfig;", "(Lde/fhg/aisec/ids/idscp2/idscp_core/fsm/FSM;Ljava/util/concurrent/locks/Condition;Lde/fhg/aisec/ids/idscp2/idscp_core/api/configuration/AttestationConfig;)V", "runEntryCode", "", "runExitCode", "Companion", "idscp2"})
public final class StateClosed
extends State {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final Logger LOG = LoggerFactory.getLogger(StateClosed.class);

    public StateClosed(final @NotNull FSM fsm, final @NotNull Condition onMessageLock, final @NotNull AttestationConfig attestationConfig) {
        Intrinsics.checkNotNullParameter((Object)fsm, (String)"fsm");
        Intrinsics.checkNotNullParameter((Object)onMessageLock, (String)"onMessageLock");
        Intrinsics.checkNotNullParameter((Object)attestationConfig, (String)"attestationConfig");
        this.addTransition(InternalControlMessage.START_IDSCP_HANDSHAKE.getValue(), new Transition((Function1<? super Event, FSM.FsmResult>)((Function1)new Function1<Event, FSM.FsmResult>(){

            @NotNull
            public final FSM.FsmResult invoke(@NotNull Event it) {
                IDSCP2.IdscpMessage idscpHello;
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (fsm.isFsmLocked()) {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("Cannot start handshake, because FSM is locked forever. Ignored.");
                    }
                    return new FSM.FsmResult(FSM.FsmResultCode.FSM_LOCKED, this);
                }
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Get DAT Token vom DAT_DRIVER");
                }
                byte[] dat = fsm.getDynamicAttributeToken();
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Send IDSCP_HELLO");
                }
                if (!fsm.sendFromFSM(idscpHello = Idscp2MessageHelper.INSTANCE.createIdscpHelloMessage(dat, attestationConfig.getSupportedAttestationSuite(), attestationConfig.getExpectedAttestationSuite()))) {
                    LOG.warn("Cannot send IdscpHello. Close connection");
                    this.runEntryCode(fsm);
                    onMessageLock.signalAll();
                    return new FSM.FsmResult(FSM.FsmResultCode.IO_ERROR, this);
                }
                this.runExitCode(onMessageLock);
                return new FSM.FsmResult(FSM.FsmResultCode.OK, fsm.getState(FSM.FsmState.STATE_WAIT_FOR_HELLO));
            }
        })));
        this.addTransition(InternalControlMessage.REPEAT_RAT.getValue(), new Transition((Function1<? super Event, FSM.FsmResult>)((Function1)new Function1<Event, FSM.FsmResult>(){

            @NotNull
            public final FSM.FsmResult invoke(@NotNull Event it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Received RepeatRat in STATE_CLOSED, ignored.");
                }
                return fsm.isFsmLocked() ? new FSM.FsmResult(FSM.FsmResultCode.FSM_LOCKED, this) : new FSM.FsmResult(FSM.FsmResultCode.FSM_NOT_STARTED, this);
            }
        })));
        this.addTransition(InternalControlMessage.SEND_DATA.getValue(), new Transition((Function1<? super Event, FSM.FsmResult>)((Function1)new Function1<Event, FSM.FsmResult>(){

            @NotNull
            public final FSM.FsmResult invoke(@NotNull Event it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Received SEND in STATE_CLOSED, ignored.");
                }
                return fsm.isFsmLocked() ? new FSM.FsmResult(FSM.FsmResultCode.FSM_LOCKED, this) : new FSM.FsmResult(FSM.FsmResultCode.FSM_NOT_STARTED, this);
            }
        })));
        this.addTransition(InternalControlMessage.IDSCP_STOP.getValue(), new Transition((Function1<? super Event, FSM.FsmResult>)((Function1)new Function1<Event, FSM.FsmResult>(){

            @NotNull
            public final FSM.FsmResult invoke(@NotNull Event it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Received STOP in STATE_CLOSED, ignored.");
                }
                return fsm.isFsmLocked() ? new FSM.FsmResult(FSM.FsmResultCode.FSM_LOCKED, this) : new FSM.FsmResult(FSM.FsmResultCode.FSM_NOT_STARTED, this);
            }
        })));
        this.setNoTransitionHandler(arg_0 -> StateClosed._init_$lambda-1(this, arg_0));
    }

    private final void runExitCode(Condition onMessageLock) {
        onMessageLock.signalAll();
    }

    @Override
    public void runEntryCode(@NotNull FSM fsm) {
        Intrinsics.checkNotNullParameter((Object)fsm, (String)"fsm");
        if (LOG.isTraceEnabled()) {
            LOG.trace("Switched to state STATE_CLOSED");
        }
        fsm.shutdownFsm();
    }

    private static final String lambda-1$lambda-0(StackTraceElement obj) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        return obj.toString();
    }

    private static final FSM.FsmResult _init_$lambda-1(StateClosed this$0, Event it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (LOG.isTraceEnabled()) {
            LOG.trace("No transition available for given event {}, stack trace for analysis:\n{}", (Object)it, (Object)Arrays.stream(Thread.currentThread().getStackTrace()).skip(1L).map(StateClosed::lambda-1$lambda-0).collect(Collectors.joining("\n")));
            LOG.trace("Stay in state STATE_CLOSED");
        }
        return new FSM.FsmResult(FSM.FsmResultCode.UNKNOWN_TRANSITION, this$0);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lde/fhg/aisec/ids/idscp2/idscp_core/fsm/StateClosed$Companion;", "", "()V", "LOG", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "idscp2"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

