/*
 * Decompiled with CFR 0.152.
 */
package de.fhg.aisec.ids.idscp2.idscp_core.fsm;

import com.google.protobuf.InvalidProtocolBufferException;
import de.fhg.aisec.ids.idscp2.idscp_core.api.configuration.AttestationConfig;
import de.fhg.aisec.ids.idscp2.idscp_core.api.idscp_connection.Idscp2Connection;
import de.fhg.aisec.ids.idscp2.idscp_core.drivers.DapsDriver;
import de.fhg.aisec.ids.idscp2.idscp_core.drivers.RatProverDriver;
import de.fhg.aisec.ids.idscp2.idscp_core.drivers.RatVerifierDriver;
import de.fhg.aisec.ids.idscp2.idscp_core.error.Idscp2HandshakeException;
import de.fhg.aisec.ids.idscp2.idscp_core.fsm.AlternatingBit;
import de.fhg.aisec.ids.idscp2.idscp_core.fsm.DynamicTimer;
import de.fhg.aisec.ids.idscp2.idscp_core.fsm.Event;
import de.fhg.aisec.ids.idscp2.idscp_core.fsm.InternalControlMessage;
import de.fhg.aisec.ids.idscp2.idscp_core.fsm.State;
import de.fhg.aisec.ids.idscp2.idscp_core.fsm.StateClosed;
import de.fhg.aisec.ids.idscp2.idscp_core.fsm.StateEstablished;
import de.fhg.aisec.ids.idscp2.idscp_core.fsm.StateWaitForAck;
import de.fhg.aisec.ids.idscp2.idscp_core.fsm.StateWaitForDatAndRat;
import de.fhg.aisec.ids.idscp2.idscp_core.fsm.StateWaitForDatAndRatVerifier;
import de.fhg.aisec.ids.idscp2.idscp_core.fsm.StateWaitForHello;
import de.fhg.aisec.ids.idscp2.idscp_core.fsm.StateWaitForRat;
import de.fhg.aisec.ids.idscp2.idscp_core.fsm.StateWaitForRatProver;
import de.fhg.aisec.ids.idscp2.idscp_core.fsm.StateWaitForRatVerifier;
import de.fhg.aisec.ids.idscp2.idscp_core.fsm.StaticTimer;
import de.fhg.aisec.ids.idscp2.idscp_core.fsm.fsmListeners.RatProverFsmListener;
import de.fhg.aisec.ids.idscp2.idscp_core.fsm.fsmListeners.RatVerifierFsmListener;
import de.fhg.aisec.ids.idscp2.idscp_core.fsm.fsmListeners.ScFsmListener;
import de.fhg.aisec.ids.idscp2.idscp_core.messages.Idscp2MessageHelper;
import de.fhg.aisec.ids.idscp2.idscp_core.rat_registry.RatProverDriverRegistry;
import de.fhg.aisec.ids.idscp2.idscp_core.rat_registry.RatVerifierDriverRegistry;
import de.fhg.aisec.ids.idscp2.idscp_core.secure_channel.SecureChannel;
import de.fhg.aisec.ids.idscp2.messages.IDSCP2;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.HashMap;
import java.util.NoSuchElementException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.GlobalScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u00e2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0015\u0018\u0000 \u0092\u00012\u00020\u00012\u00020\u00022\u00020\u0003:\b\u0092\u0001\u0093\u0001\u0094\u0001\u0095\u0001BC\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\u000b\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010\u00a2\u0006\u0002\u0010\u0012J\b\u0010W\u001a\u00020XH\u0002J\u0006\u0010Y\u001a\u00020ZJ\u0010\u0010[\u001a\u00020Z2\u0006\u0010\\\u001a\u00020]H\u0002J)\u0010^\u001a\u0004\u0018\u00010\u000e2\f\u0010_\u001a\b\u0012\u0004\u0012\u00020\u000e0`2\f\u0010a\u001a\b\u0012\u0004\u0012\u00020\u000e0`\u00a2\u0006\u0002\u0010bJ)\u0010c\u001a\u0004\u0018\u00010\u000e2\f\u0010d\u001a\b\u0012\u0004\u0012\u00020\u000e0`2\f\u0010e\u001a\b\u0012\u0004\u0012\u00020\u000e0`\u00a2\u0006\u0002\u0010bJ\u000e\u0010f\u001a\u00020!2\u0006\u0010g\u001a\u00020SJ+\u0010h\u001a\u0004\u0018\u00010\u000e2\f\u0010i\u001a\b\u0012\u0004\u0012\u00020\u000e0`2\f\u0010j\u001a\b\u0012\u0004\u0012\u00020\u000e0`H\u0002\u00a2\u0006\u0002\u0010bJ\u0006\u0010k\u001a\u00020XJ\u0010\u0010l\u001a\u00020X2\u0006\u0010m\u001a\u00020%H\u0002J\b\u0010n\u001a\u00020XH\u0016J\u0010\u0010o\u001a\u00020X2\u0006\u0010p\u001a\u00020qH\u0002J\u0010\u0010r\u001a\u00020X2\u0006\u0010s\u001a\u00020tH\u0016J\u0010\u0010u\u001a\u00020X2\u0006\u0010m\u001a\u00020%H\u0016J\u0010\u0010v\u001a\u00020X2\u0006\u0010p\u001a\u00020qH\u0016J\u0018\u0010v\u001a\u00020X2\u0006\u0010p\u001a\u00020q2\u0006\u0010w\u001a\u00020%H\u0016J\u0010\u0010x\u001a\u00020X2\u0006\u0010p\u001a\u00020qH\u0016J\u0018\u0010x\u001a\u00020X2\u0006\u0010p\u001a\u00020q2\u0006\u0010w\u001a\u00020%H\u0016J\u0010\u0010y\u001a\u00020Z2\u0006\u0010\\\u001a\u00020]H\u0002J\u0010\u0010z\u001a\u00020X2\u0006\u0010{\u001a\u00020]H\u0002J\u0010\u0010|\u001a\u00020X2\u0006\u0010{\u001a\u00020]H\u0002J\u000e\u0010}\u001a\u00020\u00142\u0006\u0010~\u001a\u00020\u007fJ\u0010\u0010\u0080\u0001\u001a\u00020X2\u0007\u0010m\u001a\u00030\u0081\u0001J\u0007\u0010\u0082\u0001\u001a\u00020ZJ\u0007\u0010\u0083\u0001\u001a\u00020\u0014J\u0007\u0010\u0084\u0001\u001a\u00020\u0014J\u0012\u0010\u0085\u0001\u001a\u00020Z2\t\u0010\u0086\u0001\u001a\u0004\u0018\u00010%J\u0010\u0010\u0087\u0001\u001a\u00020\u00142\u0007\u0010\u0086\u0001\u001a\u00020\u001dJ\u0010\u0010\u0088\u0001\u001a\u00020X2\u0007\u0010\u0086\u0001\u001a\u00020\u001dJ\u0010\u0010\u0089\u0001\u001a\u00020X2\u0007\u0010\u008a\u0001\u001a\u00020%J\u0012\u0010\u008b\u0001\u001a\u00020X2\u0007\u0010\u008c\u0001\u001a\u00020>H\u0016J\u0017\u0010\u008d\u0001\u001a\u00020X2\u0006\u0010A\u001a\u00020\u000e2\u0006\u0010V\u001a\u00020\u000eJ\u0007\u0010\u008e\u0001\u001a\u00020XJ\u0007\u0010\u008f\u0001\u001a\u00020XJ\t\u0010\u0090\u0001\u001a\u00020XH\u0002J\u0007\u0010\u0091\u0001\u001a\u00020XR$\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0013\u001a\u00020\u0014@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001f\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010$\u001a\u00020%8F\u00a2\u0006\u0006\u001a\u0004\b&\u0010'R\u000e\u0010(\u001a\u00020)X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020+X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010,\u001a\u0004\u0018\u00010\u001d8F\u00a2\u0006\u0006\u001a\u0004\b-\u0010.R\u000e\u0010/\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00100\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u00101\u001a\n 3*\u0004\u0018\u00010202X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u00104\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b4\u0010\u0017R\u0011\u00105\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b5\u0010\u0017R\u000e\u00106\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u00107\u001a\u00020%X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b8\u0010'\"\u0004\b9\u0010:R\u000e\u0010;\u001a\u00020)X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010<\u001a\n 3*\u0004\u0018\u00010202X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010=\u001a\u0004\u0018\u00010>X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010?\u001a\u00020%X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010@\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010A\u001a\u00020\u000eX\u0082.\u00a2\u0006\u0002\n\u0000R*\u0010D\u001a\b\u0012\u0002\b\u0003\u0018\u00010C2\f\u0010B\u001a\b\u0012\u0002\b\u0003\u0018\u00010C@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\bE\u0010FR\u000e\u0010G\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010I\u001a\b\u0012\u0002\b\u0003\u0018\u00010H2\f\u0010B\u001a\b\u0012\u0002\b\u0003\u0018\u00010H@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\bJ\u0010KR\u0016\u0010L\u001a\u0004\u0018\u00010>8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bM\u0010NR\u0014\u0010O\u001a\u00020%8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bP\u0010'R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010Q\u001a\u001e\u0012\u0004\u0012\u00020S\u0012\u0004\u0012\u00020!0Rj\u000e\u0012\u0004\u0012\u00020S\u0012\u0004\u0012\u00020!`TX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010U\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010V\u001a\u00020\u000eX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0096\u0001"}, d2={"Lde/fhg/aisec/ids/idscp2/idscp_core/fsm/FSM;", "Lde/fhg/aisec/ids/idscp2/idscp_core/fsm/fsmListeners/RatProverFsmListener;", "Lde/fhg/aisec/ids/idscp2/idscp_core/fsm/fsmListeners/RatVerifierFsmListener;", "Lde/fhg/aisec/ids/idscp2/idscp_core/fsm/fsmListeners/ScFsmListener;", "secureChannel", "Lde/fhg/aisec/ids/idscp2/idscp_core/secure_channel/SecureChannel;", "dapsDriver", "Lde/fhg/aisec/ids/idscp2/idscp_core/drivers/DapsDriver;", "attestationConfig", "Lde/fhg/aisec/ids/idscp2/idscp_core/api/configuration/AttestationConfig;", "ackTimeoutDelay", "", "handshakeTimeoutDelay", "connectionId", "", "connection", "Ljava/util/concurrent/CompletableFuture;", "Lde/fhg/aisec/ids/idscp2/idscp_core/api/idscp_connection/Idscp2Connection;", "(Lde/fhg/aisec/ids/idscp2/idscp_core/secure_channel/SecureChannel;Lde/fhg/aisec/ids/idscp2/idscp_core/drivers/DapsDriver;Lde/fhg/aisec/ids/idscp2/idscp_core/api/configuration/AttestationConfig;JJLjava/lang/String;Ljava/util/concurrent/CompletableFuture;)V", "value", "", "ackFlag", "getAckFlag", "()Z", "setAckFlag", "(Z)V", "ackTimer", "Lde/fhg/aisec/ids/idscp2/idscp_core/fsm/StaticTimer;", "bufferedIdscpData", "Lde/fhg/aisec/ids/idscp2/messages/IDSCP2$IdscpMessage;", "currentRatProverId", "currentRatVerifierId", "currentState", "Lde/fhg/aisec/ids/idscp2/idscp_core/fsm/State;", "datTimer", "Lde/fhg/aisec/ids/idscp2/idscp_core/fsm/DynamicTimer;", "dynamicAttributeToken", "", "getDynamicAttributeToken", "()[B", "expectedAlternatingBit", "Lde/fhg/aisec/ids/idscp2/idscp_core/fsm/AlternatingBit;", "fsmIsBusy", "Ljava/util/concurrent/locks/ReentrantLock;", "getBufferedIdscpMessage", "getGetBufferedIdscpMessage", "()Lde/fhg/aisec/ids/idscp2/messages/IDSCP2$IdscpMessage;", "handshakeResultAvailable", "handshakeTimer", "idscpHandshakeLock", "Ljava/util/concurrent/locks/Condition;", "kotlin.jvm.PlatformType", "isConnected", "isFsmLocked", "isLocked", "localDat", "getLocalDat", "setLocalDat", "([B)V", "nextSendAlternatingBit", "onMessageBlock", "peerCertificate", "Ljava/security/cert/X509Certificate;", "peerDat", "proverHandshakeTimer", "proverMechanism", "<set-?>", "Lde/fhg/aisec/ids/idscp2/idscp_core/drivers/RatProverDriver;", "ratProverDriver", "getRatProverDriver", "()Lde/fhg/aisec/ids/idscp2/idscp_core/drivers/RatProverDriver;", "ratTimer", "Lde/fhg/aisec/ids/idscp2/idscp_core/drivers/RatVerifierDriver;", "ratVerifierDriver", "getRatVerifierDriver", "()Lde/fhg/aisec/ids/idscp2/idscp_core/drivers/RatVerifierDriver;", "remotePeerCertificate", "getRemotePeerCertificate", "()Ljava/security/cert/X509Certificate;", "remotePeerDat", "getRemotePeerDat", "states", "Ljava/util/HashMap;", "Lde/fhg/aisec/ids/idscp2/idscp_core/fsm/FSM$FsmState;", "Lkotlin/collections/HashMap;", "verifierHandshakeTimer", "verifierMechanism", "checkForFsmCycles", "", "closeConnection", "Lde/fhg/aisec/ids/idscp2/idscp_core/fsm/FSM$FsmResultCode;", "feedEvent", "event", "Lde/fhg/aisec/ids/idscp2/idscp_core/fsm/Event;", "getRatProverMechanism", "localSupportedProver", "", "remoteExpectedVerifier", "([Ljava/lang/String;[Ljava/lang/String;)Ljava/lang/String;", "getRatVerifierMechanism", "localExpectedVerifier", "remoteSupportedProver", "getState", "state", "matchRatMechanisms", "primary", "secondary", "notifyHandshakeCompleteLock", "notifyIdscpMsgListener", "data", "onClose", "onControlMessage", "controlMessage", "Lde/fhg/aisec/ids/idscp2/idscp_core/fsm/InternalControlMessage;", "onError", "t", "", "onMessage", "onRatProverMessage", "ratMessage", "onRatVerifierMessage", "onUpperEvent", "processRatProverEvent", "e", "processRatVerifierEvent", "recvAck", "ack", "Lde/fhg/aisec/ids/idscp2/messages/IDSCP2$IdscpAck;", "recvData", "Lde/fhg/aisec/ids/idscp2/messages/IDSCP2$IdscpData;", "repeatRat", "restartRatProverDriver", "restartRatVerifierDriver", "send", "msg", "sendFromFSM", "setBufferedIdscpData", "setPeerDat", "dat", "setPeerX509Certificate", "certificate", "setRatMechanisms", "shutdownFsm", "startIdscpHandshake", "stopRatProverDriver", "stopRatVerifierDriver", "Companion", "FsmResult", "FsmResultCode", "FsmState", "idscp2"})
public final class FSM
implements RatProverFsmListener,
RatVerifierFsmListener,
ScFsmListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SecureChannel secureChannel;
    @NotNull
    private final DapsDriver dapsDriver;
    @NotNull
    private final String connectionId;
    @NotNull
    private final CompletableFuture<Idscp2Connection> connection;
    @NotNull
    private final HashMap<FsmState, State> states;
    @NotNull
    private State currentState;
    @Nullable
    private RatProverDriver<?> ratProverDriver;
    @Nullable
    private RatVerifierDriver<?> ratVerifierDriver;
    @Nullable
    private String currentRatProverId;
    @Nullable
    private String currentRatVerifierId;
    private String proverMechanism;
    private String verifierMechanism;
    @NotNull
    private final ReentrantLock fsmIsBusy;
    private final Condition onMessageBlock;
    private final Condition idscpHandshakeLock;
    private boolean handshakeResultAvailable;
    private boolean isLocked;
    private boolean ackFlag;
    @Nullable
    private IDSCP2.IdscpMessage bufferedIdscpData;
    @NotNull
    private AlternatingBit expectedAlternatingBit;
    @NotNull
    private AlternatingBit nextSendAlternatingBit;
    @NotNull
    private final DynamicTimer datTimer;
    @NotNull
    private final StaticTimer ratTimer;
    @NotNull
    private final StaticTimer handshakeTimer;
    @NotNull
    private final StaticTimer proverHandshakeTimer;
    @NotNull
    private final StaticTimer verifierHandshakeTimer;
    @NotNull
    private final StaticTimer ackTimer;
    @Nullable
    private X509Certificate peerCertificate;
    @NotNull
    private byte[] localDat;
    @NotNull
    private byte[] peerDat;
    private static final Logger LOG = LoggerFactory.getLogger(FSM.class);

    public FSM(@NotNull SecureChannel secureChannel, @NotNull DapsDriver dapsDriver, @NotNull AttestationConfig attestationConfig, long ackTimeoutDelay, long handshakeTimeoutDelay, @NotNull String connectionId, @NotNull CompletableFuture<Idscp2Connection> connection) {
        Intrinsics.checkNotNullParameter((Object)secureChannel, (String)"secureChannel");
        Intrinsics.checkNotNullParameter((Object)dapsDriver, (String)"dapsDriver");
        Intrinsics.checkNotNullParameter((Object)attestationConfig, (String)"attestationConfig");
        Intrinsics.checkNotNullParameter((Object)connectionId, (String)"connectionId");
        Intrinsics.checkNotNullParameter(connection, (String)"connection");
        this.secureChannel = secureChannel;
        this.dapsDriver = dapsDriver;
        this.connectionId = connectionId;
        this.connection = connection;
        this.states = new HashMap();
        this.fsmIsBusy = new ReentrantLock(true);
        this.onMessageBlock = this.fsmIsBusy.newCondition();
        this.idscpHandshakeLock = this.fsmIsBusy.newCondition();
        this.expectedAlternatingBit = new AlternatingBit(false, 1, null);
        this.nextSendAlternatingBit = new AlternatingBit(false, 1, null);
        String string = "INVALID_DAT";
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        this.localDat = byArray;
        string = "INVALID_DAT";
        charset = Charsets.UTF_8;
        bl = false;
        byte[] byArray2 = string.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"(this as java.lang.String).getBytes(charset)");
        this.peerDat = byArray2;
        Runnable handshakeTimeoutHandler = () -> FSM._init_$lambda-9(this);
        Runnable datTimeoutHandler = () -> FSM._init_$lambda-10(this);
        Runnable ratTimeoutHandler = () -> FSM._init_$lambda-11(this);
        Runnable proverTimeoutHandler = () -> FSM._init_$lambda-12(this);
        Runnable verifierTimeoutHandler = () -> FSM._init_$lambda-13(this);
        Runnable ackTimeoutHandler = () -> FSM._init_$lambda-14(this);
        this.datTimer = new DynamicTimer(this.fsmIsBusy, datTimeoutHandler);
        this.handshakeTimer = new StaticTimer(this.fsmIsBusy, handshakeTimeoutHandler, handshakeTimeoutDelay);
        this.proverHandshakeTimer = new StaticTimer(this.fsmIsBusy, proverTimeoutHandler, handshakeTimeoutDelay);
        this.verifierHandshakeTimer = new StaticTimer(this.fsmIsBusy, verifierTimeoutHandler, handshakeTimeoutDelay);
        this.ratTimer = new StaticTimer(this.fsmIsBusy, ratTimeoutHandler, attestationConfig.getRatTimeoutDelay());
        this.ackTimer = new StaticTimer(this.fsmIsBusy, ackTimeoutHandler, ackTimeoutDelay);
        Object object = this.states;
        FsmState fsmState = FsmState.STATE_CLOSED;
        Object object2 = this.onMessageBlock;
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"onMessageBlock");
        object2 = new StateClosed(this, (Condition)object2, attestationConfig);
        boolean bl2 = false;
        object.put(fsmState, object2);
        object = this.states;
        fsmState = FsmState.STATE_WAIT_FOR_HELLO;
        object2 = new StateWaitForHello(this, this.handshakeTimer, this.datTimer, this.dapsDriver, attestationConfig);
        bl2 = false;
        object.put(fsmState, object2);
        object = this.states;
        fsmState = FsmState.STATE_WAIT_FOR_RAT;
        object2 = new StateWaitForRat(this, this.handshakeTimer, this.verifierHandshakeTimer, this.proverHandshakeTimer, this.ratTimer);
        bl2 = false;
        object.put(fsmState, object2);
        object = this.states;
        fsmState = FsmState.STATE_WAIT_FOR_RAT_PROVER;
        object2 = new StateWaitForRatProver(this, this.ratTimer, this.handshakeTimer, this.proverHandshakeTimer, this.ackTimer);
        bl2 = false;
        object.put(fsmState, object2);
        object = this.states;
        fsmState = FsmState.STATE_WAIT_FOR_RAT_VERIFIER;
        object2 = new StateWaitForRatVerifier(this, this.ratTimer, this.handshakeTimer, this.verifierHandshakeTimer, this.ackTimer);
        bl2 = false;
        object.put(fsmState, object2);
        object = this.states;
        fsmState = FsmState.STATE_WAIT_FOR_DAT_AND_RAT;
        object2 = new StateWaitForDatAndRat(this, this.handshakeTimer, this.proverHandshakeTimer, this.datTimer, this.dapsDriver);
        bl2 = false;
        object.put(fsmState, object2);
        object = this.states;
        fsmState = FsmState.STATE_WAIT_FOR_DAT_AND_RAT_VERIFIER;
        object2 = new StateWaitForDatAndRatVerifier(this, this.handshakeTimer, this.datTimer, this.dapsDriver);
        bl2 = false;
        object.put(fsmState, object2);
        object = this.states;
        fsmState = FsmState.STATE_ESTABLISHED;
        object2 = new StateEstablished(this, this.ratTimer, this.handshakeTimer, this.ackTimer, this.nextSendAlternatingBit);
        bl2 = false;
        object.put(fsmState, object2);
        object = this.states;
        fsmState = FsmState.STATE_WAIT_FOR_ACK;
        object2 = new StateWaitForAck(this, this.ratTimer, this.handshakeTimer, this.ackTimer);
        bl2 = false;
        object.put(fsmState, object2);
        State state = this.states.get((Object)FsmState.STATE_CLOSED);
        Intrinsics.checkNotNull((Object)state);
        object = state;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"states[FsmState.STATE_CLOSED]!!");
        this.currentState = (State)object;
    }

    @Nullable
    public final RatProverDriver<?> getRatProverDriver() {
        return this.ratProverDriver;
    }

    @Nullable
    public final RatVerifierDriver<?> getRatVerifierDriver() {
        return this.ratVerifierDriver;
    }

    public final boolean getAckFlag() {
        return this.ackFlag;
    }

    public final void setAckFlag(boolean value) {
        this.ackFlag = value;
        if (!value) {
            this.bufferedIdscpData = null;
        }
    }

    @NotNull
    public final byte[] getLocalDat() {
        return this.localDat;
    }

    public final void setLocalDat(@NotNull byte[] byArray) {
        Intrinsics.checkNotNullParameter((Object)byArray, (String)"<set-?>");
        this.localDat = byArray;
    }

    public final void setPeerDat(@NotNull byte[] dat) {
        Intrinsics.checkNotNullParameter((Object)dat, (String)"dat");
        this.peerDat = dat;
    }

    private final void checkForFsmCycles() {
        if (this.fsmIsBusy.isHeldByCurrentThread()) {
            RuntimeException e = new RuntimeException("The current thread holds the fsm lock already. A circle might occur that could lead to undefined behaviour within the fsm");
            LOG.error(e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onMessage(@NotNull byte[] data) {
        IDSCP2.IdscpMessage idscpMessage;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        this.checkForFsmCycles();
        try {
            idscpMessage = IDSCP2.IdscpMessage.parseFrom(data);
            Intrinsics.checkNotNullExpressionValue((Object)idscpMessage, (String)"{\n            IdscpMessage.parseFrom(data)\n        }");
        }
        catch (InvalidProtocolBufferException e) {
            LOG.warn("Cannot parse raw data into IdscpMessage {}", (Object)data);
            return;
        }
        IDSCP2.IdscpMessage message = idscpMessage;
        Event event = new Event(message);
        this.fsmIsBusy.lock();
        try {
            while (Intrinsics.areEqual((Object)this.currentState, (Object)this.states.get((Object)FsmState.STATE_CLOSED))) {
                if (this.isLocked) {
                    return;
                }
                try {
                    this.onMessageBlock.await();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            this.feedEvent(event);
        }
        finally {
            this.fsmIsBusy.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void onControlMessage(InternalControlMessage controlMessage) {
        Event e = new Event(controlMessage);
        this.fsmIsBusy.lock();
        try {
            this.feedEvent(e);
        }
        finally {
            this.fsmIsBusy.unlock();
        }
    }

    @Override
    public void onRatProverMessage(@NotNull InternalControlMessage controlMessage, @NotNull byte[] ratMessage) {
        Intrinsics.checkNotNullParameter((Object)((Object)controlMessage), (String)"controlMessage");
        Intrinsics.checkNotNullParameter((Object)ratMessage, (String)"ratMessage");
        this.processRatProverEvent(new Event(controlMessage, Idscp2MessageHelper.INSTANCE.createIdscpRatProverMessage(ratMessage)));
    }

    @Override
    public void onRatProverMessage(@NotNull InternalControlMessage controlMessage) {
        Intrinsics.checkNotNullParameter((Object)((Object)controlMessage), (String)"controlMessage");
        this.processRatProverEvent(new Event(controlMessage));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void processRatProverEvent(Event e) {
        this.checkForFsmCycles();
        this.fsmIsBusy.lock();
        try {
            if (Intrinsics.areEqual((Object)String.valueOf(Thread.currentThread().getId()), (Object)this.currentRatProverId)) {
                this.feedEvent(e);
            } else {
                LOG.warn("An old or unknown Thread (" + Thread.currentThread().getId() + ") calls onRatProverMessage()");
            }
        }
        finally {
            this.fsmIsBusy.unlock();
        }
    }

    @Override
    public void onRatVerifierMessage(@NotNull InternalControlMessage controlMessage, @NotNull byte[] ratMessage) {
        Intrinsics.checkNotNullParameter((Object)((Object)controlMessage), (String)"controlMessage");
        Intrinsics.checkNotNullParameter((Object)ratMessage, (String)"ratMessage");
        this.processRatVerifierEvent(new Event(controlMessage, Idscp2MessageHelper.INSTANCE.createIdscpRatVerifierMessage(ratMessage)));
    }

    @Override
    public void onRatVerifierMessage(@NotNull InternalControlMessage controlMessage) {
        Intrinsics.checkNotNullParameter((Object)((Object)controlMessage), (String)"controlMessage");
        this.processRatVerifierEvent(new Event(controlMessage));
    }

    @Override
    @NotNull
    public byte[] getRemotePeerDat() {
        return this.peerDat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void processRatVerifierEvent(Event e) {
        this.checkForFsmCycles();
        this.fsmIsBusy.lock();
        try {
            if (Intrinsics.areEqual((Object)String.valueOf(Thread.currentThread().getId()), (Object)this.currentRatVerifierId)) {
                this.feedEvent(e);
            } else {
                LOG.warn("An old or unknown Thread (" + Thread.currentThread().getId() + ") calls onRatVerifierMessage()");
            }
        }
        finally {
            this.fsmIsBusy.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final FsmResultCode onUpperEvent(Event event) {
        this.checkForFsmCycles();
        this.fsmIsBusy.lock();
        try {
            FsmResultCode fsmResultCode = this.feedEvent(event);
            return fsmResultCode;
        }
        finally {
            this.fsmIsBusy.unlock();
        }
    }

    private final FsmResultCode feedEvent(Event event) {
        State prevState = this.currentState;
        FsmResult result = this.currentState.feedEvent(event);
        this.currentState = result.getNextState();
        if (!Intrinsics.areEqual((Object)prevState, (Object)this.currentState)) {
            this.currentState.runEntryCode(this);
        }
        return result.getCode();
    }

    @NotNull
    public final FsmResultCode closeConnection() {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Sending stop message to connection peer...");
        }
        return this.onUpperEvent(new Event(InternalControlMessage.IDSCP_STOP));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void startIdscpHandshake() throws Idscp2HandshakeException {
        block9: {
            this.checkForFsmCycles();
            this.fsmIsBusy.lock();
            try {
                if (Intrinsics.areEqual((Object)this.currentState, (Object)this.states.get((Object)FsmState.STATE_CLOSED))) {
                    if (this.isLocked) {
                        throw new Idscp2HandshakeException("FSM is in a final closed state forever");
                    }
                    this.onControlMessage(InternalControlMessage.START_IDSCP_HANDSHAKE);
                    while (!this.handshakeResultAvailable) {
                        this.idscpHandshakeLock.await();
                    }
                    if (!this.isConnected() && this.isLocked) {
                        throw new Idscp2HandshakeException("Handshake failed");
                    }
                    break block9;
                }
                throw new Idscp2HandshakeException("Handshake has already been started");
            }
            catch (InterruptedException e) {
                throw new Idscp2HandshakeException("Handshake failed because thread was interrupted");
            }
            finally {
                this.fsmIsBusy.unlock();
            }
        }
    }

    public final boolean sendFromFSM(@NotNull IDSCP2.IdscpMessage msg) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        try {
            byte[] byArray = msg.toByteArray();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"msg.toByteArray()");
            bl = this.secureChannel.send(byArray);
        }
        catch (Exception e) {
            LOG.error("Exception occurred during sending data via the secure channel: {}", (Throwable)e);
            bl = false;
        }
        return bl;
    }

    @Override
    public void onError(@NotNull Throwable t) {
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        if (!this.isFsmLocked()) {
            this.connection.thenAcceptAsync(arg_0 -> FSM.onError$lambda-0(t, arg_0));
        }
        this.checkForFsmCycles();
        this.onControlMessage(InternalControlMessage.ERROR);
    }

    @Override
    public void onClose() {
        this.onUpperEvent(new Event(InternalControlMessage.IDSCP_STOP));
    }

    @Override
    public void setPeerX509Certificate(@NotNull X509Certificate certificate) {
        Intrinsics.checkNotNullParameter((Object)certificate, (String)"certificate");
        this.peerCertificate = certificate;
    }

    @Override
    @Nullable
    public X509Certificate getRemotePeerCertificate() {
        return this.peerCertificate;
    }

    @NotNull
    public final FsmResultCode send(@Nullable byte[] msg) {
        IDSCP2.IdscpMessage idscpMessage = Idscp2MessageHelper.INSTANCE.createIdscpDataMessage(msg);
        return this.onUpperEvent(new Event(InternalControlMessage.SEND_DATA, idscpMessage));
    }

    @NotNull
    public final FsmResultCode repeatRat() {
        return this.onUpperEvent(new Event(InternalControlMessage.REPEAT_RAT));
    }

    @NotNull
    public final byte[] getDynamicAttributeToken() {
        byte[] byArray;
        try {
            byte[] token = this.dapsDriver.getToken();
            this.localDat = token;
        }
        catch (Exception e) {
            LOG.error("Exception occurred during requesting DAT from DAPS:", (Throwable)e);
            String string = "INVALID_DAT";
            Charset charset = StandardCharsets.UTF_8;
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
            boolean bl = false;
            byte[] byArray2 = string.getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"(this as java.lang.String).getBytes(charset)");
            byArray = byArray2;
        }
        return byArray;
    }

    public final boolean isConnected() {
        return Intrinsics.areEqual((Object)this.currentState, (Object)this.states.get((Object)FsmState.STATE_ESTABLISHED)) || Intrinsics.areEqual((Object)this.currentState, (Object)this.states.get((Object)FsmState.STATE_WAIT_FOR_ACK));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void notifyHandshakeCompleteLock() {
        this.fsmIsBusy.lock();
        try {
            this.handshakeResultAvailable = true;
            this.idscpHandshakeLock.signal();
        }
        finally {
            this.fsmIsBusy.unlock();
        }
    }

    @Nullable
    public final String getRatProverMechanism(@NotNull String[] localSupportedProver, @NotNull String[] remoteExpectedVerifier) {
        Intrinsics.checkNotNullParameter((Object)localSupportedProver, (String)"localSupportedProver");
        Intrinsics.checkNotNullParameter((Object)remoteExpectedVerifier, (String)"remoteExpectedVerifier");
        Object[] objectArray = localSupportedProver;
        boolean bl = false;
        if (objectArray.length == 0) {
            LOG.warn("Got empty RAT localSupportedProver suite");
            return null;
        }
        objectArray = remoteExpectedVerifier;
        bl = false;
        if (objectArray.length == 0) {
            LOG.warn("Got empty RAT remoteExpectedVerifier suite");
            return null;
        }
        if (LOG.isTraceEnabled()) {
            objectArray = localSupportedProver;
            bl = false;
            String string = Arrays.toString(objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"java.util.Arrays.toString(this)");
            objectArray = remoteExpectedVerifier;
            bl = false;
            String string2 = Arrays.toString(objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.util.Arrays.toString(this)");
            LOG.trace("Calculate RAT prover mechanism for given local provers: {} and remote verifiers: {}", (Object)string, (Object)string2);
        }
        String match = this.matchRatMechanisms(remoteExpectedVerifier, localSupportedProver);
        if (LOG.isDebugEnabled()) {
            LOG.debug("RAT prover mechanism: '{}'", (Object)match);
        }
        return match;
    }

    @Nullable
    public final String getRatVerifierMechanism(@NotNull String[] localExpectedVerifier, @NotNull String[] remoteSupportedProver) {
        Intrinsics.checkNotNullParameter((Object)localExpectedVerifier, (String)"localExpectedVerifier");
        Intrinsics.checkNotNullParameter((Object)remoteSupportedProver, (String)"remoteSupportedProver");
        Object[] objectArray = localExpectedVerifier;
        boolean bl = false;
        if (objectArray.length == 0) {
            LOG.warn("Got empty RAT localExpectedVerifier suite");
            return null;
        }
        objectArray = remoteSupportedProver;
        bl = false;
        if (objectArray.length == 0) {
            LOG.warn("Got empty RAT remoteSupportedProver suite");
            return null;
        }
        if (LOG.isTraceEnabled()) {
            objectArray = localExpectedVerifier;
            bl = false;
            String string = Arrays.toString(objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"java.util.Arrays.toString(this)");
            objectArray = remoteSupportedProver;
            bl = false;
            String string2 = Arrays.toString(objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.util.Arrays.toString(this)");
            LOG.trace("Calculate RAT verifier mechanism for given local verifiers: {} and remote provers: {}", (Object)string, (Object)string2);
        }
        String match = this.matchRatMechanisms(localExpectedVerifier, remoteSupportedProver);
        if (LOG.isDebugEnabled()) {
            LOG.debug("RAT verifier mechanism: '{}'", (Object)match);
        }
        return match;
    }

    private final String matchRatMechanisms(String[] primary, String[] secondary) {
        String[] stringArray = primary;
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            String p = stringArray[n];
            ++n;
            for (String s : secondary) {
                if (!Intrinsics.areEqual((Object)p, (Object)s)) continue;
                return p;
            }
        }
        return null;
    }

    public final boolean restartRatVerifierDriver() {
        boolean bl;
        boolean bl2;
        Boolean bl3;
        this.stopRatVerifierDriver();
        String string = this.verifierMechanism;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"verifierMechanism");
            throw null;
        }
        this.ratVerifierDriver = RatVerifierDriverRegistry.INSTANCE.startRatVerifierDriver(string, this);
        RatVerifierDriver<?> ratVerifierDriver = this.ratVerifierDriver;
        if (ratVerifierDriver == null) {
            bl3 = null;
        } else {
            RatVerifierDriver<?> ratVerifierDriver2 = ratVerifierDriver;
            bl2 = false;
            boolean bl4 = false;
            RatVerifierDriver<?> it = ratVerifierDriver2;
            boolean bl5 = false;
            this.currentRatVerifierId = String.valueOf(it.getId());
            if (LOG.isTraceEnabled()) {
                LOG.trace("Start verifier_handshake timeout");
            }
            this.verifierHandshakeTimer.resetTimeout();
            bl3 = true;
        }
        string = bl3;
        if (string == null) {
            ratVerifierDriver = this;
            boolean bl6 = false;
            bl2 = false;
            FSM $this$restartRatVerifierDriver_u24lambda_u2d2 = (FSM)((Object)ratVerifierDriver);
            boolean bl7 = false;
            LOG.error("Cannot create instance of RAT_VERIFIER_DRIVER");
            $this$restartRatVerifierDriver_u24lambda_u2d2.currentRatVerifierId = "";
            bl = false;
        } else {
            bl = (Boolean)((Object)string);
        }
        return bl;
    }

    public final void stopRatVerifierDriver() {
        this.verifierHandshakeTimer.cancelTimeout();
        RatVerifierDriver<?> ratVerifierDriver = this.ratVerifierDriver;
        if (ratVerifierDriver != null) {
            RatVerifierDriver<?> ratVerifierDriver2 = ratVerifierDriver;
            boolean bl = false;
            boolean bl2 = false;
            RatVerifierDriver<?> it = ratVerifierDriver2;
            boolean bl3 = false;
            if (it.isAlive()) {
                it.interrupt();
                BuildersKt.launch$default((CoroutineScope)((CoroutineScope)GlobalScope.INSTANCE), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(it, null){
                    int label;
                    final /* synthetic */ RatVerifierDriver<?> $it;
                    {
                        this.$it = $it;
                        super(2, $completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                this.$it.terminate();
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)3, null);
            }
        }
    }

    public final boolean restartRatProverDriver() {
        boolean bl;
        boolean bl2;
        Boolean bl3;
        this.stopRatProverDriver();
        String string = this.proverMechanism;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"proverMechanism");
            throw null;
        }
        this.ratProverDriver = RatProverDriverRegistry.INSTANCE.startRatProverDriver(string, this);
        RatProverDriver<?> ratProverDriver = this.ratProverDriver;
        if (ratProverDriver == null) {
            bl3 = null;
        } else {
            RatProverDriver<?> ratProverDriver2 = ratProverDriver;
            bl2 = false;
            boolean bl4 = false;
            RatProverDriver<?> it = ratProverDriver2;
            boolean bl5 = false;
            this.currentRatProverId = String.valueOf(it.getId());
            if (LOG.isTraceEnabled()) {
                LOG.trace("Start prover_handshake timeout");
            }
            this.proverHandshakeTimer.resetTimeout();
            bl3 = true;
        }
        string = bl3;
        if (string == null) {
            ratProverDriver = this;
            boolean bl6 = false;
            bl2 = false;
            FSM $this$restartRatProverDriver_u24lambda_u2d5 = (FSM)((Object)ratProverDriver);
            boolean bl7 = false;
            LOG.error("Cannot create instance of RAT_PROVER_DRIVER");
            $this$restartRatProverDriver_u24lambda_u2d5.currentRatProverId = "";
            bl = false;
        } else {
            bl = (Boolean)((Object)string);
        }
        return bl;
    }

    private final void stopRatProverDriver() {
        this.proverHandshakeTimer.cancelTimeout();
        RatProverDriver<?> ratProverDriver = this.ratProverDriver;
        if (ratProverDriver != null) {
            RatProverDriver<?> ratProverDriver2 = ratProverDriver;
            boolean bl = false;
            boolean bl2 = false;
            RatProverDriver<?> it = ratProverDriver2;
            boolean bl3 = false;
            if (it.isAlive()) {
                it.interrupt();
                BuildersKt.launch$default((CoroutineScope)((CoroutineScope)GlobalScope.INSTANCE), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(it, null){
                    int label;
                    final /* synthetic */ RatProverDriver<?> $it;
                    {
                        this.$it = $it;
                        super(2, $completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                this.$it.terminate();
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)3, null);
            }
        }
    }

    public final void shutdownFsm() {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Shutting down FSM of connection {}...", (Object)this.connectionId);
            LOG.trace("Running close handlers of connection {}...", (Object)this.connectionId);
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Mark FSM as terminated...");
        }
        this.isLocked = true;
        BuildersKt.launch$default((CoroutineScope)((CoroutineScope)GlobalScope.INSTANCE), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ FSM this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        if (FSM.access$getLOG$cp().isTraceEnabled()) {
                            FSM.access$getLOG$cp().trace("Closing secure channel of connection {}...", (Object)FSM.access$getConnectionId$p(this.this$0));
                        }
                        FSM.access$getSecureChannel$p(this.this$0).close();
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Clearing timeouts...");
        }
        this.datTimer.cancelTimeout();
        this.ratTimer.cancelTimeout();
        this.handshakeTimer.cancelTimeout();
        this.ackTimer.cancelTimeout();
        if (LOG.isTraceEnabled()) {
            LOG.trace("Stopping RAT components...");
        }
        this.stopRatProverDriver();
        this.stopRatVerifierDriver();
        if (!this.handshakeResultAvailable) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Notify handshake lock...");
            }
            this.notifyHandshakeCompleteLock();
        }
        this.connection.thenAcceptAsync(FSM::shutdownFsm$lambda-7);
    }

    private final void notifyIdscpMsgListener(byte[] data) {
        this.connection.thenAcceptAsync(arg_0 -> FSM.notifyIdscpMsgListener$lambda-8(data, arg_0));
    }

    public final boolean isFsmLocked() {
        return this.isLocked;
    }

    @NotNull
    public final State getState(@NotNull FsmState state) {
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
        State state2 = this.states.get((Object)state);
        if (state2 == null) {
            throw new NoSuchElementException("State unknown");
        }
        return state2;
    }

    public final void setRatMechanisms(@NotNull String proverMechanism, @NotNull String verifierMechanism) {
        Intrinsics.checkNotNullParameter((Object)proverMechanism, (String)"proverMechanism");
        Intrinsics.checkNotNullParameter((Object)verifierMechanism, (String)"verifierMechanism");
        this.proverMechanism = proverMechanism;
        this.verifierMechanism = verifierMechanism;
    }

    @Nullable
    public final IDSCP2.IdscpMessage getGetBufferedIdscpMessage() {
        return this.bufferedIdscpData;
    }

    /*
     * Enabled aggressive block sorting
     */
    public final boolean recvAck(@NotNull IDSCP2.IdscpAck ack) {
        Intrinsics.checkNotNullParameter((Object)ack, (String)"ack");
        if (!this.ackFlag) {
            LOG.warn("Received unexpected IdscpAck");
            return false;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Received IdscpAck with alternating bit {}, cancel flag in fsm", (Object)ack.getAlternatingBit());
        }
        if (this.nextSendAlternatingBit.asBoolean() != ack.getAlternatingBit()) {
            if (!LOG.isTraceEnabled()) return false;
            LOG.trace("Received IdscpAck with wrong alternating bit. Ignoring");
            return false;
        }
        this.setAckFlag(false);
        this.ackTimer.cancelTimeout();
        if (LOG.isTraceEnabled()) {
            LOG.trace("Alternate nextSend bit from {}", (Object)this.nextSendAlternatingBit.asBoolean());
        }
        this.nextSendAlternatingBit.alternate();
        return true;
    }

    public final void recvData(@NotNull IDSCP2.IdscpData data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        if (LOG.isTraceEnabled()) {
            LOG.trace("Received IdscpData with alternating bit {}", (Object)data.getAlternatingBit());
        }
        if (data.getAlternatingBit() != this.expectedAlternatingBit.asBoolean()) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Received IdscpData with unexpected alternating bit. Could be an old packet replayed. Ignore it.");
            }
        } else {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Send IdscpAck with received alternating bit {}", (Object)data.getAlternatingBit());
            }
            if (!this.sendFromFSM(Idscp2MessageHelper.INSTANCE.createIdscpAckMessage(data.getAlternatingBit()))) {
                LOG.error("Cannot send ACK");
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace("Alternate expected bit from {}", (Object)this.expectedAlternatingBit.asBoolean());
            }
            this.expectedAlternatingBit.alternate();
            byte[] byArray = data.getData().toByteArray();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"data.data.toByteArray()");
            this.notifyIdscpMsgListener(byArray);
        }
    }

    public final void setBufferedIdscpData(@NotNull IDSCP2.IdscpMessage msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        this.bufferedIdscpData = msg;
    }

    private static final void onError$lambda-0(Throwable $t, Idscp2Connection connection) {
        Intrinsics.checkNotNullParameter((Object)$t, (String)"$t");
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        connection.onError($t);
    }

    private static final void shutdownFsm$lambda-7(Idscp2Connection connection) {
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        connection.onClose();
    }

    private static final void notifyIdscpMsgListener$lambda-8(byte[] $data, Idscp2Connection connection) {
        Intrinsics.checkNotNullParameter((Object)$data, (String)"$data");
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        connection.onMessage($data);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Idscp data has been passed to connection listener");
        }
    }

    private static final void _init_$lambda-9(FSM this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        if (LOG.isTraceEnabled()) {
            LOG.trace("HANDSHAKE_TIMER_EXPIRED");
        }
        this$0.onControlMessage(InternalControlMessage.TIMEOUT);
    }

    private static final void _init_$lambda-10(FSM this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        if (LOG.isTraceEnabled()) {
            LOG.trace("DAT_TIMER_EXPIRED");
        }
        this$0.onControlMessage(InternalControlMessage.DAT_TIMER_EXPIRED);
    }

    private static final void _init_$lambda-11(FSM this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        if (LOG.isTraceEnabled()) {
            LOG.trace("RAT_TIMER_EXPIRED");
        }
        this$0.onControlMessage(InternalControlMessage.REPEAT_RAT);
    }

    private static final void _init_$lambda-12(FSM this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        if (LOG.isTraceEnabled()) {
            LOG.trace("RAT_PROVER_HANDSHAKE_TIMER_EXPIRED");
        }
        this$0.onControlMessage(InternalControlMessage.TIMEOUT);
    }

    private static final void _init_$lambda-13(FSM this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        if (LOG.isTraceEnabled()) {
            LOG.trace("RAT_VERIFIER_HANDSHAKE_TIMER_EXPIRED");
        }
        this$0.onControlMessage(InternalControlMessage.TIMEOUT);
    }

    private static final void _init_$lambda-14(FSM this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        if (LOG.isTraceEnabled()) {
            LOG.trace("ACK_TIMER_EXPIRED");
        }
        this$0.onControlMessage(InternalControlMessage.ACK_TIMER_EXPIRED);
    }

    public static final /* synthetic */ Logger access$getLOG$cp() {
        return LOG;
    }

    public static final /* synthetic */ String access$getConnectionId$p(FSM $this) {
        return $this.connectionId;
    }

    public static final /* synthetic */ SecureChannel access$getSecureChannel$p(FSM $this) {
        return $this.secureChannel;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u000b\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000b\u00a8\u0006\f"}, d2={"Lde/fhg/aisec/ids/idscp2/idscp_core/fsm/FSM$FsmState;", "", "(Ljava/lang/String;I)V", "STATE_CLOSED", "STATE_WAIT_FOR_HELLO", "STATE_WAIT_FOR_RAT", "STATE_WAIT_FOR_RAT_VERIFIER", "STATE_WAIT_FOR_RAT_PROVER", "STATE_WAIT_FOR_DAT_AND_RAT_VERIFIER", "STATE_WAIT_FOR_DAT_AND_RAT", "STATE_ESTABLISHED", "STATE_WAIT_FOR_ACK", "idscp2"})
    public static final class FsmState
    extends Enum<FsmState> {
        public static final /* enum */ FsmState STATE_CLOSED = new FsmState();
        public static final /* enum */ FsmState STATE_WAIT_FOR_HELLO = new FsmState();
        public static final /* enum */ FsmState STATE_WAIT_FOR_RAT = new FsmState();
        public static final /* enum */ FsmState STATE_WAIT_FOR_RAT_VERIFIER = new FsmState();
        public static final /* enum */ FsmState STATE_WAIT_FOR_RAT_PROVER = new FsmState();
        public static final /* enum */ FsmState STATE_WAIT_FOR_DAT_AND_RAT_VERIFIER = new FsmState();
        public static final /* enum */ FsmState STATE_WAIT_FOR_DAT_AND_RAT = new FsmState();
        public static final /* enum */ FsmState STATE_ESTABLISHED = new FsmState();
        public static final /* enum */ FsmState STATE_WAIT_FOR_ACK = new FsmState();
        private static final /* synthetic */ FsmState[] $VALUES;

        public static FsmState[] values() {
            return (FsmState[])$VALUES.clone();
        }

        public static FsmState valueOf(String value) {
            return Enum.valueOf(FsmState.class, value);
        }

        static {
            $VALUES = fsmStateArray = new FsmState[]{FsmState.STATE_CLOSED, FsmState.STATE_WAIT_FOR_HELLO, FsmState.STATE_WAIT_FOR_RAT, FsmState.STATE_WAIT_FOR_RAT_VERIFIER, FsmState.STATE_WAIT_FOR_RAT_PROVER, FsmState.STATE_WAIT_FOR_DAT_AND_RAT_VERIFIER, FsmState.STATE_WAIT_FOR_DAT_AND_RAT, FsmState.STATE_ESTABLISHED, FsmState.STATE_WAIT_FOR_ACK};
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0010\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012\u00a8\u0006\u0013"}, d2={"Lde/fhg/aisec/ids/idscp2/idscp_core/fsm/FSM$FsmResultCode;", "", "value", "", "(Ljava/lang/String;ILjava/lang/String;)V", "getValue", "()Ljava/lang/String;", "UNKNOWN_TRANSITION", "FSM_LOCKED", "FSM_NOT_STARTED", "MISSING_DAT", "INVALID_DAT", "IO_ERROR", "RAT_ERROR", "RAT_NEGOTIATION_ERROR", "WOULD_BLOCK", "NOT_CONNECTED", "IDSCP_DATA_NOT_CACHED", "OK", "idscp2"})
    public static final class FsmResultCode
    extends Enum<FsmResultCode> {
        @NotNull
        private final String value;
        public static final /* enum */ FsmResultCode UNKNOWN_TRANSITION = new FsmResultCode("No transition available for given event in current state.");
        public static final /* enum */ FsmResultCode FSM_LOCKED = new FsmResultCode("FSM is locked forever.");
        public static final /* enum */ FsmResultCode FSM_NOT_STARTED = new FsmResultCode("Handshake was never started.");
        public static final /* enum */ FsmResultCode MISSING_DAT = new FsmResultCode("DAT is missing.");
        public static final /* enum */ FsmResultCode INVALID_DAT = new FsmResultCode("DAT is invalid.");
        public static final /* enum */ FsmResultCode IO_ERROR = new FsmResultCode("Secure channel not available.");
        public static final /* enum */ FsmResultCode RAT_ERROR = new FsmResultCode("RAT error occurred.");
        public static final /* enum */ FsmResultCode RAT_NEGOTIATION_ERROR = new FsmResultCode("Error during negotiation of RAT mechanisms.");
        public static final /* enum */ FsmResultCode WOULD_BLOCK = new FsmResultCode("Operation would block until FSM is in state 'ESTABLISHED'");
        public static final /* enum */ FsmResultCode NOT_CONNECTED = new FsmResultCode("Protocol is not in a connected state at the moment.");
        public static final /* enum */ FsmResultCode IDSCP_DATA_NOT_CACHED = new FsmResultCode("IdscpData must be buffered in the 'WAIT_FOR_ACK' state.");
        public static final /* enum */ FsmResultCode OK = new FsmResultCode("Action succeed.");
        private static final /* synthetic */ FsmResultCode[] $VALUES;

        private FsmResultCode(String value) {
            this.value = value;
        }

        @NotNull
        public final String getValue() {
            return this.value;
        }

        public static FsmResultCode[] values() {
            return (FsmResultCode[])$VALUES.clone();
        }

        public static FsmResultCode valueOf(String value) {
            return Enum.valueOf(FsmResultCode.class, value);
        }

        static {
            $VALUES = fsmResultCodeArray = new FsmResultCode[]{FsmResultCode.UNKNOWN_TRANSITION, FsmResultCode.FSM_LOCKED, FsmResultCode.FSM_NOT_STARTED, FsmResultCode.MISSING_DAT, FsmResultCode.INVALID_DAT, FsmResultCode.IO_ERROR, FsmResultCode.RAT_ERROR, FsmResultCode.RAT_NEGOTIATION_ERROR, FsmResultCode.WOULD_BLOCK, FsmResultCode.NOT_CONNECTED, FsmResultCode.IDSCP_DATA_NOT_CACHED, FsmResultCode.OK};
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lde/fhg/aisec/ids/idscp2/idscp_core/fsm/FSM$FsmResult;", "", "code", "Lde/fhg/aisec/ids/idscp2/idscp_core/fsm/FSM$FsmResultCode;", "nextState", "Lde/fhg/aisec/ids/idscp2/idscp_core/fsm/State;", "(Lde/fhg/aisec/ids/idscp2/idscp_core/fsm/FSM$FsmResultCode;Lde/fhg/aisec/ids/idscp2/idscp_core/fsm/State;)V", "getCode", "()Lde/fhg/aisec/ids/idscp2/idscp_core/fsm/FSM$FsmResultCode;", "getNextState", "()Lde/fhg/aisec/ids/idscp2/idscp_core/fsm/State;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "idscp2"})
    public static final class FsmResult {
        @NotNull
        private final FsmResultCode code;
        @NotNull
        private final State nextState;

        public FsmResult(@NotNull FsmResultCode code, @NotNull State nextState) {
            Intrinsics.checkNotNullParameter((Object)((Object)code), (String)"code");
            Intrinsics.checkNotNullParameter((Object)nextState, (String)"nextState");
            this.code = code;
            this.nextState = nextState;
        }

        @NotNull
        public final FsmResultCode getCode() {
            return this.code;
        }

        @NotNull
        public final State getNextState() {
            return this.nextState;
        }

        @NotNull
        public final FsmResultCode component1() {
            return this.code;
        }

        @NotNull
        public final State component2() {
            return this.nextState;
        }

        @NotNull
        public final FsmResult copy(@NotNull FsmResultCode code, @NotNull State nextState) {
            Intrinsics.checkNotNullParameter((Object)((Object)code), (String)"code");
            Intrinsics.checkNotNullParameter((Object)nextState, (String)"nextState");
            return new FsmResult(code, nextState);
        }

        public static /* synthetic */ FsmResult copy$default(FsmResult fsmResult, FsmResultCode fsmResultCode, State state, int n, Object object) {
            if ((n & 1) != 0) {
                fsmResultCode = fsmResult.code;
            }
            if ((n & 2) != 0) {
                state = fsmResult.nextState;
            }
            return fsmResult.copy(fsmResultCode, state);
        }

        @NotNull
        public String toString() {
            return "FsmResult(code=" + this.code + ", nextState=" + this.nextState + ")";
        }

        public int hashCode() {
            int result = this.code.hashCode();
            result = result * 31 + this.nextState.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof FsmResult)) {
                return false;
            }
            FsmResult fsmResult = (FsmResult)other;
            if (this.code != fsmResult.code) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.nextState, (Object)fsmResult.nextState);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lde/fhg/aisec/ids/idscp2/idscp_core/fsm/FSM$Companion;", "", "()V", "LOG", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "idscp2"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

