/*
 * Decompiled with CFR 0.152.
 */
package de.fhg.aisec.ids.idscp2.default_drivers.keystores;

import java.net.Socket;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.HashMap;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.X509ExtendedKeyManager;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 #2\u00020\u0001:\u0002\"#B\u001f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0006J5\u0010\n\u001a\u0004\u0018\u00010\u00032\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00030\f2\u000e\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a2\u0006\u0002\u0010\u0011J1\u0010\u0012\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016\u00a2\u0006\u0002\u0010\u0015J+\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016\u00a2\u0006\u0002\u0010\u0017J/\u0010\u0018\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u000e\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a2\u0006\u0002\u0010\u0019J\u001d\u0010\u001a\u001a\n\u0012\u0004\u0012\u00020\u001b\u0018\u00010\f2\u0006\u0010\u0002\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010\u001cJ+\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00030\f2\u0006\u0010\u0004\u001a\u00020\u00032\u000e\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\fH\u0016\u00a2\u0006\u0002\u0010\u001eJ\u0012\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010\u0002\u001a\u00020\u0003H\u0016J+\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00030\f2\u0006\u0010\u0004\u001a\u00020\u00032\u000e\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\fH\u0016\u00a2\u0006\u0002\u0010\u001eR\u001c\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lde/fhg/aisec/ids/idscp2/default_drivers/keystores/CustomX509ExtendedKeyManager;", "Ljavax/net/ssl/X509ExtendedKeyManager;", "certAlias", "", "keyType", "delegate", "(Ljava/lang/String;Ljava/lang/String;Ljavax/net/ssl/X509ExtendedKeyManager;)V", "cachedAliases", "Ljava/util/HashMap;", "Lde/fhg/aisec/ids/idscp2/default_drivers/keystores/CustomX509ExtendedKeyManager$CachedAliasValue;", "chooseClientAlias", "keyTypes", "", "issuers", "Ljava/security/Principal;", "socket", "Ljava/net/Socket;", "([Ljava/lang/String;[Ljava/security/Principal;Ljava/net/Socket;)Ljava/lang/String;", "chooseEngineClientAlias", "sslEngine", "Ljavax/net/ssl/SSLEngine;", "([Ljava/lang/String;[Ljava/security/Principal;Ljavax/net/ssl/SSLEngine;)Ljava/lang/String;", "chooseEngineServerAlias", "(Ljava/lang/String;[Ljava/security/Principal;Ljavax/net/ssl/SSLEngine;)Ljava/lang/String;", "chooseServerAlias", "(Ljava/lang/String;[Ljava/security/Principal;Ljava/net/Socket;)Ljava/lang/String;", "getCertificateChain", "Ljava/security/cert/X509Certificate;", "(Ljava/lang/String;)[Ljava/security/cert/X509Certificate;", "getClientAliases", "(Ljava/lang/String;[Ljava/security/Principal;)[Ljava/lang/String;", "getPrivateKey", "Ljava/security/PrivateKey;", "getServerAliases", "CachedAliasValue", "Companion", "idscp2"})
public final class CustomX509ExtendedKeyManager
extends X509ExtendedKeyManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String certAlias;
    @NotNull
    private final String keyType;
    @NotNull
    private final X509ExtendedKeyManager delegate;
    @NotNull
    private final HashMap<String, CachedAliasValue> cachedAliases;
    private static final Logger LOG = LoggerFactory.getLogger(CustomX509ExtendedKeyManager.class);

    public CustomX509ExtendedKeyManager(@NotNull String certAlias, @NotNull String keyType, @NotNull X509ExtendedKeyManager delegate) {
        Intrinsics.checkNotNullParameter((Object)certAlias, (String)"certAlias");
        Intrinsics.checkNotNullParameter((Object)keyType, (String)"keyType");
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        this.certAlias = certAlias;
        this.keyType = keyType;
        this.delegate = delegate;
        this.cachedAliases = new HashMap();
    }

    @Override
    @NotNull
    public String[] getClientAliases(@NotNull String keyType, @Nullable Principal[] issuers) {
        Intrinsics.checkNotNullParameter((Object)keyType, (String)"keyType");
        String[] clientAliases = this.delegate.getClientAliases(keyType, issuers);
        Intrinsics.checkNotNullExpressionValue((Object)clientAliases, (String)"clientAliases");
        for (String alias : clientAliases) {
            this.cachedAliases.putIfAbsent(alias, new CachedAliasValue(keyType, null));
        }
        return clientAliases;
    }

    @Override
    @Nullable
    public String chooseClientAlias(@NotNull String[] keyTypes, @Nullable Principal[] issuers, @NotNull Socket socket) {
        Intrinsics.checkNotNullParameter((Object)keyTypes, (String)"keyTypes");
        Intrinsics.checkNotNullParameter((Object)socket, (String)"socket");
        if (CollectionsKt.listOf((Object[])Arrays.copyOf(keyTypes, keyTypes.length)).contains(this.keyType)) {
            String[] stringArray = this.cachedAliases.get(this.certAlias);
            if ((stringArray == null ? false : stringArray.match(this.keyType, issuers)) || CollectionsKt.listOf((Object[])Arrays.copyOf(stringArray = this.getClientAliases(this.keyType, issuers), stringArray.length)).contains(this.certAlias)) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("CertificateAlias is {}", (Object)this.certAlias);
                }
                return this.certAlias;
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace("certAlias '{}' was not found in keystore", (Object)this.certAlias);
            }
        } else if (LOG.isTraceEnabled() && LOG.isTraceEnabled()) {
            LOG.trace("Different keyType '{}' in chooseClientAlias() in CustomX509ExtendedKeyManager, expected '{}'", (Object)this.keyType, (Object)this.keyType);
        }
        return null;
    }

    @Override
    @NotNull
    public String[] getServerAliases(@NotNull String keyType, @Nullable Principal[] issuers) {
        Intrinsics.checkNotNullParameter((Object)keyType, (String)"keyType");
        String[] serverAliases = this.delegate.getServerAliases(keyType, issuers);
        Intrinsics.checkNotNullExpressionValue((Object)serverAliases, (String)"serverAliases");
        for (String alias : serverAliases) {
            this.cachedAliases.putIfAbsent(alias, new CachedAliasValue(keyType, null));
        }
        return serverAliases;
    }

    @Override
    @Nullable
    public String chooseServerAlias(@NotNull String keyType, @Nullable Principal[] issuers, @NotNull Socket socket) {
        Intrinsics.checkNotNullParameter((Object)keyType, (String)"keyType");
        Intrinsics.checkNotNullParameter((Object)socket, (String)"socket");
        if (Intrinsics.areEqual((Object)keyType, (Object)this.keyType)) {
            String[] stringArray = this.cachedAliases.get(this.certAlias);
            if ((stringArray == null ? false : stringArray.match(keyType, issuers)) || CollectionsKt.listOf((Object[])Arrays.copyOf(stringArray = this.getServerAliases(keyType, issuers), stringArray.length)).contains(this.certAlias)) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("CertificateAlias is {}", (Object)this.certAlias);
                }
                return this.certAlias;
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace("certAlias '{}' was not found in keystore", (Object)this.certAlias);
            }
        } else if (LOG.isTraceEnabled() && LOG.isTraceEnabled()) {
            LOG.trace("Different keyType '{}' in chooseServerAlias() in CustomX509ExtendedKeyManager, expected '{}'", (Object)keyType, (Object)this.keyType);
        }
        return null;
    }

    @Override
    @Nullable
    public X509Certificate[] getCertificateChain(@NotNull String certAlias) {
        X509Certificate[] x509CertificateArray;
        Intrinsics.checkNotNullParameter((Object)certAlias, (String)"certAlias");
        if (Intrinsics.areEqual((Object)certAlias, (Object)this.certAlias)) {
            x509CertificateArray = this.delegate.getCertificateChain(certAlias);
        } else {
            LOG.warn("Different certAlias '{}' in getCertificateChain() in class X509ExtendedKeyManager, expected: '{}'", (Object)certAlias, (Object)this.certAlias);
            x509CertificateArray = null;
        }
        return x509CertificateArray;
    }

    @Override
    @Nullable
    public PrivateKey getPrivateKey(@NotNull String certAlias) {
        PrivateKey privateKey;
        Intrinsics.checkNotNullParameter((Object)certAlias, (String)"certAlias");
        if (Intrinsics.areEqual((Object)certAlias, (Object)this.certAlias)) {
            privateKey = this.delegate.getPrivateKey(certAlias);
        } else {
            LOG.warn("Different certAlias '{}' in getPrivateKey() in class X509ExtendedKeyManager, expected '{}'", (Object)certAlias, (Object)this.certAlias);
            privateKey = null;
        }
        return privateKey;
    }

    @Override
    @NotNull
    public String chooseEngineClientAlias(@NotNull String[] keyType, @NotNull Principal[] issuers, @NotNull SSLEngine sslEngine) {
        Intrinsics.checkNotNullParameter((Object)keyType, (String)"keyType");
        Intrinsics.checkNotNullParameter((Object)issuers, (String)"issuers");
        Intrinsics.checkNotNullParameter((Object)sslEngine, (String)"sslEngine");
        String string = this.delegate.chooseEngineClientAlias(keyType, issuers, sslEngine);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"delegate.chooseEngineClientAlias(keyType, issuers, sslEngine)");
        return string;
    }

    @Override
    @NotNull
    public String chooseEngineServerAlias(@NotNull String keyType, @NotNull Principal[] issuers, @NotNull SSLEngine sslEngine) {
        Intrinsics.checkNotNullParameter((Object)keyType, (String)"keyType");
        Intrinsics.checkNotNullParameter((Object)issuers, (String)"issuers");
        Intrinsics.checkNotNullParameter((Object)sslEngine, (String)"sslEngine");
        String string = this.delegate.chooseEngineServerAlias(keyType, issuers, sslEngine);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"delegate.chooseEngineServerAlias(keyType, issuers, sslEngine)");
        return string;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J#\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0002\u001a\u00020\u00032\u000e\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000bR\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lde/fhg/aisec/ids/idscp2/default_drivers/keystores/CustomX509ExtendedKeyManager$CachedAliasValue;", "", "keyType", "", "issuer", "Ljava/security/Principal;", "(Ljava/lang/String;Ljava/security/Principal;)V", "match", "", "issuers", "", "(Ljava/lang/String;[Ljava/security/Principal;)Z", "idscp2"})
    private static final class CachedAliasValue {
        @NotNull
        private final String keyType;
        @Nullable
        private final Principal issuer;

        public CachedAliasValue(@NotNull String keyType, @Nullable Principal issuer) {
            Intrinsics.checkNotNullParameter((Object)keyType, (String)"keyType");
            this.keyType = keyType;
            this.issuer = issuer;
        }

        public final boolean match(@NotNull String keyType, @Nullable Principal[] issuers) {
            Intrinsics.checkNotNullParameter((Object)keyType, (String)"keyType");
            return Intrinsics.areEqual((Object)this.keyType, (Object)keyType) && (issuers == null || CollectionsKt.contains((Iterable)CollectionsKt.listOf((Object[])Arrays.copyOf(issuers, issuers.length)), (Object)this.issuer));
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lde/fhg/aisec/ids/idscp2/default_drivers/keystores/CustomX509ExtendedKeyManager$Companion;", "", "()V", "LOG", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "idscp2"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

