/*
 * Decompiled with CFR 0.152.
 */
package de.fhg.aisec.ids.idscp2.default_drivers.daps.aisec_daps;

import de.fhg.aisec.ids.idscp2.default_drivers.daps.aisec_daps.AisecDapsDriverConfig;
import de.fhg.aisec.ids.idscp2.default_drivers.daps.aisec_daps.SecurityProfile;
import de.fhg.aisec.ids.idscp2.default_drivers.daps.aisec_daps.SecurityRequirements;
import de.fhg.aisec.ids.idscp2.default_drivers.keystores.PreConfiguration;
import de.fhg.aisec.ids.idscp2.idscp_core.drivers.DapsDriver;
import de.fhg.aisec.ids.idscp2.idscp_core.error.DatException;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.KeyManagementException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import java.time.Instant;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509ExtendedTrustManager;
import javax.net.ssl.X509TrustManager;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import okhttp3.FormBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.x509.AuthorityKeyIdentifier;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.SubjectKeyIdentifier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jose4j.http.Get;
import org.jose4j.http.SimpleGet;
import org.jose4j.jwa.AlgorithmConstraints;
import org.jose4j.jwk.HttpsJwks;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.NumericDate;
import org.jose4j.jwt.consumer.JwtConsumer;
import org.jose4j.jwt.consumer.JwtConsumerBuilder;
import org.jose4j.keys.resolvers.HttpsJwksVerificationKeyResolver;
import org.jose4j.keys.resolvers.VerificationKeyResolver;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0005\n\u0002\u0010\u0019\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000 42\u00020\u0001:\u00014B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\"\u001a\u00020\r2\u0006\u0010#\u001a\u00020$H\u0002J\u0010\u0010%\u001a\u00020\u00062\u0006\u0010&\u001a\u00020\u0010H\u0002J\u0018\u0010'\u001a\u00020\u00062\u0006\u0010(\u001a\u00020\b2\u0006\u0010)\u001a\u00020*H\u0002J*\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020\b2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010&\u001a\u00020\u00102\u0006\u0010.\u001a\u00020*H\u0002J\b\u0010/\u001a\u00020\bH\u0002J\u0010\u00100\u001a\u0002012\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aJ\u001a\u00102\u001a\u00020,2\u0006\u0010-\u001a\u00020\b2\b\u00103\u001a\u0004\u0018\u00010\u0010H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\n\u001a\u001e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bj\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r`\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001d\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u000e\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lde/fhg/aisec/ids/idscp2/default_drivers/daps/aisec_daps/AisecDapsDriver;", "Lde/fhg/aisec/ids/idscp2/idscp_core/drivers/DapsDriver;", "config", "Lde/fhg/aisec/ids/idscp2/default_drivers/daps/aisec_daps/AisecDapsDriverConfig;", "(Lde/fhg/aisec/ids/idscp2/default_drivers/daps/aisec_daps/AisecDapsDriverConfig;)V", "connectorUUID", "", "currentToken", "", "dapsUrl", "hexLookup", "Ljava/util/HashMap;", "", "", "Lkotlin/collections/HashMap;", "localPeerCertificate", "Ljava/security/cert/X509Certificate;", "privateKey", "Ljava/security/Key;", "renewalLock", "Ljava/util/concurrent/locks/ReentrantLock;", "renewalThreshold", "", "renewalTime", "Lorg/jose4j/jwt/NumericDate;", "securityRequirements", "Lde/fhg/aisec/ids/idscp2/default_drivers/daps/aisec_daps/SecurityRequirements;", "sslSocketFactory", "Ljavax/net/ssl/SSLSocketFactory;", "token", "getToken", "()[B", "trustManager", "Ljavax/net/ssl/X509ExtendedTrustManager;", "byteToHex", "num", "", "createConnectorUUID", "certificate", "encodeHexString", "byteArray", "beautify", "", "innerVerifyToken", "", "dat", "setCurrentToken", "syncGetToken", "updateSecurityRequirements", "", "verifyToken", "peerCertificate", "Companion", "idscp2"})
public final class AisecDapsDriver
implements DapsDriver {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private SSLSocketFactory sslSocketFactory;
    @Nullable
    private SecurityRequirements securityRequirements;
    @NotNull
    private final X509ExtendedTrustManager trustManager;
    @NotNull
    private final Key privateKey;
    @NotNull
    private final String dapsUrl;
    @NotNull
    private final X509Certificate localPeerCertificate;
    @NotNull
    private final HashMap<Byte, char[]> hexLookup;
    @NotNull
    private final String connectorUUID;
    @NotNull
    private byte[] currentToken;
    @NotNull
    private NumericDate renewalTime;
    private final float renewalThreshold;
    @NotNull
    private final ReentrantLock renewalLock;
    private static final Logger LOG = LoggerFactory.getLogger(AisecDapsDriver.class);
    @NotNull
    private static final String TARGET_AUDIENCE = "idsc:IDS_CONNECTORS_ALL";

    /*
     * WARNING - void declaration
     */
    public AisecDapsDriver(@NotNull AisecDapsDriverConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.securityRequirements = config.getSecurityRequirements();
        this.privateKey = PreConfiguration.INSTANCE.getKey(config.getKeyStorePath(), config.getKeyStorePassword(), config.getKeyAlias(), config.getKeyPassword());
        this.dapsUrl = config.getDapsUrl();
        this.localPeerCertificate = PreConfiguration.INSTANCE.getCertificate(config.getKeyStorePath(), config.getKeyStorePassword(), config.getKeyAlias());
        this.hexLookup = new HashMap();
        this.connectorUUID = this.createConnectorUUID(this.localPeerCertificate);
        String string = "INVALID_TOKEN";
        Object object = Charsets.UTF_8;
        boolean bl = false;
        byte[] byArray = string.getBytes((Charset)object);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        this.currentToken = byArray;
        string = NumericDate.now();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"now()");
        this.renewalTime = string;
        this.renewalThreshold = config.getDapsTokenRenewalThreshold();
        this.renewalLock = new ReentrantLock(true);
        TrustManager[] trustManagers = PreConfiguration.INSTANCE.getX509ExtTrustManager(config.getTrustStorePath(), config.getTrustStorePassword());
        this.trustManager = (X509ExtendedTrustManager)trustManagers[0];
        AisecDapsDriver aisecDapsDriver = this;
        try {
            AisecDapsDriver aisecDapsDriver2 = aisecDapsDriver;
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, trustManagers, null);
            object = sslContext.getSocketFactory();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"{\n            val sslContext = SSLContext.getInstance(\"TLS\")\n            sslContext.init(null, trustManagers, null)\n            sslContext.socketFactory\n        }");
        }
        catch (NoSuchAlgorithmException sslContext) {
            void e;
            AisecDapsDriver aisecDapsDriver3 = aisecDapsDriver;
            LOG.error("Cannot init DefaultDapsDriver: {}", (Object)e.toString());
            throw new RuntimeException((Throwable)e);
        }
        catch (KeyManagementException e) {
            AisecDapsDriver aisecDapsDriver4 = aisecDapsDriver;
            LOG.error("Cannot init DefaultDapsDriver: {}", (Object)e.toString());
            throw new RuntimeException(e);
        }
        aisecDapsDriver2.sslSocketFactory = object;
    }

    private final String createConnectorUUID(X509Certificate certificate) {
        String akiOid = Extension.authorityKeyIdentifier.getId();
        byte[] rawAuthorityKeyIdentifier = certificate.getExtensionValue(akiOid);
        ASN1OctetString akiOc = ASN1OctetString.getInstance((Object)rawAuthorityKeyIdentifier);
        AuthorityKeyIdentifier aki = AuthorityKeyIdentifier.getInstance((Object)akiOc.getOctets());
        byte[] authorityKeyIdentifier = aki.getKeyIdentifier();
        Intrinsics.checkNotNullExpressionValue((Object)authorityKeyIdentifier, (String)"authorityKeyIdentifier");
        String string = this.encodeHexString(authorityKeyIdentifier, true);
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026.toUpperCase(Locale.ROOT)");
        String akiResult = string3;
        String skiOid = Extension.subjectKeyIdentifier.getId();
        byte[] rawSubjectKeyIdentifier = certificate.getExtensionValue(skiOid);
        ASN1OctetString ski0c = ASN1OctetString.getInstance((Object)rawSubjectKeyIdentifier);
        SubjectKeyIdentifier ski = SubjectKeyIdentifier.getInstance((Object)ski0c.getOctets());
        byte[] subjectKeyIdentifier = ski.getKeyIdentifier();
        Intrinsics.checkNotNullExpressionValue((Object)subjectKeyIdentifier, (String)"subjectKeyIdentifier");
        String string4 = this.encodeHexString(subjectKeyIdentifier, true);
        int n = 0;
        String string5 = string4;
        if (string5 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string6 = string5.toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"(this as java.lang.Strin\u2026.toUpperCase(Locale.ROOT)");
        String skiResult = string6;
        if (LOG.isDebugEnabled()) {
            LOG.debug("AKI: " + akiResult);
            LOG.debug("SKI: " + skiResult);
        }
        string4 = akiResult;
        n = 0;
        int n2 = akiResult.length() - 1;
        boolean bl2 = false;
        String string7 = string4;
        if (string7 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string8 = string7.substring(n, n2);
        Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        return skiResult + "keyid:" + string8;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final byte[] syncGetToken() {
        this.renewalLock.lock();
        try {
            Object object;
            String string;
            if (NumericDate.now().isBefore(this.renewalTime)) {
                byte[] byArray;
                if (LOG.isDebugEnabled()) {
                    byArray = this.currentToken;
                    Charset charset = StandardCharsets.UTF_8;
                    Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
                    boolean bl = false;
                    boolean bl2 = false;
                    LOG.debug("Issue cached DAT: {}", (Object)new String(byArray, charset));
                }
                byArray = this.currentToken;
                return byArray;
            }
            if (LOG.isInfoEnabled()) {
                LOG.info("Retrieving Dynamic Attribute Token from DAPS ...");
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("ConnectorUUID: " + this.connectorUUID);
            }
            Date expiration = Date.from(Instant.now().plusSeconds(86400L));
            Date issuedAt = Date.from(Instant.now());
            Date notBefore = Date.from(Instant.now());
            String jwt = Jwts.builder().setIssuer(this.connectorUUID).setSubject(this.connectorUUID).claim("@context", (Object)"https://w3id.org/idsa/contexts/context.jsonld").claim("@type", (Object)"ids:DatRequestToken").setExpiration(expiration).setIssuedAt(issuedAt).setNotBefore(notBefore).setAudience(TARGET_AUDIENCE).signWith(this.privateKey, SignatureAlgorithm.RS256).compact();
            FormBody.Builder builder = new FormBody.Builder(null, 1, null).add("grant_type", "client_credentials").add("client_assertion_type", "urn:ietf:params:oauth:client-assertion-type:jwt-bearer");
            Intrinsics.checkNotNullExpressionValue((Object)jwt, (String)"jwt");
            FormBody formBody = builder.add("client_assertion", jwt).add("scope", "idsc:IDS_CONNECTOR_ATTRIBUTES_ALL").build();
            OkHttpClient client = new OkHttpClient.Builder().sslSocketFactory(this.sslSocketFactory, (X509TrustManager)this.trustManager).connectTimeout(15L, TimeUnit.SECONDS).writeTimeout(15L, TimeUnit.SECONDS).readTimeout(15L, TimeUnit.SECONDS).build();
            Request request = new Request.Builder().url(this.dapsUrl + "/v2/token").post((RequestBody)formBody).build();
            Response response = client.newCall(request).execute();
            if (!response.isSuccessful()) {
                Object[] objectArray = new Object[]{this.connectorUUID, this.connectorUUID, expiration, issuedAt, notBefore, TARGET_AUDIENCE};
                LOG.error("Failed to request token issued with parameters: Issuer: {}, Subject: {}, Expiration: {}, IssuedAt: {}, NotBefore: {}, Audience: {}", objectArray);
                throw new DatException("Received non-200 http response: " + response.code());
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Acquired DAT from {}/v2/token", (Object)this.dapsUrl);
            }
            String string2 = string = (object = response.body()) == null ? null : object.string();
            if (string == null) {
                throw new DatException("Received empty DAPS response");
            }
            JSONObject json = new JSONObject(string);
            Object token = null;
            if (json.has("access_token")) {
                object = json.getString("access_token");
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"json.getString(\"access_token\")");
                token = object;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Received DAT from DAPS: {}", token);
                }
            } else {
                if (json.has("error")) {
                    throw new DatException("DAPS reported error: " + json.getString("error"));
                }
                throw new DatException("DAPS response does not contain \"access_token\" or \"error\" field.");
            }
            object = token;
            Charset charset = StandardCharsets.UTF_8;
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
            boolean bl = false;
            byte[] byArray = object.getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
            this.innerVerifyToken(byArray, null, this.localPeerCertificate, true);
            object = token;
            charset = StandardCharsets.UTF_8;
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
            bl = false;
            byte[] byArray2 = object.getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"(this as java.lang.String).getBytes(charset)");
            object = byArray2;
            return object;
        }
        catch (Throwable e) {
            throw e instanceof DatException ? e : (Throwable)new DatException("Error whilst retrieving DAT", e);
        }
        finally {
            this.renewalLock.unlock();
        }
    }

    @Override
    @NotNull
    public byte[] getToken() {
        return this.syncGetToken();
    }

    public final void updateSecurityRequirements(@Nullable SecurityRequirements securityRequirements) {
        this.securityRequirements = securityRequirements;
    }

    @Override
    public long verifyToken(@NotNull byte[] dat, @Nullable X509Certificate peerCertificate) {
        Intrinsics.checkNotNullParameter((Object)dat, (String)"dat");
        if (peerCertificate == null) {
            throw new DatException("Missing peer certificate for fingerprint validation");
        }
        return this.innerVerifyToken(dat, this.securityRequirements, peerCertificate, false);
    }

    private final long innerVerifyToken(byte[] dat, SecurityRequirements securityRequirements, X509Certificate certificate, boolean setCurrentToken) {
        String peerCertFingerprint;
        Object object;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Verifying dynamic attribute token...");
        }
        HttpsJwks httpsJwks = new HttpsJwks(this.dapsUrl + "/.well-known/jwks.json");
        Get getInstance = new Get();
        getInstance.setSslSocketFactory(this.sslSocketFactory);
        httpsJwks.setSimpleHttpGet((SimpleGet)getInstance);
        HttpsJwksVerificationKeyResolver jwksKeyResolver = new HttpsJwksVerificationKeyResolver(httpsJwks);
        String[] stringArray = new String[]{"IDS_Connector", TARGET_AUDIENCE};
        JwtConsumerBuilder jwtConsumerBuilder = new JwtConsumerBuilder().setRequireExpirationTime().setAllowedClockSkewInSeconds(30).setRequireSubject().setExpectedAudience(true, stringArray).setExpectedIssuer(this.dapsUrl).setVerificationKeyResolver((VerificationKeyResolver)jwksKeyResolver);
        stringArray = new String[]{"RS256"};
        JwtConsumer jwtConsumer = jwtConsumerBuilder.setJweAlgorithmConstraints(new AlgorithmConstraints(AlgorithmConstraints.ConstraintType.PERMIT, stringArray)).build();
        long validityTime = 0L;
        JwtClaims claims = null;
        try {
            object = StandardCharsets.UTF_8;
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"UTF_8");
            boolean bl = false;
            JwtClaims jwtClaims = jwtConsumer.processToClaims(new String(dat, (Charset)object));
            Intrinsics.checkNotNullExpressionValue((Object)jwtClaims, (String)"jwtConsumer.processToClaims(String(dat, StandardCharsets.UTF_8))");
            claims = jwtClaims;
            NumericDate expTime = claims.getExpirationTime();
            validityTime = expTime.getValue() - NumericDate.now().getValue();
        }
        catch (Exception e) {
            throw new DatException("Error during claims processing", e);
        }
        if (setCurrentToken) {
            this.currentToken = dat;
            NumericDate e = NumericDate.now();
            Intrinsics.checkNotNullExpressionValue((Object)e, (String)"now()");
            this.renewalTime = e;
            this.renewalTime.addSeconds((long)((float)validityTime * this.renewalThreshold));
        }
        if (!Intrinsics.areEqual((Object)certificate, (Object)this.localPeerCertificate)) {
            Object object2;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Validate peer certificate fingerprint against expected fingerprint from DAT");
            }
            if (claims.isClaimValueStringList("transportCertsSha256")) {
                object = claims.getStringListClaimValue("transportCertsSha256");
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"{\n                    claims.getStringListClaimValue(\"transportCertsSha256\")\n                }");
                object2 = object;
            } else if (claims.isClaimValueString("transportCertsSha256")) {
                String fingerprint = claims.getStringClaimValue("transportCertsSha256");
                object2 = CollectionsKt.listOf((Object)fingerprint);
            } else {
                throw new DatException("Missing or invalid 'transportCertsSha256' format in DAT");
            }
            Object datCertFingerprints = object2;
            peerCertFingerprint = null;
            try {
                MessageDigest sha256 = MessageDigest.getInstance("SHA-256");
                sha256.update(certificate.getEncoded());
                byte[] digest = sha256.digest();
                Intrinsics.checkNotNullExpressionValue((Object)digest, (String)"digest");
                String string = this.encodeHexString(digest, false);
                boolean bl = false;
                String string2 = string;
                if (string2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string3 = string2.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026.toLowerCase(Locale.ROOT)");
                peerCertFingerprint = string3;
            }
            catch (Exception e) {
                throw new DatException("Cannot calculate peer certificate fingerprint", e);
            }
            if (!datCertFingerprints.contains(peerCertFingerprint)) {
                throw new DatException("Fingerprint of peer certificate does not match an expected fingerprint from DAT");
            }
        }
        if (securityRequirements != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Validate security attributes");
            }
            if ((peerCertFingerprint = claims.getStringClaimValue("securityProfile")) == null) {
                throw new DatException("DAT does not contain securityProfile");
            }
            String securityProfile = peerCertFingerprint;
            SecurityProfile securityProfilePeer = SecurityProfile.Companion.fromString(securityProfile);
            if (securityProfilePeer.compareTo((Enum)securityRequirements.getRequiredSecurityLevel()) < 0) {
                throw new DatException("Peer does not support any valid trust profile: Required: " + securityRequirements.getRequiredSecurityLevel() + " given: " + securityProfilePeer);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Peer's supported security profile: {}", (Object)securityProfilePeer);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("DAT is valid for {} seconds", (Object)validityTime);
        }
        return validityTime;
    }

    private final char[] byteToHex(int num) {
        char[] hexDigits = new char[]{Character.forDigit(num >> 4 & 0xF, 16), Character.forDigit(num & 0xF, 16)};
        return hexDigits;
    }

    private final String encodeHexString(byte[] byteArray, boolean beautify) {
        StringBuilder sb = new StringBuilder();
        for (byte b : byteArray) {
            sb.append(this.hexLookup.computeIfAbsent(b, arg_0 -> AisecDapsDriver.encodeHexString$lambda-0(this, arg_0)));
            if (!beautify) continue;
            sb.append(':');
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
        return string;
    }

    private static final char[] encodeHexString$lambda-0(AisecDapsDriver this$0, byte num) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return this$0.byteToHex(num);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lde/fhg/aisec/ids/idscp2/default_drivers/daps/aisec_daps/AisecDapsDriver$Companion;", "", "()V", "LOG", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "TARGET_AUDIENCE", "", "idscp2"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

