/*
 * Decompiled with CFR 0.152.
 */
package de.fhg.aisec.ids.idscp2.idscp_core.fsm;

import de.fhg.aisec.ids.idscp2.idscp_core.fsm.Event;
import de.fhg.aisec.ids.idscp2.idscp_core.fsm.FSM;
import de.fhg.aisec.ids.idscp2.idscp_core.fsm.InternalControlMessage;
import de.fhg.aisec.ids.idscp2.idscp_core.fsm.State;
import de.fhg.aisec.ids.idscp2.idscp_core.fsm.StaticTimer;
import de.fhg.aisec.ids.idscp2.idscp_core.fsm.Transition;
import de.fhg.aisec.ids.idscp2.idscp_core.messages.Idscp2MessageHelper;
import de.fhg.aisec.ids.idscp2.messages.IDSCP2;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0002\u001a\u00020\u0003H\u0016\u00a8\u0006\f"}, d2={"Lde/fhg/aisec/ids/idscp2/idscp_core/fsm/StateWaitForAck;", "Lde/fhg/aisec/ids/idscp2/idscp_core/fsm/State;", "fsm", "Lde/fhg/aisec/ids/idscp2/idscp_core/fsm/FSM;", "ratTimer", "Lde/fhg/aisec/ids/idscp2/idscp_core/fsm/StaticTimer;", "handshakeTimer", "ackTimer", "(Lde/fhg/aisec/ids/idscp2/idscp_core/fsm/FSM;Lde/fhg/aisec/ids/idscp2/idscp_core/fsm/StaticTimer;Lde/fhg/aisec/ids/idscp2/idscp_core/fsm/StaticTimer;Lde/fhg/aisec/ids/idscp2/idscp_core/fsm/StaticTimer;)V", "runEntryCode", "", "Companion", "idscp2"})
public final class StateWaitForAck
extends State {
    private static final Logger LOG;
    @NotNull
    public static final Companion Companion;

    @Override
    public void runEntryCode(@NotNull FSM fsm2) {
        Intrinsics.checkNotNullParameter((Object)fsm2, (String)"fsm");
        Logger logger = LOG;
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"LOG");
        if (logger.isTraceEnabled()) {
            LOG.trace("Switched to state STATE_WAIT_FOR_ACK");
        }
    }

    public StateWaitForAck(final @NotNull FSM fsm2, final @NotNull StaticTimer ratTimer, final @NotNull StaticTimer handshakeTimer, final @NotNull StaticTimer ackTimer) {
        Intrinsics.checkNotNullParameter((Object)fsm2, (String)"fsm");
        Intrinsics.checkNotNullParameter((Object)ratTimer, (String)"ratTimer");
        Intrinsics.checkNotNullParameter((Object)handshakeTimer, (String)"handshakeTimer");
        Intrinsics.checkNotNullParameter((Object)ackTimer, (String)"ackTimer");
        this.addTransition(InternalControlMessage.ERROR.getValue(), new Transition((Function1<? super Event, FSM.FsmResult>)((Function1)new Function1<Event, FSM.FsmResult>(){

            @NotNull
            public final FSM.FsmResult invoke(@NotNull Event it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                LOG.warn("Error occurred, close idscp connection");
                return new FSM.FsmResult(FSM.FsmResultCode.OK, fsm2.getState(FSM.FsmState.STATE_CLOSED));
            }
        })));
        this.addTransition(InternalControlMessage.IDSCP_STOP.getValue(), new Transition((Function1<? super Event, FSM.FsmResult>)((Function1)new Function1<Event, FSM.FsmResult>(){

            @NotNull
            public final FSM.FsmResult invoke(@NotNull Event it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                Logger logger = LOG;
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"LOG");
                if (logger.isTraceEnabled()) {
                    LOG.trace("Send IDSCP_CLOSE");
                }
                fsm2.sendFromFSM(Idscp2MessageHelper.INSTANCE.createIdscpCloseMessage("User close", IDSCP2.IdscpClose.CloseCause.USER_SHUTDOWN));
                return new FSM.FsmResult(FSM.FsmResultCode.OK, fsm2.getState(FSM.FsmState.STATE_CLOSED));
            }
        })));
        this.addTransition(InternalControlMessage.REPEAT_RAT.getValue(), new Transition((Function1<? super Event, FSM.FsmResult>)((Function1)new Function1<Event, FSM.FsmResult>(){

            @NotNull
            public final FSM.FsmResult invoke(@NotNull Event it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                Logger logger = LOG;
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"LOG");
                if (logger.isDebugEnabled()) {
                    LOG.debug("Re-Attestation triggered");
                }
                Logger logger2 = LOG;
                Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"LOG");
                if (logger2.isTraceEnabled()) {
                    LOG.trace("Send IDSCP_RERAT, start RAT_VERIFIER");
                }
                ratTimer.cancelTimeout();
                ackTimer.cancelTimeout();
                if (!fsm2.sendFromFSM(Idscp2MessageHelper.INSTANCE.createIdscpReRatMessage(""))) {
                    LOG.warn("Cannot send ReRat message");
                    return new FSM.FsmResult(FSM.FsmResultCode.IO_ERROR, fsm2.getState(FSM.FsmState.STATE_CLOSED));
                }
                if (!fsm2.restartRatVerifierDriver()) {
                    LOG.warn("Cannot run Rat verifier, close idscp connection");
                    return new FSM.FsmResult(FSM.FsmResultCode.RAT_ERROR, fsm2.getState(FSM.FsmState.STATE_CLOSED));
                }
                return new FSM.FsmResult(FSM.FsmResultCode.OK, fsm2.getState(FSM.FsmState.STATE_WAIT_FOR_RAT_VERIFIER));
            }
        })));
        this.addTransition(InternalControlMessage.SEND_DATA.getValue(), new Transition((Function1<? super Event, FSM.FsmResult>)((Function1)new Function1<Event, FSM.FsmResult>(){

            @NotNull
            public final FSM.FsmResult invoke(@NotNull Event it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                LOG.warn("Cannot send data in STATE_WAIT_FOR_ACK");
                return new FSM.FsmResult(FSM.FsmResultCode.WOULD_BLOCK, this);
            }
        })));
        this.addTransition(InternalControlMessage.DAT_TIMER_EXPIRED.getValue(), new Transition((Function1<? super Event, FSM.FsmResult>)((Function1)new Function1<Event, FSM.FsmResult>(){

            @NotNull
            public final FSM.FsmResult invoke(@NotNull Event it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                ratTimer.cancelTimeout();
                ackTimer.cancelTimeout();
                Logger logger = LOG;
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"LOG");
                if (logger.isDebugEnabled()) {
                    LOG.debug("DAT expired, request new DAT from peer and trigger a re-attestation");
                }
                Logger logger2 = LOG;
                Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"LOG");
                if (logger2.isTraceEnabled()) {
                    LOG.trace("Send IDSCP_DAT_EXPIRED");
                }
                if (!fsm2.sendFromFSM(Idscp2MessageHelper.INSTANCE.createIdscpDatExpiredMessage())) {
                    LOG.warn("Cannot send DatExpired message");
                    return new FSM.FsmResult(FSM.FsmResultCode.IO_ERROR, fsm2.getState(FSM.FsmState.STATE_CLOSED));
                }
                Logger logger3 = LOG;
                Intrinsics.checkNotNullExpressionValue((Object)logger3, (String)"LOG");
                if (logger3.isTraceEnabled()) {
                    LOG.trace("Set handshake timeout");
                }
                handshakeTimer.resetTimeout();
                return new FSM.FsmResult(FSM.FsmResultCode.OK, fsm2.getState(FSM.FsmState.STATE_WAIT_FOR_DAT_AND_RAT_VERIFIER));
            }
        })));
        this.addTransition(InternalControlMessage.ACK_TIMER_EXPIRED.getValue(), new Transition((Function1<? super Event, FSM.FsmResult>)((Function1)new Function1<Event, FSM.FsmResult>(){

            @NotNull
            public final FSM.FsmResult invoke(@NotNull Event it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (fsm2.getAckFlag()) {
                    IDSCP2.IdscpMessage idscpMessage = fsm2.getGetBufferedIdscpMessage();
                    if (idscpMessage != null) {
                        FSM.FsmResult fsmResult;
                        IDSCP2.IdscpMessage idscpMessage2 = idscpMessage;
                        boolean bl = false;
                        boolean bl2 = false;
                        IDSCP2.IdscpMessage it2 = idscpMessage2;
                        boolean bl3 = false;
                        Logger logger = LOG;
                        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"LOG");
                        if (logger.isTraceEnabled()) {
                            LOG.trace("ACK_timeout occurred. Sending buffered IdscpData again...");
                        }
                        if (!fsm2.sendFromFSM(it2)) {
                            LOG.warn("Cannot send IdscpData, shutdown FSM");
                            fsmResult = new FSM.FsmResult(FSM.FsmResultCode.IO_ERROR, fsm2.getState(FSM.FsmState.STATE_CLOSED));
                        } else {
                            ackTimer.start();
                            fsmResult = new FSM.FsmResult(FSM.FsmResultCode.OK, this);
                        }
                        return fsmResult;
                    }
                }
                LOG.warn("No IdscpData message buffered in state WAIT_FOR_ACK. Shutdown");
                return new FSM.FsmResult(FSM.FsmResultCode.IDSCP_DATA_NOT_CACHED, fsm2.getState(FSM.FsmState.STATE_CLOSED));
            }
        })));
        this.addTransition(5, new Transition((Function1<? super Event, FSM.FsmResult>)((Function1)new Function1<Event, FSM.FsmResult>(){

            @NotNull
            public final FSM.FsmResult invoke(@NotNull Event it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                Logger logger = LOG;
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"LOG");
                if (logger.isDebugEnabled()) {
                    LOG.debug("Peer is requesting a re-attestation");
                }
                if (!fsm2.restartRatProverDriver()) {
                    LOG.warn("Cannot run Rat prover, close idscp connection");
                    return new FSM.FsmResult(FSM.FsmResultCode.RAT_ERROR, fsm2.getState(FSM.FsmState.STATE_CLOSED));
                }
                ackTimer.cancelTimeout();
                return new FSM.FsmResult(FSM.FsmResultCode.OK, fsm2.getState(FSM.FsmState.STATE_WAIT_FOR_RAT_PROVER));
            }
        })));
        this.addTransition(3, new Transition((Function1<? super Event, FSM.FsmResult>)((Function1)new Function1<Event, FSM.FsmResult>(){

            @NotNull
            public final FSM.FsmResult invoke(@NotNull Event it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                Logger logger = LOG;
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"LOG");
                if (logger.isDebugEnabled()) {
                    LOG.debug("Peer is requesting a new DAT, followed by a re-attestation");
                }
                if (!fsm2.sendFromFSM(Idscp2MessageHelper.INSTANCE.createIdscpDatMessage(fsm2.getDynamicAttributeToken()))) {
                    LOG.warn("Cannot send Dat message");
                    return new FSM.FsmResult(FSM.FsmResultCode.IO_ERROR, fsm2.getState(FSM.FsmState.STATE_CLOSED));
                }
                if (!fsm2.restartRatProverDriver()) {
                    LOG.warn("Cannot run Rat prover, close idscp connection");
                    return new FSM.FsmResult(FSM.FsmResultCode.RAT_ERROR, fsm2.getState(FSM.FsmState.STATE_CLOSED));
                }
                ackTimer.cancelTimeout();
                return new FSM.FsmResult(FSM.FsmResultCode.OK, fsm2.getState(FSM.FsmState.STATE_WAIT_FOR_RAT_PROVER));
            }
        })));
        this.addTransition(8, new Transition((Function1<? super Event, FSM.FsmResult>)((Function1)new Function1<Event, FSM.FsmResult>(){

            @NotNull
            public final FSM.FsmResult invoke(@NotNull Event it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                IDSCP2.IdscpData idscpData = it.getIdscpMessage().getIdscpData();
                Intrinsics.checkNotNullExpressionValue((Object)idscpData, (String)"it.idscpMessage.idscpData");
                fsm2.recvData(idscpData);
                return new FSM.FsmResult(FSM.FsmResultCode.OK, this);
            }
        })));
        this.addTransition(9, new Transition((Function1<? super Event, FSM.FsmResult>)((Function1)new Function1<Event, FSM.FsmResult>(){

            @NotNull
            public final FSM.FsmResult invoke(@NotNull Event it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                IDSCP2.IdscpAck idscpAck = it.getIdscpMessage().getIdscpAck();
                Intrinsics.checkNotNullExpressionValue((Object)idscpAck, (String)"it.idscpMessage.idscpAck");
                return fsm2.recvAck(idscpAck) ? new FSM.FsmResult(FSM.FsmResultCode.OK, fsm2.getState(FSM.FsmState.STATE_ESTABLISHED)) : new FSM.FsmResult(FSM.FsmResultCode.OK, this);
            }
        })));
        this.addTransition(2, new Transition((Function1<? super Event, FSM.FsmResult>)((Function1)new Function1<Event, FSM.FsmResult>(){

            @NotNull
            public final FSM.FsmResult invoke(@NotNull Event it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                Logger logger = LOG;
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"LOG");
                if (logger.isTraceEnabled()) {
                    LOG.trace("Receive IDSCP_CLOSED");
                }
                return new FSM.FsmResult(FSM.FsmResultCode.OK, fsm2.getState(FSM.FsmState.STATE_CLOSED));
            }
        })));
        this.setNoTransitionHandler(new Function<Event, FSM.FsmResult>(){

            @Override
            @NotNull
            public final FSM.FsmResult apply(@NotNull Event it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                Logger logger = LOG;
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"LOG");
                if (logger.isTraceEnabled()) {
                    LOG.trace("No transition available for given event " + it);
                    LOG.trace("Stay in state STATE_WAIT_FOR_ACK");
                }
                return new FSM.FsmResult(FSM.FsmResultCode.UNKNOWN_TRANSITION, this);
            }
        });
    }

    static {
        Companion = new Companion(null);
        LOG = LoggerFactory.getLogger(StateWaitForAck.class);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lde/fhg/aisec/ids/idscp2/idscp_core/fsm/StateWaitForAck$Companion;", "", "()V", "LOG", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "idscp2"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

