/*
 * Decompiled with CFR 0.152.
 */
package de.fhg.aisec.ids.idscp2.default_drivers.keystores;

import de.fhg.aisec.ids.idscp2.default_drivers.keystores.CustomX509ExtendedKeyManager;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509ExtendedTrustManager;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0019\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ&\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u000bJ9\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\r\u00a2\u0006\u0002\u0010\u0016J!\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u00122\u0006\u0010\u0019\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\u001bJ\u0016\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bR\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lde/fhg/aisec/ids/idscp2/default_drivers/keystores/PreConfiguration;", "", "()V", "LOG", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getCertificate", "Ljava/security/cert/X509Certificate;", "keyStorePath", "Ljava/nio/file/Path;", "keyStorePassword", "", "keyAlias", "", "getKey", "Ljava/security/Key;", "keyPassword", "getX509ExtKeyManager", "", "Ljavax/net/ssl/KeyManager;", "certAlias", "keyType", "([CLjava/nio/file/Path;[CLjava/lang/String;Ljava/lang/String;)[Ljavax/net/ssl/KeyManager;", "getX509ExtTrustManager", "Ljavax/net/ssl/TrustManager;", "trustStorePath", "trustStorePassword", "(Ljava/nio/file/Path;[C)[Ljavax/net/ssl/TrustManager;", "loadKeyStore", "Ljava/security/KeyStore;", "idscp2"})
public final class PreConfiguration {
    private static final Logger LOG;
    @NotNull
    public static final PreConfiguration INSTANCE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final KeyStore loadKeyStore(@NotNull Path keyStorePath, @NotNull char[] keyStorePassword) throws KeyStoreException, IOException, CertificateException, NoSuchAlgorithmException {
        KeyStore keyStore;
        Intrinsics.checkNotNullParameter((Object)keyStorePath, (String)"keyStorePath");
        Intrinsics.checkNotNullParameter((Object)keyStorePassword, (String)"keyStorePassword");
        KeyStore ks = null;
        String pathString = ((Object)keyStorePath).toString();
        if (StringsKt.endsWith$default((String)pathString, (String)".jks", (boolean)false, (int)2, null)) {
            KeyStore keyStore2 = KeyStore.getInstance("JKS");
            keyStore = keyStore2;
            Intrinsics.checkNotNullExpressionValue((Object)keyStore2, (String)"KeyStore.getInstance(\"JKS\")");
        } else if (StringsKt.endsWith$default((String)pathString, (String)".p12", (boolean)false, (int)2, null)) {
            KeyStore keyStore3 = KeyStore.getInstance("PKCS12");
            keyStore = keyStore3;
            Intrinsics.checkNotNullExpressionValue((Object)keyStore3, (String)"KeyStore.getInstance(\"PKCS12\")");
        } else {
            StringBuilder stringBuilder = new StringBuilder().append("Unknown file extension \"");
            String string = pathString;
            int n = StringsKt.lastIndexOf$default((CharSequence)pathString, (char)'.', (int)0, (boolean)false, (int)6, null);
            boolean bl = false;
            String string2 = string;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
            throw (Throwable)new KeyStoreException(stringBuilder.append(string3).append("\", only JKS (.jks) and PKCS12 (.p12) are supported.").toString());
        }
        ks = keyStore;
        Closeable closeable = Files.newInputStream(keyStorePath, new OpenOption[0]);
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            InputStream keyStoreInputStream = (InputStream)closeable;
            boolean bl3 = false;
            Logger logger = LOG;
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"LOG");
            if (logger.isTraceEnabled()) {
                LOG.trace("Loading key store: " + pathString);
            }
            ks.load(keyStoreInputStream, keyStorePassword);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return ks;
    }

    @NotNull
    public final TrustManager[] getX509ExtTrustManager(@NotNull Path trustStorePath, @NotNull char[] trustStorePassword) {
        Object[] objectArray;
        Intrinsics.checkNotNullParameter((Object)trustStorePath, (String)"trustStorePath");
        Intrinsics.checkNotNullParameter((Object)trustStorePassword, (String)"trustStorePassword");
        try {
            Object[] myTrustManager = null;
            KeyStore trustStore = this.loadKeyStore(trustStorePath, trustStorePassword);
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance("PKIX");
            trustManagerFactory.init(trustStore);
            TrustManagerFactory trustManagerFactory2 = trustManagerFactory;
            Intrinsics.checkNotNullExpressionValue((Object)trustManagerFactory2, (String)"trustManagerFactory");
            Object[] objectArray2 = trustManagerFactory2.getTrustManagers();
            Intrinsics.checkNotNullExpressionValue((Object)objectArray2, (String)"trustManagerFactory.trustManagers");
            myTrustManager = objectArray2;
            if (myTrustManager.length != 1 || !(myTrustManager[0] instanceof X509ExtendedTrustManager)) {
                StringBuilder stringBuilder = new StringBuilder().append("Unexpected default trust managers:");
                Object[] objectArray3 = myTrustManager;
                boolean bl = false;
                String string = Arrays.toString(objectArray3);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"java.util.Arrays.toString(this)");
                throw (Throwable)new IllegalStateException(stringBuilder.append(string).toString());
            }
            objectArray = myTrustManager;
        }
        catch (KeyStoreException e) {
            throw (Throwable)new RuntimeException(e);
        }
        catch (IOException e) {
            throw (Throwable)new RuntimeException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw (Throwable)new RuntimeException(e);
        }
        catch (CertificateException e) {
            throw (Throwable)new RuntimeException(e);
        }
        return objectArray;
    }

    @NotNull
    public final KeyManager[] getX509ExtKeyManager(@NotNull char[] keyPassword, @NotNull Path keyStorePath, @NotNull char[] keyStorePassword, @NotNull String certAlias, @NotNull String keyType) {
        Object[] objectArray;
        Intrinsics.checkNotNullParameter((Object)keyPassword, (String)"keyPassword");
        Intrinsics.checkNotNullParameter((Object)keyStorePath, (String)"keyStorePath");
        Intrinsics.checkNotNullParameter((Object)keyStorePassword, (String)"keyStorePassword");
        Intrinsics.checkNotNullParameter((Object)certAlias, (String)"certAlias");
        Intrinsics.checkNotNullParameter((Object)keyType, (String)"keyType");
        try {
            Object object;
            Object[] myKeyManager = null;
            KeyStore keystore = this.loadKeyStore(keyStorePath, keyStorePassword);
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance("PKIX");
            keyManagerFactory.init(keystore, keyPassword);
            KeyManagerFactory keyManagerFactory2 = keyManagerFactory;
            Intrinsics.checkNotNullExpressionValue((Object)keyManagerFactory2, (String)"keyManagerFactory");
            Object[] objectArray2 = keyManagerFactory2.getKeyManagers();
            Intrinsics.checkNotNullExpressionValue((Object)objectArray2, (String)"keyManagerFactory.keyManagers");
            myKeyManager = objectArray2;
            if (myKeyManager.length == 1 && myKeyManager[0] instanceof X509ExtendedKeyManager) {
                object = myKeyManager[0];
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type javax.net.ssl.X509ExtendedKeyManager");
                }
            } else {
                StringBuilder stringBuilder = new StringBuilder().append("Unexpected default key managers:");
                Object[] objectArray3 = myKeyManager;
                boolean bl = false;
                String string = Arrays.toString(objectArray3);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"java.util.Arrays.toString(this)");
                throw (Throwable)new IllegalStateException(stringBuilder.append(string).toString());
            }
            myKeyManager[0] = new CustomX509ExtendedKeyManager(certAlias, keyType, (X509ExtendedKeyManager)object);
            objectArray = myKeyManager;
        }
        catch (IOException e) {
            throw (Throwable)new RuntimeException(e);
        }
        catch (KeyStoreException e) {
            throw (Throwable)new RuntimeException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw (Throwable)new RuntimeException(e);
        }
        catch (UnrecoverableKeyException e) {
            throw (Throwable)new RuntimeException(e);
        }
        catch (CertificateException e) {
            throw (Throwable)new RuntimeException(e);
        }
        return objectArray;
    }

    @NotNull
    public final Key getKey(@NotNull Path keyStorePath, @NotNull char[] keyStorePassword, @NotNull String keyAlias, @NotNull char[] keyPassword) {
        Key key;
        Intrinsics.checkNotNullParameter((Object)keyStorePath, (String)"keyStorePath");
        Intrinsics.checkNotNullParameter((Object)keyStorePassword, (String)"keyStorePassword");
        Intrinsics.checkNotNullParameter((Object)keyAlias, (String)"keyAlias");
        Intrinsics.checkNotNullParameter((Object)keyPassword, (String)"keyPassword");
        try {
            Key key2;
            KeyStore keyStore = this.loadKeyStore(keyStorePath, keyStorePassword);
            Key key3 = key2 = keyStore.getKey(keyAlias, keyPassword);
            if (key3 == null) {
                throw (Throwable)new RuntimeException("No key was found in keystore for given alias");
            }
            key = key3;
        }
        catch (IOException e) {
            throw (Throwable)new RuntimeException(e);
        }
        catch (KeyStoreException e) {
            throw (Throwable)new RuntimeException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw (Throwable)new RuntimeException(e);
        }
        catch (CertificateException e) {
            throw (Throwable)new RuntimeException(e);
        }
        catch (UnrecoverableKeyException e) {
            throw (Throwable)new RuntimeException(e);
        }
        return key;
    }

    @NotNull
    public final X509Certificate getCertificate(@NotNull Path keyStorePath, @NotNull char[] keyStorePassword, @NotNull String keyAlias) {
        X509Certificate x509Certificate;
        Intrinsics.checkNotNullParameter((Object)keyStorePath, (String)"keyStorePath");
        Intrinsics.checkNotNullParameter((Object)keyStorePassword, (String)"keyStorePassword");
        Intrinsics.checkNotNullParameter((Object)keyAlias, (String)"keyAlias");
        try {
            KeyStore keystore = this.loadKeyStore(keyStorePath, keyStorePassword);
            Certificate certificate = keystore.getCertificate(keyAlias);
            if (certificate == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.security.cert.X509Certificate");
            }
            X509Certificate cert = (X509Certificate)certificate;
            keystore.getKey(keyAlias, keyStorePassword);
            x509Certificate = cert;
        }
        catch (IOException e) {
            throw (Throwable)new RuntimeException(e);
        }
        catch (KeyStoreException e) {
            throw (Throwable)new RuntimeException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw (Throwable)new RuntimeException(e);
        }
        catch (CertificateException e) {
            throw (Throwable)new RuntimeException(e);
        }
        catch (UnrecoverableKeyException e) {
            throw (Throwable)new RuntimeException(e);
        }
        return x509Certificate;
    }

    private PreConfiguration() {
    }

    static {
        PreConfiguration preConfiguration;
        INSTANCE = preConfiguration = new PreConfiguration();
        LOG = LoggerFactory.getLogger(PreConfiguration.class);
    }
}

