/*
 * Decompiled with CFR 0.152.
 */
package de.fhg.aisec.ids.idscp2.idscp_core.fsm;

import de.fhg.aisec.ids.idscp2.idscp_core.drivers.DapsDriver;
import de.fhg.aisec.ids.idscp2.idscp_core.fsm.DynamicTimer;
import de.fhg.aisec.ids.idscp2.idscp_core.fsm.Event;
import de.fhg.aisec.ids.idscp2.idscp_core.fsm.FSM;
import de.fhg.aisec.ids.idscp2.idscp_core.fsm.InternalControlMessage;
import de.fhg.aisec.ids.idscp2.idscp_core.fsm.State;
import de.fhg.aisec.ids.idscp2.idscp_core.fsm.StaticTimer;
import de.fhg.aisec.ids.idscp2.idscp_core.fsm.Transition;
import de.fhg.aisec.ids.idscp2.idscp_core.messages.Idscp2MessageHelper;
import de.fhg.aisec.ids.idscp2.messages.IDSCP2;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 \r2\u00020\u0001:\u0001\rB%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0002\u001a\u00020\u0003H\u0016\u00a8\u0006\u000e"}, d2={"Lde/fhg/aisec/ids/idscp2/idscp_core/fsm/StateWaitForDatAndRatVerifier;", "Lde/fhg/aisec/ids/idscp2/idscp_core/fsm/State;", "fsm", "Lde/fhg/aisec/ids/idscp2/idscp_core/fsm/FSM;", "handshakeTimer", "Lde/fhg/aisec/ids/idscp2/idscp_core/fsm/StaticTimer;", "datTimer", "Lde/fhg/aisec/ids/idscp2/idscp_core/fsm/DynamicTimer;", "dapsDriver", "Lde/fhg/aisec/ids/idscp2/idscp_core/drivers/DapsDriver;", "(Lde/fhg/aisec/ids/idscp2/idscp_core/fsm/FSM;Lde/fhg/aisec/ids/idscp2/idscp_core/fsm/StaticTimer;Lde/fhg/aisec/ids/idscp2/idscp_core/fsm/DynamicTimer;Lde/fhg/aisec/ids/idscp2/idscp_core/drivers/DapsDriver;)V", "runEntryCode", "", "Companion", "idscp2"})
public final class StateWaitForDatAndRatVerifier
extends State {
    private static final Logger LOG;
    @NotNull
    public static final Companion Companion;

    @Override
    public void runEntryCode(@NotNull FSM fsm2) {
        Intrinsics.checkNotNullParameter((Object)fsm2, (String)"fsm");
        Logger logger = LOG;
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"LOG");
        if (logger.isTraceEnabled()) {
            LOG.trace("Set handshake timeout");
        }
    }

    public StateWaitForDatAndRatVerifier(final @NotNull FSM fsm2, final @NotNull StaticTimer handshakeTimer, final @NotNull DynamicTimer datTimer, final @NotNull DapsDriver dapsDriver) {
        Intrinsics.checkNotNullParameter((Object)fsm2, (String)"fsm");
        Intrinsics.checkNotNullParameter((Object)handshakeTimer, (String)"handshakeTimer");
        Intrinsics.checkNotNullParameter((Object)datTimer, (String)"datTimer");
        Intrinsics.checkNotNullParameter((Object)dapsDriver, (String)"dapsDriver");
        this.addTransition(InternalControlMessage.IDSCP_STOP.getValue(), new Transition((Function1<? super Event, FSM.FsmResult>)((Function1)new Function1<Event, FSM.FsmResult>(){

            @NotNull
            public final FSM.FsmResult invoke(@NotNull Event it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                Logger logger = LOG;
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"LOG");
                if (logger.isTraceEnabled()) {
                    LOG.trace("Send IDSC_CLOSE");
                }
                fsm2.sendFromFSM(Idscp2MessageHelper.INSTANCE.createIdscpCloseMessage("User close", IDSCP2.IdscpClose.CloseCause.USER_SHUTDOWN));
                return new FSM.FsmResult(FSM.FsmResultCode.OK, fsm2.getState(FSM.FsmState.STATE_CLOSED));
            }
        })));
        this.addTransition(InternalControlMessage.ERROR.getValue(), new Transition((Function1<? super Event, FSM.FsmResult>)((Function1)new Function1<Event, FSM.FsmResult>(){

            @NotNull
            public final FSM.FsmResult invoke(@NotNull Event it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                LOG.warn("An internal control error occurred");
                return new FSM.FsmResult(FSM.FsmResultCode.OK, fsm2.getState(FSM.FsmState.STATE_CLOSED));
            }
        })));
        this.addTransition(InternalControlMessage.REPEAT_RAT.getValue(), new Transition((Function1<? super Event, FSM.FsmResult>)((Function1)new Function1<Event, FSM.FsmResult>(){

            @NotNull
            public final FSM.FsmResult invoke(@NotNull Event it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return new FSM.FsmResult(FSM.FsmResultCode.OK, this);
            }
        })));
        this.addTransition(InternalControlMessage.SEND_DATA.getValue(), new Transition((Function1<? super Event, FSM.FsmResult>)((Function1)new Function1<Event, FSM.FsmResult>(){

            @NotNull
            public final FSM.FsmResult invoke(@NotNull Event it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return new FSM.FsmResult(FSM.FsmResultCode.NOT_CONNECTED, this);
            }
        })));
        this.addTransition(InternalControlMessage.TIMEOUT.getValue(), new Transition((Function1<? super Event, FSM.FsmResult>)((Function1)new Function1<Event, FSM.FsmResult>(){

            @NotNull
            public final FSM.FsmResult invoke(@NotNull Event it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                LOG.warn("Handshake timeout occurred. Send IDSCP_CLOSE");
                fsm2.sendFromFSM(Idscp2MessageHelper.INSTANCE.createIdscpCloseMessage("Handshake timeout", IDSCP2.IdscpClose.CloseCause.TIMEOUT));
                return new FSM.FsmResult(FSM.FsmResultCode.OK, fsm2.getState(FSM.FsmState.STATE_CLOSED));
            }
        })));
        this.addTransition(2, new Transition((Function1<? super Event, FSM.FsmResult>)((Function1)new Function1<Event, FSM.FsmResult>(){

            @NotNull
            public final FSM.FsmResult invoke(@NotNull Event it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                Logger logger = LOG;
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"LOG");
                if (logger.isTraceEnabled()) {
                    LOG.trace("Received IDSCP_CLOSE");
                }
                return new FSM.FsmResult(FSM.FsmResultCode.OK, fsm2.getState(FSM.FsmState.STATE_CLOSED));
            }
        })));
        this.addTransition(4, new Transition((Function1<? super Event, FSM.FsmResult>)((Function1)new Function1<Event, FSM.FsmResult>(){

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final FSM.FsmResult invoke(@NotNull Event event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                handshakeTimer.cancelTimeout();
                Logger logger = LOG;
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"LOG");
                if (logger.isTraceEnabled()) {
                    LOG.trace("Verify received DAT");
                }
                IDSCP2.IdscpDat idscpDat = event.getIdscpMessage().getIdscpDat();
                Intrinsics.checkNotNullExpressionValue((Object)idscpDat, (String)"event.idscpMessage.idscpDat");
                byte[] dat = idscpDat.getToken().toByteArray();
                long datValidityPeriod = 0L;
                try {
                    void it;
                    Intrinsics.checkNotNullExpressionValue((Object)dat, (String)"dat");
                    long l = dapsDriver.verifyToken(dat, fsm2.getRemotePeerCertificate());
                    boolean bl = false;
                    boolean bl2 = false;
                    long l2 = l;
                    long l3 = 0L;
                    boolean bl3 = false;
                    datValidityPeriod = it;
                    Unit unit = Unit.INSTANCE;
                    if (l3 > l) {
                        LOG.warn("No valid remote DAT is available. Send IDSCP_CLOSE");
                        fsm2.sendFromFSM(Idscp2MessageHelper.INSTANCE.createIdscpCloseMessage("No valid DAT", IDSCP2.IdscpClose.CloseCause.NO_VALID_DAT));
                        return new FSM.FsmResult(FSM.FsmResultCode.INVALID_DAT, fsm2.getState(FSM.FsmState.STATE_CLOSED));
                    }
                }
                catch (Exception e) {
                    LOG.warn("DapsDriver has thrown Exception while validating remote DAT. Send IDSCP_CLOSE: {}", (Throwable)e);
                    fsm2.sendFromFSM(Idscp2MessageHelper.INSTANCE.createIdscpCloseMessage("No valid DAT", IDSCP2.IdscpClose.CloseCause.NO_VALID_DAT));
                    return new FSM.FsmResult(FSM.FsmResultCode.INVALID_DAT, fsm2.getState(FSM.FsmState.STATE_CLOSED));
                }
                Logger logger2 = LOG;
                Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"LOG");
                if (logger2.isTraceEnabled()) {
                    LOG.trace("Remote DAT is valid. Set dat timeout");
                }
                fsm2.setPeerDat(dat);
                datTimer.resetTimeout(datValidityPeriod * (long)1000);
                if (!fsm2.restartRatVerifierDriver()) {
                    LOG.warn("Cannot run Rat verifier, close idscp connection");
                    return new FSM.FsmResult(FSM.FsmResultCode.RAT_ERROR, fsm2.getState(FSM.FsmState.STATE_CLOSED));
                }
                return new FSM.FsmResult(FSM.FsmResultCode.OK, fsm2.getState(FSM.FsmState.STATE_WAIT_FOR_RAT_VERIFIER));
            }
        })));
        this.addTransition(3, new Transition((Function1<? super Event, FSM.FsmResult>)((Function1)new Function1<Event, FSM.FsmResult>(){

            @NotNull
            public final FSM.FsmResult invoke(@NotNull Event it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                Logger logger = LOG;
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"LOG");
                if (logger.isDebugEnabled()) {
                    LOG.debug("Peer is requesting a new DAT, followed by a re-attestation");
                }
                if (!fsm2.sendFromFSM(Idscp2MessageHelper.INSTANCE.createIdscpDatMessage(fsm2.getGetDynamicAttributeToken()))) {
                    LOG.warn("Cannot send DAT message");
                    return new FSM.FsmResult(FSM.FsmResultCode.IO_ERROR, fsm2.getState(FSM.FsmState.STATE_CLOSED));
                }
                if (!fsm2.restartRatProverDriver()) {
                    LOG.warn("Cannot run Rat prover, close idscp connection");
                    return new FSM.FsmResult(FSM.FsmResultCode.RAT_ERROR, fsm2.getState(FSM.FsmState.STATE_CLOSED));
                }
                return new FSM.FsmResult(FSM.FsmResultCode.OK, fsm2.getState(FSM.FsmState.STATE_WAIT_FOR_DAT_AND_RAT));
            }
        })));
        this.addTransition(5, new Transition((Function1<? super Event, FSM.FsmResult>)((Function1)new Function1<Event, FSM.FsmResult>(){

            @NotNull
            public final FSM.FsmResult invoke(@NotNull Event it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                Logger logger = LOG;
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"LOG");
                if (logger.isDebugEnabled()) {
                    LOG.debug("Peer is requesting a re-attestation");
                }
                if (!fsm2.restartRatProverDriver()) {
                    LOG.warn("Cannot run Rat prover, close idscp connection");
                    return new FSM.FsmResult(FSM.FsmResultCode.RAT_ERROR, fsm2.getState(FSM.FsmState.STATE_CLOSED));
                }
                return new FSM.FsmResult(FSM.FsmResultCode.OK, fsm2.getState(FSM.FsmState.STATE_WAIT_FOR_DAT_AND_RAT));
            }
        })));
        this.addTransition(9, new Transition((Function1<? super Event, FSM.FsmResult>)((Function1)new Function1<Event, FSM.FsmResult>(){

            @NotNull
            public final FSM.FsmResult invoke(@NotNull Event it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                IDSCP2.IdscpAck idscpAck = it.getIdscpMessage().getIdscpAck();
                Intrinsics.checkNotNullExpressionValue((Object)idscpAck, (String)"it.idscpMessage.idscpAck");
                fsm2.recvAck(idscpAck);
                return new FSM.FsmResult(FSM.FsmResultCode.OK, this);
            }
        })));
        this.setNoTransitionHandler(new Function<Event, FSM.FsmResult>(){

            @Override
            @NotNull
            public final FSM.FsmResult apply(@Nullable Event event) {
                Logger logger = LOG;
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"LOG");
                if (logger.isTraceEnabled()) {
                    LOG.trace("No transition available for given event " + String.valueOf(event));
                }
                return new FSM.FsmResult(FSM.FsmResultCode.UNKNOWN_TRANSITION, this);
            }
        });
    }

    static {
        Companion = new Companion(null);
        LOG = LoggerFactory.getLogger(StateWaitForDatAndRatVerifier.class);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lde/fhg/aisec/ids/idscp2/idscp_core/fsm/StateWaitForDatAndRatVerifier$Companion;", "", "()V", "LOG", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "idscp2"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

