/*
 * Decompiled with CFR 0.152.
 */
package de.fhg.aisec.ids.idscp2.idscp_core.api.idscp_connection;

import de.fhg.aisec.ids.idscp2.idscp_core.FastLatch;
import de.fhg.aisec.ids.idscp2.idscp_core.api.idscp_connection.Idscp2Connection;
import de.fhg.aisec.ids.idscp2.idscp_core.api.idscp_connection.Idscp2ConnectionImpl$WhenMappings;
import de.fhg.aisec.ids.idscp2.idscp_core.api.idscp_connection.Idscp2ConnectionListener;
import de.fhg.aisec.ids.idscp2.idscp_core.api.idscp_connection.Idscp2MessageListener;
import de.fhg.aisec.ids.idscp2.idscp_core.error.Idscp2Exception;
import de.fhg.aisec.ids.idscp2.idscp_core.error.Idscp2NotConnectedException;
import de.fhg.aisec.ids.idscp2.idscp_core.error.Idscp2TimeoutException;
import de.fhg.aisec.ids.idscp2.idscp_core.error.Idscp2WouldBlockException;
import de.fhg.aisec.ids.idscp2.idscp_core.fsm.FSM;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0006\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\u0003\n\u0002\b\b\u0018\u0000 22\u00020\u0001:\u00012B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u000fH\u0016J\u0010\u0010 \u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001cH\u0016J \u0010!\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020\u00182\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020$H\u0016J\b\u0010&\u001a\u00020\u001eH\u0016J\u0010\u0010'\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020\u0018H\u0016J\b\u0010(\u001a\u00020\u001eH\u0016J\u0010\u0010)\u001a\u00020\u001e2\u0006\u0010*\u001a\u00020+H\u0016J\u0010\u0010,\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020\u0018H\u0016J\u0010\u0010-\u001a\u00020\b2\u0006\u0010\u001f\u001a\u00020\u000fH\u0016J\u0010\u0010.\u001a\u00020\b2\u0006\u0010\u001f\u001a\u00020\u001cH\u0016J\b\u0010/\u001a\u00020\u001eH\u0016J\b\u00100\u001a\u00020\u0005H\u0016J\b\u00101\u001a\u00020\u001eH\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\r\u001a&\u0012\f\u0012\n \u0010*\u0004\u0018\u00010\u000f0\u000f \u0010*\u0012\u0012\f\u0012\n \u0010*\u0004\u0018\u00010\u000f0\u000f\u0018\u00010\u00110\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0015R\u0014\u0010\u0017\u001a\u00020\u00188VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR2\u0010\u001b\u001a&\u0012\f\u0012\n \u0010*\u0004\u0018\u00010\u001c0\u001c \u0010*\u0012\u0012\f\u0012\n \u0010*\u0004\u0018\u00010\u001c0\u001c\u0018\u00010\u00110\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lde/fhg/aisec/ids/idscp2/idscp_core/api/idscp_connection/Idscp2ConnectionImpl;", "Lde/fhg/aisec/ids/idscp2/idscp_core/api/idscp_connection/Idscp2Connection;", "fsm", "Lde/fhg/aisec/ids/idscp2/idscp_core/fsm/FSM;", "id", "", "(Lde/fhg/aisec/ids/idscp2/idscp_core/fsm/FSM;Ljava/lang/String;)V", "closed", "", "closedLock", "Ljava/util/concurrent/locks/ReentrantLock;", "connectionListenerLatch", "Lde/fhg/aisec/ids/idscp2/idscp_core/FastLatch;", "connectionListeners", "", "Lde/fhg/aisec/ids/idscp2/idscp_core/api/idscp_connection/Idscp2ConnectionListener;", "kotlin.jvm.PlatformType", "", "getId", "()Ljava/lang/String;", "isClosed", "()Z", "isConnected", "localDynamicAttributeToken", "", "getLocalDynamicAttributeToken", "()[B", "messageListeners", "Lde/fhg/aisec/ids/idscp2/idscp_core/api/idscp_connection/Idscp2MessageListener;", "addConnectionListener", "", "listener", "addMessageListener", "blockingSend", "msg", "timeout", "", "retryInterval", "close", "nonBlockingSend", "onClose", "onError", "t", "", "onMessage", "removeConnectionListener", "removeMessageListener", "repeatRat", "toString", "unlockMessaging", "Companion", "idscp2"})
public final class Idscp2ConnectionImpl
implements Idscp2Connection {
    private final Set<Idscp2ConnectionListener> connectionListeners;
    private final Set<Idscp2MessageListener> messageListeners;
    private final FastLatch connectionListenerLatch;
    private boolean closed;
    private ReentrantLock closedLock;
    private final FSM fsm;
    @NotNull
    private final String id;
    private static final Logger LOG;
    @NotNull
    public static final Companion Companion;

    @Override
    public void unlockMessaging() {
        this.connectionListenerLatch.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void close() {
        Logger logger = LOG;
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"LOG");
        if (logger.isInfoEnabled()) {
            LOG.info("Closing connection {}...", (Object)this.getId());
        }
        this.connectionListenerLatch.unlock();
        try {
            this.closedLock.lock();
            FSM.FsmResultCode fsmResultCode = this.fsm.closeConnection();
            switch (Idscp2ConnectionImpl$WhenMappings.$EnumSwitchMapping$0[fsmResultCode.ordinal()]) {
                case 1: {
                    void res;
                    throw (Throwable)new Idscp2Exception("Handshake not started: " + res.getValue());
                }
            }
            this.closed = true;
            Logger logger2 = LOG;
            Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"LOG");
            if (logger2.isDebugEnabled()) {
                LOG.debug("IDSCP2 connection {} closed", (Object)this.getId());
            }
        }
        finally {
            this.closedLock.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void nonBlockingSend(@NotNull byte[] msg) {
        void res;
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        Logger logger = LOG;
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"LOG");
        if (logger.isInfoEnabled()) {
            LOG.info("Sending data via connection {}...", (Object)this.getId());
        }
        FSM.FsmResultCode fsmResultCode = this.fsm.send(msg);
        switch (Idscp2ConnectionImpl$WhenMappings.$EnumSwitchMapping$1[fsmResultCode.ordinal()]) {
            case 1: {
                return;
            }
            case 2: {
                throw (Throwable)new Idscp2WouldBlockException("Idscp2 connection still waiting for ack");
            }
            case 3: 
            case 4: {
                throw (Throwable)new Idscp2Exception("Connection aborted: " + res.getValue());
            }
            case 5: {
                throw (Throwable)new Idscp2NotConnectedException("Idscp2 connection temporarily not available");
            }
        }
        throw (Throwable)new Idscp2Exception("Idscp2 error occurred while sending data: " + res.getValue());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void blockingSend(@NotNull byte[] msg, long timeout, long retryInterval) {
        void res;
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        Logger logger = LOG;
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"LOG");
        if (logger.isInfoEnabled()) {
            LOG.info("Sending data via connection {}...", (Object)this.getId());
        }
        long start = System.currentTimeMillis();
        block6: while (true) {
            long now;
            if ((now = System.currentTimeMillis()) >= start + timeout) {
                throw (Throwable)new Idscp2TimeoutException("Idscp2 connection temporarily not available");
            }
            FSM.FsmResultCode fsmResultCode = this.fsm.send(msg);
            switch (Idscp2ConnectionImpl$WhenMappings.$EnumSwitchMapping$2[fsmResultCode.ordinal()]) {
                case 1: {
                    return;
                }
                case 2: {
                    if (retryInterval <= 0L) continue block6;
                    Thread.sleep(retryInterval);
                    continue block6;
                }
                case 3: 
                case 4: {
                    throw (Throwable)new Idscp2Exception("Connection aborted: " + res.getValue());
                }
                case 5: {
                    throw (Throwable)new Idscp2NotConnectedException("Idscp2 connection temporarily not available");
                }
            }
            break;
        }
        throw (Throwable)new Idscp2Exception("Idscp2 error occurred while sending data: " + res.getValue());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void repeatRat() {
        void res;
        Logger logger = LOG;
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"LOG");
        if (logger.isInfoEnabled()) {
            LOG.info("Repeat Rat for connection {}...", (Object)this.getId());
        }
        FSM.FsmResultCode fsmResultCode = this.fsm.repeatRat();
        switch (Idscp2ConnectionImpl$WhenMappings.$EnumSwitchMapping$3[fsmResultCode.ordinal()]) {
            case 1: {
                return;
            }
            case 2: 
            case 3: {
                throw (Throwable)new Idscp2Exception("Connection aborted: " + res.getValue());
            }
            case 4: {
                throw (Throwable)new Idscp2Exception("RAT action failed: " + res.getValue());
            }
        }
        throw (Throwable)new Idscp2Exception("Error occurred: " + res.getValue());
    }

    @Override
    public void onMessage(@NotNull byte[] msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        this.connectionListenerLatch.await();
        Logger logger = LOG;
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"LOG");
        if (logger.isDebugEnabled()) {
            LOG.debug("Received new IDSCP Message");
        }
        Set<Idscp2MessageListener> set = this.messageListeners;
        Intrinsics.checkNotNullExpressionValue(set, (String)"messageListeners");
        Iterable $this$forEach$iv = set;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Idscp2MessageListener l = (Idscp2MessageListener)element$iv;
            boolean bl = false;
            l.onMessage(this, msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onError(@NotNull Throwable t) {
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        try {
            this.closedLock.lock();
            if (!this.closed) {
                this.connectionListenerLatch.await();
                Set<Idscp2ConnectionListener> set = this.connectionListeners;
                Intrinsics.checkNotNullExpressionValue(set, (String)"connectionListeners");
                Iterable $this$forEach$iv = set;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Idscp2ConnectionListener idscp2ConnectionListener = (Idscp2ConnectionListener)element$iv;
                    boolean bl = false;
                    idscp2ConnectionListener.onError(t);
                }
            }
        }
        finally {
            this.closedLock.unlock();
        }
    }

    @Override
    public void onClose() {
        this.connectionListenerLatch.await();
        Logger logger = LOG;
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"LOG");
        if (logger.isInfoEnabled()) {
            LOG.info("Connection with id {} is closing, notify listeners...", (Object)this.getId());
        }
        Set<Idscp2ConnectionListener> set = this.connectionListeners;
        Intrinsics.checkNotNullExpressionValue(set, (String)"connectionListeners");
        Iterable $this$forEach$iv = set;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Idscp2ConnectionListener l = (Idscp2ConnectionListener)element$iv;
            boolean bl = false;
            l.onClose();
        }
    }

    @Override
    public boolean isConnected() {
        return this.fsm.isConnected();
    }

    @Override
    public boolean isClosed() {
        return this.fsm.isFsmLocked();
    }

    @Override
    @NotNull
    public byte[] getLocalDynamicAttributeToken() {
        return this.fsm.getLocalDat();
    }

    @Override
    public void addConnectionListener(@NotNull Idscp2ConnectionListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.connectionListeners.add(listener);
    }

    @Override
    public boolean removeConnectionListener(@NotNull Idscp2ConnectionListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        return this.connectionListeners.remove(listener);
    }

    @Override
    public void addMessageListener(@NotNull Idscp2MessageListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.messageListeners.add(listener);
    }

    @Override
    public boolean removeMessageListener(@NotNull Idscp2MessageListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        return this.messageListeners.remove(listener);
    }

    @NotNull
    public String toString() {
        return "Idscp2ConnectionImpl(" + this.getId() + ')';
    }

    @Override
    @NotNull
    public String getId() {
        return this.id;
    }

    public Idscp2ConnectionImpl(@NotNull FSM fsm2, @NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)fsm2, (String)"fsm");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        this.fsm = fsm2;
        this.id = id;
        this.connectionListeners = Collections.synchronizedSet(new HashSet());
        this.messageListeners = Collections.synchronizedSet(new HashSet());
        this.connectionListenerLatch = new FastLatch();
        this.closedLock = new ReentrantLock(true);
    }

    static {
        Companion = new Companion(null);
        LOG = LoggerFactory.getLogger(Idscp2ConnectionImpl.class);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lde/fhg/aisec/ids/idscp2/idscp_core/api/idscp_connection/Idscp2ConnectionImpl$Companion;", "", "()V", "LOG", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "idscp2"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

