/*
 * Decompiled with CFR 0.152.
 */
package de.fhg.aisec.ids.idscp2.idscp_core.fsm;

import de.fhg.aisec.ids.idscp2.idscp_core.api.configuration.AttestationConfig;
import de.fhg.aisec.ids.idscp2.idscp_core.api.configuration.Idscp2Configuration;
import de.fhg.aisec.ids.idscp2.idscp_core.api.idscp_connection.Idscp2Connection;
import de.fhg.aisec.ids.idscp2.idscp_core.drivers.DapsDriver;
import de.fhg.aisec.ids.idscp2.idscp_core.error.Idscp2HandshakeException;
import de.fhg.aisec.ids.idscp2.idscp_core.fsm.AsyncIdscp2Factory;
import de.fhg.aisec.ids.idscp2.idscp_core.fsm.FSM;
import de.fhg.aisec.ids.idscp2.idscp_core.secure_channel.SecureChannel;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JH\u0010\u0006\u001a\u00020\u0007\"\b\b\u0000\u0010\b*\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0018\u0010\u000e\u001a\u0014\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u0002H\b0\u000f2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\b0\u0013R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lde/fhg/aisec/ids/idscp2/idscp_core/fsm/AsyncIdscp2Factory;", "", "()V", "LOG", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "initiateIdscp2Connection", "", "CC", "Lde/fhg/aisec/ids/idscp2/idscp_core/api/idscp_connection/Idscp2Connection;", "secureChannel", "Lde/fhg/aisec/ids/idscp2/idscp_core/secure_channel/SecureChannel;", "configuration", "Lde/fhg/aisec/ids/idscp2/idscp_core/api/configuration/Idscp2Configuration;", "connectionFactory", "Lkotlin/Function2;", "Lde/fhg/aisec/ids/idscp2/idscp_core/fsm/FSM;", "", "connectionFuture", "Ljava/util/concurrent/CompletableFuture;", "idscp2"})
public final class AsyncIdscp2Factory {
    private static final Logger LOG;
    @NotNull
    public static final AsyncIdscp2Factory INSTANCE;

    public final <CC extends Idscp2Connection> boolean initiateIdscp2Connection(@NotNull SecureChannel secureChannel, @NotNull Idscp2Configuration configuration, @NotNull Function2<? super FSM, ? super String, ? extends CC> connectionFactory, @NotNull CompletableFuture<CC> connectionFuture) {
        Intrinsics.checkNotNullParameter((Object)secureChannel, (String)"secureChannel");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter(connectionFactory, (String)"connectionFactory");
        Intrinsics.checkNotNullParameter(connectionFuture, (String)"connectionFuture");
        if (connectionFuture.isCancelled()) {
            secureChannel.close();
            return false;
        }
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"UUID.randomUUID().toString()");
        String id = string;
        DapsDriver dapsDriver = configuration.getDapsDriver();
        AttestationConfig attestationConfig = configuration.getAttestationConfig();
        long l = configuration.getAckTimeoutDelay();
        long l2 = configuration.getHandshakeTimeoutDelay();
        CompletionStage completionStage = connectionFuture.thenApply((Function)initiateIdscp2Connection.fsm.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"connectionFuture.thenApp\u2026 it as Idscp2Connection }");
        FSM fsm2 = new FSM(secureChannel, dapsDriver, attestationConfig, l, l2, id, (CompletableFuture<Idscp2Connection>)completionStage);
        secureChannel.setFsm(fsm2);
        CompletableFuture.runAsync(new Runnable(id, fsm2, connectionFactory, connectionFuture){
            final /* synthetic */ String $id;
            final /* synthetic */ FSM $fsm;
            final /* synthetic */ Function2 $connectionFactory;
            final /* synthetic */ CompletableFuture $connectionFuture;

            public final void run() {
                try {
                    Logger logger = AsyncIdscp2Factory.access$getLOG$p(AsyncIdscp2Factory.INSTANCE);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"LOG");
                    if (logger.isDebugEnabled()) {
                        AsyncIdscp2Factory.access$getLOG$p(AsyncIdscp2Factory.INSTANCE).debug("Starting IDSCP2 handshake for future connection with id {}", (Object)this.$id);
                    }
                    this.$fsm.startIdscpHandshake();
                    Logger logger2 = AsyncIdscp2Factory.access$getLOG$p(AsyncIdscp2Factory.INSTANCE);
                    Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"LOG");
                    if (logger2.isDebugEnabled()) {
                        AsyncIdscp2Factory.access$getLOG$p(AsyncIdscp2Factory.INSTANCE).debug("Handshake successful. Create new IDSCP2 connection with id {}", (Object)this.$id);
                    }
                    Idscp2Connection connection = (Idscp2Connection)this.$connectionFactory.invoke((Object)this.$fsm, (Object)this.$id);
                    this.$connectionFuture.complete(connection);
                    if (this.$connectionFuture.isCancelled()) {
                        connection.close();
                    }
                }
                catch (Idscp2HandshakeException e) {
                    this.$connectionFuture.completeExceptionally(e);
                }
            }
            {
                this.$id = string;
                this.$fsm = fSM;
                this.$connectionFactory = function2;
                this.$connectionFuture = completableFuture;
            }
        });
        return true;
    }

    private AsyncIdscp2Factory() {
    }

    static {
        AsyncIdscp2Factory asyncIdscp2Factory;
        INSTANCE = asyncIdscp2Factory = new AsyncIdscp2Factory();
        LOG = LoggerFactory.getLogger(AsyncIdscp2Factory.class);
    }

    public static final /* synthetic */ Logger access$getLOG$p(AsyncIdscp2Factory $this) {
        AsyncIdscp2Factory asyncIdscp2Factory = $this;
        return LOG;
    }
}

