/*
 * Decompiled with CFR 0.152.
 */
package de.fhg.aisec.ids.idscp2.example;

import de.fhg.aisec.ids.idscp2.default_drivers.daps.aisec_daps.AisecDapsDriver;
import de.fhg.aisec.ids.idscp2.default_drivers.daps.aisec_daps.AisecDapsDriverConfig;
import de.fhg.aisec.ids.idscp2.default_drivers.daps.aisec_daps.SecurityProfile;
import de.fhg.aisec.ids.idscp2.default_drivers.daps.aisec_daps.SecurityRequirements;
import de.fhg.aisec.ids.idscp2.default_drivers.secure_channel.tlsv1_3.NativeTlsConfiguration;
import de.fhg.aisec.ids.idscp2.example.Idscp2ServerInitiator;
import de.fhg.aisec.ids.idscp2.idscp_core.api.configuration.AttestationConfig;
import de.fhg.aisec.ids.idscp2.idscp_core.api.configuration.Idscp2Configuration;
import de.fhg.aisec.ids.idscp2.idscp_core.drivers.DapsDriver;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001b\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0007\u00a2\u0006\u0002\u0010\b\u00a8\u0006\t"}, d2={"Lde/fhg/aisec/ids/idscp2/example/RunTLSServer;", "", "()V", "main", "", "argv", "", "", "([Ljava/lang/String;)V", "idscp2"})
public final class RunTLSServer {
    @NotNull
    public static final RunTLSServer INSTANCE;

    @JvmStatic
    public static final void main(@NotNull String[] argv) {
        Intrinsics.checkNotNullParameter((Object)argv, (String)"argv");
        URL uRL = Objects.requireNonNull(RunTLSServer.class.getClassLoader().getResource("ssl/provider-keystore.p12"));
        Intrinsics.checkNotNullExpressionValue((Object)uRL, (String)"Objects.requireNonNull(\n\u2026store.p12\")\n            )");
        Path keyStorePath = Paths.get(uRL.getPath(), new String[0]);
        URL uRL2 = Objects.requireNonNull(RunTLSServer.class.getClassLoader().getResource("ssl/truststore.p12"));
        Intrinsics.checkNotNullExpressionValue((Object)uRL2, (String)"Objects.requireNonNull(\n\u2026store.p12\")\n            )");
        Path trustStorePath = Paths.get(uRL2.getPath(), new String[0]);
        AttestationConfig localAttestationConfig = new AttestationConfig.Builder().setSupportedRatSuite(new String[]{"Dummy"}).setExpectedRatSuite(new String[]{"Dummy"}).setRatTimeoutDelay(300000L).build();
        SecurityRequirements securityRequirements = new SecurityRequirements.Builder().setRequiredSecurityLevel(SecurityProfile.TRUSTED).build();
        AisecDapsDriverConfig.Builder builder = new AisecDapsDriverConfig.Builder();
        Path path = keyStorePath;
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"keyStorePath");
        AisecDapsDriverConfig.Builder builder2 = builder.setKeyStorePath(path);
        Path path2 = trustStorePath;
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"trustStorePath");
        DapsDriver dapsDriver = new AisecDapsDriver(builder2.setTrustStorePath(path2).setDapsUrl("https://daps-dev.aisec.fraunhofer.de").setSecurityRequirements(securityRequirements).build());
        Idscp2Configuration settings = new Idscp2Configuration.Builder().setAttestationConfig(localAttestationConfig).setDapsDriver(dapsDriver).build();
        NativeTlsConfiguration nativeTlsConfiguration = new NativeTlsConfiguration.Builder().setKeyStorePath(keyStorePath).setTrustStorePath(trustStorePath).setCertificateAlias("1.0.1").setHost("consumer-core").build();
        Idscp2ServerInitiator initiator = new Idscp2ServerInitiator();
        initiator.init(settings, nativeTlsConfiguration);
    }

    private RunTLSServer() {
    }

    static {
        RunTLSServer runTLSServer;
        INSTANCE = runTLSServer = new RunTLSServer();
    }
}

