/*
 * Decompiled with CFR 0.152.
 */
package de.fhg.aisec.ids.idscp2.idscp_core.fsm;

import com.google.protobuf.ProtocolStringList;
import de.fhg.aisec.ids.idscp2.idscp_core.api.configuration.AttestationConfig;
import de.fhg.aisec.ids.idscp2.idscp_core.drivers.DapsDriver;
import de.fhg.aisec.ids.idscp2.idscp_core.fsm.DynamicTimer;
import de.fhg.aisec.ids.idscp2.idscp_core.fsm.Event;
import de.fhg.aisec.ids.idscp2.idscp_core.fsm.FSM;
import de.fhg.aisec.ids.idscp2.idscp_core.fsm.InternalControlMessage;
import de.fhg.aisec.ids.idscp2.idscp_core.fsm.State;
import de.fhg.aisec.ids.idscp2.idscp_core.fsm.StaticTimer;
import de.fhg.aisec.ids.idscp2.idscp_core.fsm.Transition;
import de.fhg.aisec.ids.idscp2.idscp_core.messages.Idscp2MessageHelper;
import de.fhg.aisec.ids.idscp2.messages.IDSCP2;
import java.util.Collection;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0002\u001a\u00020\u0003H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lde/fhg/aisec/ids/idscp2/idscp_core/fsm/StateWaitForHello;", "Lde/fhg/aisec/ids/idscp2/idscp_core/fsm/State;", "fsm", "Lde/fhg/aisec/ids/idscp2/idscp_core/fsm/FSM;", "handshakeTimer", "Lde/fhg/aisec/ids/idscp2/idscp_core/fsm/StaticTimer;", "datTimer", "Lde/fhg/aisec/ids/idscp2/idscp_core/fsm/DynamicTimer;", "dapsDriver", "Lde/fhg/aisec/ids/idscp2/idscp_core/drivers/DapsDriver;", "attestationConfig", "Lde/fhg/aisec/ids/idscp2/idscp_core/api/configuration/AttestationConfig;", "(Lde/fhg/aisec/ids/idscp2/idscp_core/fsm/FSM;Lde/fhg/aisec/ids/idscp2/idscp_core/fsm/StaticTimer;Lde/fhg/aisec/ids/idscp2/idscp_core/fsm/DynamicTimer;Lde/fhg/aisec/ids/idscp2/idscp_core/drivers/DapsDriver;Lde/fhg/aisec/ids/idscp2/idscp_core/api/configuration/AttestationConfig;)V", "runEntryCode", "", "Companion", "idscp2"})
public final class StateWaitForHello
extends State {
    private final StaticTimer handshakeTimer;
    private static final Logger LOG;
    @NotNull
    public static final Companion Companion;

    @Override
    public void runEntryCode(@NotNull FSM fsm) {
        Intrinsics.checkNotNullParameter((Object)fsm, (String)"fsm");
        Logger logger = LOG;
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"LOG");
        if (logger.isTraceEnabled()) {
            LOG.trace("Switched to state STATE_WAIT_FOR_HELLO");
            LOG.trace("Set handshake timeout to 5 seconds");
        }
        this.handshakeTimer.resetTimeout();
    }

    public StateWaitForHello(final @NotNull FSM fsm, @NotNull StaticTimer handshakeTimer, final @NotNull DynamicTimer datTimer, final @NotNull DapsDriver dapsDriver, final @NotNull AttestationConfig attestationConfig) {
        Intrinsics.checkNotNullParameter((Object)fsm, (String)"fsm");
        Intrinsics.checkNotNullParameter((Object)handshakeTimer, (String)"handshakeTimer");
        Intrinsics.checkNotNullParameter((Object)datTimer, (String)"datTimer");
        Intrinsics.checkNotNullParameter((Object)dapsDriver, (String)"dapsDriver");
        Intrinsics.checkNotNullParameter((Object)attestationConfig, (String)"attestationConfig");
        this.handshakeTimer = handshakeTimer;
        this.addTransition(InternalControlMessage.ERROR.getValue(), new Transition((Function1<? super Event, FSM.FsmResult>)((Function1)new Function1<Event, FSM.FsmResult>(){

            @NotNull
            public final FSM.FsmResult invoke(@NotNull Event it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                LOG.warn("An internal control error occurred");
                return new FSM.FsmResult(FSM.FsmResultCode.OK, fsm.getState(FSM.FsmState.STATE_CLOSED));
            }
        })));
        this.addTransition(InternalControlMessage.IDSCP_STOP.getValue(), new Transition((Function1<? super Event, FSM.FsmResult>)((Function1)new Function1<Event, FSM.FsmResult>(){

            @NotNull
            public final FSM.FsmResult invoke(@NotNull Event it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                Logger logger = LOG;
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"LOG");
                if (logger.isTraceEnabled()) {
                    LOG.trace("Received stop signal from user. Send IDSCP_CLOSE");
                }
                fsm.sendFromFSM(Idscp2MessageHelper.INSTANCE.createIdscpCloseMessage("User close", IDSCP2.IdscpClose.CloseCause.USER_SHUTDOWN));
                return new FSM.FsmResult(FSM.FsmResultCode.OK, fsm.getState(FSM.FsmState.STATE_CLOSED));
            }
        })));
        this.addTransition(InternalControlMessage.SEND_DATA.getValue(), new Transition((Function1<? super Event, FSM.FsmResult>)((Function1)new Function1<Event, FSM.FsmResult>(){

            @NotNull
            public final FSM.FsmResult invoke(@NotNull Event it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                Logger logger = LOG;
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"LOG");
                if (logger.isTraceEnabled()) {
                    LOG.trace("Received SEND signal from user, but FSM is not connected yet");
                }
                return new FSM.FsmResult(FSM.FsmResultCode.NOT_CONNECTED, this);
            }
        })));
        this.addTransition(InternalControlMessage.REPEAT_RAT.getValue(), new Transition((Function1<? super Event, FSM.FsmResult>)((Function1)new Function1<Event, FSM.FsmResult>(){

            @NotNull
            public final FSM.FsmResult invoke(@NotNull Event it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                Logger logger = LOG;
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"LOG");
                if (logger.isTraceEnabled()) {
                    LOG.trace("Received REPEAT_RAT signal from user");
                }
                return new FSM.FsmResult(FSM.FsmResultCode.OK, this);
            }
        })));
        this.addTransition(InternalControlMessage.TIMEOUT.getValue(), new Transition((Function1<? super Event, FSM.FsmResult>)((Function1)new Function1<Event, FSM.FsmResult>(){

            @NotNull
            public final FSM.FsmResult invoke(@NotNull Event it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                LOG.warn("STATE_WAIT_FOR_HELLO timeout. Send IDSCP_CLOSE");
                fsm.sendFromFSM(Idscp2MessageHelper.INSTANCE.createIdscpCloseMessage("Handshake Timeout", IDSCP2.IdscpClose.CloseCause.TIMEOUT));
                return new FSM.FsmResult(FSM.FsmResultCode.OK, fsm.getState(FSM.FsmState.STATE_CLOSED));
            }
        })));
        this.addTransition(2, new Transition((Function1<? super Event, FSM.FsmResult>)((Function1)new Function1<Event, FSM.FsmResult>(){

            @NotNull
            public final FSM.FsmResult invoke(@NotNull Event it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                Logger logger = LOG;
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"LOG");
                if (logger.isTraceEnabled()) {
                    LOG.trace("Received IDSCP_CLOSE. Close connection");
                }
                return new FSM.FsmResult(FSM.FsmResultCode.OK, fsm.getState(FSM.FsmState.STATE_CLOSED));
            }
        })));
        this.addTransition(1, new Transition((Function1<? super Event, FSM.FsmResult>)((Function1)new Function1<Event, FSM.FsmResult>(){

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final FSM.FsmResult invoke(@NotNull Event event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                handshakeTimer.cancelTimeout();
                IDSCP2.IdscpHello idscpHello = event.getIdscpMessage().getIdscpHello();
                Logger logger = LOG;
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"LOG");
                if (logger.isTraceEnabled()) {
                    LOG.trace("Received IDSCP_HELLO");
                }
                Logger logger2 = LOG;
                Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"LOG");
                if (logger2.isTraceEnabled()) {
                    LOG.trace("Calculate Rat mechanisms");
                }
                String[] stringArray = attestationConfig.getSupportedAttestationSuite();
                IDSCP2.IdscpHello idscpHello2 = idscpHello;
                Intrinsics.checkNotNullExpressionValue((Object)idscpHello2, (String)"idscpHello");
                ProtocolStringList protocolStringList = idscpHello2.getExpectedRatSuiteList();
                Intrinsics.checkNotNullExpressionValue((Object)protocolStringList, (String)"idscpHello.expectedRatSuiteList");
                Collection $this$toTypedArray$iv = (Collection)protocolStringList;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                String[] stringArray2 = thisCollection$iv.toArray(new String[0]);
                if (stringArray2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                String proverMechanism = fsm.getRatProverMechanism(stringArray, stringArray2);
                if (proverMechanism == null) {
                    LOG.warn("No match for RAT prover mechanism");
                    return new FSM.FsmResult(FSM.FsmResultCode.RAT_NEGOTIATION_ERROR, fsm.getState(FSM.FsmState.STATE_CLOSED));
                }
                String[] stringArray3 = attestationConfig.getExpectedAttestationSuite();
                ProtocolStringList protocolStringList2 = idscpHello.getSupportedRatSuiteList();
                Intrinsics.checkNotNullExpressionValue((Object)protocolStringList2, (String)"idscpHello.supportedRatSuiteList");
                Collection $this$toTypedArray$iv2 = (Collection)protocolStringList2;
                boolean $i$f$toTypedArray22 = false;
                Collection thisCollection$iv2 = $this$toTypedArray$iv2;
                String[] stringArray4 = thisCollection$iv2.toArray(new String[0]);
                if (stringArray4 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                String verifierMechanism = fsm.getRatVerifierMechanism(stringArray3, stringArray4);
                if (verifierMechanism == null) {
                    LOG.warn("No match for RAT verifier mechanism");
                    return new FSM.FsmResult(FSM.FsmResultCode.RAT_NEGOTIATION_ERROR, fsm.getState(FSM.FsmState.STATE_CLOSED));
                }
                Logger logger3 = LOG;
                Intrinsics.checkNotNullExpressionValue((Object)logger3, (String)"LOG");
                if (logger3.isTraceEnabled()) {
                    LOG.trace("Verify received DAT");
                }
                long datValidityPeriod = 0L;
                if (!idscpHello.hasDynamicAttributeToken()) {
                    LOG.warn("No remote DAT is available. Send IDSCP_CLOSE");
                    fsm.sendFromFSM(Idscp2MessageHelper.INSTANCE.createIdscpCloseMessage("No valid DAT", IDSCP2.IdscpClose.CloseCause.NO_VALID_DAT));
                    return new FSM.FsmResult(FSM.FsmResultCode.MISSING_DAT, fsm.getState(FSM.FsmState.STATE_CLOSED));
                }
                try {
                    void it;
                    IDSCP2.IdscpDat idscpDat = idscpHello.getDynamicAttributeToken();
                    Intrinsics.checkNotNullExpressionValue((Object)idscpDat, (String)"idscpHello.dynamicAttributeToken");
                    byte[] byArray = idscpDat.getToken().toByteArray();
                    Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"idscpHello.dynamicAttrib\u2026Token.token.toByteArray()");
                    long $i$f$toTypedArray22 = dapsDriver.verifyToken(byArray, fsm.getRemotePeerCertificate());
                    boolean bl = false;
                    boolean bl2 = false;
                    long l = $i$f$toTypedArray22;
                    long l2 = 0L;
                    boolean bl3 = false;
                    datValidityPeriod = it;
                    Unit unit = Unit.INSTANCE;
                    if (l2 > $i$f$toTypedArray22) {
                        LOG.warn("No valid remote DAT is available. Send IDSCP_CLOSE");
                        fsm.sendFromFSM(Idscp2MessageHelper.INSTANCE.createIdscpCloseMessage("No valid DAT", IDSCP2.IdscpClose.CloseCause.NO_VALID_DAT));
                        return new FSM.FsmResult(FSM.FsmResultCode.INVALID_DAT, fsm.getState(FSM.FsmState.STATE_CLOSED));
                    }
                }
                catch (Exception e) {
                    LOG.warn("DapsDriver throws Exception while validating remote DAT. Send IDSCP_CLOSE {}", (Throwable)e);
                    fsm.sendFromFSM(Idscp2MessageHelper.INSTANCE.createIdscpCloseMessage("No valid DAT", IDSCP2.IdscpClose.CloseCause.NO_VALID_DAT));
                    return new FSM.FsmResult(FSM.FsmResultCode.INVALID_DAT, fsm.getState(FSM.FsmState.STATE_CLOSED));
                }
                Logger logger4 = LOG;
                Intrinsics.checkNotNullExpressionValue((Object)logger4, (String)"LOG");
                if (logger4.isTraceEnabled()) {
                    LOG.trace("Remote DAT is valid. Set dat timeout to its validity period");
                }
                datTimer.resetTimeout(datValidityPeriod * (long)1000);
                fsm.setRatMechanisms(proverMechanism, verifierMechanism);
                Logger logger5 = LOG;
                Intrinsics.checkNotNullExpressionValue((Object)logger5, (String)"LOG");
                if (logger5.isTraceEnabled()) {
                    LOG.debug("Start RAT Prover and Verifier");
                }
                if (!fsm.restartRatVerifierDriver()) {
                    LOG.warn("Cannot run Rat verifier, close idscp connection");
                    return new FSM.FsmResult(FSM.FsmResultCode.RAT_ERROR, fsm.getState(FSM.FsmState.STATE_CLOSED));
                }
                if (!fsm.restartRatProverDriver()) {
                    LOG.warn("Cannot run Rat prover, close idscp connection");
                    return new FSM.FsmResult(FSM.FsmResultCode.RAT_ERROR, fsm.getState(FSM.FsmState.STATE_CLOSED));
                }
                return new FSM.FsmResult(FSM.FsmResultCode.OK, fsm.getState(FSM.FsmState.STATE_WAIT_FOR_RAT));
            }
        })));
        this.setNoTransitionHandler(new Function<Event, FSM.FsmResult>(){

            @Override
            @NotNull
            public final FSM.FsmResult apply(@NotNull Event it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                Logger logger = LOG;
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"LOG");
                if (logger.isTraceEnabled()) {
                    LOG.trace("No transition available for given event " + it);
                    LOG.trace("Stay in state STATE_WAIT_FOR_HELLO");
                }
                return new FSM.FsmResult(FSM.FsmResultCode.UNKNOWN_TRANSITION, this);
            }
        });
    }

    static {
        Companion = new Companion(null);
        LOG = LoggerFactory.getLogger(StateWaitForHello.class);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lde/fhg/aisec/ids/idscp2/idscp_core/fsm/StateWaitForHello$Companion;", "", "()V", "LOG", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "idscp2"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

