/*
 * Decompiled with CFR 0.152.
 */
package de.fhg.aisec.ids.idscp2.idscp_core.fsm;

import de.fhg.aisec.ids.idscp2.idscp_core.drivers.DapsDriver;
import de.fhg.aisec.ids.idscp2.idscp_core.drivers.RatProverDriver;
import de.fhg.aisec.ids.idscp2.idscp_core.fsm.DynamicTimer;
import de.fhg.aisec.ids.idscp2.idscp_core.fsm.Event;
import de.fhg.aisec.ids.idscp2.idscp_core.fsm.FSM;
import de.fhg.aisec.ids.idscp2.idscp_core.fsm.InternalControlMessage;
import de.fhg.aisec.ids.idscp2.idscp_core.fsm.State;
import de.fhg.aisec.ids.idscp2.idscp_core.fsm.StaticTimer;
import de.fhg.aisec.ids.idscp2.idscp_core.fsm.Transition;
import de.fhg.aisec.ids.idscp2.idscp_core.messages.Idscp2MessageHelper;
import de.fhg.aisec.ids.idscp2.messages.IDSCP2;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.GlobalScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u0002\u001a\u00020\u0003H\u0016\u00a8\u0006\u000f"}, d2={"Lde/fhg/aisec/ids/idscp2/idscp_core/fsm/StateWaitForDatAndRat;", "Lde/fhg/aisec/ids/idscp2/idscp_core/fsm/State;", "fsm", "Lde/fhg/aisec/ids/idscp2/idscp_core/fsm/FSM;", "handshakeTimer", "Lde/fhg/aisec/ids/idscp2/idscp_core/fsm/StaticTimer;", "proverHandshakeTimer", "datTimer", "Lde/fhg/aisec/ids/idscp2/idscp_core/fsm/DynamicTimer;", "dapsDriver", "Lde/fhg/aisec/ids/idscp2/idscp_core/drivers/DapsDriver;", "(Lde/fhg/aisec/ids/idscp2/idscp_core/fsm/FSM;Lde/fhg/aisec/ids/idscp2/idscp_core/fsm/StaticTimer;Lde/fhg/aisec/ids/idscp2/idscp_core/fsm/StaticTimer;Lde/fhg/aisec/ids/idscp2/idscp_core/fsm/DynamicTimer;Lde/fhg/aisec/ids/idscp2/idscp_core/drivers/DapsDriver;)V", "runEntryCode", "", "Companion", "idscp2"})
public final class StateWaitForDatAndRat
extends State {
    private static final Logger LOG;
    @NotNull
    public static final Companion Companion;

    @Override
    public void runEntryCode(@NotNull FSM fsm) {
        Intrinsics.checkNotNullParameter((Object)fsm, (String)"fsm");
        Logger logger = LOG;
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"LOG");
        if (logger.isTraceEnabled()) {
            LOG.trace("Switched to state STATE_WAIT_FOR_DAT_AND_RAT");
        }
    }

    public StateWaitForDatAndRat(final @NotNull FSM fsm, final @NotNull StaticTimer handshakeTimer, final @NotNull StaticTimer proverHandshakeTimer, final @NotNull DynamicTimer datTimer, final @NotNull DapsDriver dapsDriver) {
        Intrinsics.checkNotNullParameter((Object)fsm, (String)"fsm");
        Intrinsics.checkNotNullParameter((Object)handshakeTimer, (String)"handshakeTimer");
        Intrinsics.checkNotNullParameter((Object)proverHandshakeTimer, (String)"proverHandshakeTimer");
        Intrinsics.checkNotNullParameter((Object)datTimer, (String)"datTimer");
        Intrinsics.checkNotNullParameter((Object)dapsDriver, (String)"dapsDriver");
        this.addTransition(InternalControlMessage.IDSCP_STOP.getValue(), new Transition((Function1<? super Event, FSM.FsmResult>)((Function1)new Function1<Event, FSM.FsmResult>(){

            @NotNull
            public final FSM.FsmResult invoke(@NotNull Event it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                Logger logger = LOG;
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"LOG");
                if (logger.isTraceEnabled()) {
                    LOG.trace("Send IDSC_CLOSE");
                }
                fsm.sendFromFSM(Idscp2MessageHelper.INSTANCE.createIdscpCloseMessage("User close", IDSCP2.IdscpClose.CloseCause.USER_SHUTDOWN));
                return new FSM.FsmResult(FSM.FsmResultCode.OK, fsm.getState(FSM.FsmState.STATE_CLOSED));
            }
        })));
        this.addTransition(InternalControlMessage.ERROR.getValue(), new Transition((Function1<? super Event, FSM.FsmResult>)((Function1)new Function1<Event, FSM.FsmResult>(){

            @NotNull
            public final FSM.FsmResult invoke(@NotNull Event it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                LOG.warn("An internal control error occurred");
                return new FSM.FsmResult(FSM.FsmResultCode.OK, fsm.getState(FSM.FsmState.STATE_CLOSED));
            }
        })));
        this.addTransition(InternalControlMessage.REPEAT_RAT.getValue(), new Transition((Function1<? super Event, FSM.FsmResult>)((Function1)new Function1<Event, FSM.FsmResult>(){

            @NotNull
            public final FSM.FsmResult invoke(@NotNull Event it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return new FSM.FsmResult(FSM.FsmResultCode.OK, this);
            }
        })));
        this.addTransition(InternalControlMessage.SEND_DATA.getValue(), new Transition((Function1<? super Event, FSM.FsmResult>)((Function1)new Function1<Event, FSM.FsmResult>(){

            @NotNull
            public final FSM.FsmResult invoke(@NotNull Event it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return new FSM.FsmResult(FSM.FsmResultCode.NOT_CONNECTED, this);
            }
        })));
        this.addTransition(InternalControlMessage.TIMEOUT.getValue(), new Transition((Function1<? super Event, FSM.FsmResult>)((Function1)new Function1<Event, FSM.FsmResult>(){

            @NotNull
            public final FSM.FsmResult invoke(@NotNull Event it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                LOG.warn("Handshake timeout occurred. Send IDSCP_CLOSE");
                fsm.sendFromFSM(Idscp2MessageHelper.INSTANCE.createIdscpCloseMessage("Handshake timeout", IDSCP2.IdscpClose.CloseCause.TIMEOUT));
                return new FSM.FsmResult(FSM.FsmResultCode.OK, fsm.getState(FSM.FsmState.STATE_CLOSED));
            }
        })));
        this.addTransition(InternalControlMessage.RAT_PROVER_OK.getValue(), new Transition((Function1<? super Event, FSM.FsmResult>)((Function1)new Function1<Event, FSM.FsmResult>(){

            @NotNull
            public final FSM.FsmResult invoke(@NotNull Event it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                Logger logger = LOG;
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"LOG");
                if (logger.isTraceEnabled()) {
                    LOG.trace("Received RAT_PROVER OK");
                }
                proverHandshakeTimer.cancelTimeout();
                return new FSM.FsmResult(FSM.FsmResultCode.OK, fsm.getState(FSM.FsmState.STATE_WAIT_FOR_DAT_AND_RAT_VERIFIER));
            }
        })));
        this.addTransition(InternalControlMessage.RAT_PROVER_FAILED.getValue(), new Transition((Function1<? super Event, FSM.FsmResult>)((Function1)new Function1<Event, FSM.FsmResult>(){

            @NotNull
            public final FSM.FsmResult invoke(@NotNull Event it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                LOG.warn("RAT_PROVER failed. Send IDSCP_CLOSE");
                fsm.sendFromFSM(Idscp2MessageHelper.INSTANCE.createIdscpCloseMessage("RAT_PROVER failed", IDSCP2.IdscpClose.CloseCause.RAT_PROVER_FAILED));
                return new FSM.FsmResult(FSM.FsmResultCode.OK, fsm.getState(FSM.FsmState.STATE_CLOSED));
            }
        })));
        this.addTransition(InternalControlMessage.RAT_PROVER_MSG.getValue(), new Transition((Function1<? super Event, FSM.FsmResult>)((Function1)new Function1<Event, FSM.FsmResult>(){

            @NotNull
            public final FSM.FsmResult invoke(@NotNull Event event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                Logger logger = LOG;
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"LOG");
                if (logger.isTraceEnabled()) {
                    LOG.trace("Send IDSCP_RAT_PROVER");
                }
                if (!fsm.sendFromFSM(event.getIdscpMessage())) {
                    LOG.warn("Cannot send rat prover message");
                    return new FSM.FsmResult(FSM.FsmResultCode.IO_ERROR, fsm.getState(FSM.FsmState.STATE_CLOSED));
                }
                return new FSM.FsmResult(FSM.FsmResultCode.OK, this);
            }
        })));
        this.addTransition(2, new Transition((Function1<? super Event, FSM.FsmResult>)((Function1)new Function1<Event, FSM.FsmResult>(){

            @NotNull
            public final FSM.FsmResult invoke(@NotNull Event it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                Logger logger = LOG;
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"LOG");
                if (logger.isTraceEnabled()) {
                    LOG.trace("Received IDSCP_CLOSE");
                }
                return new FSM.FsmResult(FSM.FsmResultCode.OK, fsm.getState(FSM.FsmState.STATE_CLOSED));
            }
        })));
        this.addTransition(4, new Transition((Function1<? super Event, FSM.FsmResult>)((Function1)new Function1<Event, FSM.FsmResult>(){

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final FSM.FsmResult invoke(@NotNull Event event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                handshakeTimer.cancelTimeout();
                Logger logger = LOG;
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"LOG");
                if (logger.isTraceEnabled()) {
                    LOG.trace("Verify received DAT");
                }
                IDSCP2.IdscpDat idscpDat = event.getIdscpMessage().getIdscpDat();
                Intrinsics.checkNotNullExpressionValue((Object)idscpDat, (String)"event.idscpMessage.idscpDat");
                byte[] dat = idscpDat.getToken().toByteArray();
                long datValidityPeriod = 0L;
                try {
                    void it;
                    Intrinsics.checkNotNullExpressionValue((Object)dat, (String)"dat");
                    long l = dapsDriver.verifyToken(dat, fsm.getRemotePeerCertificate());
                    boolean bl = false;
                    boolean bl2 = false;
                    long l2 = l;
                    long l3 = 0L;
                    boolean bl3 = false;
                    datValidityPeriod = it;
                    Unit unit = Unit.INSTANCE;
                    if (l3 > l) {
                        Logger logger2 = LOG;
                        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"LOG");
                        if (logger2.isTraceEnabled()) {
                            LOG.trace("No valid remote DAT is available. Send IDSCP_CLOSE");
                        }
                        fsm.sendFromFSM(Idscp2MessageHelper.INSTANCE.createIdscpCloseMessage("No valid DAT", IDSCP2.IdscpClose.CloseCause.NO_VALID_DAT));
                        return new FSM.FsmResult(FSM.FsmResultCode.INVALID_DAT, fsm.getState(FSM.FsmState.STATE_CLOSED));
                    }
                }
                catch (Exception e) {
                    LOG.warn("DapsDriver has thrown Exception while validating remote DAT. Send IDSCP_CLOSE: {}", (Throwable)e);
                    fsm.sendFromFSM(Idscp2MessageHelper.INSTANCE.createIdscpCloseMessage("No valid DAT", IDSCP2.IdscpClose.CloseCause.NO_VALID_DAT));
                    return new FSM.FsmResult(FSM.FsmResultCode.INVALID_DAT, fsm.getState(FSM.FsmState.STATE_CLOSED));
                }
                Logger logger3 = LOG;
                Intrinsics.checkNotNullExpressionValue((Object)logger3, (String)"LOG");
                if (logger3.isTraceEnabled()) {
                    LOG.trace("Remote DAT is valid. Set dat timeout");
                }
                datTimer.resetTimeout(datValidityPeriod * (long)1000);
                if (!fsm.restartRatVerifierDriver()) {
                    LOG.warn("Cannot run Rat verifier, close idscp connection");
                    return new FSM.FsmResult(FSM.FsmResultCode.RAT_ERROR, fsm.getState(FSM.FsmState.STATE_CLOSED));
                }
                return new FSM.FsmResult(FSM.FsmResultCode.OK, fsm.getState(FSM.FsmState.STATE_WAIT_FOR_RAT));
            }
        })));
        this.addTransition(3, new Transition((Function1<? super Event, FSM.FsmResult>)((Function1)new Function1<Event, FSM.FsmResult>(){

            @NotNull
            public final FSM.FsmResult invoke(@NotNull Event it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                Logger logger = LOG;
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"LOG");
                if (logger.isDebugEnabled()) {
                    LOG.debug("Peer is requesting a new DAT, followed by a re-attestation");
                }
                if (!fsm.sendFromFSM(Idscp2MessageHelper.INSTANCE.createIdscpDatMessage(fsm.getGetDynamicAttributeToken()))) {
                    LOG.warn("Cannot send Dat message");
                    return new FSM.FsmResult(FSM.FsmResultCode.IO_ERROR, fsm.getState(FSM.FsmState.STATE_CLOSED));
                }
                if (!fsm.restartRatProverDriver()) {
                    LOG.warn("Cannot run Rat prover, close idscp connection");
                    return new FSM.FsmResult(FSM.FsmResultCode.RAT_ERROR, fsm.getState(FSM.FsmState.STATE_CLOSED));
                }
                return new FSM.FsmResult(FSM.FsmResultCode.OK, this);
            }
        })));
        this.addTransition(7, new Transition((Function1<? super Event, FSM.FsmResult>)((Function1)new Function1<Event, FSM.FsmResult>(){

            @NotNull
            public final FSM.FsmResult invoke(@NotNull Event event) {
                block6: {
                    boolean bl;
                    boolean bl2;
                    Object object;
                    block5: {
                        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                        Logger logger = LOG;
                        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"LOG");
                        if (logger.isTraceEnabled()) {
                            LOG.trace("Delegate received IDSCP_RAT_VERIFIER to RAT_PROVER");
                        }
                        if (!event.getIdscpMessage().hasIdscpRatVerifier()) {
                            LOG.warn("IDSCP_RAT_VERIFIER Message not available");
                            return new FSM.FsmResult(FSM.FsmResultCode.RAT_ERROR, fsm.getState(FSM.FsmState.STATE_CLOSED));
                        }
                        Object object2 = fsm.getRatProverDriver();
                        if (object2 == null) break block5;
                        object = object2;
                        bl2 = false;
                        bl = false;
                        Object it = object;
                        boolean bl3 = false;
                        object2 = BuildersKt.launch$default(GlobalScope.INSTANCE, null, null, (Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>((RatProverDriver)it, null, event){
                            int label;
                            final /* synthetic */ RatProverDriver $it;
                            final /* synthetic */ Event $event$inlined;
                            {
                                this.$it = ratProverDriver;
                                this.$event$inlined = event;
                                super(2, continuation);
                            }

                            @Nullable
                            public final Object invokeSuspend(@NotNull Object object) {
                                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        IDSCP2.IdscpRatVerifier idscpRatVerifier = this.$event$inlined.getIdscpMessage().getIdscpRatVerifier();
                                        Intrinsics.checkNotNullExpressionValue((Object)idscpRatVerifier, (String)"event.idscpMessage.idscpRatVerifier");
                                        byte[] byArray = idscpRatVerifier.getData().toByteArray();
                                        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"event.idscpMessage.idscp\u2026rifier.data.toByteArray()");
                                        this.$it.delegate(byArray);
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            @NotNull
                            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                                Intrinsics.checkNotNullParameter(completion, (String)"completion");
                                Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                                return function2;
                            }

                            public final Object invoke(Object object, Object object2) {
                                return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }, 3, null);
                        if (object2 != null) break block6;
                    }
                    object = this;
                    bl2 = false;
                    bl = false;
                    Object $this$run = object;
                    boolean bl4 = false;
                    LOG.warn("RatProverDriver not available");
                    return new FSM.FsmResult(FSM.FsmResultCode.RAT_ERROR, fsm.getState(FSM.FsmState.STATE_CLOSED));
                }
                return new FSM.FsmResult(FSM.FsmResultCode.OK, this);
            }
        })));
        this.addTransition(5, new Transition((Function1<? super Event, FSM.FsmResult>)((Function1)new Function1<Event, FSM.FsmResult>(){

            @NotNull
            public final FSM.FsmResult invoke(@NotNull Event it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                Logger logger = LOG;
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"LOG");
                if (logger.isDebugEnabled()) {
                    LOG.debug("Peer is requesting a re-attestation");
                }
                if (!fsm.restartRatProverDriver()) {
                    LOG.warn("Cannot run Rat prover, close idscp connection");
                    return new FSM.FsmResult(FSM.FsmResultCode.RAT_ERROR, fsm.getState(FSM.FsmState.STATE_CLOSED));
                }
                return new FSM.FsmResult(FSM.FsmResultCode.OK, this);
            }
        })));
        this.addTransition(9, new Transition((Function1<? super Event, FSM.FsmResult>)((Function1)new Function1<Event, FSM.FsmResult>(){

            @NotNull
            public final FSM.FsmResult invoke(@NotNull Event it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                IDSCP2.IdscpAck idscpAck = it.getIdscpMessage().getIdscpAck();
                Intrinsics.checkNotNullExpressionValue((Object)idscpAck, (String)"it.idscpMessage.idscpAck");
                fsm.recvAck(idscpAck);
                return new FSM.FsmResult(FSM.FsmResultCode.OK, this);
            }
        })));
        this.setNoTransitionHandler(new Function<Event, FSM.FsmResult>(){

            @Override
            @NotNull
            public final FSM.FsmResult apply(@NotNull Event it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                Logger logger = LOG;
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"LOG");
                if (logger.isTraceEnabled()) {
                    LOG.trace("No transition available for given event " + it);
                }
                return new FSM.FsmResult(FSM.FsmResultCode.UNKNOWN_TRANSITION, this);
            }
        });
    }

    static {
        Companion = new Companion(null);
        LOG = LoggerFactory.getLogger(StateWaitForDatAndRat.class);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lde/fhg/aisec/ids/idscp2/idscp_core/fsm/StateWaitForDatAndRat$Companion;", "", "()V", "LOG", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "idscp2"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

