/*
 * Decompiled with CFR 0.152.
 */
package de.fhg.aisec.ids.idscp2.example;

import de.fhg.aisec.ids.idscp2.default_drivers.daps.null_daps.NullDaps;
import de.fhg.aisec.ids.idscp2.default_drivers.secure_channel.tlsv1_3.NativeTlsConfiguration;
import de.fhg.aisec.ids.idscp2.example.CommandlineTunnelServer;
import de.fhg.aisec.ids.idscp2.example.RunTLSServer;
import de.fhg.aisec.ids.idscp2.idscp_core.api.configuration.AttestationConfig;
import de.fhg.aisec.ids.idscp2.idscp_core.api.configuration.Idscp2Configuration;
import de.fhg.aisec.ids.idscp2.idscp_core.drivers.DapsDriver;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001b\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0007\u00a2\u0006\u0002\u0010\b\u00a8\u0006\t"}, d2={"Lde/fhg/aisec/ids/idscp2/example/RunTunnelServer;", "", "()V", "main", "", "argv", "", "", "([Ljava/lang/String;)V", "idscp2"})
public final class RunTunnelServer {
    @NotNull
    public static final RunTunnelServer INSTANCE;

    @JvmStatic
    public static final void main(@NotNull String[] argv) {
        Intrinsics.checkNotNullParameter((Object)argv, (String)"argv");
        AttestationConfig localAttestationConfig = new AttestationConfig.Builder().setSupportedRatSuite(new String[]{"Dummy"}).setExpectedRatSuite(new String[]{"Dummy"}).setRatTimeoutDelay(60000L).build();
        DapsDriver dapsDriver = new NullDaps();
        Idscp2Configuration settings = new Idscp2Configuration.Builder().setAttestationConfig(localAttestationConfig).setDapsDriver(dapsDriver).build();
        NativeTlsConfiguration.Builder builder = new NativeTlsConfiguration.Builder();
        URL uRL = Objects.requireNonNull(RunTLSServer.class.getClassLoader().getResource("ssl/provider-keystore-localhost.p12"));
        Intrinsics.checkNotNullExpressionValue((Object)uRL, (String)"Objects.requireNonNull(R\u2026keystore-localhost.p12\"))");
        Path path = Paths.get(uRL.getPath(), new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"Paths.get(Objects.requir\u2026re-localhost.p12\")).path)");
        NativeTlsConfiguration.Builder builder2 = builder.setKeyStorePath(path);
        URL uRL2 = Objects.requireNonNull(RunTLSServer.class.getClassLoader().getResource("ssl/truststore.p12"));
        Intrinsics.checkNotNullExpressionValue((Object)uRL2, (String)"Objects.requireNonNull(R\u2026ce(\"ssl/truststore.p12\"))");
        Path path2 = Paths.get(uRL2.getPath(), new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"Paths.get(Objects.requir\u2026l/truststore.p12\")).path)");
        NativeTlsConfiguration nativeTlsConfiguration = builder2.setTrustStorePath(path2).setCertificateAlias("1.0.1").setServerPort(12345).setHost("localhost").build();
        CommandlineTunnelServer initiator = new CommandlineTunnelServer();
        initiator.init(settings, nativeTlsConfiguration);
    }

    private RunTunnelServer() {
    }

    static {
        RunTunnelServer runTunnelServer;
        INSTANCE = runTunnelServer = new RunTunnelServer();
    }
}

