/*
 * Decompiled with CFR 0.152.
 */
package de.fhg.aisec.ids.idscp2.default_drivers.secure_channel.tlsv1_3.server;

import de.fhg.aisec.ids.idscp2.default_drivers.keystores.PreConfiguration;
import de.fhg.aisec.ids.idscp2.default_drivers.secure_channel.tlsv1_3.NativeTlsConfiguration;
import de.fhg.aisec.ids.idscp2.default_drivers.secure_channel.tlsv1_3.TLSConstants;
import de.fhg.aisec.ids.idscp2.default_drivers.secure_channel.tlsv1_3.server.TLSServerThread;
import de.fhg.aisec.ids.idscp2.idscp_core.api.idscp_connection.Idscp2Connection;
import de.fhg.aisec.ids.idscp2.idscp_core.api.idscp_server.SecureChannelInitListener;
import de.fhg.aisec.ids.idscp2.idscp_core.api.idscp_server.ServerConnectionListener;
import de.fhg.aisec.ids.idscp2.idscp_core.drivers.SecureServer;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.concurrent.CompletableFuture;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManager;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 \u0018*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u00032\u00020\u0004:\u0001\u0018B/\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\b\u0012\u0012\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u000b0\n\u00a2\u0006\u0002\u0010\fJ\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0016H\u0016R\u001e\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000e@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lde/fhg/aisec/ids/idscp2/default_drivers/secure_channel/tlsv1_3/server/TLSServer;", "CC", "Lde/fhg/aisec/ids/idscp2/idscp_core/api/idscp_connection/Idscp2Connection;", "Ljava/lang/Runnable;", "Lde/fhg/aisec/ids/idscp2/idscp_core/drivers/SecureServer;", "nativeTlsConfiguration", "Lde/fhg/aisec/ids/idscp2/default_drivers/secure_channel/tlsv1_3/NativeTlsConfiguration;", "secureChannelInitListener", "Lde/fhg/aisec/ids/idscp2/idscp_core/api/idscp_server/SecureChannelInitListener;", "serverListenerPromise", "Ljava/util/concurrent/CompletableFuture;", "Lde/fhg/aisec/ids/idscp2/idscp_core/api/idscp_server/ServerConnectionListener;", "(Lde/fhg/aisec/ids/idscp2/default_drivers/secure_channel/tlsv1_3/NativeTlsConfiguration;Lde/fhg/aisec/ids/idscp2/idscp_core/api/idscp_server/SecureChannelInitListener;Ljava/util/concurrent/CompletableFuture;)V", "<set-?>", "", "isRunning", "()Z", "serverSocket", "Ljava/net/ServerSocket;", "serverThread", "Ljava/lang/Thread;", "run", "", "safeStop", "Companion", "idscp2"})
public final class TLSServer<CC extends Idscp2Connection>
implements Runnable,
SecureServer {
    private volatile boolean isRunning;
    private final ServerSocket serverSocket;
    private final Thread serverThread;
    private final SecureChannelInitListener<CC> secureChannelInitListener;
    private final CompletableFuture<ServerConnectionListener<CC>> serverListenerPromise;
    private static final Logger LOG;
    @NotNull
    public static final Companion Companion;

    @Override
    public boolean isRunning() {
        return this.isRunning;
    }

    @Override
    public void run() {
        if (this.serverSocket.isClosed()) {
            LOG.warn("ServerSocket has been closed, server thread is stopping now.");
            return;
        }
        this.isRunning = true;
        Logger logger = LOG;
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"LOG");
        if (logger.isTraceEnabled()) {
            LOG.trace("TLS server started, entering accept() loop...");
        }
        while (this.isRunning()) {
            try {
                Socket socket = this.serverSocket.accept();
                if (socket == null) {
                    throw new NullPointerException("null cannot be cast to non-null type javax.net.ssl.SSLSocket");
                }
                SSLSocket sslSocket = (SSLSocket)socket;
                try {
                    Logger logger2 = LOG;
                    Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"LOG");
                    if (logger2.isTraceEnabled()) {
                        LOG.trace("New TLS client has connected. Creating new server thread...");
                    }
                    TLSServerThread<CC> serverThread = new TLSServerThread<CC>(sslSocket, this.secureChannelInitListener, this.serverListenerPromise);
                    sslSocket.addHandshakeCompletedListener(serverThread);
                    serverThread.start();
                }
                catch (Exception serverThreadException) {
                    LOG.warn("Error whilst creating/starting TLSServerThread", (Throwable)serverThreadException);
                }
            }
            catch (SocketTimeoutException sslSocket) {
            }
            catch (SocketException e) {
                Logger logger3 = LOG;
                Intrinsics.checkNotNullExpressionValue((Object)logger3, (String)"LOG");
                if (logger3.isTraceEnabled()) {
                    LOG.trace("Server socket has been closed.");
                }
                this.isRunning = false;
            }
            catch (IOException e) {
                LOG.warn("Error during TLS server socket accept, notifying error handlers...");
                this.secureChannelInitListener.onError(e);
                this.isRunning = false;
            }
        }
        if (!this.serverSocket.isClosed()) {
            try {
                this.serverSocket.close();
            }
            catch (IOException e) {
                LOG.warn("Could not close TLS server socket", (Throwable)e);
            }
        }
    }

    @Override
    public void safeStop() {
        Logger logger = LOG;
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"LOG");
        if (logger.isTraceEnabled()) {
            LOG.trace("Stopping tls server");
        }
        this.isRunning = false;
        try {
            this.serverThread.join();
        }
        catch (InterruptedException e) {
            LOG.warn("InterruptedException whilst waiting for server stop", (Throwable)e);
            Thread.currentThread().interrupt();
        }
    }

    public TLSServer(@NotNull NativeTlsConfiguration nativeTlsConfiguration, @NotNull SecureChannelInitListener<CC> secureChannelInitListener, @NotNull CompletableFuture<ServerConnectionListener<CC>> serverListenerPromise) {
        SSLParameters sslParameters;
        Intrinsics.checkNotNullParameter((Object)nativeTlsConfiguration, (String)"nativeTlsConfiguration");
        Intrinsics.checkNotNullParameter(secureChannelInitListener, (String)"secureChannelInitListener");
        Intrinsics.checkNotNullParameter(serverListenerPromise, (String)"serverListenerPromise");
        this.secureChannelInitListener = secureChannelInitListener;
        this.serverListenerPromise = serverListenerPromise;
        Logger logger = LOG;
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"LOG");
        if (logger.isTraceEnabled()) {
            LOG.trace("Creating trust manager for TLS server...");
        }
        TrustManager[] myTrustManager = PreConfiguration.INSTANCE.getX509ExtTrustManager(nativeTlsConfiguration.getTrustStorePath(), nativeTlsConfiguration.getTrustStorePassword());
        Logger logger2 = LOG;
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"LOG");
        if (logger2.isTraceEnabled()) {
            LOG.trace("Creating key manager for TLS server...");
        }
        KeyManager[] myKeyManager = PreConfiguration.INSTANCE.getX509ExtKeyManager(nativeTlsConfiguration.getKeyPassword(), nativeTlsConfiguration.getKeyStorePath(), nativeTlsConfiguration.getKeyStorePassword(), nativeTlsConfiguration.getCertificateAlias(), nativeTlsConfiguration.getKeyStoreKeyType());
        Logger logger3 = LOG;
        Intrinsics.checkNotNullExpressionValue((Object)logger3, (String)"LOG");
        if (logger3.isTraceEnabled()) {
            LOG.trace("Setting TLS security attributes and creating TLS server socket...");
        }
        SSLContext sslContext = SSLContext.getInstance("TLSv1.3");
        sslContext.init(myKeyManager, myTrustManager, null);
        SSLContext sSLContext = sslContext;
        Intrinsics.checkNotNullExpressionValue((Object)sSLContext, (String)"sslContext");
        SSLServerSocketFactory socketFactory = sSLContext.getServerSocketFactory();
        ServerSocket serverSocket = socketFactory.createServerSocket(nativeTlsConfiguration.getServerPort());
        Intrinsics.checkNotNullExpressionValue((Object)serverSocket, (String)"socketFactory.createServ\u2026Configuration.serverPort)");
        this.serverSocket = serverSocket;
        this.serverSocket.setSoTimeout(nativeTlsConfiguration.getServerSocketTimeout());
        ServerSocket serverSocket2 = this.serverSocket;
        if (serverSocket2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type javax.net.ssl.SSLServerSocket");
        }
        SSLServerSocket sslServerSocket = (SSLServerSocket)serverSocket2;
        SSLParameters sSLParameters = sslParameters = sslServerSocket.getSSLParameters();
        Intrinsics.checkNotNullExpressionValue((Object)sSLParameters, (String)"sslParameters");
        sSLParameters.setUseCipherSuitesOrder(true);
        sslParameters.setNeedClientAuth(true);
        sslParameters.setProtocols(TLSConstants.INSTANCE.getTLS_ENABLED_PROTOCOLS());
        sslParameters.setCipherSuites(TLSConstants.INSTANCE.getTLS_ENABLED_CIPHERS());
        sslServerSocket.setSSLParameters(sslParameters);
        Logger logger4 = LOG;
        Intrinsics.checkNotNullExpressionValue((Object)logger4, (String)"LOG");
        if (logger4.isTraceEnabled()) {
            LOG.trace("Starting TLS server...");
        }
        this.serverThread = new Thread((Runnable)this, "TLS Server Thread " + nativeTlsConfiguration.getHost() + ":" + nativeTlsConfiguration.getServerPort());
        this.serverThread.start();
    }

    static {
        Companion = new Companion(null);
        LOG = LoggerFactory.getLogger(TLSServer.class);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lde/fhg/aisec/ids/idscp2/default_drivers/secure_channel/tlsv1_3/server/TLSServer$Companion;", "", "()V", "LOG", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "idscp2"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

