/*
 * Decompiled with CFR 0.152.
 */
package de.fhg.aisec.ids.idscp2.default_drivers.daps.aisec_daps;

import de.fhg.aisec.ids.idscp2.default_drivers.daps.aisec_daps.DefaultDapsDriverConfig;
import de.fhg.aisec.ids.idscp2.default_drivers.daps.aisec_daps.SecurityProfile;
import de.fhg.aisec.ids.idscp2.default_drivers.daps.aisec_daps.SecurityRequirements;
import de.fhg.aisec.ids.idscp2.default_drivers.keystores.PreConfiguration;
import de.fhg.aisec.ids.idscp2.idscp_core.drivers.DapsDriver;
import de.fhg.aisec.ids.idscp2.idscp_core.error.DatException;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.KeyManagementException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import java.time.Instant;
import java.util.Date;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509ExtendedTrustManager;
import javax.net.ssl.X509TrustManager;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.FormBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.x509.AuthorityKeyIdentifier;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.SubjectKeyIdentifier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jose4j.http.Get;
import org.jose4j.http.SimpleGet;
import org.jose4j.jwa.AlgorithmConstraints;
import org.jose4j.jwk.HttpsJwks;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.NumericDate;
import org.jose4j.jwt.consumer.JwtConsumer;
import org.jose4j.jwt.consumer.JwtConsumerBuilder;
import org.jose4j.keys.resolvers.HttpsJwksVerificationKeyResolver;
import org.jose4j.keys.resolvers.VerificationKeyResolver;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0005\n\u0002\u0010\u0019\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\u0018\u0000 *2\u00020\u0001:\u0001*B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0010\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u001e\u001a\u00020\rH\u0002J\u0018\u0010\u001f\u001a\u00020\u00062\u0006\u0010 \u001a\u00020\u00152\u0006\u0010!\u001a\u00020\"H\u0002J\u0010\u0010#\u001a\u00020$2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011J\u001a\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u00152\b\u0010(\u001a\u0004\u0018\u00010\rH\u0016J \u0010)\u001a\u00020&2\u0006\u0010'\u001a\u00020\u00152\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u001e\u001a\u00020\rR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lde/fhg/aisec/ids/idscp2/default_drivers/daps/aisec_daps/DefaultDapsDriver;", "Lde/fhg/aisec/ids/idscp2/idscp_core/drivers/DapsDriver;", "config", "Lde/fhg/aisec/ids/idscp2/default_drivers/daps/aisec_daps/DefaultDapsDriverConfig;", "(Lde/fhg/aisec/ids/idscp2/default_drivers/daps/aisec_daps/DefaultDapsDriverConfig;)V", "connectorUUID", "", "dapsUrl", "hexLookup", "Ljava/util/HashMap;", "", "", "localPeerCertificate", "Ljava/security/cert/X509Certificate;", "privateKey", "Ljava/security/Key;", "securityRequirements", "Lde/fhg/aisec/ids/idscp2/default_drivers/daps/aisec_daps/SecurityRequirements;", "sslSocketFactory", "Ljavax/net/ssl/SSLSocketFactory;", "token", "", "getToken", "()[B", "trustManager", "Ljavax/net/ssl/X509ExtendedTrustManager;", "byteToHex", "num", "", "createConnectorUUID", "certificate", "encodeHexString", "byteArray", "beautify", "", "updateSecurityRequirements", "", "verifyToken", "", "dat", "peerCertificate", "verifyTokenSecurityAttributes", "Companion", "idscp2"})
public final class DefaultDapsDriver
implements DapsDriver {
    private SSLSocketFactory sslSocketFactory;
    private SecurityRequirements securityRequirements;
    private final X509ExtendedTrustManager trustManager;
    private final Key privateKey;
    private final String dapsUrl;
    private final X509Certificate localPeerCertificate;
    private final HashMap<Byte, char[]> hexLookup;
    private final String connectorUUID;
    private static final Logger LOG;
    private static final String TARGET_AUDIENCE = "idsc:IDS_CONNECTORS_ALL";
    @NotNull
    public static final Companion Companion;

    private final String createConnectorUUID(X509Certificate certificate) {
        SubjectKeyIdentifier ski;
        ASN1OctetString ski0c;
        AuthorityKeyIdentifier aki;
        ASN1OctetString akiOc;
        ASN1ObjectIdentifier aSN1ObjectIdentifier = Extension.authorityKeyIdentifier;
        Intrinsics.checkNotNullExpressionValue((Object)aSN1ObjectIdentifier, (String)"Extension.authorityKeyIdentifier");
        String akiOid = aSN1ObjectIdentifier.getId();
        byte[] rawAuthorityKeyIdentifier = certificate.getExtensionValue(akiOid);
        ASN1OctetString aSN1OctetString = akiOc = ASN1OctetString.getInstance((Object)rawAuthorityKeyIdentifier);
        Intrinsics.checkNotNullExpressionValue((Object)aSN1OctetString, (String)"akiOc");
        AuthorityKeyIdentifier authorityKeyIdentifier = aki = AuthorityKeyIdentifier.getInstance((Object)aSN1OctetString.getOctets());
        Intrinsics.checkNotNullExpressionValue((Object)authorityKeyIdentifier, (String)"aki");
        byte[] authorityKeyIdentifier2 = authorityKeyIdentifier.getKeyIdentifier();
        Intrinsics.checkNotNullExpressionValue((Object)authorityKeyIdentifier2, (String)"authorityKeyIdentifier");
        String string = this.encodeHexString(authorityKeyIdentifier2, true);
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.toUpperCase();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).toUpperCase()");
        String akiResult = string3;
        ASN1ObjectIdentifier aSN1ObjectIdentifier2 = Extension.subjectKeyIdentifier;
        Intrinsics.checkNotNullExpressionValue((Object)aSN1ObjectIdentifier2, (String)"Extension.subjectKeyIdentifier");
        String skiOid = aSN1ObjectIdentifier2.getId();
        byte[] rawSubjectKeyIdentifier = certificate.getExtensionValue(skiOid);
        ASN1OctetString aSN1OctetString2 = ski0c = ASN1OctetString.getInstance((Object)rawSubjectKeyIdentifier);
        Intrinsics.checkNotNullExpressionValue((Object)aSN1OctetString2, (String)"ski0c");
        SubjectKeyIdentifier subjectKeyIdentifier = ski = SubjectKeyIdentifier.getInstance((Object)aSN1OctetString2.getOctets());
        Intrinsics.checkNotNullExpressionValue((Object)subjectKeyIdentifier, (String)"ski");
        byte[] subjectKeyIdentifier2 = subjectKeyIdentifier.getKeyIdentifier();
        Intrinsics.checkNotNullExpressionValue((Object)subjectKeyIdentifier2, (String)"subjectKeyIdentifier");
        String string4 = this.encodeHexString(subjectKeyIdentifier2, true);
        int n = 0;
        String string5 = string4;
        if (string5 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string6 = string5.toUpperCase();
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"(this as java.lang.String).toUpperCase()");
        String skiResult = string6;
        Logger logger = LOG;
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"LOG");
        if (logger.isDebugEnabled()) {
            LOG.debug("AKI: " + akiResult);
            LOG.debug("SKI: " + skiResult);
        }
        StringBuilder stringBuilder = new StringBuilder().append(skiResult).append("keyid:");
        string4 = akiResult;
        n = 0;
        int n2 = akiResult.length() - 1;
        boolean bl2 = false;
        String string7 = string4;
        if (string7 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string8 = string7.substring(n, n2);
        Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        return stringBuilder.append(string8).toString();
    }

    @Override
    @NotNull
    public byte[] getToken() {
        byte[] byArray;
        String token = null;
        LOG.info("Retrieving Dynamic Attribute Token from Daps ...");
        Logger logger = LOG;
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"LOG");
        if (logger.isDebugEnabled()) {
            LOG.debug("ConnectorUUID: " + this.connectorUUID);
            LOG.debug("Retrieving Dynamic Attribute Token...");
        }
        Date expiration = Date.from(Instant.now().plusSeconds(86400L));
        Date issuedAt = Date.from(Instant.now());
        Date notBefore = Date.from(Instant.now());
        String jwt = Jwts.builder().setIssuer(this.connectorUUID).setSubject(this.connectorUUID).claim("@context", (Object)"https://w3id.org/idsa/contexts/context.jsonld").claim("@type", (Object)"ids:DatRequestToken").setExpiration(expiration).setIssuedAt(issuedAt).setNotBefore(notBefore).setAudience(TARGET_AUDIENCE).signWith(this.privateKey, SignatureAlgorithm.RS256).compact();
        FormBody.Builder builder = new FormBody.Builder(null, 1, null).add("grant_type", "client_credentials").add("client_assertion_type", "urn:ietf:params:oauth:client-assertion-type:jwt-bearer");
        String string = jwt;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"jwt");
        RequestBody formBody = (RequestBody)builder.add("client_assertion", string).add("scope", "idsc:IDS_CONNECTOR_ATTRIBUTES_ALL").build();
        OkHttpClient client = new OkHttpClient.Builder().sslSocketFactory(this.sslSocketFactory, (X509TrustManager)this.trustManager).connectTimeout(15L, TimeUnit.SECONDS).writeTimeout(15L, TimeUnit.SECONDS).readTimeout(15L, TimeUnit.SECONDS).build();
        Request request = new Request.Builder().url(this.dapsUrl + "/v2/token").post(formBody).build();
        try {
            Object object;
            Response response = client.newCall(request).execute();
            if (!response.isSuccessful()) {
                LOG.error("Failed to request token issued with parameters: Issuer: {}, Subject: {}, Expiration: {}, IssuedAt: {}, NotBefore: {}, Audience: {}", new Object[]{this.connectorUUID, this.connectorUUID, expiration, issuedAt, notBefore, TARGET_AUDIENCE});
                throw (Throwable)new DatException("Received non-200 http response: " + response.code());
            }
            Logger logger2 = LOG;
            Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"LOG");
            if (logger2.isDebugEnabled()) {
                LOG.debug("Acquired DAT from {}/v2/token", (Object)this.dapsUrl);
            }
            if ((object = response.body()) == null || (object = object.string()) == null) {
                throw (Throwable)new DatException("Received empty DAPS response");
            }
            JSONObject json = new JSONObject((String)object);
            if (json.has("access_token")) {
                String string2 = json.getString("access_token");
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"json.getString(\"access_token\")");
                token = string2;
                Logger logger3 = LOG;
                Intrinsics.checkNotNullExpressionValue((Object)logger3, (String)"LOG");
                if (logger3.isDebugEnabled()) {
                    LOG.debug("Received DAT from DAPS: {}", (Object)token);
                }
            } else {
                if (json.has("error")) {
                    throw (Throwable)new DatException("DAPS reported error: " + json.getString("error"));
                }
                throw (Throwable)new DatException("DAPS response does not contain \"access_token\" or \"error\" field.");
            }
            String string3 = token;
            Charset charset = StandardCharsets.UTF_8;
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"StandardCharsets.UTF_8");
            Charset charset2 = charset;
            boolean bl = false;
            String string4 = string3;
            if (string4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            byte[] byArray2 = string4.getBytes(charset2);
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"(this as java.lang.String).getBytes(charset)");
            this.verifyTokenSecurityAttributes(byArray2, null, this.localPeerCertificate);
            string3 = token;
            Charset charset3 = StandardCharsets.UTF_8;
            Intrinsics.checkNotNullExpressionValue((Object)charset3, (String)"StandardCharsets.UTF_8");
            charset2 = charset3;
            bl = false;
            String string5 = string3;
            if (string5 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            byte[] byArray3 = string5.getBytes(charset2);
            Intrinsics.checkNotNullExpressionValue((Object)byArray3, (String)"(this as java.lang.String).getBytes(charset)");
            byArray = byArray3;
        }
        catch (IOException e) {
            throw (Throwable)new DatException("Error whilst retrieving DAT", e);
        }
        return byArray;
    }

    public final void updateSecurityRequirements(@Nullable SecurityRequirements securityRequirements) {
        this.securityRequirements = securityRequirements;
    }

    @Override
    public long verifyToken(@NotNull byte[] dat, @Nullable X509Certificate peerCertificate) {
        Intrinsics.checkNotNullParameter((Object)dat, (String)"dat");
        if (peerCertificate == null) {
            throw (Throwable)new DatException("Missing peer certificate for fingerprint validation");
        }
        return this.verifyTokenSecurityAttributes(dat, this.securityRequirements, peerCertificate);
    }

    public final long verifyTokenSecurityAttributes(@NotNull byte[] dat, @Nullable SecurityRequirements securityRequirements, @NotNull X509Certificate certificate) {
        Intrinsics.checkNotNullParameter((Object)dat, (String)"dat");
        Intrinsics.checkNotNullParameter((Object)certificate, (String)"certificate");
        Logger logger = LOG;
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"LOG");
        if (logger.isDebugEnabled()) {
            LOG.debug("Verifying dynamic attribute token...");
        }
        HttpsJwks httpsJwks = new HttpsJwks(this.dapsUrl + "/.well-known/jwks.json");
        Get getInstance = new Get();
        getInstance.setSslSocketFactory(this.sslSocketFactory);
        httpsJwks.setSimpleHttpGet((SimpleGet)getInstance);
        HttpsJwksVerificationKeyResolver jwksKeyResolver = new HttpsJwksVerificationKeyResolver(httpsJwks);
        JwtConsumer jwtConsumer = new JwtConsumerBuilder().setRequireExpirationTime().setAllowedClockSkewInSeconds(30).setRequireSubject().setExpectedAudience(true, new String[]{"IDS_Connector", TARGET_AUDIENCE}).setExpectedIssuer(this.dapsUrl).setVerificationKeyResolver((VerificationKeyResolver)jwksKeyResolver).setJweAlgorithmConstraints(new AlgorithmConstraints(AlgorithmConstraints.ConstraintType.PERMIT, new String[]{"RS256"})).build();
        long validityTime = 0L;
        JwtClaims claims = null;
        try {
            NumericDate expTime;
            Charset charset = StandardCharsets.UTF_8;
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"StandardCharsets.UTF_8");
            Charset charset2 = charset;
            boolean bl = false;
            JwtClaims jwtClaims = jwtConsumer.processToClaims(new String(dat, charset2));
            Intrinsics.checkNotNullExpressionValue((Object)jwtClaims, (String)"jwtConsumer.processToCla\u2026 StandardCharsets.UTF_8))");
            claims = jwtClaims;
            NumericDate numericDate = expTime = claims.getExpirationTime();
            Intrinsics.checkNotNullExpressionValue((Object)numericDate, (String)"expTime");
            long l = numericDate.getValue();
            NumericDate numericDate2 = NumericDate.now();
            Intrinsics.checkNotNullExpressionValue((Object)numericDate2, (String)"NumericDate.now()");
            validityTime = l - numericDate2.getValue();
        }
        catch (Exception e) {
            throw (Throwable)new DatException("Error during claims processing", e);
        }
        if (Intrinsics.areEqual((Object)certificate, (Object)this.localPeerCertificate) ^ true) {
            Logger logger2 = LOG;
            Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"LOG");
            if (logger2.isDebugEnabled()) {
                LOG.debug("Validate peer certificate fingerprint against expected fingerprint from DAT");
            }
            Object object = claims.getClaimValue("transportCertsSha256");
            if (object == null) {
                throw (Throwable)new DatException("DAT does not contain peer certificate fingerprints");
            }
            Object datCertFingerprint = object;
            String peerCertFingerprint = null;
            try {
                MessageDigest sha256 = MessageDigest.getInstance("SHA-256");
                sha256.update(certificate.getEncoded());
                byte[] digest = sha256.digest();
                Intrinsics.checkNotNullExpressionValue((Object)digest, (String)"digest");
                String string = this.encodeHexString(digest, false);
                boolean bl = false;
                String string2 = string;
                if (string2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string3 = string2.toLowerCase();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).toLowerCase()");
                peerCertFingerprint = string3;
            }
            catch (Exception e) {
                throw (Throwable)new DatException("Cannot calculate peer certificate fingerprint", e);
            }
            if (Intrinsics.areEqual((Object)peerCertFingerprint, (Object)datCertFingerprint) ^ true) {
                throw (Throwable)new DatException("Fingerprint of peer certificate does not match the expected fingerprint from DAT");
            }
        }
        if (securityRequirements != null) {
            Logger logger3 = LOG;
            Intrinsics.checkNotNullExpressionValue((Object)logger3, (String)"LOG");
            if (logger3.isDebugEnabled()) {
                LOG.debug("Validate security attributes");
            }
            String string = claims.getStringClaimValue("securityProfile");
            if (string == null) {
                throw (Throwable)new DatException("DAT does not contain securityProfile");
            }
            String securityProfile = string;
            SecurityProfile securityProfilePeer = SecurityProfile.Companion.fromString(securityProfile);
            if (securityProfilePeer.compareTo((Enum)securityRequirements.getRequiredSecurityLevel()) < 0) {
                throw (Throwable)new DatException("Peer does not support any valid trust profile: Required: " + (Object)((Object)securityRequirements.getRequiredSecurityLevel()) + " given: " + (Object)((Object)securityProfilePeer));
            }
            Logger logger4 = LOG;
            Intrinsics.checkNotNullExpressionValue((Object)logger4, (String)"LOG");
            if (logger4.isDebugEnabled()) {
                LOG.debug("Peer's supported security profile: {}", (Object)securityProfilePeer);
            }
        }
        Logger logger5 = LOG;
        Intrinsics.checkNotNullExpressionValue((Object)logger5, (String)"LOG");
        if (logger5.isDebugEnabled()) {
            LOG.debug("DAT is valid for {} seconds", (Object)validityTime);
        }
        return validityTime;
    }

    private final char[] byteToHex(int num) {
        char[] hexDigits = new char[]{Character.forDigit(num >> 4 & 0xF, 16), Character.forDigit(num & 0xF, 16)};
        return hexDigits;
    }

    private final String encodeHexString(byte[] byteArray, boolean beautify) {
        StringBuilder sb = new StringBuilder();
        for (byte b : byteArray) {
            sb.append(this.hexLookup.computeIfAbsent(b, new Function<Byte, char[]>(this){
                final /* synthetic */ DefaultDapsDriver this$0;

                @NotNull
                public final char[] apply(byte num) {
                    return DefaultDapsDriver.access$byteToHex(this.this$0, num);
                }
                {
                    this.this$0 = defaultDapsDriver;
                }
            }));
            if (!beautify) continue;
            sb.append(':');
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    public DefaultDapsDriver(@NotNull DefaultDapsDriverConfig config) {
        SSLSocketFactory sSLSocketFactory;
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.securityRequirements = config.getSecurityRequirements();
        this.privateKey = PreConfiguration.INSTANCE.getKey(config.getKeyStorePath(), config.getKeyStorePassword(), config.getKeyAlias(), config.getKeyPassword());
        this.dapsUrl = config.getDapsUrl();
        this.localPeerCertificate = PreConfiguration.INSTANCE.getCertificate(config.getKeyStorePath(), config.getKeyStorePassword(), config.getKeyAlias());
        this.hexLookup = new HashMap();
        this.connectorUUID = this.createConnectorUUID(this.localPeerCertificate);
        TrustManager[] trustManagers = PreConfiguration.INSTANCE.getX509ExtTrustManager(config.getTrustStorePath(), config.getTrustStorePassword());
        TrustManager trustManager = trustManagers[0];
        if (trustManager == null) {
            throw new NullPointerException("null cannot be cast to non-null type javax.net.ssl.X509ExtendedTrustManager");
        }
        this.trustManager = (X509ExtendedTrustManager)trustManager;
        DefaultDapsDriver defaultDapsDriver = this;
        try {
            DefaultDapsDriver defaultDapsDriver2 = defaultDapsDriver;
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, trustManagers, null);
            SSLContext sSLContext = sslContext;
            Intrinsics.checkNotNullExpressionValue((Object)sSLContext, (String)"sslContext");
            SSLSocketFactory sSLSocketFactory2 = sSLContext.getSocketFactory();
            Intrinsics.checkNotNullExpressionValue((Object)sSLSocketFactory2, (String)"sslContext.socketFactory");
            sSLSocketFactory = sSLSocketFactory2;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            void e;
            DefaultDapsDriver defaultDapsDriver3 = defaultDapsDriver;
            LOG.error("Cannot init DefaultDapsDriver: {}", (Object)e.toString());
            throw (Throwable)new RuntimeException((Throwable)e);
        }
        catch (KeyManagementException e) {
            DefaultDapsDriver defaultDapsDriver4 = defaultDapsDriver;
            LOG.error("Cannot init DefaultDapsDriver: {}", (Object)e.toString());
            throw (Throwable)new RuntimeException(e);
        }
        defaultDapsDriver2.sslSocketFactory = sSLSocketFactory;
    }

    static {
        Companion = new Companion(null);
        LOG = LoggerFactory.getLogger(DefaultDapsDriver.class);
    }

    public static final /* synthetic */ char[] access$byteToHex(DefaultDapsDriver $this, int num) {
        return $this.byteToHex(num);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lde/fhg/aisec/ids/idscp2/default_drivers/daps/aisec_daps/DefaultDapsDriver$Companion;", "", "()V", "LOG", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "TARGET_AUDIENCE", "", "idscp2"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

