/*
 * Decompiled with CFR 0.152.
 */
package de.fhg.aisec.ids.idscp2.idscp_core.secure_channel;

import de.fhg.aisec.ids.idscp2.idscp_core.drivers.SecureChannelEndpoint;
import de.fhg.aisec.ids.idscp2.idscp_core.fsm.fsmListeners.ScFsmListener;
import de.fhg.aisec.ids.idscp2.idscp_core.secure_channel.SecureChannel;
import de.fhg.aisec.ids.idscp2.idscp_core.secure_channel.SecureChannelListener;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0006\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u000b\u001a\u00020\fJ\b\u0010\r\u001a\u00020\fH\u0016J\u0010\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u000e\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u0013J\u000e\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\n\u00a8\u0006\u0019"}, d2={"Lde/fhg/aisec/ids/idscp2/idscp_core/secure_channel/SecureChannel;", "Lde/fhg/aisec/ids/idscp2/idscp_core/secure_channel/SecureChannelListener;", "endpoint", "Lde/fhg/aisec/ids/idscp2/idscp_core/drivers/SecureChannelEndpoint;", "(Lde/fhg/aisec/ids/idscp2/idscp_core/drivers/SecureChannelEndpoint;)V", "fsmPromise", "Ljava/util/concurrent/CompletableFuture;", "Lde/fhg/aisec/ids/idscp2/idscp_core/fsm/fsmListeners/ScFsmListener;", "isConnected", "", "()Z", "close", "", "onClose", "onError", "t", "", "onMessage", "data", "", "send", "msg", "setFsm", "fsm", "Companion", "idscp2"})
public final class SecureChannel
implements SecureChannelListener {
    private final CompletableFuture<ScFsmListener> fsmPromise;
    private final SecureChannelEndpoint endpoint;
    private static final Logger LOG;
    @NotNull
    public static final Companion Companion;

    public final void close() {
        Logger logger = LOG;
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"LOG");
        if (logger.isTraceEnabled()) {
            LOG.trace("Close secure channel");
        }
        this.endpoint.close();
    }

    public final boolean send(@NotNull byte[] msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        Logger logger = LOG;
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"LOG");
        if (logger.isTraceEnabled()) {
            LOG.trace("Send message via secure channel");
        }
        return this.endpoint.send(msg);
    }

    @Override
    public void onMessage(@NotNull byte[] data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Logger logger = LOG;
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"LOG");
        if (logger.isTraceEnabled()) {
            LOG.trace("New raw data has been received via the secure channel");
        }
        this.fsmPromise.thenAccept((Consumer)new Consumer<ScFsmListener>(data){
            final /* synthetic */ byte[] $data;

            public final void accept(@NotNull ScFsmListener fsmListener) {
                Intrinsics.checkNotNullParameter((Object)fsmListener, (String)"fsmListener");
                fsmListener.onMessage(this.$data);
            }
            {
                this.$data = byArray;
            }
        });
    }

    @Override
    public void onError(@NotNull Throwable t) {
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        this.fsmPromise.thenAccept((Consumer)new Consumer<ScFsmListener>(t){
            final /* synthetic */ Throwable $t;

            public final void accept(@NotNull ScFsmListener fsmListener) {
                Intrinsics.checkNotNullParameter((Object)fsmListener, (String)"fsmListener");
                fsmListener.onError(this.$t);
            }
            {
                this.$t = throwable;
            }
        });
    }

    @Override
    public void onClose() {
        this.fsmPromise.thenAccept((Consumer)onClose.1.INSTANCE);
    }

    public final boolean isConnected() {
        return this.endpoint.isConnected();
    }

    public final void setFsm(@NotNull ScFsmListener fsm) {
        Intrinsics.checkNotNullParameter((Object)fsm, (String)"fsm");
        this.fsmPromise.complete(fsm);
    }

    public SecureChannel(@NotNull SecureChannelEndpoint endpoint) {
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        this.endpoint = endpoint;
        this.fsmPromise = new CompletableFuture();
    }

    static {
        Companion = new Companion(null);
        LOG = LoggerFactory.getLogger(SecureChannel.class);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lde/fhg/aisec/ids/idscp2/idscp_core/secure_channel/SecureChannel$Companion;", "", "()V", "LOG", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "idscp2"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

