/*
 * Decompiled with CFR 0.152.
 */
package de.fhg.aisec.ids.idscp2.idscp_core.fsm;

import com.google.protobuf.InvalidProtocolBufferException;
import de.fhg.aisec.ids.idscp2.idscp_core.FastLatch;
import de.fhg.aisec.ids.idscp2.idscp_core.api.configuration.AttestationConfig;
import de.fhg.aisec.ids.idscp2.idscp_core.api.idscp_connection.Idscp2Connection;
import de.fhg.aisec.ids.idscp2.idscp_core.drivers.DapsDriver;
import de.fhg.aisec.ids.idscp2.idscp_core.drivers.RatProverDriver;
import de.fhg.aisec.ids.idscp2.idscp_core.drivers.RatVerifierDriver;
import de.fhg.aisec.ids.idscp2.idscp_core.error.Idscp2HandshakeException;
import de.fhg.aisec.ids.idscp2.idscp_core.fsm.AlternatingBit;
import de.fhg.aisec.ids.idscp2.idscp_core.fsm.DynamicTimer;
import de.fhg.aisec.ids.idscp2.idscp_core.fsm.Event;
import de.fhg.aisec.ids.idscp2.idscp_core.fsm.InternalControlMessage;
import de.fhg.aisec.ids.idscp2.idscp_core.fsm.State;
import de.fhg.aisec.ids.idscp2.idscp_core.fsm.StateClosed;
import de.fhg.aisec.ids.idscp2.idscp_core.fsm.StateEstablished;
import de.fhg.aisec.ids.idscp2.idscp_core.fsm.StateWaitForAck;
import de.fhg.aisec.ids.idscp2.idscp_core.fsm.StateWaitForDatAndRat;
import de.fhg.aisec.ids.idscp2.idscp_core.fsm.StateWaitForDatAndRatVerifier;
import de.fhg.aisec.ids.idscp2.idscp_core.fsm.StateWaitForHello;
import de.fhg.aisec.ids.idscp2.idscp_core.fsm.StateWaitForRat;
import de.fhg.aisec.ids.idscp2.idscp_core.fsm.StateWaitForRatProver;
import de.fhg.aisec.ids.idscp2.idscp_core.fsm.StateWaitForRatVerifier;
import de.fhg.aisec.ids.idscp2.idscp_core.fsm.StaticTimer;
import de.fhg.aisec.ids.idscp2.idscp_core.fsm.fsmListeners.RatProverFsmListener;
import de.fhg.aisec.ids.idscp2.idscp_core.fsm.fsmListeners.RatVerifierFsmListener;
import de.fhg.aisec.ids.idscp2.idscp_core.fsm.fsmListeners.ScFsmListener;
import de.fhg.aisec.ids.idscp2.idscp_core.messages.Idscp2MessageHelper;
import de.fhg.aisec.ids.idscp2.idscp_core.rat_registry.RatProverDriverRegistry;
import de.fhg.aisec.ids.idscp2.idscp_core.rat_registry.RatVerifierDriverRegistry;
import de.fhg.aisec.ids.idscp2.idscp_core.secure_channel.SecureChannel;
import de.fhg.aisec.ids.idscp2.messages.IDSCP2;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.GlobalScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u00d6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0011\u0018\u0000 \u0082\u00012\u00020\u00012\u00020\u00022\u00020\u0003:\b\u0082\u0001\u0083\u0001\u0084\u0001\u0085\u0001B5\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000fJ\b\u0010K\u001a\u00020LH\u0002J\u0006\u0010M\u001a\u00020NJ\u0010\u0010O\u001a\u00020N2\u0006\u0010P\u001a\u00020QH\u0002J)\u0010R\u001a\u0004\u0018\u00010\u001c2\f\u0010S\u001a\b\u0012\u0004\u0012\u00020\u001c0T2\f\u0010U\u001a\b\u0012\u0004\u0012\u00020\u001c0T\u00a2\u0006\u0002\u0010VJ)\u0010W\u001a\u0004\u0018\u00010\u001c2\f\u0010X\u001a\b\u0012\u0004\u0012\u00020\u001c0T2\f\u0010Y\u001a\b\u0012\u0004\u0012\u00020\u001c0T\u00a2\u0006\u0002\u0010VJ\u000e\u0010Z\u001a\u00020\u001f2\u0006\u0010[\u001a\u00020HJ)\u0010\\\u001a\u0004\u0018\u00010\u001c2\f\u0010]\u001a\b\u0012\u0004\u0012\u00020\u001c0T2\f\u0010^\u001a\b\u0012\u0004\u0012\u00020\u001c0T\u00a2\u0006\u0002\u0010VJ\u0006\u0010_\u001a\u00020LJ\u0010\u0010`\u001a\u00020L2\u0006\u0010a\u001a\u00020*H\u0002J\b\u0010b\u001a\u00020LH\u0016J\u0010\u0010c\u001a\u00020L2\u0006\u0010d\u001a\u00020eH\u0002J\u0010\u0010f\u001a\u00020L2\u0006\u0010g\u001a\u00020hH\u0016J\u0010\u0010i\u001a\u00020L2\u0006\u0010a\u001a\u00020*H\u0016J\u0010\u0010j\u001a\u00020L2\u0006\u0010d\u001a\u00020eH\u0016J\u0018\u0010j\u001a\u00020L2\u0006\u0010d\u001a\u00020e2\u0006\u0010k\u001a\u00020*H\u0016J\u0010\u0010l\u001a\u00020L2\u0006\u0010d\u001a\u00020eH\u0016J\u0018\u0010l\u001a\u00020L2\u0006\u0010d\u001a\u00020e2\u0006\u0010k\u001a\u00020*H\u0016J\u0010\u0010m\u001a\u00020N2\u0006\u0010P\u001a\u00020QH\u0002J\u0010\u0010n\u001a\u00020L2\u0006\u0010o\u001a\u00020QH\u0002J\u0010\u0010p\u001a\u00020L2\u0006\u0010o\u001a\u00020QH\u0002J\u000e\u0010q\u001a\u00020\u00112\u0006\u0010r\u001a\u00020sJ\u000e\u0010t\u001a\u00020L2\u0006\u0010a\u001a\u00020uJ\u0006\u0010v\u001a\u00020NJ\u0006\u0010w\u001a\u00020\u0011J\u0006\u0010x\u001a\u00020\u0011J\u0010\u0010y\u001a\u00020N2\b\u0010z\u001a\u0004\u0018\u00010*J\u000e\u0010{\u001a\u00020\u00112\u0006\u0010z\u001a\u00020\u001aJ\u000e\u0010|\u001a\u00020L2\u0006\u0010z\u001a\u00020\u001aJ\u0016\u0010}\u001a\u00020L2\u0006\u0010;\u001a\u00020\u001c2\u0006\u0010J\u001a\u00020\u001cJ\u0006\u0010~\u001a\u00020LJ\u0006\u0010\u007f\u001a\u00020LJ\t\u0010\u0080\u0001\u001a\u00020LH\u0002J\u0007\u0010\u0081\u0001\u001a\u00020LR$\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u0011@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010&\u001a\u0004\u0018\u00010\u001a8F\u00a2\u0006\u0006\u001a\u0004\b'\u0010(R\u0011\u0010)\u001a\u00020*8F\u00a2\u0006\u0006\u001a\u0004\b+\u0010,R\u000e\u0010-\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010.\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010/\u001a\u000200X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u00101\u001a\n 3*\u0004\u0018\u00010202X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u00104\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b4\u0010\u0014R\u0011\u00105\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b5\u0010\u0014R\u000e\u00106\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u00107\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b7\u0010\u0014R\u000e\u00108\u001a\u00020#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u00109\u001a\n 3*\u0004\u0018\u00010202X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010:\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010;\u001a\u00020\u001cX\u0082.\u00a2\u0006\u0002\n\u0000R*\u0010>\u001a\b\u0012\u0002\b\u0003\u0018\u00010=2\f\u0010<\u001a\b\u0012\u0002\b\u0003\u0018\u00010=@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b?\u0010@R\u000e\u0010A\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010C\u001a\b\u0012\u0002\b\u0003\u0018\u00010B2\f\u0010<\u001a\b\u0012\u0002\b\u0003\u0018\u00010B@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\bD\u0010ER\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010F\u001a\u000e\u0012\u0004\u0012\u00020H\u0012\u0004\u0012\u00020\u001f0GX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010I\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010J\u001a\u00020\u001cX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0086\u0001"}, d2={"Lde/fhg/aisec/ids/idscp2/idscp_core/fsm/FSM;", "Lde/fhg/aisec/ids/idscp2/idscp_core/fsm/fsmListeners/RatProverFsmListener;", "Lde/fhg/aisec/ids/idscp2/idscp_core/fsm/fsmListeners/RatVerifierFsmListener;", "Lde/fhg/aisec/ids/idscp2/idscp_core/fsm/fsmListeners/ScFsmListener;", "connection", "Lde/fhg/aisec/ids/idscp2/idscp_core/api/idscp_connection/Idscp2Connection;", "secureChannel", "Lde/fhg/aisec/ids/idscp2/idscp_core/secure_channel/SecureChannel;", "dapsDriver", "Lde/fhg/aisec/ids/idscp2/idscp_core/drivers/DapsDriver;", "attestationConfig", "Lde/fhg/aisec/ids/idscp2/idscp_core/api/configuration/AttestationConfig;", "ackTimeoutDelay", "", "handshakeTimeoutDelay", "(Lde/fhg/aisec/ids/idscp2/idscp_core/api/idscp_connection/Idscp2Connection;Lde/fhg/aisec/ids/idscp2/idscp_core/secure_channel/SecureChannel;Lde/fhg/aisec/ids/idscp2/idscp_core/drivers/DapsDriver;Lde/fhg/aisec/ids/idscp2/idscp_core/api/configuration/AttestationConfig;JJ)V", "value", "", "ackFlag", "getAckFlag", "()Z", "setAckFlag", "(Z)V", "ackTimer", "Lde/fhg/aisec/ids/idscp2/idscp_core/fsm/StaticTimer;", "bufferedIdscpData", "Lde/fhg/aisec/ids/idscp2/messages/IDSCP2$IdscpMessage;", "currentRatProverId", "", "currentRatVerifierId", "currentState", "Lde/fhg/aisec/ids/idscp2/idscp_core/fsm/State;", "datTimer", "Lde/fhg/aisec/ids/idscp2/idscp_core/fsm/DynamicTimer;", "expectedAlternatingBit", "Lde/fhg/aisec/ids/idscp2/idscp_core/fsm/AlternatingBit;", "fsmIsBusy", "Ljava/util/concurrent/locks/ReentrantLock;", "getBufferedIdscpMessage", "getGetBufferedIdscpMessage", "()Lde/fhg/aisec/ids/idscp2/messages/IDSCP2$IdscpMessage;", "getDynamicAttributeToken", "", "getGetDynamicAttributeToken", "()[B", "handshakeResultAvailable", "handshakeTimer", "idscpHandshakeCompletedLatch", "Lde/fhg/aisec/ids/idscp2/idscp_core/FastLatch;", "idscpHandshakeLock", "Ljava/util/concurrent/locks/Condition;", "kotlin.jvm.PlatformType", "isConnected", "isFsmLocked", "isLocked", "isNotClosed", "nextSendAlternatingBit", "onMessageBlock", "proverHandshakeTimer", "proverMechanism", "<set-?>", "Lde/fhg/aisec/ids/idscp2/idscp_core/drivers/RatProverDriver;", "ratProverDriver", "getRatProverDriver", "()Lde/fhg/aisec/ids/idscp2/idscp_core/drivers/RatProverDriver;", "ratTimer", "Lde/fhg/aisec/ids/idscp2/idscp_core/drivers/RatVerifierDriver;", "ratVerifierDriver", "getRatVerifierDriver", "()Lde/fhg/aisec/ids/idscp2/idscp_core/drivers/RatVerifierDriver;", "states", "Ljava/util/HashMap;", "Lde/fhg/aisec/ids/idscp2/idscp_core/fsm/FSM$FsmState;", "verifierHandshakeTimer", "verifierMechanism", "checkForFsmCycles", "", "closeConnection", "Lde/fhg/aisec/ids/idscp2/idscp_core/fsm/FSM$FsmResultCode;", "feedEvent", "event", "Lde/fhg/aisec/ids/idscp2/idscp_core/fsm/Event;", "getRatProverMechanism", "localSupportedProver", "", "remoteExpectedVerifier", "([Ljava/lang/String;[Ljava/lang/String;)Ljava/lang/String;", "getRatVerifierMechanism", "localExpectedVerifier", "remoteSupportedProver", "getState", "state", "matchRatMechanisms", "primary", "secondary", "notifyHandshakeCompleteLock", "notifyIdscpMsgListener", "data", "onClose", "onControlMessage", "controlMessage", "Lde/fhg/aisec/ids/idscp2/idscp_core/fsm/InternalControlMessage;", "onError", "t", "", "onMessage", "onRatProverMessage", "ratMessage", "onRatVerifierMessage", "onUpperEvent", "processRatProverEvent", "e", "processRatVerifierEvent", "recvAck", "ack", "Lde/fhg/aisec/ids/idscp2/messages/IDSCP2$IdscpAck;", "recvData", "Lde/fhg/aisec/ids/idscp2/messages/IDSCP2$IdscpData;", "repeatRat", "restartRatProverDriver", "restartRatVerifierDriver", "send", "msg", "sendFromFSM", "setBufferedIdscpData", "setRatMechanisms", "shutdownFsm", "startIdscpHandshake", "stopRatProverDriver", "stopRatVerifierDriver", "Companion", "FsmResult", "FsmResultCode", "FsmState", "idscp2"})
public final class FSM
implements RatProverFsmListener,
RatVerifierFsmListener,
ScFsmListener {
    private final HashMap<FsmState, State> states;
    private State currentState;
    private final Idscp2Connection connection;
    private final SecureChannel secureChannel;
    @Nullable
    private RatProverDriver<?> ratProverDriver;
    @Nullable
    private RatVerifierDriver<?> ratVerifierDriver;
    private String currentRatProverId;
    private String currentRatVerifierId;
    private String proverMechanism;
    private String verifierMechanism;
    private final ReentrantLock fsmIsBusy;
    private final Condition onMessageBlock;
    private final Condition idscpHandshakeLock;
    private boolean handshakeResultAvailable;
    private final FastLatch idscpHandshakeCompletedLatch;
    private boolean isLocked;
    private boolean ackFlag;
    private IDSCP2.IdscpMessage bufferedIdscpData;
    private AlternatingBit expectedAlternatingBit;
    private AlternatingBit nextSendAlternatingBit;
    private final DynamicTimer datTimer;
    private final StaticTimer ratTimer;
    private final StaticTimer handshakeTimer;
    private final StaticTimer proverHandshakeTimer;
    private final StaticTimer verifierHandshakeTimer;
    private final StaticTimer ackTimer;
    private final DapsDriver dapsDriver;
    private static final Logger LOG;
    @NotNull
    public static final Companion Companion;

    @Nullable
    public final RatProverDriver<?> getRatProverDriver() {
        return this.ratProverDriver;
    }

    @Nullable
    public final RatVerifierDriver<?> getRatVerifierDriver() {
        return this.ratVerifierDriver;
    }

    public final boolean getAckFlag() {
        return this.ackFlag;
    }

    public final void setAckFlag(boolean value) {
        this.ackFlag = value;
        if (!value) {
            this.bufferedIdscpData = null;
        }
    }

    private final void checkForFsmCycles() {
        if (this.fsmIsBusy.isHeldByCurrentThread()) {
            RuntimeException e = new RuntimeException("The current thread holds the fsm lock already. A circle might occur that could lead to undefined behaviour within the fsm");
            LOG.error(e.getMessage(), (Throwable)e);
            throw (Throwable)e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onMessage(@NotNull byte[] data) {
        IDSCP2.IdscpMessage idscpMessage;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        this.checkForFsmCycles();
        try {
            IDSCP2.IdscpMessage idscpMessage2 = IDSCP2.IdscpMessage.parseFrom(data);
            Intrinsics.checkNotNullExpressionValue((Object)idscpMessage2, (String)"IdscpMessage.parseFrom(data)");
            idscpMessage = idscpMessage2;
        }
        catch (InvalidProtocolBufferException e) {
            LOG.warn("Cannot parse raw data into IdscpMessage {}", (Object)data);
            return;
        }
        IDSCP2.IdscpMessage message = idscpMessage;
        Event event = new Event(message);
        this.fsmIsBusy.lock();
        try {
            while (Intrinsics.areEqual((Object)this.currentState, (Object)this.states.get((Object)FsmState.STATE_CLOSED))) {
                if (this.isLocked) {
                    return;
                }
                try {
                    this.onMessageBlock.await();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            this.feedEvent(event);
        }
        finally {
            this.fsmIsBusy.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void onControlMessage(InternalControlMessage controlMessage) {
        Event e = new Event(controlMessage);
        this.fsmIsBusy.lock();
        try {
            this.feedEvent(e);
        }
        finally {
            this.fsmIsBusy.unlock();
        }
    }

    @Override
    public void onRatProverMessage(@NotNull InternalControlMessage controlMessage, @NotNull byte[] ratMessage) {
        Intrinsics.checkNotNullParameter((Object)((Object)controlMessage), (String)"controlMessage");
        Intrinsics.checkNotNullParameter((Object)ratMessage, (String)"ratMessage");
        this.processRatProverEvent(new Event(controlMessage, Idscp2MessageHelper.INSTANCE.createIdscpRatProverMessage(ratMessage)));
    }

    @Override
    public void onRatProverMessage(@NotNull InternalControlMessage controlMessage) {
        Intrinsics.checkNotNullParameter((Object)((Object)controlMessage), (String)"controlMessage");
        this.processRatProverEvent(new Event(controlMessage));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void processRatProverEvent(Event e) {
        this.checkForFsmCycles();
        this.fsmIsBusy.lock();
        try {
            Thread thread = Thread.currentThread();
            Intrinsics.checkNotNullExpressionValue((Object)thread, (String)"Thread.currentThread()");
            if (Intrinsics.areEqual((Object)String.valueOf(thread.getId()), (Object)this.currentRatProverId)) {
                this.feedEvent(e);
            } else {
                StringBuilder stringBuilder = new StringBuilder().append("An old or unknown Thread (");
                Thread thread2 = Thread.currentThread();
                Intrinsics.checkNotNullExpressionValue((Object)thread2, (String)"Thread.currentThread()");
                LOG.warn(stringBuilder.append(thread2.getId()).append(") calls onRatProverMessage()").toString());
            }
        }
        finally {
            this.fsmIsBusy.unlock();
        }
    }

    @Override
    public void onRatVerifierMessage(@NotNull InternalControlMessage controlMessage, @NotNull byte[] ratMessage) {
        Intrinsics.checkNotNullParameter((Object)((Object)controlMessage), (String)"controlMessage");
        Intrinsics.checkNotNullParameter((Object)ratMessage, (String)"ratMessage");
        this.processRatVerifierEvent(new Event(controlMessage, Idscp2MessageHelper.INSTANCE.createIdscpRatVerifierMessage(ratMessage)));
    }

    @Override
    public void onRatVerifierMessage(@NotNull InternalControlMessage controlMessage) {
        Intrinsics.checkNotNullParameter((Object)((Object)controlMessage), (String)"controlMessage");
        this.processRatVerifierEvent(new Event(controlMessage));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void processRatVerifierEvent(Event e) {
        this.checkForFsmCycles();
        this.fsmIsBusy.lock();
        try {
            Thread thread = Thread.currentThread();
            Intrinsics.checkNotNullExpressionValue((Object)thread, (String)"Thread.currentThread()");
            if (Intrinsics.areEqual((Object)String.valueOf(thread.getId()), (Object)this.currentRatVerifierId)) {
                this.feedEvent(e);
            } else {
                StringBuilder stringBuilder = new StringBuilder().append("An old or unknown Thread (");
                Thread thread2 = Thread.currentThread();
                Intrinsics.checkNotNullExpressionValue((Object)thread2, (String)"Thread.currentThread()");
                LOG.warn(stringBuilder.append(thread2.getId()).append(") calls onRatVerifierMessage()").toString());
            }
        }
        finally {
            this.fsmIsBusy.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final FsmResultCode onUpperEvent(Event event) {
        this.checkForFsmCycles();
        this.fsmIsBusy.lock();
        try {
            FsmResultCode fsmResultCode = this.feedEvent(event);
            return fsmResultCode;
        }
        finally {
            this.fsmIsBusy.unlock();
        }
    }

    private final FsmResultCode feedEvent(Event event) {
        State prevState = this.currentState;
        FsmResult result2 = this.currentState.feedEvent(event);
        this.currentState = result2.getNextState();
        if (Intrinsics.areEqual((Object)prevState, (Object)this.currentState) ^ true) {
            this.currentState.runEntryCode(this);
        }
        return result2.getCode();
    }

    @NotNull
    public final FsmResultCode closeConnection() {
        Logger logger = LOG;
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"LOG");
        if (logger.isTraceEnabled()) {
            LOG.trace("Sending stop message to connection peer...");
        }
        return this.onUpperEvent(new Event(InternalControlMessage.IDSCP_STOP));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void startIdscpHandshake() throws Idscp2HandshakeException {
        block9: {
            this.checkForFsmCycles();
            this.fsmIsBusy.lock();
            try {
                if (Intrinsics.areEqual((Object)this.currentState, (Object)this.states.get((Object)FsmState.STATE_CLOSED))) {
                    if (this.isLocked) {
                        throw (Throwable)new Idscp2HandshakeException("FSM is in a final closed state forever");
                    }
                    this.onControlMessage(InternalControlMessage.START_IDSCP_HANDSHAKE);
                    while (!this.handshakeResultAvailable) {
                        this.idscpHandshakeLock.await();
                    }
                    if (!this.isConnected() && this.isLocked) {
                        throw (Throwable)new Idscp2HandshakeException("Handshake failed");
                    }
                    break block9;
                }
                throw (Throwable)new Idscp2HandshakeException("Handshake has already been started");
            }
            catch (InterruptedException e) {
                throw (Throwable)new Idscp2HandshakeException("Handshake failed because thread was interrupted");
            }
            finally {
                this.fsmIsBusy.unlock();
            }
        }
    }

    public final boolean sendFromFSM(@NotNull IDSCP2.IdscpMessage msg) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        try {
            byte[] byArray = msg.toByteArray();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"msg.toByteArray()");
            bl = this.secureChannel.send(byArray);
        }
        catch (Exception e) {
            LOG.error("Exception occurred during sending data via the secure channel: {}", (Throwable)e);
            bl = false;
        }
        return bl;
    }

    @Override
    public void onError(@NotNull Throwable t) {
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        BuildersKt.launch$default(GlobalScope.INSTANCE, null, null, (Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, t, null){
            int label;
            final /* synthetic */ FSM this$0;
            final /* synthetic */ Throwable $t;

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        FSM.access$getConnection$p(this.this$0).onError(this.$t);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }
            {
                this.this$0 = fSM;
                this.$t = throwable;
                super(2, continuation);
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                Intrinsics.checkNotNullParameter(completion, (String)"completion");
                Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                return function2;
            }

            public final Object invoke(Object object, Object object2) {
                return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 3, null);
        this.checkForFsmCycles();
        this.onControlMessage(InternalControlMessage.ERROR);
    }

    @Override
    public void onClose() {
        this.onUpperEvent(new Event(InternalControlMessage.IDSCP_STOP));
    }

    @NotNull
    public final FsmResultCode send(@Nullable byte[] msg) {
        this.idscpHandshakeCompletedLatch.await();
        IDSCP2.IdscpMessage idscpMessage = Idscp2MessageHelper.INSTANCE.createIdscpDataMessage(msg);
        return this.onUpperEvent(new Event(InternalControlMessage.SEND_DATA, idscpMessage));
    }

    @NotNull
    public final FsmResultCode repeatRat() {
        this.idscpHandshakeCompletedLatch.await();
        return this.onUpperEvent(new Event(InternalControlMessage.REPEAT_RAT));
    }

    @NotNull
    public final byte[] getGetDynamicAttributeToken() {
        byte[] byArray;
        try {
            byArray = this.dapsDriver.getToken();
        }
        catch (Exception e) {
            LOG.error("Exception occurred during requesting DAT from DAPS: {}", (Throwable)e);
            String string = "INVALID_DAT";
            Charset charset = StandardCharsets.UTF_8;
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"StandardCharsets.UTF_8");
            Charset charset2 = charset;
            boolean bl = false;
            byte[] byArray2 = string.getBytes(charset2);
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"(this as java.lang.String).getBytes(charset)");
            byArray = byArray2;
        }
        return byArray;
    }

    public final boolean isConnected() {
        return Intrinsics.areEqual((Object)this.currentState, (Object)this.states.get((Object)FsmState.STATE_ESTABLISHED)) || Intrinsics.areEqual((Object)this.currentState, (Object)this.states.get((Object)FsmState.STATE_WAIT_FOR_ACK));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void notifyHandshakeCompleteLock() {
        this.fsmIsBusy.lock();
        try {
            this.handshakeResultAvailable = true;
            this.idscpHandshakeLock.signal();
            this.idscpHandshakeCompletedLatch.unlock();
        }
        finally {
            this.fsmIsBusy.unlock();
        }
    }

    @Nullable
    public final String getRatProverMechanism(@NotNull String[] localSupportedProver, @NotNull String[] remoteExpectedVerifier) {
        Intrinsics.checkNotNullParameter((Object)localSupportedProver, (String)"localSupportedProver");
        Intrinsics.checkNotNullParameter((Object)remoteExpectedVerifier, (String)"remoteExpectedVerifier");
        Object[] objectArray = localSupportedProver;
        boolean bl = false;
        if (objectArray.length == 0) {
            LOG.warn("Got empty RAT localSupportedProver suite");
            return null;
        }
        objectArray = remoteExpectedVerifier;
        bl = false;
        if (objectArray.length == 0) {
            LOG.warn("Got empty RAT remoteExpectedVerifier suite");
            return null;
        }
        Logger logger = LOG;
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"LOG");
        if (logger.isTraceEnabled()) {
            objectArray = localSupportedProver;
            bl = false;
            String string = Arrays.toString(objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"java.util.Arrays.toString(this)");
            objectArray = remoteExpectedVerifier;
            bl = false;
            String string2 = Arrays.toString(objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.util.Arrays.toString(this)");
            LOG.trace("Calculate RAT prover mechanism for given local provers: {} and remote verifiers: {}", (Object)string, (Object)string2);
        }
        return this.matchRatMechanisms(remoteExpectedVerifier, localSupportedProver);
    }

    @Nullable
    public final String getRatVerifierMechanism(@NotNull String[] localExpectedVerifier, @NotNull String[] remoteSupportedProver) {
        Intrinsics.checkNotNullParameter((Object)localExpectedVerifier, (String)"localExpectedVerifier");
        Intrinsics.checkNotNullParameter((Object)remoteSupportedProver, (String)"remoteSupportedProver");
        Object[] objectArray = localExpectedVerifier;
        boolean bl = false;
        if (objectArray.length == 0) {
            LOG.warn("Got empty RAT localExpectedVerifier suite");
            return null;
        }
        objectArray = remoteSupportedProver;
        bl = false;
        if (objectArray.length == 0) {
            LOG.warn("Got empty RAT remoteSupportedProver suite");
            return null;
        }
        Logger logger = LOG;
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"LOG");
        if (logger.isTraceEnabled()) {
            objectArray = localExpectedVerifier;
            bl = false;
            String string = Arrays.toString(objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"java.util.Arrays.toString(this)");
            objectArray = remoteSupportedProver;
            bl = false;
            String string2 = Arrays.toString(objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.util.Arrays.toString(this)");
            LOG.trace("Calculate RAT verifier mechanism for given local verifiers: {} and remote provers: {}", (Object)string, (Object)string2);
        }
        return this.matchRatMechanisms(localExpectedVerifier, remoteSupportedProver);
    }

    @Nullable
    public final String matchRatMechanisms(@NotNull String[] primary, @NotNull String[] secondary) {
        Intrinsics.checkNotNullParameter((Object)primary, (String)"primary");
        Intrinsics.checkNotNullParameter((Object)secondary, (String)"secondary");
        for (String p : primary) {
            for (String s : secondary) {
                if (!Intrinsics.areEqual((Object)p, (Object)s)) continue;
                Logger logger = LOG;
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"LOG");
                if (logger.isDebugEnabled()) {
                    LOG.debug("RAT mechanism is {}", (Object)p);
                }
                return p;
            }
        }
        return null;
    }

    public final boolean restartRatVerifierDriver() {
        boolean bl;
        this.stopRatVerifierDriver();
        String string = this.verifierMechanism;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"verifierMechanism");
        }
        this.ratVerifierDriver = RatVerifierDriverRegistry.INSTANCE.startRatVerifierDriver(string, this);
        RatVerifierDriver<?> ratVerifierDriver = this.ratVerifierDriver;
        if (ratVerifierDriver != null) {
            RatVerifierDriver<?> ratVerifierDriver2 = ratVerifierDriver;
            boolean bl2 = false;
            boolean bl3 = false;
            RatVerifierDriver<?> it = ratVerifierDriver2;
            boolean bl4 = false;
            this.currentRatVerifierId = String.valueOf(it.getId());
            Logger logger = LOG;
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"LOG");
            if (logger.isTraceEnabled()) {
                LOG.trace("Start verifier_handshake timeout");
            }
            this.verifierHandshakeTimer.resetTimeout();
            bl = true;
        } else {
            FSM fSM = this;
            boolean bl5 = false;
            boolean bl6 = false;
            FSM $this$run = fSM;
            boolean bl7 = false;
            LOG.error("Cannot create instance of RAT_VERIFIER_DRIVER");
            $this$run.currentRatVerifierId = "";
            bl = false;
        }
        return bl;
    }

    public final void stopRatVerifierDriver() {
        block1: {
            this.verifierHandshakeTimer.cancelTimeout();
            RatVerifierDriver<?> ratVerifierDriver = this.ratVerifierDriver;
            if (ratVerifierDriver == null) break block1;
            RatVerifierDriver<?> ratVerifierDriver2 = ratVerifierDriver;
            boolean bl = false;
            boolean bl2 = false;
            RatVerifierDriver<?> it = ratVerifierDriver2;
            boolean bl3 = false;
            if (it.isAlive()) {
                it.interrupt();
                BuildersKt.launch$default(GlobalScope.INSTANCE, null, null, (Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(it, null){
                    int label;
                    final /* synthetic */ RatVerifierDriver $it;

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                this.$it.terminate();
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }
                    {
                        this.$it = ratVerifierDriver;
                        super(2, continuation);
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                        Intrinsics.checkNotNullParameter(completion, (String)"completion");
                        Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                        return function2;
                    }

                    public final Object invoke(Object object, Object object2) {
                        return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
                    }
                }, 3, null);
            }
        }
    }

    public final boolean restartRatProverDriver() {
        boolean bl;
        this.stopRatProverDriver();
        String string = this.proverMechanism;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"proverMechanism");
        }
        this.ratProverDriver = RatProverDriverRegistry.INSTANCE.startRatProverDriver(string, this);
        RatProverDriver<?> ratProverDriver = this.ratProverDriver;
        if (ratProverDriver != null) {
            RatProverDriver<?> ratProverDriver2 = ratProverDriver;
            boolean bl2 = false;
            boolean bl3 = false;
            RatProverDriver<?> it = ratProverDriver2;
            boolean bl4 = false;
            this.currentRatProverId = String.valueOf(it.getId());
            Logger logger = LOG;
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"LOG");
            if (logger.isTraceEnabled()) {
                LOG.trace("Start prover_handshake timeout");
            }
            this.proverHandshakeTimer.resetTimeout();
            bl = true;
        } else {
            FSM fSM = this;
            boolean bl5 = false;
            boolean bl6 = false;
            FSM $this$run = fSM;
            boolean bl7 = false;
            LOG.error("Cannot create instance of RAT_PROVER_DRIVER");
            $this$run.currentRatProverId = "";
            bl = false;
        }
        return bl;
    }

    private final void stopRatProverDriver() {
        block1: {
            this.proverHandshakeTimer.cancelTimeout();
            RatProverDriver<?> ratProverDriver = this.ratProverDriver;
            if (ratProverDriver == null) break block1;
            RatProverDriver<?> ratProverDriver2 = ratProverDriver;
            boolean bl = false;
            boolean bl2 = false;
            RatProverDriver<?> it = ratProverDriver2;
            boolean bl3 = false;
            if (it.isAlive()) {
                it.interrupt();
                BuildersKt.launch$default(GlobalScope.INSTANCE, null, null, (Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(it, null){
                    int label;
                    final /* synthetic */ RatProverDriver $it;

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                this.$it.terminate();
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }
                    {
                        this.$it = ratProverDriver;
                        super(2, continuation);
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                        Intrinsics.checkNotNullParameter(completion, (String)"completion");
                        Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                        return function2;
                    }

                    public final Object invoke(Object object, Object object2) {
                        return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
                    }
                }, 3, null);
            }
        }
    }

    public final void shutdownFsm() {
        Logger logger = LOG;
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"LOG");
        if (logger.isTraceEnabled()) {
            LOG.trace("Shutting down FSM of connection {}...", (Object)this.connection.getId());
            LOG.trace("Running close handlers of connection {}...", (Object)this.connection.getId());
        }
        BuildersKt.launch$default(GlobalScope.INSTANCE, null, null, (Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ FSM this$0;

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        FSM.access$getConnection$p(this.this$0).onClose();
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }
            {
                this.this$0 = fSM;
                super(2, continuation);
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                Intrinsics.checkNotNullParameter(completion, (String)"completion");
                Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                return function2;
            }

            public final Object invoke(Object object, Object object2) {
                return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 3, null);
        BuildersKt.launch$default(GlobalScope.INSTANCE, null, null, (Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ FSM this$0;

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        Logger logger = FSM.access$getLOG$cp();
                        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"LOG");
                        if (logger.isTraceEnabled()) {
                            FSM.access$getLOG$cp().trace("Closing secure channel of connection {}...", (Object)FSM.access$getConnection$p(this.this$0).getId());
                        }
                        FSM.access$getSecureChannel$p(this.this$0).close();
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }
            {
                this.this$0 = fSM;
                super(2, continuation);
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                Intrinsics.checkNotNullParameter(completion, (String)"completion");
                Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                return function2;
            }

            public final Object invoke(Object object, Object object2) {
                return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 3, null);
        Logger logger2 = LOG;
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"LOG");
        if (logger2.isTraceEnabled()) {
            LOG.trace("Clearing timeouts...");
        }
        this.datTimer.cancelTimeout();
        this.ratTimer.cancelTimeout();
        this.handshakeTimer.cancelTimeout();
        this.ackTimer.cancelTimeout();
        Logger logger3 = LOG;
        Intrinsics.checkNotNullExpressionValue((Object)logger3, (String)"LOG");
        if (logger3.isTraceEnabled()) {
            LOG.trace("Stopping RAT components...");
        }
        this.stopRatProverDriver();
        this.stopRatVerifierDriver();
        Logger logger4 = LOG;
        Intrinsics.checkNotNullExpressionValue((Object)logger4, (String)"LOG");
        if (logger4.isTraceEnabled()) {
            LOG.trace("Mark FSM as terminated...");
        }
        this.isLocked = true;
        if (!this.handshakeResultAvailable) {
            Logger logger5 = LOG;
            Intrinsics.checkNotNullExpressionValue((Object)logger5, (String)"LOG");
            if (logger5.isTraceEnabled()) {
                LOG.trace("Notify handshake lock...");
            }
            this.notifyHandshakeCompleteLock();
        }
    }

    private final void notifyIdscpMsgListener(byte[] data) {
        BuildersKt.launch$default(GlobalScope.INSTANCE, null, null, (Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, data, null){
            int label;
            final /* synthetic */ FSM this$0;
            final /* synthetic */ byte[] $data;

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        FSM.access$getConnection$p(this.this$0).onMessage(this.$data);
                        Logger logger = FSM.access$getLOG$cp();
                        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"LOG");
                        if (logger.isTraceEnabled()) {
                            FSM.access$getLOG$cp().trace("Idscp data has been passed to connection listener");
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }
            {
                this.this$0 = fSM;
                this.$data = byArray;
                super(2, continuation);
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                Intrinsics.checkNotNullParameter(completion, (String)"completion");
                Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                return function2;
            }

            public final Object invoke(Object object, Object object2) {
                return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 3, null);
    }

    public final boolean isFsmLocked() {
        return this.isLocked;
    }

    @NotNull
    public final State getState(@NotNull FsmState state) {
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
        State state2 = this.states.get((Object)state);
        if (state2 == null) {
            throw (Throwable)new NoSuchElementException("State unknown");
        }
        return state2;
    }

    public final boolean isNotClosed() {
        return Intrinsics.areEqual((Object)this.currentState, (Object)this.getState(FsmState.STATE_CLOSED));
    }

    public final void setRatMechanisms(@NotNull String proverMechanism, @NotNull String verifierMechanism) {
        Intrinsics.checkNotNullParameter((Object)proverMechanism, (String)"proverMechanism");
        Intrinsics.checkNotNullParameter((Object)verifierMechanism, (String)"verifierMechanism");
        this.proverMechanism = proverMechanism;
        this.verifierMechanism = verifierMechanism;
    }

    @Nullable
    public final IDSCP2.IdscpMessage getGetBufferedIdscpMessage() {
        return this.bufferedIdscpData;
    }

    /*
     * Enabled aggressive block sorting
     */
    public final boolean recvAck(@NotNull IDSCP2.IdscpAck ack) {
        Intrinsics.checkNotNullParameter((Object)ack, (String)"ack");
        if (!this.ackFlag) {
            LOG.warn("Received unexpected IdscpAck");
            return false;
        }
        Logger logger = LOG;
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"LOG");
        if (logger.isTraceEnabled()) {
            LOG.trace("Received IdscpAck with alternating bit {}, cancel flag in fsm", (Object)ack.getAlternatingBit());
        }
        if (this.nextSendAlternatingBit.asBoolean() != ack.getAlternatingBit()) {
            Logger logger2 = LOG;
            Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"LOG");
            if (!logger2.isTraceEnabled()) return false;
            LOG.trace("Received IdscpAck with wrong alternating bit. Ignoring");
            return false;
        }
        this.setAckFlag(false);
        this.ackTimer.cancelTimeout();
        Logger logger3 = LOG;
        Intrinsics.checkNotNullExpressionValue((Object)logger3, (String)"LOG");
        if (logger3.isTraceEnabled()) {
            LOG.trace("Alternate nextSend bit from {}", (Object)this.nextSendAlternatingBit.asBoolean());
        }
        this.nextSendAlternatingBit.alternate();
        return true;
    }

    public final void recvData(@NotNull IDSCP2.IdscpData data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Logger logger = LOG;
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"LOG");
        if (logger.isTraceEnabled()) {
            LOG.trace("Received IdscpData with alternating bit {}", (Object)data.getAlternatingBit());
        }
        if (data.getAlternatingBit() != this.expectedAlternatingBit.asBoolean()) {
            Logger logger2 = LOG;
            Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"LOG");
            if (logger2.isTraceEnabled()) {
                LOG.trace("Received IdscpData with unexpected alternating bit. Could be an old packet replayed. Ignore it.");
            }
        } else {
            Logger logger3 = LOG;
            Intrinsics.checkNotNullExpressionValue((Object)logger3, (String)"LOG");
            if (logger3.isTraceEnabled()) {
                LOG.trace("Send IdscpAck with received alternating bit {}", (Object)data.getAlternatingBit());
            }
            if (!this.sendFromFSM(Idscp2MessageHelper.INSTANCE.createIdscpAckMessage(data.getAlternatingBit()))) {
                LOG.error("Cannot send ACK");
            }
            Logger logger4 = LOG;
            Intrinsics.checkNotNullExpressionValue((Object)logger4, (String)"LOG");
            if (logger4.isTraceEnabled()) {
                LOG.trace("Alternate expected bit from {}", (Object)this.expectedAlternatingBit.asBoolean());
            }
            this.expectedAlternatingBit.alternate();
            byte[] byArray = data.getData().toByteArray();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"data.data.toByteArray()");
            this.notifyIdscpMsgListener(byArray);
        }
    }

    public final void setBufferedIdscpData(@NotNull IDSCP2.IdscpMessage msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        this.bufferedIdscpData = msg;
    }

    public FSM(@NotNull Idscp2Connection connection, @NotNull SecureChannel secureChannel, @NotNull DapsDriver dapsDriver, @NotNull AttestationConfig attestationConfig, long ackTimeoutDelay, long handshakeTimeoutDelay) {
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        Intrinsics.checkNotNullParameter((Object)secureChannel, (String)"secureChannel");
        Intrinsics.checkNotNullParameter((Object)dapsDriver, (String)"dapsDriver");
        Intrinsics.checkNotNullParameter((Object)attestationConfig, (String)"attestationConfig");
        this.dapsDriver = dapsDriver;
        this.states = new HashMap();
        this.fsmIsBusy = new ReentrantLock(true);
        this.onMessageBlock = this.fsmIsBusy.newCondition();
        this.idscpHandshakeLock = this.fsmIsBusy.newCondition();
        this.idscpHandshakeCompletedLatch = new FastLatch();
        this.expectedAlternatingBit = new AlternatingBit(false, 1, null);
        this.nextSendAlternatingBit = new AlternatingBit(false, 1, null);
        Runnable handshakeTimeoutHandler2 = new Runnable(this){
            final /* synthetic */ FSM this$0;

            public final void run() {
                Logger logger = FSM.access$getLOG$cp();
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"LOG");
                if (logger.isTraceEnabled()) {
                    FSM.access$getLOG$cp().trace("HANDSHAKE_TIMER_EXPIRED");
                }
                FSM.access$onControlMessage(this.this$0, InternalControlMessage.TIMEOUT);
            }
            {
                this.this$0 = fSM;
            }
        };
        Runnable datTimeoutHandler2 = new Runnable(this){
            final /* synthetic */ FSM this$0;

            public final void run() {
                Logger logger = FSM.access$getLOG$cp();
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"LOG");
                if (logger.isTraceEnabled()) {
                    FSM.access$getLOG$cp().trace("DAT_TIMER_EXPIRED");
                }
                FSM.access$onControlMessage(this.this$0, InternalControlMessage.DAT_TIMER_EXPIRED);
            }
            {
                this.this$0 = fSM;
            }
        };
        Runnable ratTimeoutHandler2 = new Runnable(this){
            final /* synthetic */ FSM this$0;

            public final void run() {
                Logger logger = FSM.access$getLOG$cp();
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"LOG");
                if (logger.isTraceEnabled()) {
                    FSM.access$getLOG$cp().trace("RAT_TIMER_EXPIRED");
                }
                FSM.access$onControlMessage(this.this$0, InternalControlMessage.REPEAT_RAT);
            }
            {
                this.this$0 = fSM;
            }
        };
        Runnable proverTimeoutHandler2 = new Runnable(this){
            final /* synthetic */ FSM this$0;

            public final void run() {
                Logger logger = FSM.access$getLOG$cp();
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"LOG");
                if (logger.isTraceEnabled()) {
                    FSM.access$getLOG$cp().trace("RAT_PROVER_HANDSHAKE_TIMER_EXPIRED");
                }
                FSM.access$onControlMessage(this.this$0, InternalControlMessage.TIMEOUT);
            }
            {
                this.this$0 = fSM;
            }
        };
        Runnable verifierTimeoutHandler2 = new Runnable(this){
            final /* synthetic */ FSM this$0;

            public final void run() {
                Logger logger = FSM.access$getLOG$cp();
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"LOG");
                if (logger.isTraceEnabled()) {
                    FSM.access$getLOG$cp().trace("RAT_VERIFIER_HANDSHAKE_TIMER_EXPIRED");
                }
                FSM.access$onControlMessage(this.this$0, InternalControlMessage.TIMEOUT);
            }
            {
                this.this$0 = fSM;
            }
        };
        Runnable ackTimeoutHandler2 = new Runnable(this){
            final /* synthetic */ FSM this$0;

            public final void run() {
                Logger logger = FSM.access$getLOG$cp();
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"LOG");
                if (logger.isTraceEnabled()) {
                    FSM.access$getLOG$cp().trace("ACK_TIMER_EXPIRED");
                }
                FSM.access$onControlMessage(this.this$0, InternalControlMessage.ACK_TIMER_EXPIRED);
            }
            {
                this.this$0 = fSM;
            }
        };
        this.datTimer = new DynamicTimer(this.fsmIsBusy, datTimeoutHandler2);
        this.handshakeTimer = new StaticTimer(this.fsmIsBusy, handshakeTimeoutHandler2, handshakeTimeoutDelay);
        this.proverHandshakeTimer = new StaticTimer(this.fsmIsBusy, proverTimeoutHandler2, handshakeTimeoutDelay);
        this.verifierHandshakeTimer = new StaticTimer(this.fsmIsBusy, verifierTimeoutHandler2, handshakeTimeoutDelay);
        this.ratTimer = new StaticTimer(this.fsmIsBusy, ratTimeoutHandler2, attestationConfig.getRatTimeoutDelay());
        this.ackTimer = new StaticTimer(this.fsmIsBusy, ackTimeoutHandler2, ackTimeoutDelay);
        Map map2 = this.states;
        Condition condition = this.onMessageBlock;
        Intrinsics.checkNotNullExpressionValue((Object)condition, (String)"onMessageBlock");
        map2.put(FsmState.STATE_CLOSED, new StateClosed(this, condition, attestationConfig));
        ((Map)this.states).put(FsmState.STATE_WAIT_FOR_HELLO, new StateWaitForHello(this, this.handshakeTimer, this.datTimer, this.dapsDriver, attestationConfig));
        ((Map)this.states).put(FsmState.STATE_WAIT_FOR_RAT, new StateWaitForRat(this, this.handshakeTimer, this.verifierHandshakeTimer, this.proverHandshakeTimer, this.ratTimer));
        ((Map)this.states).put(FsmState.STATE_WAIT_FOR_RAT_PROVER, new StateWaitForRatProver(this, this.ratTimer, this.handshakeTimer, this.proverHandshakeTimer, this.ackTimer));
        ((Map)this.states).put(FsmState.STATE_WAIT_FOR_RAT_VERIFIER, new StateWaitForRatVerifier(this, this.ratTimer, this.handshakeTimer, this.verifierHandshakeTimer, this.ackTimer));
        ((Map)this.states).put(FsmState.STATE_WAIT_FOR_DAT_AND_RAT, new StateWaitForDatAndRat(this, this.handshakeTimer, this.proverHandshakeTimer, this.datTimer, this.dapsDriver));
        ((Map)this.states).put(FsmState.STATE_WAIT_FOR_DAT_AND_RAT_VERIFIER, new StateWaitForDatAndRatVerifier(this, this.handshakeTimer, this.datTimer, this.dapsDriver));
        ((Map)this.states).put(FsmState.STATE_ESTABLISHED, new StateEstablished(this, this.ratTimer, this.handshakeTimer, this.ackTimer, this.nextSendAlternatingBit));
        ((Map)this.states).put(FsmState.STATE_WAIT_FOR_ACK, new StateWaitForAck(this, this.ratTimer, this.handshakeTimer, this.ackTimer));
        State state = this.states.get((Object)FsmState.STATE_CLOSED);
        if (state == null) {
            throw (Throwable)new NoSuchElementException("State unknown");
        }
        this.currentState = state;
        this.connection = connection;
        this.secureChannel = secureChannel;
    }

    static {
        Companion = new Companion(null);
        LOG = LoggerFactory.getLogger(FSM.class);
    }

    public static final /* synthetic */ Idscp2Connection access$getConnection$p(FSM $this) {
        return $this.connection;
    }

    public static final /* synthetic */ Logger access$getLOG$cp() {
        return LOG;
    }

    public static final /* synthetic */ SecureChannel access$getSecureChannel$p(FSM $this) {
        return $this.secureChannel;
    }

    public static final /* synthetic */ void access$onControlMessage(FSM $this, InternalControlMessage controlMessage) {
        $this.onControlMessage(controlMessage);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u000b\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000b\u00a8\u0006\f"}, d2={"Lde/fhg/aisec/ids/idscp2/idscp_core/fsm/FSM$FsmState;", "", "(Ljava/lang/String;I)V", "STATE_CLOSED", "STATE_WAIT_FOR_HELLO", "STATE_WAIT_FOR_RAT", "STATE_WAIT_FOR_RAT_VERIFIER", "STATE_WAIT_FOR_RAT_PROVER", "STATE_WAIT_FOR_DAT_AND_RAT_VERIFIER", "STATE_WAIT_FOR_DAT_AND_RAT", "STATE_ESTABLISHED", "STATE_WAIT_FOR_ACK", "idscp2"})
    public static final class FsmState
    extends Enum<FsmState> {
        public static final /* enum */ FsmState STATE_CLOSED;
        public static final /* enum */ FsmState STATE_WAIT_FOR_HELLO;
        public static final /* enum */ FsmState STATE_WAIT_FOR_RAT;
        public static final /* enum */ FsmState STATE_WAIT_FOR_RAT_VERIFIER;
        public static final /* enum */ FsmState STATE_WAIT_FOR_RAT_PROVER;
        public static final /* enum */ FsmState STATE_WAIT_FOR_DAT_AND_RAT_VERIFIER;
        public static final /* enum */ FsmState STATE_WAIT_FOR_DAT_AND_RAT;
        public static final /* enum */ FsmState STATE_ESTABLISHED;
        public static final /* enum */ FsmState STATE_WAIT_FOR_ACK;
        private static final /* synthetic */ FsmState[] $VALUES;

        static {
            FsmState[] fsmStateArray = new FsmState[9];
            FsmState[] fsmStateArray2 = fsmStateArray;
            fsmStateArray[0] = STATE_CLOSED = new FsmState();
            fsmStateArray[1] = STATE_WAIT_FOR_HELLO = new FsmState();
            fsmStateArray[2] = STATE_WAIT_FOR_RAT = new FsmState();
            fsmStateArray[3] = STATE_WAIT_FOR_RAT_VERIFIER = new FsmState();
            fsmStateArray[4] = STATE_WAIT_FOR_RAT_PROVER = new FsmState();
            fsmStateArray[5] = STATE_WAIT_FOR_DAT_AND_RAT_VERIFIER = new FsmState();
            fsmStateArray[6] = STATE_WAIT_FOR_DAT_AND_RAT = new FsmState();
            fsmStateArray[7] = STATE_ESTABLISHED = new FsmState();
            fsmStateArray[8] = STATE_WAIT_FOR_ACK = new FsmState();
            $VALUES = fsmStateArray;
        }

        public static FsmState[] values() {
            return (FsmState[])$VALUES.clone();
        }

        public static FsmState valueOf(String string) {
            return Enum.valueOf(FsmState.class, string);
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0010\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012\u00a8\u0006\u0013"}, d2={"Lde/fhg/aisec/ids/idscp2/idscp_core/fsm/FSM$FsmResultCode;", "", "value", "", "(Ljava/lang/String;ILjava/lang/String;)V", "getValue", "()Ljava/lang/String;", "UNKNOWN_TRANSITION", "FSM_LOCKED", "FSM_NOT_STARTED", "MISSING_DAT", "INVALID_DAT", "IO_ERROR", "RAT_ERROR", "RAT_NEGOTIATION_ERROR", "WOULD_BLOCK", "NOT_CONNECTED", "IDSCP_DATA_NOT_CACHED", "OK", "idscp2"})
    public static final class FsmResultCode
    extends Enum<FsmResultCode> {
        public static final /* enum */ FsmResultCode UNKNOWN_TRANSITION;
        public static final /* enum */ FsmResultCode FSM_LOCKED;
        public static final /* enum */ FsmResultCode FSM_NOT_STARTED;
        public static final /* enum */ FsmResultCode MISSING_DAT;
        public static final /* enum */ FsmResultCode INVALID_DAT;
        public static final /* enum */ FsmResultCode IO_ERROR;
        public static final /* enum */ FsmResultCode RAT_ERROR;
        public static final /* enum */ FsmResultCode RAT_NEGOTIATION_ERROR;
        public static final /* enum */ FsmResultCode WOULD_BLOCK;
        public static final /* enum */ FsmResultCode NOT_CONNECTED;
        public static final /* enum */ FsmResultCode IDSCP_DATA_NOT_CACHED;
        public static final /* enum */ FsmResultCode OK;
        private static final /* synthetic */ FsmResultCode[] $VALUES;
        @NotNull
        private final String value;

        static {
            FsmResultCode[] fsmResultCodeArray = new FsmResultCode[12];
            FsmResultCode[] fsmResultCodeArray2 = fsmResultCodeArray;
            fsmResultCodeArray[0] = UNKNOWN_TRANSITION = new FsmResultCode("No transition available for given event in current state.");
            fsmResultCodeArray[1] = FSM_LOCKED = new FsmResultCode("FSM is locked forever.");
            fsmResultCodeArray[2] = FSM_NOT_STARTED = new FsmResultCode("Handshake was never started.");
            fsmResultCodeArray[3] = MISSING_DAT = new FsmResultCode("DAT is missing.");
            fsmResultCodeArray[4] = INVALID_DAT = new FsmResultCode("DAT is invalid.");
            fsmResultCodeArray[5] = IO_ERROR = new FsmResultCode("Secure channel not available.");
            fsmResultCodeArray[6] = RAT_ERROR = new FsmResultCode("RAT error occurred.");
            fsmResultCodeArray[7] = RAT_NEGOTIATION_ERROR = new FsmResultCode("Error during negotiation of RAT mechanisms.");
            fsmResultCodeArray[8] = WOULD_BLOCK = new FsmResultCode("Operation would block until FSM is in state 'ESTABLISHED'");
            fsmResultCodeArray[9] = NOT_CONNECTED = new FsmResultCode("Protocol is not in a connected state at the moment.");
            fsmResultCodeArray[10] = IDSCP_DATA_NOT_CACHED = new FsmResultCode("IdscpData must be buffered in the 'WAIT_FOR_ACK' state.");
            fsmResultCodeArray[11] = OK = new FsmResultCode("Action succeed.");
            $VALUES = fsmResultCodeArray;
        }

        @NotNull
        public final String getValue() {
            return this.value;
        }

        private FsmResultCode(String value) {
            this.value = value;
        }

        public static FsmResultCode[] values() {
            return (FsmResultCode[])$VALUES.clone();
        }

        public static FsmResultCode valueOf(String string) {
            return Enum.valueOf(FsmResultCode.class, string);
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lde/fhg/aisec/ids/idscp2/idscp_core/fsm/FSM$FsmResult;", "", "code", "Lde/fhg/aisec/ids/idscp2/idscp_core/fsm/FSM$FsmResultCode;", "nextState", "Lde/fhg/aisec/ids/idscp2/idscp_core/fsm/State;", "(Lde/fhg/aisec/ids/idscp2/idscp_core/fsm/FSM$FsmResultCode;Lde/fhg/aisec/ids/idscp2/idscp_core/fsm/State;)V", "getCode", "()Lde/fhg/aisec/ids/idscp2/idscp_core/fsm/FSM$FsmResultCode;", "getNextState", "()Lde/fhg/aisec/ids/idscp2/idscp_core/fsm/State;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "idscp2"})
    public static final class FsmResult {
        @NotNull
        private final FsmResultCode code;
        @NotNull
        private final State nextState;

        @NotNull
        public final FsmResultCode getCode() {
            return this.code;
        }

        @NotNull
        public final State getNextState() {
            return this.nextState;
        }

        public FsmResult(@NotNull FsmResultCode code, @NotNull State nextState) {
            Intrinsics.checkNotNullParameter((Object)((Object)code), (String)"code");
            Intrinsics.checkNotNullParameter((Object)nextState, (String)"nextState");
            this.code = code;
            this.nextState = nextState;
        }

        @NotNull
        public final FsmResultCode component1() {
            return this.code;
        }

        @NotNull
        public final State component2() {
            return this.nextState;
        }

        @NotNull
        public final FsmResult copy(@NotNull FsmResultCode code, @NotNull State nextState) {
            Intrinsics.checkNotNullParameter((Object)((Object)code), (String)"code");
            Intrinsics.checkNotNullParameter((Object)nextState, (String)"nextState");
            return new FsmResult(code, nextState);
        }

        public static /* synthetic */ FsmResult copy$default(FsmResult fsmResult, FsmResultCode fsmResultCode, State state, int n, Object object) {
            if ((n & 1) != 0) {
                fsmResultCode = fsmResult.code;
            }
            if ((n & 2) != 0) {
                state = fsmResult.nextState;
            }
            return fsmResult.copy(fsmResultCode, state);
        }

        @NotNull
        public String toString() {
            return "FsmResult(code=" + (Object)((Object)this.code) + ", nextState=" + this.nextState + ")";
        }

        public int hashCode() {
            FsmResultCode fsmResultCode = this.code;
            State state = this.nextState;
            return (fsmResultCode != null ? ((Object)((Object)fsmResultCode)).hashCode() : 0) * 31 + (state != null ? state.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof FsmResult)) break block3;
                    FsmResult fsmResult = (FsmResult)object;
                    if (!Intrinsics.areEqual((Object)((Object)this.code), (Object)((Object)fsmResult.code)) || !Intrinsics.areEqual((Object)this.nextState, (Object)fsmResult.nextState)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lde/fhg/aisec/ids/idscp2/idscp_core/fsm/FSM$Companion;", "", "()V", "LOG", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "idscp2"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

