/*
 * Decompiled with CFR 0.152.
 */
package de.fhg.aisec.ids.idscp2.default_drivers.secure_channel.tlsv1_3.client;

import de.fhg.aisec.ids.idscp2.default_drivers.keystores.PreConfiguration;
import de.fhg.aisec.ids.idscp2.default_drivers.secure_channel.tlsv1_3.NativeTlsConfiguration;
import de.fhg.aisec.ids.idscp2.default_drivers.secure_channel.tlsv1_3.TLSConstants;
import de.fhg.aisec.ids.idscp2.default_drivers.secure_channel.tlsv1_3.TLSSessionVerificationHelper;
import de.fhg.aisec.ids.idscp2.default_drivers.secure_channel.tlsv1_3.client.DataAvailableListener;
import de.fhg.aisec.ids.idscp2.default_drivers.secure_channel.tlsv1_3.client.InputListenerThread;
import de.fhg.aisec.ids.idscp2.default_drivers.secure_channel.tlsv1_3.client.TLSClient;
import de.fhg.aisec.ids.idscp2.idscp_core.api.configuration.Idscp2Configuration;
import de.fhg.aisec.ids.idscp2.idscp_core.api.idscp_connection.Idscp2Connection;
import de.fhg.aisec.ids.idscp2.idscp_core.drivers.SecureChannelEndpoint;
import de.fhg.aisec.ids.idscp2.idscp_core.error.Idscp2Exception;
import de.fhg.aisec.ids.idscp2.idscp_core.secure_channel.SecureChannel;
import de.fhg.aisec.ids.idscp2.idscp_core.secure_channel.SecureChannelListener;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import javax.net.ssl.HandshakeCompletedEvent;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLProtocolException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\u0018\u0000 .*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u00032\u00020\u00042\u00020\u0005:\u0001.B=\u0012\u0018\u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00028\u00000\u0007\u0012\u0006\u0010\n\u001a\u00020\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00000\u000e\u00a2\u0006\u0002\u0010\u000fJ\b\u0010\u001b\u001a\u00020\u001cH\u0016J\u0018\u0010\u001d\u001a\u00020\u001c2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010 \u001a\u00020!J\b\u0010\"\u001a\u00020\u001cH\u0002J\u0010\u0010#\u001a\u00020\u001c2\u0006\u0010$\u001a\u00020%H\u0016J\b\u0010&\u001a\u00020\u001cH\u0016J\u0010\u0010'\u001a\u00020\u001c2\u0006\u0010(\u001a\u00020)H\u0016J\u0010\u0010*\u001a\u00020\u001c2\u0006\u0010+\u001a\u00020,H\u0016J\u0010\u0010-\u001a\u00020\u00172\u0006\u0010+\u001a\u00020,H\u0016R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00028\u00000\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00000\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\u00020\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0018R\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lde/fhg/aisec/ids/idscp2/default_drivers/secure_channel/tlsv1_3/client/TLSClient;", "CC", "Lde/fhg/aisec/ids/idscp2/idscp_core/api/idscp_connection/Idscp2Connection;", "Ljavax/net/ssl/HandshakeCompletedListener;", "Lde/fhg/aisec/ids/idscp2/default_drivers/secure_channel/tlsv1_3/client/DataAvailableListener;", "Lde/fhg/aisec/ids/idscp2/idscp_core/drivers/SecureChannelEndpoint;", "connectionFactory", "Lkotlin/Function2;", "Lde/fhg/aisec/ids/idscp2/idscp_core/secure_channel/SecureChannel;", "Lde/fhg/aisec/ids/idscp2/idscp_core/api/configuration/Idscp2Configuration;", "clientConfiguration", "nativeTlsConfiguration", "Lde/fhg/aisec/ids/idscp2/default_drivers/secure_channel/tlsv1_3/NativeTlsConfiguration;", "connectionFuture", "Ljava/util/concurrent/CompletableFuture;", "(Lkotlin/jvm/functions/Function2;Lde/fhg/aisec/ids/idscp2/idscp_core/api/configuration/Idscp2Configuration;Lde/fhg/aisec/ids/idscp2/default_drivers/secure_channel/tlsv1_3/NativeTlsConfiguration;Ljava/util/concurrent/CompletableFuture;)V", "clientSocket", "Ljava/net/Socket;", "dataOutputStream", "Ljava/io/DataOutputStream;", "inputListenerThread", "Lde/fhg/aisec/ids/idscp2/default_drivers/secure_channel/tlsv1_3/client/InputListenerThread;", "isConnected", "", "()Z", "listenerPromise", "Lde/fhg/aisec/ids/idscp2/idscp_core/secure_channel/SecureChannelListener;", "close", "", "connect", "hostname", "", "port", "", "disconnect", "handshakeCompleted", "handshakeCompletedEvent", "Ljavax/net/ssl/HandshakeCompletedEvent;", "onClose", "onError", "e", "", "onMessage", "bytes", "", "send", "Companion", "idscp2"})
public final class TLSClient<CC extends Idscp2Connection>
implements HandshakeCompletedListener,
DataAvailableListener,
SecureChannelEndpoint {
    private final Socket clientSocket;
    private DataOutputStream dataOutputStream;
    private InputListenerThread inputListenerThread;
    private final CompletableFuture<SecureChannelListener> listenerPromise;
    private final Function2<SecureChannel, Idscp2Configuration, CC> connectionFactory;
    private final Idscp2Configuration clientConfiguration;
    private final CompletableFuture<CC> connectionFuture;
    private static final Logger LOG;
    @NotNull
    public static final Companion Companion;

    public final void connect(@Nullable String hostname, int port) {
        SSLSocket sslSocket = (SSLSocket)this.clientSocket;
        if (sslSocket == null || sslSocket.isClosed()) {
            throw (Throwable)new Idscp2Exception("Client socket is not available");
        }
        try {
            sslSocket.connect(new InetSocketAddress(hostname, port));
            Logger logger = LOG;
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"LOG");
            if (logger.isTraceEnabled()) {
                LOG.trace("Client is connected to server {}:{}", (Object)hostname, (Object)port);
            }
            ((SSLSocket)this.clientSocket).setSoTimeout(5000);
            this.dataOutputStream = new DataOutputStream(this.clientSocket.getOutputStream());
            InputStream inputStream = this.clientSocket.getInputStream();
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"clientSocket.getInputStream()");
            this.inputListenerThread = new InputListenerThread(inputStream, this);
            sslSocket.addHandshakeCompletedListener(this);
            Logger logger2 = LOG;
            Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"LOG");
            if (logger2.isTraceEnabled()) {
                LOG.trace("Start TLS Handshake");
            }
            sslSocket.startHandshake();
        }
        catch (SSLHandshakeException e) {
            this.disconnect();
            throw (Throwable)new Idscp2Exception("TLS Handshake failed", e);
        }
        catch (SSLProtocolException e) {
            this.disconnect();
            throw (Throwable)new Idscp2Exception("TLS Handshake failed", e);
        }
        catch (IOException e) {
            this.disconnect();
            throw (Throwable)new Idscp2Exception("Connecting TLS client to server failed", e);
        }
    }

    private final void disconnect() {
        Logger logger = LOG;
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"LOG");
        if (logger.isTraceEnabled()) {
            LOG.trace("Disconnecting from TLS server...");
        }
        if (this.inputListenerThread != null) {
            InputListenerThread inputListenerThread = this.inputListenerThread;
            if (inputListenerThread == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"inputListenerThread");
            }
            inputListenerThread.safeStop();
        }
        if (!this.clientSocket.isClosed()) {
            try {
                this.clientSocket.close();
            }
            catch (IOException e) {
                this.onError(e);
            }
        }
    }

    @Override
    public void onClose() {
        this.listenerPromise.thenAccept((Consumer)onClose.1.INSTANCE);
    }

    @Override
    public void onError(@NotNull Throwable e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.listenerPromise.thenAccept((Consumer)new Consumer<SecureChannelListener>(e){
            final /* synthetic */ Throwable $e;

            public final void accept(@NotNull SecureChannelListener listener) {
                Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
                listener.onError(this.$e);
            }
            {
                this.$e = throwable;
            }
        });
    }

    @Override
    public void close() {
        this.disconnect();
    }

    @Override
    public boolean send(@NotNull byte[] bytes) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        if (!this.isConnected()) {
            LOG.warn("Client cannot send data because socket is not connected");
            bl = false;
        } else {
            boolean bl2;
            try {
                DataOutputStream dataOutputStream = this.dataOutputStream;
                if (dataOutputStream == null) {
                    throw (Throwable)new IOException("DataOutputStream not available");
                }
                DataOutputStream dataOutputStream2 = dataOutputStream;
                boolean bl3 = false;
                boolean bl4 = false;
                DataOutputStream it = dataOutputStream2;
                boolean bl5 = false;
                it.writeInt(bytes.length);
                it.write(bytes);
                it.flush();
                Logger logger = LOG;
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"LOG");
                if (logger.isTraceEnabled()) {
                    LOG.trace("Sending message...");
                }
                bl2 = true;
            }
            catch (IOException e) {
                LOG.warn("Client cannot send data", (Throwable)e);
                bl2 = false;
            }
            bl = bl2;
        }
        return bl;
    }

    @Override
    public boolean isConnected() {
        return this.clientSocket.isConnected();
    }

    @Override
    public void handshakeCompleted(@NotNull HandshakeCompletedEvent handshakeCompletedEvent) {
        Intrinsics.checkNotNullParameter((Object)handshakeCompletedEvent, (String)"handshakeCompletedEvent");
        Logger logger = LOG;
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"LOG");
        if (logger.isTraceEnabled()) {
            LOG.trace("TLS Handshake was successful");
        }
        try {
            SSLSession sSLSession = handshakeCompletedEvent.getSession();
            Intrinsics.checkNotNullExpressionValue((Object)sSLSession, (String)"handshakeCompletedEvent.session");
            TLSSessionVerificationHelper.INSTANCE.verifyTlsSession(sSLSession);
            Logger logger2 = LOG;
            Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"LOG");
            if (logger2.isTraceEnabled()) {
                LOG.trace("TLS session is valid");
            }
            SecureChannel secureChannel = new SecureChannel(this);
            this.listenerPromise.complete(secureChannel);
            Idscp2Connection connection = (Idscp2Connection)this.connectionFactory.invoke((Object)secureChannel, (Object)this.clientConfiguration);
            InputListenerThread inputListenerThread = this.inputListenerThread;
            if (inputListenerThread == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"inputListenerThread");
            }
            inputListenerThread.start();
            this.connectionFuture.complete(connection);
            if (this.connectionFuture.isCancelled()) {
                connection.close();
            }
        }
        catch (SSLPeerUnverifiedException e) {
            this.disconnect();
            this.connectionFuture.completeExceptionally(new Idscp2Exception("TLS session is not valid. Close TLS connection", e));
        }
    }

    @Override
    public void onMessage(@NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        this.listenerPromise.thenAccept((Consumer)new Consumer<SecureChannelListener>(bytes){
            final /* synthetic */ byte[] $bytes;

            public final void accept(@NotNull SecureChannelListener listener) {
                Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
                listener.onMessage(this.$bytes);
            }
            {
                this.$bytes = byArray;
            }
        });
    }

    public TLSClient(@NotNull Function2<? super SecureChannel, ? super Idscp2Configuration, ? extends CC> connectionFactory, @NotNull Idscp2Configuration clientConfiguration, @NotNull NativeTlsConfiguration nativeTlsConfiguration, @NotNull CompletableFuture<CC> connectionFuture) {
        SSLParameters sslParameters;
        Intrinsics.checkNotNullParameter(connectionFactory, (String)"connectionFactory");
        Intrinsics.checkNotNullParameter((Object)clientConfiguration, (String)"clientConfiguration");
        Intrinsics.checkNotNullParameter((Object)nativeTlsConfiguration, (String)"nativeTlsConfiguration");
        Intrinsics.checkNotNullParameter(connectionFuture, (String)"connectionFuture");
        this.connectionFactory = connectionFactory;
        this.clientConfiguration = clientConfiguration;
        this.connectionFuture = connectionFuture;
        this.listenerPromise = new CompletableFuture();
        TrustManager[] myTrustManager = PreConfiguration.INSTANCE.getX509ExtTrustManager(nativeTlsConfiguration.getTrustStorePath(), nativeTlsConfiguration.getTrustStorePassword());
        KeyManager[] myKeyManager = PreConfiguration.INSTANCE.getX509ExtKeyManager(nativeTlsConfiguration.getKeyPassword(), nativeTlsConfiguration.getKeyStorePath(), nativeTlsConfiguration.getKeyStorePassword(), nativeTlsConfiguration.getCertificateAlias(), nativeTlsConfiguration.getKeyStoreKeyType());
        SSLContext sslContext = SSLContext.getInstance("TLSv1.3");
        sslContext.init(myKeyManager, myTrustManager, null);
        SSLContext sSLContext = sslContext;
        Intrinsics.checkNotNullExpressionValue((Object)sSLContext, (String)"sslContext");
        SSLSocketFactory socketFactory = sSLContext.getSocketFactory();
        Socket socket = socketFactory.createSocket();
        Intrinsics.checkNotNullExpressionValue((Object)socket, (String)"socketFactory.createSocket()");
        Socket socket2 = this.clientSocket = socket;
        if (socket2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type javax.net.ssl.SSLSocket");
        }
        SSLSocket sslSocket = (SSLSocket)socket2;
        SSLParameters sSLParameters = sslParameters = sslSocket.getSSLParameters();
        Intrinsics.checkNotNullExpressionValue((Object)sSLParameters, (String)"sslParameters");
        sSLParameters.setUseCipherSuitesOrder(false);
        sslParameters.setNeedClientAuth(true);
        sslParameters.setProtocols(TLSConstants.INSTANCE.getTLS_ENABLED_PROTOCOLS());
        sslParameters.setCipherSuites(TLSConstants.INSTANCE.getTLS_ENABLED_CIPHERS());
        sslSocket.setSSLParameters(sslParameters);
        Logger logger = LOG;
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"LOG");
        if (logger.isTraceEnabled()) {
            LOG.trace("TLS Client was initialized successfully");
        }
    }

    static {
        Companion = new Companion(null);
        LOG = LoggerFactory.getLogger(TLSClient.class);
    }

    public static final /* synthetic */ InputListenerThread access$getInputListenerThread$p(TLSClient $this) {
        InputListenerThread inputListenerThread = $this.inputListenerThread;
        if (inputListenerThread == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"inputListenerThread");
        }
        return inputListenerThread;
    }

    public static final /* synthetic */ void access$setInputListenerThread$p(TLSClient $this, InputListenerThread inputListenerThread) {
        $this.inputListenerThread = inputListenerThread;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lde/fhg/aisec/ids/idscp2/default_drivers/secure_channel/tlsv1_3/client/TLSClient$Companion;", "", "()V", "LOG", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "idscp2"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

