/*
 * Decompiled with CFR 0.152.
 */
package de.fhg.aisec.ids.idscp2.default_drivers.secure_channel.tlsv1_3;

import java.net.InetAddress;
import java.security.cert.Certificate;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00070\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00070\fH\u0002J\u0010\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0007H\u0002J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lde/fhg/aisec/ids/idscp2/default_drivers/secure_channel/tlsv1_3/TLSSessionVerificationHelper;", "", "()V", "LOG", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "ipv4Pattern", "", "ipv6Pattern", "checkHostname", "", "dnsNameLabels", "", "hostNameLabels", "isIpAddress", "host", "verifyTlsSession", "", "sslSession", "Ljavax/net/ssl/SSLSession;", "idscp2"})
public final class TLSSessionVerificationHelper {
    private static final Logger LOG;
    private static final String ipv4Pattern = "(([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.){3}([01]?\\d\\d?|2[0-4]\\d|25[0-5])";
    private static final String ipv6Pattern = "([0-9a-f]{1,4}:){7}([0-9a-f]){1,4}";
    @NotNull
    public static final TLSSessionVerificationHelper INSTANCE;

    /*
     * WARNING - void declaration
     */
    public final void verifyTlsSession(@NotNull SSLSession sslSession) throws SSLPeerUnverifiedException {
        Intrinsics.checkNotNullParameter((Object)sslSession, (String)"sslSession");
        String host = sslSession.getPeerHost();
        Logger logger = LOG;
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"LOG");
        if (logger.isTraceEnabled()) {
            LOG.trace("Connected to {}:{}", (Object)host, (Object)sslSession.getPeerPort());
        }
        try {
            Iterator iterator;
            Certificate[] certificates = sslSession.getPeerCertificates();
            if (certificates.length != 1) {
                throw (Throwable)new SSLPeerUnverifiedException("Unexpected number of certificates");
            }
            Certificate certificate = certificates[0];
            if (certificate == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.security.cert.X509Certificate");
            }
            X509Certificate peerCert = (X509Certificate)certificate;
            Collection<List<?>> collection = peerCert.getSubjectAlternativeNames();
            if (collection == null) {
                throw (Throwable)new SSLPeerUnverifiedException("No Subject alternative names for hostname verification provided");
            }
            Collection<List<?>> sans = collection;
            ArrayList<Object> acceptedDnsNames = new ArrayList<Object>();
            ArrayList<Object> acceptedIpAddresses = new ArrayList<Object>();
            for (List<?> subjectAltName : sans) {
                boolean bl;
                if (subjectAltName.size() != 2) continue;
                Object value = subjectAltName.get(1);
                iterator = (Integer)subjectAltName.get(0);
                Integer n = iterator;
                if (n != null && n == 2) {
                    if (value instanceof String) {
                        acceptedDnsNames.add(value);
                        continue;
                    }
                    if (!(value instanceof byte[])) continue;
                    bl = false;
                    acceptedDnsNames.add(new String((byte[])value, Charsets.UTF_8));
                    continue;
                }
                Iterator iterator2 = iterator;
                if (iterator2 != null && (Integer)((Object)iterator2) == 7) {
                    if (value instanceof String) {
                        acceptedIpAddresses.add(value);
                        continue;
                    }
                    if (!(value instanceof byte[])) continue;
                    bl = false;
                    acceptedIpAddresses.add(new String((byte[])value, Charsets.UTF_8));
                    continue;
                }
                Logger logger2 = LOG;
                Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"LOG");
                if (!logger2.isTraceEnabled()) continue;
                LOG.trace("Unhandled SAN type \"{}\" with value \"{}\"", subjectAltName.get(0), value);
            }
            String string = host;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"host");
            if (this.isIpAddress(string)) {
                if (!acceptedIpAddresses.contains(host)) {
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    Object list$iv$iv;
                    String it;
                    void $this$flatMapTo$iv$iv;
                    Iterable $this$flatMap$iv = acceptedDnsNames;
                    boolean $i$f$flatMap = false;
                    iterator = $this$flatMap$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$flatMapTo = false;
                    for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                        List list;
                        it = (String)element$iv$iv;
                        boolean bl = false;
                        try {
                            Object[] objectArray = InetAddress.getAllByName(it);
                            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"InetAddress.getAllByName(it)");
                            list = ArraysKt.toList((Object[])objectArray);
                        }
                        catch (Throwable e) {
                            list = CollectionsKt.emptyList();
                        }
                        list$iv$iv = list;
                        CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                    }
                    $this$flatMap$iv = (List)destination$iv$iv;
                    boolean $i$f$map = false;
                    $this$flatMapTo$iv$iv = $this$map$iv;
                    destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        list$iv$iv = (InetAddress)item$iv$iv;
                        Collection collection2 = destination$iv$iv;
                        boolean bl = false;
                        String string2 = it;
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"it");
                        String string3 = ((InetAddress)((Object)string2)).getHostAddress();
                        collection2.add(string3);
                    }
                    List resolvedIps = (List)destination$iv$iv;
                    Logger logger3 = LOG;
                    Intrinsics.checkNotNullExpressionValue((Object)logger3, (String)"LOG");
                    if (logger3.isTraceEnabled()) {
                        LOG.trace("Resolved IPs: {}", (Object)CollectionsKt.joinToString$default((Iterable)CollectionsKt.toSet((Iterable)resolvedIps), null, null, null, (int)0, null, null, (int)63, null));
                    }
                    if (!resolvedIps.contains(host)) {
                        throw (Throwable)new SSLPeerUnverifiedException("Hostname verification failed. Peer certificate does not belong to peer host");
                    }
                }
            } else {
                List hostLabels = StringsKt.split$default((CharSequence)host, (String[])new String[]{"."}, (boolean)false, (int)0, (int)6, null);
                boolean found = false;
                iterator = acceptedDnsNames.iterator();
                while (iterator.hasNext()) {
                    String entry;
                    String string4 = entry = (String)iterator.next();
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"entry");
                    if (!this.checkHostname(StringsKt.split$default((CharSequence)StringsKt.trimEnd((String)string4, (char[])new char[]{'.'}), (String[])new String[]{"."}, (boolean)false, (int)0, (int)6, null), hostLabels)) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    throw (Throwable)new SSLPeerUnverifiedException("Hostname verification failed. Peer certificate does not belong to peer host");
                }
            }
            Date oneDay = new Date();
            oneDay.setTime(oneDay.getTime() + (long)86400000);
            peerCert.checkValidity();
            peerCert.checkValidity(oneDay);
        }
        catch (CertificateParsingException e) {
            throw (Throwable)new SSLPeerUnverifiedException("TLS Session Verification failed " + e);
        }
        catch (CertificateNotYetValidException e) {
            throw (Throwable)new SSLPeerUnverifiedException("TLS Session Verification failed " + e);
        }
        catch (CertificateExpiredException e) {
            throw (Throwable)new SSLPeerUnverifiedException("TLS Session Verification failed " + e);
        }
    }

    private final boolean isIpAddress(String host) {
        Matcher ip4 = Pattern.compile(ipv4Pattern, 2).matcher(host);
        if (ip4.matches()) {
            return true;
        }
        Matcher ip6 = Pattern.compile(ipv6Pattern, 2).matcher(host);
        return ip6.matches();
    }

    /*
     * WARNING - void declaration
     */
    private final boolean checkHostname(List<String> dnsNameLabels, List<String> hostNameLabels) {
        if (dnsNameLabels.size() == hostNameLabels.size()) {
            int n = 1;
            int n2 = dnsNameLabels.size();
            while (n < n2) {
                void i;
                if (Intrinsics.areEqual((Object)dnsNameLabels.get((int)i), (Object)hostNameLabels.get((int)i)) ^ true) {
                    return false;
                }
                ++i;
            }
            CharSequence charSequence = hostNameLabels.get(0);
            Regex regex = new Regex(StringsKt.replace$default((String)dnsNameLabels.get(0), (String)"*", (String)".*", (boolean)false, (int)4, null));
            boolean bl = false;
            return regex.matches(charSequence);
        }
        return false;
    }

    private TLSSessionVerificationHelper() {
    }

    static {
        TLSSessionVerificationHelper tLSSessionVerificationHelper;
        INSTANCE = tLSSessionVerificationHelper = new TLSSessionVerificationHelper();
        LOG = LoggerFactory.getLogger(TLSSessionVerificationHelper.class);
    }
}

