/*
 * Decompiled with CFR 0.152.
 */
package de.fhg.aisec.ids.idscp2.default_drivers.secure_channel.tlsv1_3;

import de.fhg.aisec.ids.idscp2.default_drivers.secure_channel.tlsv1_3.NativeTlsConfiguration;
import de.fhg.aisec.ids.idscp2.default_drivers.secure_channel.tlsv1_3.client.TLSClient;
import de.fhg.aisec.ids.idscp2.default_drivers.secure_channel.tlsv1_3.server.TLSServer;
import de.fhg.aisec.ids.idscp2.idscp_core.api.configuration.Idscp2Configuration;
import de.fhg.aisec.ids.idscp2.idscp_core.api.idscp_connection.Idscp2Connection;
import de.fhg.aisec.ids.idscp2.idscp_core.api.idscp_server.SecureChannelInitListener;
import de.fhg.aisec.ids.idscp2.idscp_core.api.idscp_server.ServerConnectionListener;
import de.fhg.aisec.ids.idscp2.idscp_core.drivers.SecureChannelDriver;
import de.fhg.aisec.ids.idscp2.idscp_core.drivers.SecureServer;
import de.fhg.aisec.ids.idscp2.idscp_core.error.Idscp2Exception;
import de.fhg.aisec.ids.idscp2.idscp_core.secure_channel.SecureChannel;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u00020\u00040\u0003B\u0005\u00a2\u0006\u0002\u0010\u0005J8\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u00072\u0018\u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00028\u00000\t2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u0004H\u0016J2\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00000\u00112\u0012\u0010\u0012\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00130\u00072\u0006\u0010\r\u001a\u00020\u0004H\u0016\u00a8\u0006\u0014"}, d2={"Lde/fhg/aisec/ids/idscp2/default_drivers/secure_channel/tlsv1_3/NativeTLSDriver;", "CC", "Lde/fhg/aisec/ids/idscp2/idscp_core/api/idscp_connection/Idscp2Connection;", "Lde/fhg/aisec/ids/idscp2/idscp_core/drivers/SecureChannelDriver;", "Lde/fhg/aisec/ids/idscp2/default_drivers/secure_channel/tlsv1_3/NativeTlsConfiguration;", "()V", "connect", "Ljava/util/concurrent/CompletableFuture;", "connectionFactory", "Lkotlin/Function2;", "Lde/fhg/aisec/ids/idscp2/idscp_core/secure_channel/SecureChannel;", "Lde/fhg/aisec/ids/idscp2/idscp_core/api/configuration/Idscp2Configuration;", "configuration", "secureChannelConfig", "listen", "Lde/fhg/aisec/ids/idscp2/idscp_core/drivers/SecureServer;", "channelInitListener", "Lde/fhg/aisec/ids/idscp2/idscp_core/api/idscp_server/SecureChannelInitListener;", "serverListenerPromise", "Lde/fhg/aisec/ids/idscp2/idscp_core/api/idscp_server/ServerConnectionListener;", "idscp2"})
public final class NativeTLSDriver<CC extends Idscp2Connection>
implements SecureChannelDriver<CC, NativeTlsConfiguration> {
    @Override
    @NotNull
    public CompletableFuture<CC> connect(@NotNull Function2<? super SecureChannel, ? super Idscp2Configuration, ? extends CC> connectionFactory, @NotNull Idscp2Configuration configuration, @NotNull NativeTlsConfiguration secureChannelConfig) {
        Intrinsics.checkNotNullParameter(connectionFactory, (String)"connectionFactory");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)secureChannelConfig, (String)"secureChannelConfig");
        CompletableFuture connectionFuture = new CompletableFuture();
        try {
            TLSClient<CC> tlsClient = new TLSClient<CC>(connectionFactory, configuration, secureChannelConfig, connectionFuture);
            tlsClient.connect(secureChannelConfig.getHost(), secureChannelConfig.getServerPort());
        }
        catch (Exception e) {
            connectionFuture.completeExceptionally(new Idscp2Exception("Call to connect() has failed", e));
        }
        return connectionFuture;
    }

    @Override
    @NotNull
    public SecureServer listen(@NotNull SecureChannelInitListener<CC> channelInitListener, @NotNull CompletableFuture<ServerConnectionListener<CC>> serverListenerPromise, @NotNull NativeTlsConfiguration secureChannelConfig) {
        SecureServer secureServer;
        Intrinsics.checkNotNullParameter(channelInitListener, (String)"channelInitListener");
        Intrinsics.checkNotNullParameter(serverListenerPromise, (String)"serverListenerPromise");
        Intrinsics.checkNotNullParameter((Object)secureChannelConfig, (String)"secureChannelConfig");
        try {
            secureServer = new TLSServer<CC>(secureChannelConfig, channelInitListener, serverListenerPromise);
        }
        catch (Exception e) {
            throw (Throwable)new Idscp2Exception("Error while trying to to start SecureServer", e);
        }
        return secureServer;
    }
}

