/*
 * Decompiled with CFR 0.152.
 */
package de.fhg.aisec.ids.idscp2.defaultdrivers.keystores;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.KeyStore;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0019\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lde/fhg/aisec/ids/idscp2/defaultdrivers/keystores/KeyStoreUtil;", "", "()V", "JKS_MAGIC_NUMBER", "", "LOG", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getKeyStoreType", "", "data", "", "loadKeyStore", "Ljava/security/KeyStore;", "keyStorePath", "Ljava/nio/file/Path;", "keyStorePassword", "", "idscp2"})
public final class KeyStoreUtil {
    @NotNull
    public static final KeyStoreUtil INSTANCE = new KeyStoreUtil();
    private static final int JKS_MAGIC_NUMBER = -17957139;
    private static final Logger LOG = LoggerFactory.getLogger(KeyStoreUtil.class);

    private KeyStoreUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String getKeyStoreType(byte[] data) {
        Closeable closeable = new DataInputStream(new ByteArrayInputStream(data));
        Throwable throwable = null;
        try {
            DataInputStream dis = (DataInputStream)closeable;
            boolean bl = false;
            if (dis.available() < 4) {
                throw new RuntimeException("KeyStore is too small to be an actual KeyStore!");
            }
            if (dis.readInt() == -17957139) {
                String string = "JKS";
                return string;
            }
            dis = Unit.INSTANCE;
        }
        catch (Throwable dis) {
            throwable = dis;
            throw dis;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        try {
            throwable = ASN1Primitive.fromByteArray((byte[])data);
        }
        catch (IOException e) {
            throw new RuntimeException("KeyStore not supported, could not detect JKS magic bytes or parse as ASN.1.");
        }
        Throwable pfx = throwable;
        if (pfx instanceof ASN1Sequence) {
            int n = ((ASN1Sequence)pfx).size();
            boolean bl = 2 <= n ? n < 4 : false;
            if (bl) {
                ASN1Encodable it = ((ASN1Sequence)pfx).getObjectAt(0);
                boolean bl2 = false;
                if (it instanceof ASN1Integer && ((ASN1Integer)it).getValue().intValue() == 3) {
                    return "PKCS12";
                }
            }
        }
        throw new RuntimeException("KeyStore not supported, could not detect JKS magic bytes or valid PKCS#12 structure in parsed ASN.1");
    }

    @NotNull
    public final KeyStore loadKeyStore(@NotNull Path keyStorePath, @NotNull char[] keyStorePassword) {
        KeyStore ks;
        KeyStore keyStore;
        KeyStore keyStore2;
        Intrinsics.checkNotNullParameter((Object)keyStorePath, (String)"keyStorePath");
        Intrinsics.checkNotNullParameter((Object)keyStorePassword, (String)"keyStorePassword");
        byte[] byArray = Files.readAllBytes(keyStorePath);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"readAllBytes(this)");
        byte[] keyStoreBytes = byArray;
        try {
            String type = this.getKeyStoreType(keyStoreBytes);
            keyStore2 = KeyStore.getInstance(type);
        }
        catch (RuntimeException e) {
            String defaultType = KeyStore.getDefaultType();
            LOG.warn("Could not detect KeyStore type, PKCS#12 or JKS expected. Trying default type \"" + defaultType + "\".", (Throwable)e);
            keyStore2 = KeyStore.getInstance(defaultType);
        }
        KeyStore $this$loadKeyStore_u24lambda_u242 = keyStore = (ks = keyStore2);
        boolean bl = false;
        if (LOG.isTraceEnabled()) {
            LOG.trace("Try loading key store: {}", (Object)keyStorePath);
        }
        $this$loadKeyStore_u24lambda_u242.load(new ByteArrayInputStream(keyStoreBytes), keyStorePassword);
        KeyStore keyStore3 = keyStore;
        Intrinsics.checkNotNullExpressionValue((Object)keyStore3, (String)"ks.apply {\n            i\u2026yStorePassword)\n        }");
        return keyStore3;
    }
}

