/*
 * Decompiled with CFR 0.152.
 */
package de.fhg.aisec.ids.idscp2.defaultdrivers.daps.aisecdaps;

import de.fhg.aisec.ids.idscp2.core.error.DatException;
import java.net.URI;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u0016"}, d2={"Lde/fhg/aisec/ids/idscp2/defaultdrivers/daps/aisecdaps/DapsMeta;", "", "issuer", "", "jwksUri", "tokenEndpoint", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getIssuer", "()Ljava/lang/String;", "getJwksUri", "getTokenEndpoint", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "Companion", "idscp2"})
public final class DapsMeta {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String issuer;
    @NotNull
    private final String jwksUri;
    @NotNull
    private final String tokenEndpoint;

    public DapsMeta(@NotNull String issuer, @NotNull String jwksUri, @NotNull String tokenEndpoint) {
        Intrinsics.checkNotNullParameter((Object)issuer, (String)"issuer");
        Intrinsics.checkNotNullParameter((Object)jwksUri, (String)"jwksUri");
        Intrinsics.checkNotNullParameter((Object)tokenEndpoint, (String)"tokenEndpoint");
        this.issuer = issuer;
        this.jwksUri = jwksUri;
        this.tokenEndpoint = tokenEndpoint;
    }

    @NotNull
    public final String getIssuer() {
        return this.issuer;
    }

    @NotNull
    public final String getJwksUri() {
        return this.jwksUri;
    }

    @NotNull
    public final String getTokenEndpoint() {
        return this.tokenEndpoint;
    }

    @NotNull
    public final String component1() {
        return this.issuer;
    }

    @NotNull
    public final String component2() {
        return this.jwksUri;
    }

    @NotNull
    public final String component3() {
        return this.tokenEndpoint;
    }

    @NotNull
    public final DapsMeta copy(@NotNull String issuer, @NotNull String jwksUri, @NotNull String tokenEndpoint) {
        Intrinsics.checkNotNullParameter((Object)issuer, (String)"issuer");
        Intrinsics.checkNotNullParameter((Object)jwksUri, (String)"jwksUri");
        Intrinsics.checkNotNullParameter((Object)tokenEndpoint, (String)"tokenEndpoint");
        return new DapsMeta(issuer, jwksUri, tokenEndpoint);
    }

    public static /* synthetic */ DapsMeta copy$default(DapsMeta dapsMeta, String string, String string2, String string3, int n, Object object) {
        if ((n & 1) != 0) {
            string = dapsMeta.issuer;
        }
        if ((n & 2) != 0) {
            string2 = dapsMeta.jwksUri;
        }
        if ((n & 4) != 0) {
            string3 = dapsMeta.tokenEndpoint;
        }
        return dapsMeta.copy(string, string2, string3);
    }

    @NotNull
    public String toString() {
        return "DapsMeta(issuer=" + this.issuer + ", jwksUri=" + this.jwksUri + ", tokenEndpoint=" + this.tokenEndpoint + ")";
    }

    public int hashCode() {
        int result = this.issuer.hashCode();
        result = result * 31 + this.jwksUri.hashCode();
        result = result * 31 + this.tokenEndpoint.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DapsMeta)) {
            return false;
        }
        DapsMeta dapsMeta = (DapsMeta)other;
        if (!Intrinsics.areEqual((Object)this.issuer, (Object)dapsMeta.issuer)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.jwksUri, (Object)dapsMeta.jwksUri)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.tokenEndpoint, (Object)dapsMeta.tokenEndpoint);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u001a\u0010\u0007\u001a\u00020\u00042\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00010\t\u00a8\u0006\n"}, d2={"Lde/fhg/aisec/ids/idscp2/defaultdrivers/daps/aisecdaps/DapsMeta$Companion;", "", "()V", "fromDapsUrl", "Lde/fhg/aisec/ids/idscp2/defaultdrivers/daps/aisecdaps/DapsMeta;", "url", "", "fromJson", "json", "", "idscp2"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DapsMeta fromDapsUrl(@NotNull String url) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            URI dapsUri = new URI(url);
            return new DapsMeta(dapsUri.getScheme() + "://" + dapsUri.getHost(), url + "/.well-known/jwks.json", url + "/token");
        }

        @NotNull
        public final DapsMeta fromJson(@NotNull Map<String, ? extends Object> json) {
            Intrinsics.checkNotNullParameter(json, (String)"json");
            String string = (String)json.get("issuer");
            if (string == null) {
                throw new DatException("\"issuer\" not found in DAPS meta JSON");
            }
            String string2 = (String)json.get("jwks_uri");
            if (string2 == null) {
                throw new DatException("\"jwks_uri\" not found in DAPS meta JSON");
            }
            String string3 = (String)json.get("token_endpoint");
            if (string3 == null) {
                throw new DatException("\"token_endpoint\" not found in DAPS meta JSON");
            }
            return new DapsMeta(string, string2, string3);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

