/*
 * Decompiled with CFR 0.152.
 */
package de.fhg.aisec.ids.idscp2.core.fsm;

import com.google.protobuf.ProtocolStringList;
import de.fhg.aisec.ids.idscp2.core.api.configuration.AttestationConfig;
import de.fhg.aisec.ids.idscp2.core.drivers.DapsDriver;
import de.fhg.aisec.ids.idscp2.core.fsm.DynamicTimer;
import de.fhg.aisec.ids.idscp2.core.fsm.Event;
import de.fhg.aisec.ids.idscp2.core.fsm.FSM;
import de.fhg.aisec.ids.idscp2.core.fsm.InternalControlMessage;
import de.fhg.aisec.ids.idscp2.core.fsm.State;
import de.fhg.aisec.ids.idscp2.core.fsm.StaticTimer;
import de.fhg.aisec.ids.idscp2.core.fsm.Transition;
import de.fhg.aisec.ids.idscp2.core.messages.Idscp2MessageHelper;
import de.fhg.aisec.ids.idscp2.messages.IDSCP2;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0002\u001a\u00020\u0003H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lde/fhg/aisec/ids/idscp2/core/fsm/StateWaitForHello;", "Lde/fhg/aisec/ids/idscp2/core/fsm/State;", "fsm", "Lde/fhg/aisec/ids/idscp2/core/fsm/FSM;", "handshakeTimer", "Lde/fhg/aisec/ids/idscp2/core/fsm/StaticTimer;", "datTimer", "Lde/fhg/aisec/ids/idscp2/core/fsm/DynamicTimer;", "dapsDriver", "Lde/fhg/aisec/ids/idscp2/core/drivers/DapsDriver;", "attestationConfig", "Lde/fhg/aisec/ids/idscp2/core/api/configuration/AttestationConfig;", "(Lde/fhg/aisec/ids/idscp2/core/fsm/FSM;Lde/fhg/aisec/ids/idscp2/core/fsm/StaticTimer;Lde/fhg/aisec/ids/idscp2/core/fsm/DynamicTimer;Lde/fhg/aisec/ids/idscp2/core/drivers/DapsDriver;Lde/fhg/aisec/ids/idscp2/core/api/configuration/AttestationConfig;)V", "runEntryCode", "", "Companion", "idscp2"})
public final class StateWaitForHello
extends State {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final StaticTimer handshakeTimer;
    private static final Logger LOG = LoggerFactory.getLogger(StateWaitForHello.class);

    public StateWaitForHello(final @NotNull FSM fsm2, @NotNull StaticTimer handshakeTimer, final @NotNull DynamicTimer datTimer, final @NotNull DapsDriver dapsDriver, final @NotNull AttestationConfig attestationConfig) {
        Intrinsics.checkNotNullParameter((Object)fsm2, (String)"fsm");
        Intrinsics.checkNotNullParameter((Object)handshakeTimer, (String)"handshakeTimer");
        Intrinsics.checkNotNullParameter((Object)datTimer, (String)"datTimer");
        Intrinsics.checkNotNullParameter((Object)dapsDriver, (String)"dapsDriver");
        Intrinsics.checkNotNullParameter((Object)attestationConfig, (String)"attestationConfig");
        this.handshakeTimer = handshakeTimer;
        this.addTransition(InternalControlMessage.ERROR.getValue(), new Transition((Function1<? super Event, FSM.FsmResult>)((Function1)new Function1<Event, FSM.FsmResult>(){

            @NotNull
            public final FSM.FsmResult invoke(@NotNull Event it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                LOG.warn("An internal control error occurred");
                return new FSM.FsmResult(FSM.FsmResultCode.OK, fsm2.getState(FSM.FsmState.STATE_CLOSED));
            }
        })));
        this.addTransition(InternalControlMessage.IDSCP_STOP.getValue(), new Transition((Function1<? super Event, FSM.FsmResult>)((Function1)new Function1<Event, FSM.FsmResult>(){

            @NotNull
            public final FSM.FsmResult invoke(@NotNull Event it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Received stop signal from user. Send IDSCP_CLOSE");
                }
                fsm2.sendFromFSM(Idscp2MessageHelper.INSTANCE.createIdscpCloseMessage("User close", IDSCP2.IdscpClose.CloseCause.USER_SHUTDOWN));
                return new FSM.FsmResult(FSM.FsmResultCode.OK, fsm2.getState(FSM.FsmState.STATE_CLOSED));
            }
        })));
        this.addTransition(InternalControlMessage.SEND_DATA.getValue(), new Transition((Function1<? super Event, FSM.FsmResult>)((Function1)new Function1<Event, FSM.FsmResult>(){

            @NotNull
            public final FSM.FsmResult invoke(@NotNull Event it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Received SEND signal from user, but FSM is not connected yet");
                }
                return new FSM.FsmResult(FSM.FsmResultCode.NOT_CONNECTED, this);
            }
        })));
        this.addTransition(InternalControlMessage.REPEAT_RA.getValue(), new Transition((Function1<? super Event, FSM.FsmResult>)((Function1)new Function1<Event, FSM.FsmResult>(){

            @NotNull
            public final FSM.FsmResult invoke(@NotNull Event it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Received REPEAT_RA signal from user");
                }
                return new FSM.FsmResult(FSM.FsmResultCode.OK, this);
            }
        })));
        this.addTransition(InternalControlMessage.TIMEOUT.getValue(), new Transition((Function1<? super Event, FSM.FsmResult>)((Function1)new Function1<Event, FSM.FsmResult>(){

            @NotNull
            public final FSM.FsmResult invoke(@NotNull Event it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                LOG.warn("STATE_WAIT_FOR_HELLO timeout. Send IDSCP_CLOSE");
                fsm2.sendFromFSM(Idscp2MessageHelper.INSTANCE.createIdscpCloseMessage("Handshake Timeout", IDSCP2.IdscpClose.CloseCause.TIMEOUT));
                return new FSM.FsmResult(FSM.FsmResultCode.OK, fsm2.getState(FSM.FsmState.STATE_CLOSED));
            }
        })));
        this.addTransition(2, new Transition((Function1<? super Event, FSM.FsmResult>)((Function1)new Function1<Event, FSM.FsmResult>(){

            @NotNull
            public final FSM.FsmResult invoke(@NotNull Event it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Received IDSCP_CLOSE. Close connection");
                }
                return new FSM.FsmResult(FSM.FsmResultCode.OK, fsm2.getState(FSM.FsmState.STATE_CLOSED));
            }
        })));
        this.addTransition(1, new Transition((Function1<? super Event, FSM.FsmResult>)((Function1)new Function1<Event, FSM.FsmResult>(){

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final FSM.FsmResult invoke(@NotNull Event event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                handshakeTimer.cancelTimeout();
                IDSCP2.IdscpHello idscpHello = event.getIdscpMessage().getIdscpHello();
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Received IDSCP_HELLO");
                }
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Calculate RA mechanisms");
                }
                String[] stringArray = attestationConfig.getSupportedAttestationSuite();
                ProtocolStringList protocolStringList = idscpHello.getExpectedRaSuiteList();
                Intrinsics.checkNotNullExpressionValue((Object)protocolStringList, (String)"idscpHello.expectedRaSuiteList");
                Collection $this$toTypedArray$iv = (Collection)protocolStringList;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                String proverMechanism = fsm2.getRaProverMechanism(stringArray, thisCollection$iv.toArray(new String[0]));
                if (proverMechanism == null) {
                    LOG.warn("No match for RA prover mechanism");
                    return new FSM.FsmResult(FSM.FsmResultCode.RA_NEGOTIATION_ERROR, fsm2.getState(FSM.FsmState.STATE_CLOSED));
                }
                String[] stringArray2 = attestationConfig.getExpectedAttestationSuite();
                ProtocolStringList protocolStringList2 = idscpHello.getSupportedRaSuiteList();
                Intrinsics.checkNotNullExpressionValue((Object)protocolStringList2, (String)"idscpHello.supportedRaSuiteList");
                Collection $this$toTypedArray$iv2 = (Collection)protocolStringList2;
                boolean $i$f$toTypedArray2 = false;
                Collection thisCollection$iv2 = $this$toTypedArray$iv2;
                String verifierMechanism = fsm2.getRaVerifierMechanism(stringArray2, thisCollection$iv2.toArray(new String[0]));
                if (verifierMechanism == null) {
                    LOG.warn("No match for RA verifier mechanism");
                    return new FSM.FsmResult(FSM.FsmResultCode.RA_NEGOTIATION_ERROR, fsm2.getState(FSM.FsmState.STATE_CLOSED));
                }
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Verify received DAT");
                }
                long datValidityPeriod = 0L;
                if (!idscpHello.hasDynamicAttributeToken()) {
                    LOG.warn("No remote DAT is available. Send IDSCP_CLOSE");
                    fsm2.sendFromFSM(Idscp2MessageHelper.INSTANCE.createIdscpCloseMessage("No valid DAT", IDSCP2.IdscpClose.CloseCause.NO_VALID_DAT));
                    return new FSM.FsmResult(FSM.FsmResultCode.MISSING_DAT, fsm2.getState(FSM.FsmState.STATE_CLOSED));
                }
                byte[] remoteDat = idscpHello.getDynamicAttributeToken().getToken().toByteArray();
                try {
                    void it;
                    Intrinsics.checkNotNullExpressionValue((Object)remoteDat, (String)"remoteDat");
                    long l = thisCollection$iv2 = dapsDriver.verifyToken(remoteDat, fsm2.getRemotePeerCertificate());
                    long l2 = 0L;
                    boolean bl = false;
                    datValidityPeriod = it;
                    Unit unit = Unit.INSTANCE;
                    if (l2 > thisCollection$iv2) {
                        LOG.warn("No valid remote DAT is available. Send IDSCP_CLOSE");
                        fsm2.sendFromFSM(Idscp2MessageHelper.INSTANCE.createIdscpCloseMessage("No valid DAT", IDSCP2.IdscpClose.CloseCause.NO_VALID_DAT));
                        return new FSM.FsmResult(FSM.FsmResultCode.INVALID_DAT, fsm2.getState(FSM.FsmState.STATE_CLOSED));
                    }
                }
                catch (Exception e) {
                    LOG.warn("DapsDriver throws Exception while validating remote DAT. Send IDSCP_CLOSE.", (Throwable)e);
                    fsm2.sendFromFSM(Idscp2MessageHelper.INSTANCE.createIdscpCloseMessage("No valid DAT", IDSCP2.IdscpClose.CloseCause.NO_VALID_DAT));
                    return new FSM.FsmResult(FSM.FsmResultCode.INVALID_DAT, fsm2.getState(FSM.FsmState.STATE_CLOSED));
                }
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Remote DAT is valid. Set dat timeout to its validity period");
                }
                fsm2.setPeerDat(remoteDat);
                datTimer.resetTimeout(datValidityPeriod * (long)1000);
                fsm2.setRaMechanisms(proverMechanism, verifierMechanism);
                if (LOG.isTraceEnabled()) {
                    LOG.debug("Start RA Prover and Verifier");
                }
                if (!fsm2.restartRaVerifierDriver()) {
                    LOG.warn("Cannot run RA verifier, close idscp connection");
                    return new FSM.FsmResult(FSM.FsmResultCode.RA_ERROR, fsm2.getState(FSM.FsmState.STATE_CLOSED));
                }
                if (!fsm2.restartRaProverDriver()) {
                    LOG.warn("Cannot run RA prover, close idscp connection");
                    return new FSM.FsmResult(FSM.FsmResultCode.RA_ERROR, fsm2.getState(FSM.FsmState.STATE_CLOSED));
                }
                return new FSM.FsmResult(FSM.FsmResultCode.OK, fsm2.getState(FSM.FsmState.STATE_WAIT_FOR_RA));
            }
        })));
        this.setNoTransitionHandler(arg_0 -> StateWaitForHello._init_$lambda$0(this, arg_0));
    }

    @Override
    public void runEntryCode(@NotNull FSM fsm2) {
        Intrinsics.checkNotNullParameter((Object)fsm2, (String)"fsm");
        if (LOG.isTraceEnabled()) {
            LOG.trace("Switched to state STATE_WAIT_FOR_HELLO");
            LOG.trace("Set handshake timeout to " + this.handshakeTimer.getDelay() + " ms.");
        }
        this.handshakeTimer.resetTimeout();
    }

    private static final FSM.FsmResult _init_$lambda$0(StateWaitForHello this$0, Event it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (LOG.isTraceEnabled()) {
            LOG.trace("No transition available for given event " + it);
            LOG.trace("Stay in state STATE_WAIT_FOR_HELLO");
        }
        return new FSM.FsmResult(FSM.FsmResultCode.UNKNOWN_TRANSITION, this$0);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lde/fhg/aisec/ids/idscp2/core/fsm/StateWaitForHello$Companion;", "", "()V", "LOG", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "idscp2"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

