/*
 * Decompiled with CFR 0.152.
 */
package de.fhg.aisec.ids.idscp2.defaultdrivers.keystores;

import de.fhg.aisec.ids.idscp2.defaultdrivers.keystores.KeyStoreUtil;
import java.nio.file.Path;
import java.security.Key;
import java.security.KeyStore;
import java.security.cert.CertSelector;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509ExtendedTrustManager;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0019\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u001e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0005J&\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0014J)\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\u0002\u0010\u001cJ\u0016\u0010\u001d\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u001f\u001a\u00020\u0014RN\u0010\u0003\u001aB\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00070\u0007 \u0006* \u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00070\u0007\u0018\u00010\b0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lde/fhg/aisec/ids/idscp2/defaultdrivers/keystores/PreConfiguration;", "", "()V", "TRUST_MANAGERS", "", "", "kotlin.jvm.PlatformType", "Ljavax/net/ssl/X509ExtendedTrustManager;", "", "filterTrustAnchors", "Ljava/security/cert/PKIXBuilderParameters;", "keyStore", "Ljava/security/KeyStore;", "validityUntilDate", "Ljava/util/Date;", "getCertificate", "Ljava/security/cert/X509Certificate;", "keyStorePath", "Ljava/nio/file/Path;", "keyStorePassword", "", "keyAlias", "getKey", "Ljava/security/Key;", "keyPassword", "getX509ExtKeyManager", "", "Ljavax/net/ssl/KeyManager;", "([CLjava/nio/file/Path;[C)[Ljavax/net/ssl/KeyManager;", "getX509ExtTrustManager", "trustStorePath", "trustStorePassword", "idscp2"})
public final class PreConfiguration {
    @NotNull
    public static final PreConfiguration INSTANCE = new PreConfiguration();
    private static final Map<String, X509ExtendedTrustManager> TRUST_MANAGERS = Collections.synchronizedMap(new LinkedHashMap());

    private PreConfiguration() {
    }

    @NotNull
    public final X509ExtendedTrustManager getX509ExtTrustManager(@NotNull Path trustStorePath, @NotNull char[] trustStorePassword) {
        Intrinsics.checkNotNullParameter((Object)trustStorePath, (String)"trustStorePath");
        Intrinsics.checkNotNullParameter((Object)trustStorePassword, (String)"trustStorePassword");
        X509ExtendedTrustManager x509ExtendedTrustManager = TRUST_MANAGERS.computeIfAbsent(((Object)trustStorePath.toAbsolutePath()).toString(), arg_0 -> PreConfiguration.getX509ExtTrustManager$lambda$0((Function1)new Function1<String, X509ExtendedTrustManager>(trustStorePath, trustStorePassword){
            final /* synthetic */ Path $trustStorePath;
            final /* synthetic */ char[] $trustStorePassword;
            {
                this.$trustStorePath = $trustStorePath;
                this.$trustStorePassword = $trustStorePassword;
                super(1);
            }

            public final X509ExtendedTrustManager invoke(String it) {
                TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance("PKIX");
                Path path = this.$trustStorePath;
                char[] cArray = this.$trustStorePassword;
                TrustManagerFactory $this$invoke_u24lambda_u240 = trustManagerFactory;
                boolean bl = false;
                $this$invoke_u24lambda_u240.init(KeyStoreUtil.INSTANCE.loadKeyStore(path, cArray));
                Object[] it2 = trustManagerFactory.getTrustManagers();
                boolean bl2 = false;
                if (it2.length != 1 || !(it2[0] instanceof X509ExtendedTrustManager)) {
                    String string = Arrays.toString(it2);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(this)");
                    throw new IllegalStateException("Unexpected default trust manager(s): " + string);
                }
                Object object = it2[0];
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type javax.net.ssl.X509ExtendedTrustManager");
                return (X509ExtendedTrustManager)object;
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)x509ExtendedTrustManager, (String)"trustStorePath: Path,\n  \u2026r\n            }\n        }");
        return x509ExtendedTrustManager;
    }

    @NotNull
    public final KeyManager[] getX509ExtKeyManager(@NotNull char[] keyPassword, @NotNull Path keyStorePath, @NotNull char[] keyStorePassword) {
        Object[] objectArray;
        Intrinsics.checkNotNullParameter((Object)keyPassword, (String)"keyPassword");
        Intrinsics.checkNotNullParameter((Object)keyStorePath, (String)"keyStorePath");
        Intrinsics.checkNotNullParameter((Object)keyStorePassword, (String)"keyStorePassword");
        KeyStore keystore = KeyStoreUtil.INSTANCE.loadKeyStore(keyStorePath, keyStorePassword);
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance("PKIX");
        keyManagerFactory.init(keystore, keyPassword);
        Object[] it = objectArray = keyManagerFactory.getKeyManagers();
        boolean bl = false;
        if (it.length != 1 || !(it[0] instanceof X509ExtendedKeyManager)) {
            String string = Arrays.toString(it);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(this)");
            throw new IllegalStateException("Unexpected default key managers:" + string);
        }
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"keyManagerFactory.keyMan\u2026)\n            }\n        }");
        return objectArray;
    }

    @NotNull
    public final Key getKey(@NotNull Path keyStorePath, @NotNull char[] keyStorePassword, @NotNull String keyAlias, @NotNull char[] keyPassword) {
        Key key;
        Intrinsics.checkNotNullParameter((Object)keyStorePath, (String)"keyStorePath");
        Intrinsics.checkNotNullParameter((Object)keyStorePassword, (String)"keyStorePassword");
        Intrinsics.checkNotNullParameter((Object)keyAlias, (String)"keyAlias");
        Intrinsics.checkNotNullParameter((Object)keyPassword, (String)"keyPassword");
        KeyStore keyStore = KeyStoreUtil.INSTANCE.loadKeyStore(keyStorePath, keyStorePassword);
        Key key2 = key = keyStore.getKey(keyAlias, keyPassword);
        if (key2 == null) {
            throw new RuntimeException("No key was found in keystore for given alias");
        }
        return key2;
    }

    @NotNull
    public final X509Certificate getCertificate(@NotNull Path keyStorePath, @NotNull char[] keyStorePassword, @NotNull String keyAlias) {
        Intrinsics.checkNotNullParameter((Object)keyStorePath, (String)"keyStorePath");
        Intrinsics.checkNotNullParameter((Object)keyStorePassword, (String)"keyStorePassword");
        Intrinsics.checkNotNullParameter((Object)keyAlias, (String)"keyAlias");
        KeyStore keystore = KeyStoreUtil.INSTANCE.loadKeyStore(keyStorePath, keyStorePassword);
        Certificate certificate = keystore.getCertificate(keyAlias);
        Intrinsics.checkNotNull((Object)certificate, (String)"null cannot be cast to non-null type java.security.cert.X509Certificate");
        X509Certificate cert = (X509Certificate)certificate;
        keystore.getKey(keyAlias, keyStorePassword);
        return cert;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final PKIXBuilderParameters filterTrustAnchors(@NotNull KeyStore keyStore, @NotNull Date validityUntilDate) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)keyStore, (String)"keyStore");
        Intrinsics.checkNotNullParameter((Object)validityUntilDate, (String)"validityUntilDate");
        PKIXParameters params = new PKIXParameters(keyStore);
        Set<TrustAnchor> set = params.getTrustAnchors();
        Intrinsics.checkNotNullExpressionValue(set, (String)"params.trustAnchors");
        Iterable $this$filter$iv = set;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            boolean bl;
            TrustAnchor it = (TrustAnchor)element$iv$iv;
            boolean bl2 = false;
            try {
                it.getTrustedCert().checkValidity(validityUntilDate);
                bl = true;
            }
            catch (CertificateException e) {
                bl = false;
            }
            if (!bl) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Set validTrustAnchors = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        return new PKIXBuilderParameters(validTrustAnchors, (CertSelector)new X509CertSelector());
    }

    private static final X509ExtendedTrustManager getX509ExtTrustManager$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (X509ExtendedTrustManager)$tmp0.invoke(p0);
    }
}

