/*
 * Decompiled with CFR 0.152.
 */
package de.fhg.aisec.ids.idscp2.defaultdrivers.daps.aisecdaps;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.fhg.aisec.ids.idscp2.core.drivers.DapsDriver;
import de.fhg.aisec.ids.idscp2.core.error.DatException;
import de.fhg.aisec.ids.idscp2.defaultdrivers.daps.aisecdaps.AisecDapsDriver;
import de.fhg.aisec.ids.idscp2.defaultdrivers.daps.aisecdaps.AisecDapsDriverConfig;
import de.fhg.aisec.ids.idscp2.defaultdrivers.daps.aisecdaps.DapsMeta;
import de.fhg.aisec.ids.idscp2.defaultdrivers.daps.aisecdaps.SecurityProfile;
import de.fhg.aisec.ids.idscp2.defaultdrivers.daps.aisecdaps.SecurityRequirements;
import de.fhg.aisec.ids.idscp2.defaultdrivers.keystores.PreConfiguration;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import io.ktor.client.HttpClient;
import io.ktor.client.HttpClientConfig;
import io.ktor.client.HttpClientKt;
import io.ktor.client.engine.HttpClientEngineFactory;
import io.ktor.client.engine.java.Java;
import io.ktor.client.engine.java.JavaHttpConfig;
import io.ktor.client.plugins.HttpClientPlugin;
import io.ktor.client.plugins.cache.HttpCache;
import io.ktor.client.plugins.contentnegotiation.ContentNegotiation;
import io.ktor.client.request.HttpRequestBuilder;
import io.ktor.client.request.HttpRequestKt;
import io.ktor.client.request.forms.FormBuildersKt;
import io.ktor.client.statement.HttpResponse;
import io.ktor.client.statement.HttpResponseKt;
import io.ktor.client.statement.HttpStatement;
import io.ktor.http.HeaderValue;
import io.ktor.http.Headers;
import io.ktor.http.HttpMessage;
import io.ktor.http.HttpMessagePropertiesKt;
import io.ktor.http.HttpStatusCode;
import io.ktor.http.Parameters;
import io.ktor.http.ParametersKt;
import io.ktor.util.reflect.TypeInfoJvmKt;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.http.HttpClient;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.KeyManagementException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.time.Instant;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Triple;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.reflect.KType;
import kotlin.reflect.KTypeProjection;
import kotlin.reflect.TypesJVMKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.x509.AuthorityKeyIdentifier;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.SubjectKeyIdentifier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jose4j.http.SimpleResponse;
import org.jose4j.jwa.AlgorithmConstraints;
import org.jose4j.jwk.HttpsJwks;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.NumericDate;
import org.jose4j.jwt.consumer.JwtConsumer;
import org.jose4j.jwt.consumer.JwtConsumerBuilder;
import org.jose4j.keys.resolvers.HttpsJwksVerificationKeyResolver;
import org.jose4j.keys.resolvers.VerificationKeyResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u0000 +2\u00020\u0001:\u0001+B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\"\u001a\u00020\u00062\u0006\u0010#\u001a\u00020\u0012H\u0002J\b\u0010$\u001a\u00020\nH\u0002J4\u0010%\u001a\u00020\f2\u0006\u0010&\u001a\u00020\b2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010#\u001a\u00020\u00122\u0006\u0010'\u001a\u00020(2\b\b\u0002\u0010\t\u001a\u00020\nH\u0002J\u001a\u0010)\u001a\u00020\f2\u0006\u0010&\u001a\u00020\b2\b\u0010*\u001a\u0004\u0018\u00010\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\n \u0010*\u0004\u0018\u00010\u000f0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001f\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010!\u00a8\u0006,"}, d2={"Lde/fhg/aisec/ids/idscp2/defaultdrivers/daps/aisecdaps/AisecDapsDriver;", "Lde/fhg/aisec/ids/idscp2/core/drivers/DapsDriver;", "config", "Lde/fhg/aisec/ids/idscp2/defaultdrivers/daps/aisecdaps/AisecDapsDriverConfig;", "(Lde/fhg/aisec/ids/idscp2/defaultdrivers/daps/aisecdaps/AisecDapsDriverConfig;)V", "connectorUUID", "", "currentToken", "", "dapsMeta", "Lde/fhg/aisec/ids/idscp2/defaultdrivers/daps/aisecdaps/DapsMeta;", "dapsMetaExpire", "", "dapsUrl", "httpClient", "Lio/ktor/client/HttpClient;", "kotlin.jvm.PlatformType", "localPeerCertificate", "Ljava/security/cert/X509Certificate;", "privateKey", "Ljava/security/Key;", "renewalLock", "Ljava/util/concurrent/locks/ReentrantLock;", "renewalThreshold", "", "renewalTime", "Lorg/jose4j/jwt/NumericDate;", "securityRequirements", "Lde/fhg/aisec/ids/idscp2/defaultdrivers/daps/aisecdaps/SecurityRequirements;", "sslContext", "Ljavax/net/ssl/SSLContext;", "token", "getToken", "()[B", "extractConnectorUUID", "certificate", "getDapsMeta", "innerVerifyToken", "dat", "setCurrentToken", "", "verifyToken", "peerCertificate", "Companion", "idscp2"})
public final class AisecDapsDriver
implements DapsDriver {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AisecDapsDriverConfig config;
    @Nullable
    private SecurityRequirements securityRequirements;
    @NotNull
    private final Key privateKey;
    @NotNull
    private final String dapsUrl;
    @NotNull
    private final X509Certificate localPeerCertificate;
    @NotNull
    private final String connectorUUID;
    @NotNull
    private byte[] currentToken;
    @NotNull
    private NumericDate renewalTime;
    private final float renewalThreshold;
    @NotNull
    private final ReentrantLock renewalLock;
    @NotNull
    private final SSLContext sslContext;
    private final HttpClient httpClient;
    @Nullable
    private DapsMeta dapsMeta;
    private long dapsMetaExpire;
    private static final Logger LOG = LoggerFactory.getLogger(AisecDapsDriver.class);
    @NotNull
    private static final String TARGET_AUDIENCE = "idsc:IDS_CONNECTORS_ALL";
    private static final long META_FALLBACK_LIFETIME_MS = 86400000L;
    private static final Map<TrustManager, HttpClient> HTTP_CLIENTS = Collections.synchronizedMap(new LinkedHashMap());
    @NotNull
    private static final HashMap<Byte, String> hexLookup = new HashMap();

    /*
     * WARNING - void declaration
     */
    public AisecDapsDriver(@NotNull AisecDapsDriverConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.config = config;
        this.securityRequirements = this.config.getSecurityRequirements();
        this.privateKey = PreConfiguration.INSTANCE.getKey(this.config.getKeyStorePath(), this.config.getKeyStorePassword(), this.config.getKeyAlias(), this.config.getKeyPassword());
        this.dapsUrl = this.config.getDapsUrl();
        this.localPeerCertificate = PreConfiguration.INSTANCE.getCertificate(this.config.getKeyStorePath(), this.config.getKeyStorePassword(), this.config.getKeyAlias());
        this.connectorUUID = this.extractConnectorUUID(this.localPeerCertificate);
        Object object = "INVALID_TOKEN";
        byte[] byArray = ((String)object).getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        this.currentToken = byArray;
        NumericDate numericDate = NumericDate.now();
        Intrinsics.checkNotNullExpressionValue((Object)numericDate, (String)"now()");
        this.renewalTime = numericDate;
        this.renewalThreshold = this.config.getDapsTokenRenewalThreshold();
        this.renewalLock = new ReentrantLock(true);
        AisecDapsDriver aisecDapsDriver = this;
        try {
            void $this$sslContext_u24lambda_u240;
            SSLContext sSLContext;
            SSLContext sSLContext2 = sSLContext = SSLContext.getInstance("TLS");
            AisecDapsDriver aisecDapsDriver2 = aisecDapsDriver;
            boolean bl = false;
            TrustManager[] trustManagerArray = new TrustManager[]{this.config.getTrustManager()};
            $this$sslContext_u24lambda_u240.init(null, trustManagerArray, null);
            AisecDapsDriver aisecDapsDriver3 = aisecDapsDriver2;
            SSLContext sSLContext3 = sSLContext;
            Intrinsics.checkNotNullExpressionValue((Object)sSLContext3, (String)"{\n        SSLContext.get\u2026r), null)\n        }\n    }");
            object = sSLContext3;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            void e;
            AisecDapsDriver aisecDapsDriver4 = aisecDapsDriver;
            LOG.error("Cannot init AisecDapsDriver", (Throwable)e);
            throw new RuntimeException((Throwable)e);
        }
        catch (KeyManagementException e) {
            AisecDapsDriver aisecDapsDriver5 = aisecDapsDriver;
            LOG.error("Cannot init AisecDapsDriver", (Throwable)e);
            throw new RuntimeException(e);
        }
        aisecDapsDriver3.sslContext = object;
        this.httpClient = HTTP_CLIENTS.computeIfAbsent(this.config.getTrustManager(), arg_0 -> AisecDapsDriver.httpClient$lambda$1((Function1)new Function1<TrustManager, HttpClient>(this){
            final /* synthetic */ AisecDapsDriver this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final HttpClient invoke(TrustManager it) {
                return HttpClientKt.HttpClient((HttpClientEngineFactory)((HttpClientEngineFactory)Java.INSTANCE), (Function1)((Function1)new Function1<HttpClientConfig<JavaHttpConfig>, Unit>(this.this$0){
                    final /* synthetic */ AisecDapsDriver this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull HttpClientConfig<JavaHttpConfig> $this$HttpClient) {
                        Intrinsics.checkNotNullParameter($this$HttpClient, (String)"$this$HttpClient");
                        $this$HttpClient.engine((Function1)new Function1<JavaHttpConfig, Unit>(this.this$0){
                            final /* synthetic */ AisecDapsDriver this$0;
                            {
                                this.this$0 = $receiver;
                                super(1);
                            }

                            public final void invoke(@NotNull JavaHttpConfig $this$engine) {
                                Intrinsics.checkNotNullParameter((Object)$this$engine, (String)"$this$engine");
                                $this$engine.config((Function1)new Function1<HttpClient.Builder, Unit>(this.this$0){
                                    final /* synthetic */ AisecDapsDriver this$0;
                                    {
                                        this.this$0 = $receiver;
                                        super(1);
                                    }

                                    public final void invoke(@NotNull HttpClient.Builder $this$config) {
                                        Intrinsics.checkNotNullParameter((Object)$this$config, (String)"$this$config");
                                        $this$config.sslContext(AisecDapsDriver.access$getSslContext$p(this.this$0));
                                        $this$config.connectTimeout(Duration.ofSeconds(15L));
                                    }
                                });
                            }
                        });
                        HttpClientConfig.install$default($this$HttpClient, (HttpClientPlugin)((HttpClientPlugin)HttpCache.Companion), null, (int)2, null);
                        $this$HttpClient.install((HttpClientPlugin)ContentNegotiation.Plugin, (Function1)httpClient.2.INSTANCE);
                    }
                }));
            }
        }, arg_0));
    }

    private final String extractConnectorUUID(X509Certificate certificate) {
        String akiOid = Extension.authorityKeyIdentifier.getId();
        byte[] rawAuthorityKeyIdentifier = certificate.getExtensionValue(akiOid);
        ASN1OctetString akiOc = ASN1OctetString.getInstance((Object)rawAuthorityKeyIdentifier);
        AuthorityKeyIdentifier aki = AuthorityKeyIdentifier.getInstance((Object)akiOc.getOctets());
        byte[] authorityKeyIdentifier = aki.getKeyIdentifier();
        Intrinsics.checkNotNullExpressionValue((Object)authorityKeyIdentifier, (String)"authorityKeyIdentifier");
        String string = Companion.toHexString(authorityKeyIdentifier, ":").toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
        String akiResult = string;
        String skiOid = Extension.subjectKeyIdentifier.getId();
        byte[] rawSubjectKeyIdentifier = certificate.getExtensionValue(skiOid);
        ASN1OctetString ski0c = ASN1OctetString.getInstance((Object)rawSubjectKeyIdentifier);
        SubjectKeyIdentifier ski = SubjectKeyIdentifier.getInstance((Object)ski0c.getOctets());
        byte[] subjectKeyIdentifier = ski.getKeyIdentifier();
        Intrinsics.checkNotNullExpressionValue((Object)subjectKeyIdentifier, (String)"subjectKeyIdentifier");
        String string2 = Companion.toHexString(subjectKeyIdentifier, ":").toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
        String skiResult = string2;
        if (LOG.isDebugEnabled()) {
            LOG.debug("AKI: " + akiResult);
            LOG.debug("SKI: " + skiResult);
        }
        return skiResult + ":keyid:" + akiResult;
    }

    private final DapsMeta getDapsMeta() {
        DapsMeta dapsMeta;
        if (this.dapsMetaExpire > System.currentTimeMillis() && (dapsMeta = this.dapsMeta) != null) {
            DapsMeta it = dapsMeta;
            boolean bl = false;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Reusing DAPS meta, remaining validity: {} seconds", (Object)((this.dapsMetaExpire - System.currentTimeMillis()) / (long)1000));
            }
            return it;
        }
        URI dapsUri = URI.create(this.dapsUrl);
        return (DapsMeta)BuildersKt.runBlocking((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super DapsMeta>, Object>(this, dapsUri, null){
            Object L$0;
            Object L$1;
            int label;
            final /* synthetic */ AisecDapsDriver this$0;
            final /* synthetic */ URI $dapsUri;
            {
                this.this$0 = $receiver;
                this.$dapsUri = $dapsUri;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                block13: {
                    var17_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            v0 = AisecDapsDriver.access$getHttpClient$p(this.this$0);
                            Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"httpClient");
                            $this$request_u24default$iv = v0;
                            urlString$iv = this.$dapsUri.getScheme() + "://" + this.$dapsUri.getHost() + "/.well-known/oauth-authorization-server" + this.$dapsUri.getPath();
                            $i$f$request = false;
                            $this$request$iv$iv = $this$request_u24default$iv;
                            $i$f$request = false;
                            var9_15 = $this$request$iv$iv;
                            $this$request_u24lambda_u2d0$iv = var10_16 = new HttpRequestBuilder();
                            $i$a$-request-BuildersKt$request$5$iv = false;
                            HttpRequestKt.url((HttpRequestBuilder)$this$request_u24lambda_u2d0$iv, (String)urlString$iv);
                            var13_19 = $this$request_u24lambda_u2d0$iv;
                            $i$a$-request-BuildersKt$request$4 = false;
                            builder$iv$iv$iv = var10_16;
                            $i$f$request = false;
                            this.label = 1;
                            v1 = new HttpStatement(builder$iv$iv$iv, (HttpClient)$this$request$iv$iv$iv).execute((Continuation)this);
                            if (v1 == var17_2) {
                                return var17_2;
                            }
                            ** GOTO lbl35
                        }
                        case 1: {
                            $i$f$request = false;
                            $i$f$request = false;
                            $i$f$request = false;
                            ResultKt.throwOnFailure((Object)$result);
                            v1 = $result;
lbl35:
                            // 2 sources

                            response = (HttpResponse)v1;
                            $this$request_u24default$iv = response.getStatus().getValue();
                            v2 = 200 <= $this$request_u24default$iv ? $this$request_u24default$iv < 300 : false;
                            if (!v2) break;
                            $this$request_u24default$iv = response;
                            var16_23 = DapsMeta.Companion;
                            $i$f$body = false;
                            $i$f$typeInfo = false;
                            kType$iv$iv = Reflection.typeOf(Map.class, (KTypeProjection)KTypeProjection.Companion.invariant(Reflection.typeOf(String.class)), (KTypeProjection)KTypeProjection.Companion.invariant(Reflection.typeOf(Object.class)));
                            reifiedType$iv$iv = TypesJVMKt.getJavaType((KType)kType$iv$iv);
                            this.L$0 = response;
                            this.L$1 = var16_23;
                            this.label = 2;
                            v3 = $this$body$iv.getCall().bodyNullable(TypeInfoJvmKt.typeInfoImpl((Type)reifiedType$iv$iv, (KClass)Reflection.getOrCreateKotlinClass(Map.class), (KType)kType$iv$iv), (Continuation)this);
                            if (v3 == var17_2) {
                                return var17_2;
                            }
                            ** GOTO lbl58
                        }
                        case 2: {
                            $i$f$body = false;
                            var16_23 = (DapsMeta.Companion)this.L$1;
                            response = (HttpResponse)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v3 = $result;
lbl58:
                            // 2 sources

                            if (v3 == null) {
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any>");
                            }
                            var3_5 = var16_23.fromJson((Map)v3);
                            var4_9 = this.this$0;
                            dm = var3_5;
                            $i$a$-also-AisecDapsDriver$getDapsMeta$2$1 = false;
                            $this$first$iv = HttpMessagePropertiesKt.cacheControl((HttpMessage)((HttpMessage)response));
                            $i$f$first = false;
                            for (E element$iv : $this$first$iv) {
                                it = (HeaderValue)element$iv;
                                $i$a$-first-AisecDapsDriver$getDapsMeta$2$1$maxAge$1 = false;
                                if (!StringsKt.startsWith$default((String)it.getValue(), (String)"max-age=", (boolean)false, (int)2, null)) continue;
                                ** GOTO lbl72
                            }
                            throw new NoSuchElementException("Collection contains no element matching the predicate.");
lbl72:
                            // 1 sources

                            var7_13 = new String[]{"="};
                            v4 = (String)CollectionsKt.getOrNull((List)StringsKt.split$default((CharSequence)((HeaderValue)element$iv).getValue(), (String[])var7_13, (boolean)false, (int)0, (int)6, null), (int)1);
                            v5 = maxAge = v4 != null ? Boxing.boxInt((int)Integer.parseInt(v4)) : null;
                            if (AisecDapsDriver.access$getLOG$cp().isTraceEnabled()) {
                                AisecDapsDriver.access$getLOG$cp().trace("DAPS meta: Cache-Control max-age: " + maxAge);
                            }
                            v6 = maxAge;
                            AisecDapsDriver.access$setDapsMetaExpire$p(var4_9, response.getResponseTime().getTimestamp() + (long)(v6 != null ? v6 : 0) * 1000L);
                            AisecDapsDriver.access$setDapsMeta$p(var4_9, dm);
                            v7 = var3_5;
                            break block13;
                        }
                    }
                    if (Intrinsics.areEqual((Object)response.getStatus(), (Object)HttpStatusCode.Companion.getNotFound())) {
                        AisecDapsDriver.access$getLOG$cp().warn("DAPS /.well-known/oauth-authorization-server not available, using fallback URLs. Next retry to fetch DAPS meta in 86400 seconds");
                    } else {
                        AisecDapsDriver.access$getLOG$cp().error("Request was not successful, unexpected HTTP status " + response.getStatus());
                    }
                    var3_6 = DapsMeta.Companion.fromDapsUrl(AisecDapsDriver.access$getDapsUrl$p(this.this$0));
                    var4_7 = this.this$0;
                    it = var3_6;
                    $i$a$-also-AisecDapsDriver$getDapsMeta$2$2 = false;
                    if (Intrinsics.areEqual((Object)response.getStatus(), (Object)HttpStatusCode.Companion.getNotFound())) {
                        AisecDapsDriver.access$setDapsMetaExpire$p(var4_7, System.currentTimeMillis() + 86400000L);
                        AisecDapsDriver.access$setDapsMeta$p(var4_7, it);
                    }
                    v7 = var3_6;
                }
                return v7;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super DapsMeta> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public byte[] getToken() {
        this.renewalLock.lock();
        try {
            if (NumericDate.now().isBefore(this.renewalTime)) {
                byte[] byArray;
                if (LOG.isDebugEnabled()) {
                    byArray = this.currentToken;
                    Charset charset = StandardCharsets.UTF_8;
                    Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
                    Charset charset2 = charset;
                    LOG.debug("Issue cached DAT: {}", (Object)new String(byArray, charset2));
                }
                byArray = this.currentToken;
                return byArray;
            }
            if (LOG.isInfoEnabled()) {
                LOG.info("Retrieving Dynamic Attribute Token from DAPS ...");
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("ConnectorUUID: " + this.connectorUUID);
            }
            Date expiration = Date.from(Instant.now().plusSeconds(86400L));
            Date issuedAt = Date.from(Instant.now());
            Date notBefore = Date.from(Instant.now());
            String jwt = Jwts.builder().setIssuer(this.connectorUUID).setSubject(this.connectorUUID).claim("@context", (Object)"https://w3id.org/idsa/contexts/context.jsonld").claim("@type", (Object)"ids:DatRequestToken").setExpiration(expiration).setIssuedAt(issuedAt).setNotBefore(notBefore).setAudience(TARGET_AUDIENCE).signWith(this.privateKey, SignatureAlgorithm.RS256).compact();
            DapsMeta dapsMeta = this.getDapsMeta();
            byte[] byArray = (byte[])BuildersKt.runBlocking((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super byte[]>, Object>(this, dapsMeta, expiration, issuedAt, notBefore, jwt, null){
                int label;
                final /* synthetic */ AisecDapsDriver this$0;
                final /* synthetic */ DapsMeta $dapsMeta;
                final /* synthetic */ Date $expiration;
                final /* synthetic */ Date $issuedAt;
                final /* synthetic */ Date $notBefore;
                final /* synthetic */ String $jwt;
                {
                    this.this$0 = $receiver;
                    this.$dapsMeta = $dapsMeta;
                    this.$expiration = $expiration;
                    this.$issuedAt = $issuedAt;
                    this.$notBefore = $notBefore;
                    this.$jwt = $jwt;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object var1_1) {
                    var15_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            v0 = AisecDapsDriver.access$getHttpClient$p(this.this$0);
                            Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"httpClient");
                            var4_3 = this.$jwt;
                            var5_4 = this.this$0;
                            $i$f$build = false;
                            var8_11 = var7_9 = ParametersKt.ParametersBuilder$default((int)0, (int)1, null);
                            var13_12 = this.$dapsMeta.getTokenEndpoint();
                            var12_13 = v0;
                            $i$a$-build-AisecDapsDriver$token$1$response$1 = false;
                            $this$invokeSuspend_u24lambda_u241.append("grant_type", "client_credentials");
                            $this$invokeSuspend_u24lambda_u241.append("client_assertion_type", "urn:ietf:params:oauth:client-assertion-type:jwt-bearer");
                            Intrinsics.checkNotNullExpressionValue((Object)var4_3, (String)"jwt");
                            $this$invokeSuspend_u24lambda_u241.append("client_assertion", var4_3);
                            $this$invokeSuspend_u24lambda_u241.append("scope", "idsc:IDS_CONNECTOR_ATTRIBUTES_ALL");
                            v1 = AisecDapsDriver.access$getConfig$p(var5_4).getTransportCertsSha256();
                            if (v1 != null) {
                                it = v1;
                                $i$a$-let-AisecDapsDriver$token$1$response$1$1 = false;
                                v2 = new ObjectMapper().writeValueAsString((Object)MapsKt.mapOf((Pair)TuplesKt.to((Object)"access_token", (Object)MapsKt.mapOf((Pair)TuplesKt.to((Object)"transportCertsSha256", (Object)MapsKt.mapOf((Pair)TuplesKt.to((Object)"value", it)))))));
                                Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"ObjectMapper().writeValu\u2026                        )");
                                $this$invokeSuspend_u24lambda_u241.append("claims", v2);
                            }
                            var14_17 = Unit.INSTANCE;
                            this.label = 1;
                            v3 = FormBuildersKt.submitForm$default((HttpClient)var12_13, (String)var13_12, (Parameters)var7_9.build(), (boolean)false, null, (Continuation)((Continuation)this), (int)12, null);
                            if (v3 == var15_2) {
                                return var15_2;
                            }
                            ** GOTO lbl37
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            v3 = $result;
lbl37:
                            // 2 sources

                            if (!Intrinsics.areEqual((Object)(response = (HttpResponse)v3).getStatus(), (Object)HttpStatusCode.Companion.getOK())) {
                                var3_19 = new Object[]{AisecDapsDriver.access$getConnectorUUID$p(this.this$0), AisecDapsDriver.access$getConnectorUUID$p(this.this$0), this.$expiration, this.$issuedAt, this.$notBefore, "idsc:IDS_CONNECTORS_ALL"};
                                AisecDapsDriver.access$getLOG$cp().error("Failed to request token issued with parameters: Issuer: {}, Subject: {}, Expiration: {}, IssuedAt: {}, NotBefore: {}, Audience: {}", var3_19);
                                throw new DatException("Received non-200 status: " + response.getStatus());
                            }
                            $this$body$iv = response;
                            $i$f$body = false;
                            $i$f$typeInfo = false;
                            kType$iv$iv = Reflection.typeOf(Map.class, (KTypeProjection)KTypeProjection.Companion.invariant(Reflection.typeOf(String.class)), (KTypeProjection)KTypeProjection.Companion.invariant(Reflection.typeOf(Object.class)));
                            reifiedType$iv$iv = TypesJVMKt.getJavaType((KType)kType$iv$iv);
                            this.label = 2;
                            v4 = $this$body$iv.getCall().bodyNullable(TypeInfoJvmKt.typeInfoImpl((Type)reifiedType$iv$iv, (KClass)Reflection.getOrCreateKotlinClass(Map.class), (KType)kType$iv$iv), (Continuation)this);
                            if (v4 == var15_2) {
                                return var15_2;
                            }
                            ** GOTO lbl55
                        }
                        case 2: {
                            $i$f$body = false;
                            ResultKt.throwOnFailure((Object)$result);
                            v4 = $result;
lbl55:
                            // 2 sources

                            if (v4 == null) {
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any>");
                            }
                            json = (Map)v4;
                            if (AisecDapsDriver.access$getLOG$cp().isDebugEnabled()) {
                                AisecDapsDriver.access$getLOG$cp().debug("Acquired DAT from {}", (Object)this.$dapsMeta.getTokenEndpoint());
                            }
                            if (json.containsKey("access_token")) {
                                it = var5_6 = String.valueOf(json.get("access_token"));
                                $i$a$-also-AisecDapsDriver$token$1$token$1 = false;
                                if (AisecDapsDriver.access$getLOG$cp().isDebugEnabled()) {
                                    AisecDapsDriver.access$getLOG$cp().debug("Received DAT from DAPS: {}", (Object)it);
                                }
                            } else {
                                if (json.containsKey("error")) {
                                    throw new DatException("DAPS reported error: " + json.get("error"));
                                }
                                throw new DatException("DAPS response does not contain \"access_token\" or \"error\" field.");
                            }
                            var5_6 = token = var5_6;
                            v5 = StandardCharsets.UTF_8;
                            Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"UTF_8");
                            v6 = var5_6.getBytes(v5);
                            Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"this as java.lang.String).getBytes(charset)");
                            AisecDapsDriver.access$innerVerifyToken(this.this$0, v6, null, AisecDapsDriver.access$getLocalPeerCertificate$p(this.this$0), true, this.$dapsMeta);
                            var5_6 = token;
                            v7 = StandardCharsets.UTF_8;
                            Intrinsics.checkNotNullExpressionValue((Object)v7, (String)"UTF_8");
                            v8 = var5_6.getBytes(v7);
                            Intrinsics.checkNotNullExpressionValue((Object)v8, (String)"this as java.lang.String).getBytes(charset)");
                            return v8;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super byte[]> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }));
            return byArray;
        }
        catch (Throwable e) {
            throw e instanceof DatException ? e : (Throwable)new DatException("Error whilst retrieving DAT", e);
        }
        finally {
            this.renewalLock.unlock();
        }
    }

    @Override
    public long verifyToken(@NotNull byte[] dat, @Nullable X509Certificate peerCertificate) {
        Intrinsics.checkNotNullParameter((Object)dat, (String)"dat");
        if (peerCertificate == null) {
            throw new DatException("Missing peer certificate for fingerprint validation");
        }
        return AisecDapsDriver.innerVerifyToken$default(this, dat, this.securityRequirements, peerCertificate, false, null, 16, null);
    }

    private final long innerVerifyToken(byte[] dat, SecurityRequirements securityRequirements, X509Certificate certificate, boolean setCurrentToken, DapsMeta dapsMeta) {
        HttpsJwks httpsJwks2;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Verifying dynamic attribute token...");
        }
        HttpsJwks $this$innerVerifyToken_u24lambda_u244 = httpsJwks2 = new HttpsJwks(dapsMeta.getJwksUri());
        boolean $i$a$-apply-AisecDapsDriver$innerVerifyToken$httpsJwks$22 = false;
        $this$innerVerifyToken_u24lambda_u244.setSimpleHttpGet(arg_0 -> AisecDapsDriver.innerVerifyToken$lambda$4$lambda$3(this, arg_0));
        HttpsJwks httpsJwks3 = httpsJwks2;
        HttpsJwksVerificationKeyResolver jwksKeyResolver = new HttpsJwksVerificationKeyResolver(httpsJwks3);
        String[] $i$a$-apply-AisecDapsDriver$innerVerifyToken$httpsJwks$22 = new String[]{"IDS_Connector", TARGET_AUDIENCE};
        JwtConsumerBuilder jwtConsumerBuilder = new JwtConsumerBuilder().setRequireExpirationTime().setAllowedClockSkewInSeconds(30).setRequireSubject().setExpectedAudience(true, $i$a$-apply-AisecDapsDriver$innerVerifyToken$httpsJwks$22).setExpectedIssuer(dapsMeta.getIssuer()).setVerificationKeyResolver((VerificationKeyResolver)jwksKeyResolver);
        $i$a$-apply-AisecDapsDriver$innerVerifyToken$httpsJwks$22 = new String[]{"RS256"};
        JwtConsumer jwtConsumer = jwtConsumerBuilder.setJweAlgorithmConstraints(new AlgorithmConstraints(AlgorithmConstraints.ConstraintType.PERMIT, $i$a$-apply-AisecDapsDriver$innerVerifyToken$httpsJwks$22)).build();
        long validityTime = 0L;
        JwtClaims claims = null;
        try {
            Charset charset = StandardCharsets.UTF_8;
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
            Charset charset2 = charset;
            JwtClaims jwtClaims = jwtConsumer.processToClaims(new String(dat, charset2));
            Intrinsics.checkNotNullExpressionValue((Object)jwtClaims, (String)"jwtConsumer.processToCla\u2026 StandardCharsets.UTF_8))");
            claims = jwtClaims;
            NumericDate expTime = claims.getExpirationTime();
            validityTime = expTime.getValue() - NumericDate.now().getValue();
        }
        catch (Exception e) {
            throw new DatException("Error during claims processing", e);
        }
        if (setCurrentToken) {
            this.currentToken = dat;
            NumericDate numericDate = NumericDate.now();
            Intrinsics.checkNotNullExpressionValue((Object)numericDate, (String)"now()");
            this.renewalTime = numericDate;
            this.renewalTime.addSeconds((long)((float)validityTime * this.renewalThreshold));
        }
        if (!Intrinsics.areEqual((Object)certificate, (Object)this.localPeerCertificate)) {
            List list;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Validate peer certificate fingerprint against expected fingerprint from DAT");
            }
            if (claims.isClaimValueStringList("transportCertsSha256")) {
                List list2 = claims.getStringListClaimValue("transportCertsSha256");
                list = list2;
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"{\n                    cl\u2026ha256\")\n                }");
            } else if (claims.isClaimValueString("transportCertsSha256")) {
                String fingerprint = claims.getStringClaimValue("transportCertsSha256");
                list = CollectionsKt.listOf((Object)fingerprint);
            } else {
                throw new DatException("Missing or invalid 'transportCertsSha256' format in DAT");
            }
            List datCertFingerprints = list;
            String peerCertFingerprint = null;
            try {
                byte[] byArray = MessageDigest.getInstance("SHA-256").digest(certificate.getEncoded());
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getInstance(\"SHA-256\").digest(certificate.encoded)");
                String string = de.fhg.aisec.ids.idscp2.defaultdrivers.daps.aisecdaps.AisecDapsDriver$Companion.toHexString$default(Companion, byArray, null, 1, null).toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
                peerCertFingerprint = string;
            }
            catch (Exception e) {
                throw new DatException("Cannot calculate peer certificate fingerprint", e);
            }
            if (!datCertFingerprints.contains(peerCertFingerprint)) {
                throw new DatException("Fingerprint of peer certificate (" + peerCertFingerprint + ") does not match any fingerprint from DAT (" + datCertFingerprints + ").");
            }
        }
        SecurityRequirements securityRequirements2 = securityRequirements;
        if (securityRequirements2 != null) {
            String string;
            SecurityRequirements it = securityRequirements2;
            boolean bl = false;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Validate security attributes");
            }
            if ((string = claims.getStringClaimValue("securityProfile")) == null) {
                throw new DatException("DAT does not contain securityProfile");
            }
            String securityProfile = string;
            SecurityProfile securityProfilePeer = SecurityProfile.Companion.fromString(securityProfile);
            if (securityProfilePeer.compareTo((Enum)it.getRequiredSecurityLevel()) < 0) {
                throw new DatException("Peer does not support any valid trust profile: Required: " + it.getRequiredSecurityLevel() + " given: " + securityProfilePeer);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Peer's supported security profile: {}", (Object)securityProfilePeer);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("DAT is valid for {} seconds", (Object)validityTime);
        }
        return validityTime;
    }

    static /* synthetic */ long innerVerifyToken$default(AisecDapsDriver aisecDapsDriver, byte[] byArray, SecurityRequirements securityRequirements, X509Certificate x509Certificate, boolean bl, DapsMeta dapsMeta, int n, Object object) {
        if ((n & 0x10) != 0) {
            dapsMeta = aisecDapsDriver.getDapsMeta();
        }
        return aisecDapsDriver.innerVerifyToken(byArray, securityRequirements, x509Certificate, bl, dapsMeta);
    }

    private static final HttpClient httpClient$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (HttpClient)$tmp0.invoke(p0);
    }

    private static final SimpleResponse innerVerifyToken$lambda$4$lambda$3(AisecDapsDriver this$0, String url) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return new SimpleResponse(this$0, url){
            @NotNull
            private final Triple<HttpStatusCode, Headers, String> response;
            {
                this.response = (Triple)BuildersKt.runBlocking((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Triple<? extends HttpStatusCode, ? extends Headers, ? extends String>>, Object>($receiver, $url, null){
                    Object L$0;
                    Object L$1;
                    int label;
                    final /* synthetic */ AisecDapsDriver this$0;
                    final /* synthetic */ String $url;
                    {
                        this.this$0 = $receiver;
                        this.$url = $url;
                        super(2, $completion);
                    }

                    /*
                     * Unable to fully structure code
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object var1_1) {
                        var21_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)var1_1);
                                v0 = AisecDapsDriver.access$getHttpClient$p(this.this$0);
                                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"httpClient");
                                var3_3 = v0;
                                var4_4 = this.$url;
                                Intrinsics.checkNotNullExpressionValue((Object)var4_4, (String)"url");
                                urlString$iv = var4_4;
                                $i$f$request = false;
                                $this$request$iv$iv = $this$request_u24default$iv;
                                $i$f$request = false;
                                var8_10 = $this$request$iv$iv;
                                $this$request_u24lambda_u2d0$iv = var9_11 = new HttpRequestBuilder();
                                $i$a$-request-BuildersKt$request$5$iv = false;
                                HttpRequestKt.url((HttpRequestBuilder)$this$request_u24lambda_u2d0$iv, (String)urlString$iv);
                                var12_14 = $this$request_u24lambda_u2d0$iv;
                                $i$a$-request-BuildersKt$request$4 = false;
                                builder$iv$iv$iv = var9_11;
                                $i$f$request = false;
                                this.label = 1;
                                v1 = new HttpStatement(builder$iv$iv$iv, (HttpClient)$this$request$iv$iv$iv).execute((Continuation)this);
                                if (v1 == var21_2) {
                                    return var21_2;
                                }
                                ** GOTO lbl36
                            }
                            case 1: {
                                $i$f$request = false;
                                $i$f$request = false;
                                $i$f$request = false;
                                ResultKt.throwOnFailure((Object)$result);
                                v1 = $result;
lbl36:
                                // 2 sources

                                request = (HttpResponse)v1;
                                var16_19 = request.getHeaders();
                                var15_20 = request.getStatus();
                                this.L$0 = var15_20;
                                this.L$1 = var16_19;
                                this.label = 2;
                                v2 = HttpResponseKt.bodyAsText$default((HttpResponse)request, null, (Continuation)((Continuation)this), (int)1, null);
                                if (v2 == var21_2) {
                                    return var21_2;
                                }
                                ** GOTO lbl51
                            }
                            case 2: {
                                var16_19 = (Headers)this.L$1;
                                var15_20 = (HttpStatusCode)this.L$0;
                                ResultKt.throwOnFailure((Object)$result);
                                v2 = $result;
lbl51:
                                // 2 sources

                                var18_22 = var17_21 = v2;
                                var19_23 = var16_19;
                                var20_24 = var15_20;
                                return new Triple((Object)var20_24, (Object)var19_23, (Object)var18_22);
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Triple<HttpStatusCode, ? extends Headers, String>> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }));
            }

            @NotNull
            public final Triple<HttpStatusCode, Headers, String> getResponse() {
                return this.response;
            }

            public int getStatusCode() {
                return ((HttpStatusCode)this.response.getFirst()).getValue();
            }

            @NotNull
            public String getStatusMessage() {
                return ((HttpStatusCode)this.response.getFirst()).getDescription();
            }

            @NotNull
            public Set<String> getHeaderNames() {
                return ((Headers)this.response.getSecond()).names();
            }

            @Nullable
            public List<String> getHeaderValues(@NotNull String name) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                return ((Headers)this.response.getSecond()).getAll(name);
            }

            @NotNull
            public String getBody() {
                return (String)this.response.getThird();
            }
        };
    }

    public static final /* synthetic */ HttpClient access$getHttpClient$p(AisecDapsDriver $this) {
        return $this.httpClient;
    }

    public static final /* synthetic */ Logger access$getLOG$cp() {
        return LOG;
    }

    public static final /* synthetic */ String access$getDapsUrl$p(AisecDapsDriver $this) {
        return $this.dapsUrl;
    }

    public static final /* synthetic */ void access$setDapsMetaExpire$p(AisecDapsDriver $this, long l) {
        $this.dapsMetaExpire = l;
    }

    public static final /* synthetic */ void access$setDapsMeta$p(AisecDapsDriver $this, DapsMeta dapsMeta) {
        $this.dapsMeta = dapsMeta;
    }

    public static final /* synthetic */ String access$getConnectorUUID$p(AisecDapsDriver $this) {
        return $this.connectorUUID;
    }

    public static final /* synthetic */ long access$innerVerifyToken(AisecDapsDriver $this, byte[] dat, SecurityRequirements securityRequirements, X509Certificate certificate, boolean setCurrentToken, DapsMeta dapsMeta) {
        return $this.innerVerifyToken(dat, securityRequirements, certificate, setCurrentToken, dapsMeta);
    }

    public static final /* synthetic */ X509Certificate access$getLocalPeerCertificate$p(AisecDapsDriver $this) {
        return $this.localPeerCertificate;
    }

    public static final /* synthetic */ AisecDapsDriverConfig access$getConfig$p(AisecDapsDriver $this) {
        return $this.config;
    }

    public static final /* synthetic */ HashMap access$getHexLookup$cp() {
        return hexLookup;
    }

    public static final /* synthetic */ SSLContext access$getSslContext$p(AisecDapsDriver $this) {
        return $this.sslContext;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\r\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0014\u0010\u0016\u001a\u00020\u000e*\u00020\u00172\b\b\u0002\u0010\u0018\u001a\u00020\u0019RN\u0010\u0003\u001aB\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00070\u0007 \u0006* \u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00070\u0007\u0018\u00010\b0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \u0006*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082T\u00a2\u0006\u0002\n\u0000R*\u0010\u000f\u001a\u001e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u000e0\u0010j\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u000e`\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lde/fhg/aisec/ids/idscp2/defaultdrivers/daps/aisecdaps/AisecDapsDriver$Companion;", "", "()V", "HTTP_CLIENTS", "", "Ljavax/net/ssl/TrustManager;", "kotlin.jvm.PlatformType", "Lio/ktor/client/HttpClient;", "", "LOG", "Lorg/slf4j/Logger;", "META_FALLBACK_LIFETIME_MS", "", "TARGET_AUDIENCE", "", "hexLookup", "Ljava/util/HashMap;", "", "Lkotlin/collections/HashMap;", "byteToHex", "num", "", "toHexString", "", "delimiter", "", "idscp2"})
    public static final class Companion {
        private Companion() {
        }

        private final String byteToHex(int num) {
            char[] hexDigits = new char[]{Character.forDigit(num >> 4 & 0xF, 16), Character.forDigit(num & 0xF, 16)};
            return new String(hexDigits);
        }

        @NotNull
        public final String toHexString(@NotNull byte[] $this$toHexString, @NotNull CharSequence delimiter) {
            Intrinsics.checkNotNullParameter((Object)$this$toHexString, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)delimiter, (String)"delimiter");
            return ArraysKt.joinToString$default((byte[])$this$toHexString, (CharSequence)delimiter, null, null, (int)0, null, (Function1)toHexString.1.INSTANCE, (int)30, null);
        }

        public static /* synthetic */ String toHexString$default(Companion companion, byte[] byArray, CharSequence charSequence, int n, Object object) {
            if ((n & 1) != 0) {
                charSequence = "";
            }
            return companion.toHexString(byArray, charSequence);
        }

        public static final /* synthetic */ String access$byteToHex(Companion $this, int num) {
            return $this.byteToHex(num);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

