/*
 * Decompiled with CFR 0.152.
 */
package de.fhg.aisec.ids.idscp2.core.fsm;

import de.fhg.aisec.ids.idscp2.core.drivers.RaProverDriver;
import de.fhg.aisec.ids.idscp2.core.drivers.RaVerifierDriver;
import de.fhg.aisec.ids.idscp2.core.fsm.Event;
import de.fhg.aisec.ids.idscp2.core.fsm.FSM;
import de.fhg.aisec.ids.idscp2.core.fsm.InternalControlMessage;
import de.fhg.aisec.ids.idscp2.core.fsm.State;
import de.fhg.aisec.ids.idscp2.core.fsm.StaticTimer;
import de.fhg.aisec.ids.idscp2.core.fsm.Transition;
import de.fhg.aisec.ids.idscp2.core.messages.Idscp2MessageHelper;
import de.fhg.aisec.ids.idscp2.messages.IDSCP2;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 \f2\u00020\u0001:\u0001\fB-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u0003H\u0016\u00a8\u0006\r"}, d2={"Lde/fhg/aisec/ids/idscp2/core/fsm/StateWaitForRa;", "Lde/fhg/aisec/ids/idscp2/core/fsm/State;", "fsm", "Lde/fhg/aisec/ids/idscp2/core/fsm/FSM;", "handshakeTimer", "Lde/fhg/aisec/ids/idscp2/core/fsm/StaticTimer;", "verifierHandshakeTimer", "proverHandshakeTimer", "raTimer", "(Lde/fhg/aisec/ids/idscp2/core/fsm/FSM;Lde/fhg/aisec/ids/idscp2/core/fsm/StaticTimer;Lde/fhg/aisec/ids/idscp2/core/fsm/StaticTimer;Lde/fhg/aisec/ids/idscp2/core/fsm/StaticTimer;Lde/fhg/aisec/ids/idscp2/core/fsm/StaticTimer;)V", "runEntryCode", "", "Companion", "idscp2"})
public final class StateWaitForRa
extends State {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final Logger LOG = LoggerFactory.getLogger(StateWaitForRa.class);

    public StateWaitForRa(final @NotNull FSM fsm2, final @NotNull StaticTimer handshakeTimer, final @NotNull StaticTimer verifierHandshakeTimer, final @NotNull StaticTimer proverHandshakeTimer, final @NotNull StaticTimer raTimer) {
        Intrinsics.checkNotNullParameter((Object)fsm2, (String)"fsm");
        Intrinsics.checkNotNullParameter((Object)handshakeTimer, (String)"handshakeTimer");
        Intrinsics.checkNotNullParameter((Object)verifierHandshakeTimer, (String)"verifierHandshakeTimer");
        Intrinsics.checkNotNullParameter((Object)proverHandshakeTimer, (String)"proverHandshakeTimer");
        Intrinsics.checkNotNullParameter((Object)raTimer, (String)"raTimer");
        this.addTransition(InternalControlMessage.ERROR.getValue(), new Transition((Function1<? super Event, FSM.FsmResult>)((Function1)new Function1<Event, FSM.FsmResult>(){

            @NotNull
            public final FSM.FsmResult invoke(@NotNull Event it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                LOG.warn("An internal control error occurred");
                return new FSM.FsmResult(FSM.FsmResultCode.OK, fsm2.getState(FSM.FsmState.STATE_CLOSED));
            }
        })));
        this.addTransition(InternalControlMessage.IDSCP_STOP.getValue(), new Transition((Function1<? super Event, FSM.FsmResult>)((Function1)new Function1<Event, FSM.FsmResult>(){

            @NotNull
            public final FSM.FsmResult invoke(@NotNull Event it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Send IDSCP_CLOSE");
                }
                fsm2.sendFromFSM(Idscp2MessageHelper.INSTANCE.createIdscpCloseMessage("User close", IDSCP2.IdscpClose.CloseCause.USER_SHUTDOWN));
                return new FSM.FsmResult(FSM.FsmResultCode.OK, fsm2.getState(FSM.FsmState.STATE_CLOSED));
            }
        })));
        this.addTransition(InternalControlMessage.SEND_DATA.getValue(), new Transition((Function1<? super Event, FSM.FsmResult>)((Function1)new Function1<Event, FSM.FsmResult>(){

            @NotNull
            public final FSM.FsmResult invoke(@NotNull Event it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return new FSM.FsmResult(FSM.FsmResultCode.NOT_CONNECTED, this);
            }
        })));
        this.addTransition(InternalControlMessage.REPEAT_RA.getValue(), new Transition((Function1<? super Event, FSM.FsmResult>)((Function1)new Function1<Event, FSM.FsmResult>(){

            @NotNull
            public final FSM.FsmResult invoke(@NotNull Event it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return new FSM.FsmResult(FSM.FsmResultCode.OK, this);
            }
        })));
        this.addTransition(InternalControlMessage.RA_PROVER_OK.getValue(), new Transition((Function1<? super Event, FSM.FsmResult>)((Function1)new Function1<Event, FSM.FsmResult>(){

            @NotNull
            public final FSM.FsmResult invoke(@NotNull Event it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Received RA_PROVER OK");
                }
                proverHandshakeTimer.cancelTimeout();
                return new FSM.FsmResult(FSM.FsmResultCode.OK, fsm2.getState(FSM.FsmState.STATE_WAIT_FOR_RA_VERIFIER));
            }
        })));
        this.addTransition(InternalControlMessage.RA_VERIFIER_OK.getValue(), new Transition((Function1<? super Event, FSM.FsmResult>)((Function1)new Function1<Event, FSM.FsmResult>(){

            @NotNull
            public final FSM.FsmResult invoke(@NotNull Event it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Received RA_VERIFIER OK");
                }
                verifierHandshakeTimer.cancelTimeout();
                raTimer.resetTimeout();
                return new FSM.FsmResult(FSM.FsmResultCode.OK, fsm2.getState(FSM.FsmState.STATE_WAIT_FOR_RA_PROVER));
            }
        })));
        this.addTransition(InternalControlMessage.RA_PROVER_FAILED.getValue(), new Transition((Function1<? super Event, FSM.FsmResult>)((Function1)new Function1<Event, FSM.FsmResult>(){

            @NotNull
            public final FSM.FsmResult invoke(@NotNull Event it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                LOG.warn("RA_PROVER failed. Send IDSCP_CLOSE");
                fsm2.sendFromFSM(Idscp2MessageHelper.INSTANCE.createIdscpCloseMessage("RA_PROVER failed", IDSCP2.IdscpClose.CloseCause.RA_PROVER_FAILED));
                return new FSM.FsmResult(FSM.FsmResultCode.OK, fsm2.getState(FSM.FsmState.STATE_CLOSED));
            }
        })));
        this.addTransition(InternalControlMessage.RA_VERIFIER_FAILED.getValue(), new Transition((Function1<? super Event, FSM.FsmResult>)((Function1)new Function1<Event, FSM.FsmResult>(){

            @NotNull
            public final FSM.FsmResult invoke(@NotNull Event it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                LOG.warn("RA_VERIFIER failed. Send IDSCP_CLOSE");
                fsm2.sendFromFSM(Idscp2MessageHelper.INSTANCE.createIdscpCloseMessage("RA_VERIFIER failed", IDSCP2.IdscpClose.CloseCause.RA_VERIFIER_FAILED));
                return new FSM.FsmResult(FSM.FsmResultCode.OK, fsm2.getState(FSM.FsmState.STATE_CLOSED));
            }
        })));
        this.addTransition(InternalControlMessage.RA_PROVER_MSG.getValue(), new Transition((Function1<? super Event, FSM.FsmResult>)((Function1)new Function1<Event, FSM.FsmResult>(){

            @NotNull
            public final FSM.FsmResult invoke(@NotNull Event event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Send IDSCP_RA_PROVER");
                }
                if (!fsm2.sendFromFSM(event.getIdscpMessage())) {
                    LOG.warn("Cannot send RA prover message");
                    return new FSM.FsmResult(FSM.FsmResultCode.IO_ERROR, fsm2.getState(FSM.FsmState.STATE_CLOSED));
                }
                return new FSM.FsmResult(FSM.FsmResultCode.OK, this);
            }
        })));
        this.addTransition(InternalControlMessage.RA_VERIFIER_MSG.getValue(), new Transition((Function1<? super Event, FSM.FsmResult>)((Function1)new Function1<Event, FSM.FsmResult>(){

            @NotNull
            public final FSM.FsmResult invoke(@NotNull Event event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Send IDSCP_RA_VERIFIER");
                }
                if (!fsm2.sendFromFSM(event.getIdscpMessage())) {
                    LOG.warn("Cannot send RA verifier message");
                    return new FSM.FsmResult(FSM.FsmResultCode.IO_ERROR, fsm2.getState(FSM.FsmState.STATE_CLOSED));
                }
                return new FSM.FsmResult(FSM.FsmResultCode.OK, this);
            }
        })));
        this.addTransition(InternalControlMessage.DAT_TIMER_EXPIRED.getValue(), new Transition((Function1<? super Event, FSM.FsmResult>)((Function1)new Function1<Event, FSM.FsmResult>(){

            @NotNull
            public final FSM.FsmResult invoke(@NotNull Event it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (LOG.isDebugEnabled()) {
                    LOG.debug("DAT expired, request new DAT from peer and trigger a re-attestation");
                }
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Send IDSCP_DAT_EXPIRED and cancel RA_VERIFIER");
                }
                fsm2.stopRaVerifierDriver();
                if (!fsm2.sendFromFSM(Idscp2MessageHelper.INSTANCE.createIdscpDatExpiredMessage())) {
                    LOG.warn("Cannot send DatExpired message");
                    return new FSM.FsmResult(FSM.FsmResultCode.IO_ERROR, fsm2.getState(FSM.FsmState.STATE_CLOSED));
                }
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Start Handshake Timer");
                }
                handshakeTimer.resetTimeout();
                return new FSM.FsmResult(FSM.FsmResultCode.OK, fsm2.getState(FSM.FsmState.STATE_WAIT_FOR_DAT_AND_RA));
            }
        })));
        this.addTransition(InternalControlMessage.TIMEOUT.getValue(), new Transition((Function1<? super Event, FSM.FsmResult>)((Function1)new Function1<Event, FSM.FsmResult>(){

            @NotNull
            public final FSM.FsmResult invoke(@NotNull Event it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                LOG.warn("Handshake timeout occurred. Send IDSCP_CLOSE");
                fsm2.sendFromFSM(Idscp2MessageHelper.INSTANCE.createIdscpCloseMessage("Handshake timeout", IDSCP2.IdscpClose.CloseCause.TIMEOUT));
                return new FSM.FsmResult(FSM.FsmResultCode.OK, fsm2.getState(FSM.FsmState.STATE_CLOSED));
            }
        })));
        this.addTransition(9, new Transition((Function1<? super Event, FSM.FsmResult>)((Function1)new Function1<Event, FSM.FsmResult>(){

            @NotNull
            public final FSM.FsmResult invoke(@NotNull Event it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                IDSCP2.IdscpAck idscpAck = it.getIdscpMessage().getIdscpAck();
                Intrinsics.checkNotNullExpressionValue((Object)idscpAck, (String)"it.idscpMessage.idscpAck");
                fsm2.recvAck(idscpAck);
                return new FSM.FsmResult(FSM.FsmResultCode.OK, this);
            }
        })));
        this.addTransition(7, new Transition((Function1<? super Event, FSM.FsmResult>)((Function1)new Function1<Event, FSM.FsmResult>(){

            @NotNull
            public final FSM.FsmResult invoke(@NotNull Event event) {
                CompletableFuture<Void> completableFuture;
                CompletableFuture<Void> completableFuture2;
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Delegate received IDSCP_RA_VERIFIER to RA_PROVER");
                }
                if (!event.getIdscpMessage().hasIdscpRaVerifier()) {
                    LOG.warn("IDSCP_RA_Verifier message not available");
                    return new FSM.FsmResult(FSM.FsmResultCode.RA_ERROR, fsm2.getState(FSM.FsmState.STATE_CLOSED));
                }
                RaProverDriver<?> raProverDriver = fsm2.getRaProverDriver();
                if (raProverDriver != null) {
                    RaProverDriver<?> it = raProverDriver;
                    boolean bl = false;
                    completableFuture2 = CompletableFuture.runAsync(() -> 14.invoke$lambda$1$lambda$0(it, event));
                } else {
                    completableFuture2 = completableFuture = null;
                }
                if (completableFuture == null) {
                    StateWaitForRa stateWaitForRa = this;
                    FSM fSM = fsm2;
                    StateWaitForRa $this$invoke_u24lambda_u242 = stateWaitForRa;
                    boolean bl = false;
                    LOG.warn("RaProverDriver not available");
                    return new FSM.FsmResult(FSM.FsmResultCode.RA_ERROR, fSM.getState(FSM.FsmState.STATE_CLOSED));
                }
                return new FSM.FsmResult(FSM.FsmResultCode.OK, this);
            }

            private static final void invoke$lambda$1$lambda$0(RaProverDriver $it, Event $event) {
                Intrinsics.checkNotNullParameter((Object)$it, (String)"$it");
                Intrinsics.checkNotNullParameter((Object)$event, (String)"$event");
                byte[] byArray = $event.getIdscpMessage().getIdscpRaVerifier().getData().toByteArray();
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"event.idscpMessage.idscp\u2026rifier.data.toByteArray()");
                $it.delegate(byArray);
            }
        })));
        this.addTransition(6, new Transition((Function1<? super Event, FSM.FsmResult>)((Function1)new Function1<Event, FSM.FsmResult>(){

            @NotNull
            public final FSM.FsmResult invoke(@NotNull Event event) {
                CompletableFuture<Void> completableFuture;
                CompletableFuture<Void> completableFuture2;
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Delegate received IDSCP_RA_PROVER to RA_VERIFIER");
                }
                if (!event.getIdscpMessage().hasIdscpRaProver()) {
                    LOG.warn("IDSCP_RA_PROVER message not available");
                    return new FSM.FsmResult(FSM.FsmResultCode.RA_ERROR, fsm2.getState(FSM.FsmState.STATE_CLOSED));
                }
                RaVerifierDriver<?> raVerifierDriver = fsm2.getRaVerifierDriver();
                if (raVerifierDriver != null) {
                    RaVerifierDriver<?> it = raVerifierDriver;
                    boolean bl = false;
                    completableFuture2 = CompletableFuture.runAsync(() -> 15.invoke$lambda$1$lambda$0(it, event));
                } else {
                    completableFuture2 = completableFuture = null;
                }
                if (completableFuture == null) {
                    StateWaitForRa stateWaitForRa = this;
                    FSM fSM = fsm2;
                    StateWaitForRa $this$invoke_u24lambda_u242 = stateWaitForRa;
                    boolean bl = false;
                    LOG.warn("RaVerifierDriver not available");
                    return new FSM.FsmResult(FSM.FsmResultCode.RA_ERROR, fSM.getState(FSM.FsmState.STATE_CLOSED));
                }
                return new FSM.FsmResult(FSM.FsmResultCode.OK, this);
            }

            private static final void invoke$lambda$1$lambda$0(RaVerifierDriver $it, Event $event) {
                Intrinsics.checkNotNullParameter((Object)$it, (String)"$it");
                Intrinsics.checkNotNullParameter((Object)$event, (String)"$event");
                byte[] byArray = $event.getIdscpMessage().getIdscpRaProver().getData().toByteArray();
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"event.idscpMessage.idscp\u2026Prover.data.toByteArray()");
                $it.delegate(byArray);
            }
        })));
        this.addTransition(3, new Transition((Function1<? super Event, FSM.FsmResult>)((Function1)new Function1<Event, FSM.FsmResult>(){

            @NotNull
            public final FSM.FsmResult invoke(@NotNull Event it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Peer is requesting a new DAT, followed by a re-attestation");
                }
                if (!fsm2.sendFromFSM(Idscp2MessageHelper.INSTANCE.createIdscpDatMessage(fsm2.getDynamicAttributeToken()))) {
                    LOG.warn("Cannot send DAT message");
                    return new FSM.FsmResult(FSM.FsmResultCode.IO_ERROR, fsm2.getState(FSM.FsmState.STATE_CLOSED));
                }
                if (!fsm2.restartRaProverDriver()) {
                    LOG.warn("Cannot run RA prover, close idscp connection");
                    return new FSM.FsmResult(FSM.FsmResultCode.RA_ERROR, fsm2.getState(FSM.FsmState.STATE_CLOSED));
                }
                return new FSM.FsmResult(FSM.FsmResultCode.OK, this);
            }
        })));
        this.addTransition(2, new Transition((Function1<? super Event, FSM.FsmResult>)((Function1)new Function1<Event, FSM.FsmResult>(){

            @NotNull
            public final FSM.FsmResult invoke(@NotNull Event it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Received IDSCP_CLOSE");
                }
                return new FSM.FsmResult(FSM.FsmResultCode.OK, fsm2.getState(FSM.FsmState.STATE_CLOSED));
            }
        })));
        this.setNoTransitionHandler(arg_0 -> StateWaitForRa._init_$lambda$0(this, arg_0));
    }

    @Override
    public void runEntryCode(@NotNull FSM fsm2) {
        Intrinsics.checkNotNullParameter((Object)fsm2, (String)"fsm");
        if (LOG.isTraceEnabled()) {
            LOG.trace("Switched to state STATE_WAIT_FOR_RA");
        }
    }

    private static final FSM.FsmResult _init_$lambda$0(StateWaitForRa this$0, Event event) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        if (LOG.isTraceEnabled()) {
            LOG.trace("No transition available for given event " + event);
            LOG.trace("Stay in state STATE_WAIT_FOR_RA");
        }
        return new FSM.FsmResult(FSM.FsmResultCode.UNKNOWN_TRANSITION, this$0);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lde/fhg/aisec/ids/idscp2/core/fsm/StateWaitForRa$Companion;", "", "()V", "LOG", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "idscp2"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

