/*
 * Decompiled with CFR 0.152.
 */
package de.fhg.aisec.ids.idscp2.core.api.server;

import de.fhg.aisec.ids.idscp2.core.api.Idscp2EndpointListener;
import de.fhg.aisec.ids.idscp2.core.api.connection.Idscp2Connection;
import de.fhg.aisec.ids.idscp2.core.api.connection.Idscp2ConnectionAdapter;
import de.fhg.aisec.ids.idscp2.core.api.server.ServerConnectionListener;
import de.fhg.aisec.ids.idscp2.core.drivers.SecureServer;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u0000 \u0018*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u0001\u0018B\u001b\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u00a2\u0006\u0002\u0010\bJ\u0015\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0016J\u0006\u0010\u0017\u001a\u00020\u0014R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR2\u0010\r\u001a&\u0012\f\u0012\n \u000f*\u0004\u0018\u00018\u00008\u0000 \u000f*\u0012\u0012\f\u0012\n \u000f*\u0004\u0018\u00018\u00008\u0000\u0018\u00010\n0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0010\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0012R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lde/fhg/aisec/ids/idscp2/core/api/server/Idscp2Server;", "CC", "Lde/fhg/aisec/ids/idscp2/core/api/connection/Idscp2Connection;", "Lde/fhg/aisec/ids/idscp2/core/api/server/ServerConnectionListener;", "secureServer", "Lde/fhg/aisec/ids/idscp2/core/drivers/SecureServer;", "endpointListener", "Lde/fhg/aisec/ids/idscp2/core/api/Idscp2EndpointListener;", "(Lde/fhg/aisec/ids/idscp2/core/drivers/SecureServer;Lde/fhg/aisec/ids/idscp2/core/api/Idscp2EndpointListener;)V", "allConnections", "", "getAllConnections", "()Ljava/util/Set;", "connections", "", "kotlin.jvm.PlatformType", "isRunning", "", "()Z", "onConnectionCreated", "", "connection", "(Lde/fhg/aisec/ids/idscp2/core/api/connection/Idscp2Connection;)V", "terminate", "Companion", "idscp2"})
public final class Idscp2Server<CC extends Idscp2Connection>
implements ServerConnectionListener<CC> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SecureServer secureServer;
    @NotNull
    private final Idscp2EndpointListener<CC> endpointListener;
    private final Set<CC> connections;
    private static final Logger LOG = LoggerFactory.getLogger(Idscp2Server.class);

    public Idscp2Server(@NotNull SecureServer secureServer, @NotNull Idscp2EndpointListener<CC> endpointListener) {
        Intrinsics.checkNotNullParameter((Object)secureServer, (String)"secureServer");
        Intrinsics.checkNotNullParameter(endpointListener, (String)"endpointListener");
        this.secureServer = secureServer;
        this.endpointListener = endpointListener;
        this.connections = Collections.synchronizedSet(new HashSet());
    }

    public final void terminate() {
        if (LOG.isInfoEnabled()) {
            LOG.info("Terminating IDSCP2 server {}", (Object)this.toString());
        }
        for (Idscp2Connection connection : this.connections) {
            connection.close();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Idscp connection with id {} has been closed", (Object)connection.getId());
            }
            this.connections.remove(connection);
        }
        this.secureServer.safeStop();
    }

    @Override
    public void onConnectionCreated(@NotNull CC connection) {
        Intrinsics.checkNotNullParameter(connection, (String)"connection");
        if (LOG.isTraceEnabled()) {
            LOG.trace("Bind connection with id {} to Idscp2Server {}", (Object)connection.getId(), (Object)this.toString());
        }
        connection.addConnectionListener(new Idscp2ConnectionAdapter(this, connection){
            final /* synthetic */ Idscp2Server<CC> this$0;
            final /* synthetic */ CC $connection;
            {
                this.this$0 = $receiver;
                this.$connection = $connection;
            }

            public void onClose() {
                Idscp2Server.access$getConnections$p(this.this$0).remove(this.$connection);
            }
        });
        this.connections.add(connection);
        this.endpointListener.onConnection(connection);
        connection.unlockMessaging();
    }

    public final boolean isRunning() {
        return this.secureServer.isRunning();
    }

    @NotNull
    public final Set<CC> getAllConnections() {
        Set<CC> set = Collections.unmodifiableSet(this.connections);
        Intrinsics.checkNotNullExpressionValue(set, (String)"unmodifiableSet(connections)");
        return set;
    }

    public static final /* synthetic */ Set access$getConnections$p(Idscp2Server $this) {
        return $this.connections;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lde/fhg/aisec/ids/idscp2/core/api/server/Idscp2Server$Companion;", "", "()V", "LOG", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "idscp2"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

