/*
 * Decompiled with CFR 0.152.
 */
package de.fhg.aisec.ids.idscp2.defaultdrivers.securechannel.tls13.server;

import de.fhg.aisec.ids.idscp2.core.api.configuration.Idscp2Configuration;
import de.fhg.aisec.ids.idscp2.core.api.connection.Idscp2Connection;
import de.fhg.aisec.ids.idscp2.core.api.server.ServerConnectionListener;
import de.fhg.aisec.ids.idscp2.core.drivers.SecureServer;
import de.fhg.aisec.ids.idscp2.core.fsm.FSM;
import de.fhg.aisec.ids.idscp2.defaultdrivers.keystores.PreConfiguration;
import de.fhg.aisec.ids.idscp2.defaultdrivers.securechannel.tls13.NativeTlsConfiguration;
import de.fhg.aisec.ids.idscp2.defaultdrivers.securechannel.tls13.TLSConstants;
import de.fhg.aisec.ids.idscp2.defaultdrivers.securechannel.tls13.server.TLSServerThread;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.concurrent.CompletableFuture;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManager;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 \u001c*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u00032\u00020\u0004:\u0001\u001cBC\u0012\u0012\u0010\u0005\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00070\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0018\u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00028\u00000\r\u00a2\u0006\u0002\u0010\u0010J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u001aH\u0016R \u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00028\u00000\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u0012@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lde/fhg/aisec/ids/idscp2/defaultdrivers/securechannel/tls13/server/TLSServer;", "CC", "Lde/fhg/aisec/ids/idscp2/core/api/connection/Idscp2Connection;", "Ljava/lang/Runnable;", "Lde/fhg/aisec/ids/idscp2/core/drivers/SecureServer;", "connectionListenerPromise", "Ljava/util/concurrent/CompletableFuture;", "Lde/fhg/aisec/ids/idscp2/core/api/server/ServerConnectionListener;", "nativeTlsConfiguration", "Lde/fhg/aisec/ids/idscp2/defaultdrivers/securechannel/tls13/NativeTlsConfiguration;", "serverConfiguration", "Lde/fhg/aisec/ids/idscp2/core/api/configuration/Idscp2Configuration;", "connectionFactory", "Lkotlin/Function2;", "Lde/fhg/aisec/ids/idscp2/core/fsm/FSM;", "", "(Ljava/util/concurrent/CompletableFuture;Lde/fhg/aisec/ids/idscp2/defaultdrivers/securechannel/tls13/NativeTlsConfiguration;Lde/fhg/aisec/ids/idscp2/core/api/configuration/Idscp2Configuration;Lkotlin/jvm/functions/Function2;)V", "<set-?>", "", "isRunning", "()Z", "serverSocket", "Ljava/net/ServerSocket;", "serverThread", "Ljava/lang/Thread;", "run", "", "safeStop", "Companion", "idscp2"})
public final class TLSServer<CC extends Idscp2Connection>
implements Runnable,
SecureServer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CompletableFuture<ServerConnectionListener<CC>> connectionListenerPromise;
    @NotNull
    private final NativeTlsConfiguration nativeTlsConfiguration;
    @NotNull
    private final Idscp2Configuration serverConfiguration;
    @NotNull
    private final Function2<FSM, String, CC> connectionFactory;
    private volatile boolean isRunning;
    @NotNull
    private final ServerSocket serverSocket;
    @NotNull
    private final Thread serverThread;
    private static final Logger LOG = LoggerFactory.getLogger(TLSServer.class);

    public TLSServer(@NotNull CompletableFuture<ServerConnectionListener<CC>> connectionListenerPromise, @NotNull NativeTlsConfiguration nativeTlsConfiguration, @NotNull Idscp2Configuration serverConfiguration, @NotNull Function2<? super FSM, ? super String, ? extends CC> connectionFactory) {
        Intrinsics.checkNotNullParameter(connectionListenerPromise, (String)"connectionListenerPromise");
        Intrinsics.checkNotNullParameter((Object)nativeTlsConfiguration, (String)"nativeTlsConfiguration");
        Intrinsics.checkNotNullParameter((Object)serverConfiguration, (String)"serverConfiguration");
        Intrinsics.checkNotNullParameter(connectionFactory, (String)"connectionFactory");
        this.connectionListenerPromise = connectionListenerPromise;
        this.nativeTlsConfiguration = nativeTlsConfiguration;
        this.serverConfiguration = serverConfiguration;
        this.connectionFactory = connectionFactory;
        if (LOG.isTraceEnabled()) {
            LOG.trace("Creating trust manager for TLS server...");
        }
        TrustManager myTrustManager = this.nativeTlsConfiguration.getTrustManager();
        if (LOG.isTraceEnabled()) {
            LOG.trace("Creating key manager for TLS server...");
        }
        KeyManager[] myKeyManager = PreConfiguration.INSTANCE.getX509ExtKeyManager(this.nativeTlsConfiguration.getKeyPassword(), this.nativeTlsConfiguration.getKeyStorePath(), this.nativeTlsConfiguration.getKeyStorePassword(), this.nativeTlsConfiguration.getCertificateAlias(), this.nativeTlsConfiguration.getKeyStoreKeyType());
        if (LOG.isTraceEnabled()) {
            LOG.trace("Setting TLS security attributes and creating TLS server socket...");
        }
        SSLContext sslContext = SSLContext.getInstance("TLSv1.3");
        TrustManager[] trustManagerArray = new TrustManager[]{myTrustManager};
        sslContext.init(myKeyManager, trustManagerArray, null);
        SSLServerSocketFactory socketFactory = sslContext.getServerSocketFactory();
        ServerSocket serverSocket = socketFactory.createServerSocket(this.nativeTlsConfiguration.getServerPort());
        Intrinsics.checkNotNullExpressionValue((Object)serverSocket, (String)"socketFactory.createServ\u2026Configuration.serverPort)");
        this.serverSocket = serverSocket;
        this.serverSocket.setSoTimeout(this.nativeTlsConfiguration.getSocketTimeout());
        ServerSocket serverSocket2 = this.serverSocket;
        Intrinsics.checkNotNull((Object)serverSocket2, (String)"null cannot be cast to non-null type javax.net.ssl.SSLServerSocket");
        SSLServerSocket sslServerSocket = (SSLServerSocket)serverSocket2;
        SSLParameters sslParameters = sslServerSocket.getSSLParameters();
        sslParameters.setUseCipherSuitesOrder(true);
        sslParameters.setNeedClientAuth(true);
        sslParameters.setProtocols(TLSConstants.INSTANCE.getTLS_ENABLED_PROTOCOLS());
        sslParameters.setCipherSuites(TLSConstants.INSTANCE.getTLS_ENABLED_CIPHERS());
        sslServerSocket.setSSLParameters(sslParameters);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Starting TLS server...");
        }
        this.serverThread = new Thread((Runnable)this, "TLS Server Thread " + this.nativeTlsConfiguration.getHost() + ":" + this.nativeTlsConfiguration.getServerPort());
        this.serverThread.start();
    }

    @Override
    public boolean isRunning() {
        return this.isRunning;
    }

    @Override
    public void run() {
        if (this.serverSocket.isClosed()) {
            LOG.warn("ServerSocket has been closed, server thread is stopping now.");
            return;
        }
        this.isRunning = true;
        if (LOG.isTraceEnabled()) {
            LOG.trace("TLS server started, entering accept() loop...");
        }
        while (this.isRunning()) {
            try {
                Socket socket = this.serverSocket.accept();
                Intrinsics.checkNotNull((Object)socket, (String)"null cannot be cast to non-null type javax.net.ssl.SSLSocket");
                SSLSocket sslSocket = (SSLSocket)socket;
                try {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("New TLS client has connected. Creating new server thread...");
                    }
                    CompletableFuture connectionFuture = new CompletableFuture();
                    ((CompletableFuture)connectionFuture.thenAccept(arg_0 -> TLSServer.run$lambda-1(this, arg_0))).exceptionally(TLSServer::run$lambda-2);
                    TLSServerThread serverThread = new TLSServerThread(sslSocket, connectionFuture, this.nativeTlsConfiguration, this.serverConfiguration, this.connectionFactory);
                    sslSocket.addHandshakeCompletedListener(serverThread);
                    serverThread.start();
                }
                catch (Exception serverThreadException) {
                    LOG.warn("Error while creating/starting TLSServerThread", (Throwable)serverThreadException);
                }
            }
            catch (SocketTimeoutException sslSocket) {
            }
            catch (SocketException e) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Server socket has been closed.");
                }
                this.isRunning = false;
            }
            catch (IOException e) {
                LOG.warn("Error during TLS server socket accept, notifying error handlers...");
                this.isRunning = false;
            }
        }
        if (!this.serverSocket.isClosed()) {
            try {
                this.serverSocket.close();
            }
            catch (IOException e) {
                LOG.warn("Cannot close TLS server socket", (Throwable)e);
            }
        }
    }

    @Override
    public void safeStop() {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Stopping tls server");
        }
        this.isRunning = false;
        try {
            this.serverThread.join();
        }
        catch (InterruptedException e) {
            LOG.warn("InterruptedException whilst waiting for server stop", (Throwable)e);
            Thread.currentThread().interrupt();
        }
    }

    private static final void run$lambda-1$lambda-0(Idscp2Connection $connection, ServerConnectionListener listener) {
        Intrinsics.checkNotNullExpressionValue((Object)$connection, (String)"connection");
        listener.onConnectionCreated($connection);
    }

    private static final void run$lambda-1(TLSServer this$0, Idscp2Connection connection) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.connectionListenerPromise.thenAccept(arg_0 -> TLSServer.run$lambda-1$lambda-0(connection, arg_0));
    }

    private static final Void run$lambda-2(Throwable it) {
        LOG.warn("Idscp2Connection creation failed", it);
        return null;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lde/fhg/aisec/ids/idscp2/defaultdrivers/securechannel/tls13/server/TLSServer$Companion;", "", "()V", "LOG", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "idscp2"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

