/*
 * Decompiled with CFR 0.152.
 */
package de.fhg.aisec.ids.idscp2.defaultdrivers.securechannel.tls13.client;

import de.fhg.aisec.ids.idscp2.core.api.configuration.Idscp2Configuration;
import de.fhg.aisec.ids.idscp2.core.api.connection.Idscp2Connection;
import de.fhg.aisec.ids.idscp2.core.drivers.SecureChannelEndpoint;
import de.fhg.aisec.ids.idscp2.core.error.Idscp2Exception;
import de.fhg.aisec.ids.idscp2.core.fsm.AsyncIdscp2Factory;
import de.fhg.aisec.ids.idscp2.core.fsm.FSM;
import de.fhg.aisec.ids.idscp2.core.securechannel.SecureChannel;
import de.fhg.aisec.ids.idscp2.core.securechannel.SecureChannelListener;
import de.fhg.aisec.ids.idscp2.defaultdrivers.keystores.PreConfiguration;
import de.fhg.aisec.ids.idscp2.defaultdrivers.securechannel.tls13.NativeTlsConfiguration;
import de.fhg.aisec.ids.idscp2.defaultdrivers.securechannel.tls13.TLSConstants;
import de.fhg.aisec.ids.idscp2.defaultdrivers.securechannel.tls13.TLSSessionVerificationHelper;
import de.fhg.aisec.ids.idscp2.defaultdrivers.securechannel.tls13.client.DataAvailableListener;
import de.fhg.aisec.ids.idscp2.defaultdrivers.securechannel.tls13.client.InputListenerThread;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.concurrent.CompletableFuture;
import javax.net.ssl.HandshakeCompletedEvent;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLProtocolException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\u0018\u0000 /*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u00032\u00020\u00042\u00020\u0005:\u0001/B=\u0012\u0018\u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00028\u00000\u0007\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000\u000f\u00a2\u0006\u0002\u0010\u0010J\b\u0010\u001d\u001a\u00020\u001eH\u0002J\b\u0010\u001f\u001a\u00020\u001eH\u0016J\u0018\u0010 \u001a\u00020\u001e2\b\u0010!\u001a\u0004\u0018\u00010\t2\u0006\u0010\"\u001a\u00020#J\u0010\u0010$\u001a\u00020\u001e2\u0006\u0010%\u001a\u00020&H\u0016J\b\u0010'\u001a\u00020\u001eH\u0016J\u0010\u0010(\u001a\u00020\u001e2\u0006\u0010)\u001a\u00020*H\u0016J\u0010\u0010+\u001a\u00020\u001e2\u0006\u0010,\u001a\u00020-H\u0016J\b\u0010\u001c\u001a\u00020\tH\u0016J\u0010\u0010.\u001a\u00020\u00182\u0006\u0010,\u001a\u00020-H\u0016R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00028\u00000\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\u00020\u00188VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0019R\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lde/fhg/aisec/ids/idscp2/defaultdrivers/securechannel/tls13/client/TLSClient;", "CC", "Lde/fhg/aisec/ids/idscp2/core/api/connection/Idscp2Connection;", "Ljavax/net/ssl/HandshakeCompletedListener;", "Lde/fhg/aisec/ids/idscp2/defaultdrivers/securechannel/tls13/client/DataAvailableListener;", "Lde/fhg/aisec/ids/idscp2/core/drivers/SecureChannelEndpoint;", "connectionFactory", "Lkotlin/Function2;", "Lde/fhg/aisec/ids/idscp2/core/fsm/FSM;", "", "clientConfiguration", "Lde/fhg/aisec/ids/idscp2/core/api/configuration/Idscp2Configuration;", "nativeTlsConfiguration", "Lde/fhg/aisec/ids/idscp2/defaultdrivers/securechannel/tls13/NativeTlsConfiguration;", "connectionFuture", "Ljava/util/concurrent/CompletableFuture;", "(Lkotlin/jvm/functions/Function2;Lde/fhg/aisec/ids/idscp2/core/api/configuration/Idscp2Configuration;Lde/fhg/aisec/ids/idscp2/defaultdrivers/securechannel/tls13/NativeTlsConfiguration;Ljava/util/concurrent/CompletableFuture;)V", "clientSocket", "Ljava/net/Socket;", "dataOutputStream", "Ljava/io/DataOutputStream;", "inputListenerThread", "Lde/fhg/aisec/ids/idscp2/defaultdrivers/securechannel/tls13/client/InputListenerThread;", "isConnected", "", "()Z", "listenerPromise", "Lde/fhg/aisec/ids/idscp2/core/securechannel/SecureChannelListener;", "remotePeer", "cleanup", "", "close", "connect", "hostname", "port", "", "handshakeCompleted", "handshakeCompletedEvent", "Ljavax/net/ssl/HandshakeCompletedEvent;", "onClose", "onError", "e", "", "onMessage", "bytes", "", "send", "Companion", "idscp2"})
public final class TLSClient<CC extends Idscp2Connection>
implements HandshakeCompletedListener,
DataAvailableListener,
SecureChannelEndpoint {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Function2<FSM, String, CC> connectionFactory;
    @NotNull
    private final Idscp2Configuration clientConfiguration;
    @NotNull
    private final NativeTlsConfiguration nativeTlsConfiguration;
    @NotNull
    private final CompletableFuture<CC> connectionFuture;
    @NotNull
    private final Socket clientSocket;
    @Nullable
    private DataOutputStream dataOutputStream;
    private InputListenerThread inputListenerThread;
    @NotNull
    private final CompletableFuture<SecureChannelListener> listenerPromise;
    @NotNull
    private String remotePeer;
    private static final Logger LOG = LoggerFactory.getLogger(TLSClient.class);

    public TLSClient(@NotNull Function2<? super FSM, ? super String, ? extends CC> connectionFactory, @NotNull Idscp2Configuration clientConfiguration, @NotNull NativeTlsConfiguration nativeTlsConfiguration, @NotNull CompletableFuture<CC> connectionFuture) {
        Intrinsics.checkNotNullParameter(connectionFactory, (String)"connectionFactory");
        Intrinsics.checkNotNullParameter((Object)clientConfiguration, (String)"clientConfiguration");
        Intrinsics.checkNotNullParameter((Object)nativeTlsConfiguration, (String)"nativeTlsConfiguration");
        Intrinsics.checkNotNullParameter(connectionFuture, (String)"connectionFuture");
        this.connectionFactory = connectionFactory;
        this.clientConfiguration = clientConfiguration;
        this.nativeTlsConfiguration = nativeTlsConfiguration;
        this.connectionFuture = connectionFuture;
        this.listenerPromise = new CompletableFuture();
        this.remotePeer = "NotConnected";
        TrustManager myTrustManager = this.nativeTlsConfiguration.getTrustManager();
        KeyManager[] myKeyManager = PreConfiguration.INSTANCE.getX509ExtKeyManager(this.nativeTlsConfiguration.getKeyPassword(), this.nativeTlsConfiguration.getKeyStorePath(), this.nativeTlsConfiguration.getKeyStorePassword(), this.nativeTlsConfiguration.getCertificateAlias(), this.nativeTlsConfiguration.getKeyStoreKeyType());
        SSLContext sslContext = SSLContext.getInstance("TLSv1.3");
        TrustManager[] trustManagerArray = new TrustManager[]{myTrustManager};
        sslContext.init(myKeyManager, trustManagerArray, null);
        SSLSocketFactory socketFactory = sslContext.getSocketFactory();
        Socket socket = socketFactory.createSocket();
        Intrinsics.checkNotNullExpressionValue((Object)socket, (String)"socketFactory.createSocket()");
        Socket socket2 = this.clientSocket = socket;
        Intrinsics.checkNotNull((Object)socket2, (String)"null cannot be cast to non-null type javax.net.ssl.SSLSocket");
        SSLSocket sslSocket = (SSLSocket)socket2;
        SSLParameters sslParameters = sslSocket.getSSLParameters();
        sslParameters.setUseCipherSuitesOrder(false);
        sslParameters.setNeedClientAuth(true);
        sslParameters.setProtocols(TLSConstants.INSTANCE.getTLS_ENABLED_PROTOCOLS());
        sslParameters.setCipherSuites(TLSConstants.INSTANCE.getTLS_ENABLED_CIPHERS());
        sslSocket.setSSLParameters(sslParameters);
        if (LOG.isTraceEnabled()) {
            LOG.trace("TLS Client was initialized successfully");
        }
    }

    public final void connect(@Nullable String hostname, int port) {
        SSLSocket sslSocket = (SSLSocket)this.clientSocket;
        if (sslSocket == null || sslSocket.isClosed()) {
            throw new Idscp2Exception("Client socket is not available");
        }
        try {
            sslSocket.connect(new InetSocketAddress(hostname, port));
            if (LOG.isTraceEnabled()) {
                LOG.trace("Client is connected to server {}:{}", (Object)hostname, (Object)port);
            }
            ((SSLSocket)this.clientSocket).setSoTimeout(this.nativeTlsConfiguration.getSocketTimeout());
            this.dataOutputStream = new DataOutputStream(this.clientSocket.getOutputStream());
            InputStream inputStream = this.clientSocket.getInputStream();
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"clientSocket.getInputStream()");
            this.inputListenerThread = new InputListenerThread(inputStream, this);
            if (LOG.isTraceEnabled()) {
                LOG.trace("Start TLS Handshake");
            }
            sslSocket.addHandshakeCompletedListener(this);
            sslSocket.startHandshake();
        }
        catch (SSLHandshakeException e) {
            this.cleanup();
            throw new Idscp2Exception("TLS Handshake failed", e);
        }
        catch (SSLProtocolException e) {
            this.cleanup();
            throw new Idscp2Exception("TLS Handshake failed", e);
        }
        catch (IOException e) {
            this.cleanup();
            throw new Idscp2Exception("Connecting TLS client to server failed", e);
        }
    }

    private final void cleanup() {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Cleanup broken TLS connection ..");
        }
        if (this.inputListenerThread != null) {
            InputListenerThread inputListenerThread = this.inputListenerThread;
            InputListenerThread inputListenerThread2 = inputListenerThread;
            if (inputListenerThread2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"inputListenerThread");
                inputListenerThread2 = null;
            }
            inputListenerThread2.safeStop();
        }
        if (!this.clientSocket.isClosed()) {
            try {
                this.clientSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public void onClose() {
        this.listenerPromise.thenAccept(TLSClient::onClose$lambda-0);
    }

    @Override
    public void onError(@NotNull Throwable e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.listenerPromise.thenAccept(arg_0 -> TLSClient.onError$lambda-1(e, arg_0));
    }

    @Override
    public void onMessage(@NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        this.listenerPromise.thenAccept(arg_0 -> TLSClient.onMessage$lambda-2(bytes, arg_0));
    }

    @Override
    public void close() {
        this.cleanup();
    }

    @Override
    public boolean send(@NotNull byte[] bytes) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        if (!this.isConnected()) {
            LOG.warn("Client cannot send data because TLS socket is not connected");
            bl = false;
        } else {
            boolean bl2;
            try {
                Unit unit;
                DataOutputStream dataOutputStream = this.dataOutputStream;
                if (dataOutputStream != null) {
                    DataOutputStream it = dataOutputStream;
                    boolean bl3 = false;
                    it.writeInt(bytes.length);
                    it.write(bytes);
                    it.flush();
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
                if (unit == null) {
                    throw new IOException("DataOutputStream not available");
                }
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Sending message...");
                }
                bl2 = true;
            }
            catch (Exception e) {
                LOG.warn("Client cannot send data", (Throwable)e);
                bl2 = false;
            }
            bl = bl2;
        }
        return bl;
    }

    @Override
    public boolean isConnected() {
        return this.clientSocket.isConnected();
    }

    @Override
    @NotNull
    public String remotePeer() {
        return this.remotePeer;
    }

    @Override
    public void handshakeCompleted(@NotNull HandshakeCompletedEvent handshakeCompletedEvent) {
        Intrinsics.checkNotNullParameter((Object)handshakeCompletedEvent, (String)"handshakeCompletedEvent");
        if (LOG.isTraceEnabled()) {
            LOG.trace("TLS Handshake was successful");
        }
        if (this.connectionFuture.isCancelled()) {
            this.cleanup();
            return;
        }
        try {
            SSLSession sslSession = handshakeCompletedEvent.getSession();
            Certificate[] certificates = sslSession.getPeerCertificates();
            Intrinsics.checkNotNullExpressionValue((Object)certificates, (String)"certificates");
            if (certificates.length == 0) {
                throw new SSLPeerUnverifiedException("Missing peer certificate");
            }
            Certificate certificate = certificates[0];
            Intrinsics.checkNotNull((Object)certificate, (String)"null cannot be cast to non-null type java.security.cert.X509Certificate");
            X509Certificate peerCert = (X509Certificate)certificate;
            String string = sslSession.getPeerHost();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sslSession.peerHost");
            TLSSessionVerificationHelper.verifyTlsSession$default(TLSSessionVerificationHelper.INSTANCE, string, sslSession.getPeerPort(), peerCert, this.nativeTlsConfiguration.getHostnameVerificationEnabled(), false, 16, null);
            if (LOG.isTraceEnabled()) {
                LOG.trace("TLS session is valid");
            }
            this.remotePeer = sslSession.getPeerHost() + ":" + sslSession.getPeerPort();
            SecureChannel secureChannel = new SecureChannel(this, peerCert);
            this.listenerPromise.complete(secureChannel);
            boolean success = AsyncIdscp2Factory.INSTANCE.initiateIdscp2Connection(secureChannel, this.clientConfiguration, this.connectionFactory, this.connectionFuture);
            if (success) {
                InputListenerThread inputListenerThread = this.inputListenerThread;
                if (inputListenerThread == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"inputListenerThread");
                    inputListenerThread = null;
                }
                inputListenerThread.start();
            }
        }
        catch (Exception e) {
            this.cleanup();
            this.connectionFuture.completeExceptionally(new Idscp2Exception("TLS session was not valid", e));
        }
    }

    private static final void onClose$lambda-0(SecureChannelListener obj) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        obj.onClose();
    }

    private static final void onError$lambda-1(Throwable $e, SecureChannelListener listener) {
        Intrinsics.checkNotNullParameter((Object)$e, (String)"$e");
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        listener.onError($e);
    }

    private static final void onMessage$lambda-2(byte[] $bytes, SecureChannelListener listener) {
        Intrinsics.checkNotNullParameter((Object)$bytes, (String)"$bytes");
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        listener.onMessage($bytes);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lde/fhg/aisec/ids/idscp2/defaultdrivers/securechannel/tls13/client/TLSClient$Companion;", "", "()V", "LOG", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "idscp2"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

