/*
 * Decompiled with CFR 0.152.
 */
package de.fhg.aisec.ids.idscp2.defaultdrivers.securechannel.tls13;

import de.fhg.aisec.ids.idscp2.core.error.Idscp2Exception;
import de.fhg.aisec.ids.idscp2.defaultdrivers.keystores.PreConfiguration;
import java.nio.file.Path;
import java.util.Arrays;
import javax.net.ssl.TrustManager;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0019\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000e\u0018\u0000 .2\u00020\u0001:\u0002-.B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0013\u0010)\u001a\u00020\n2\b\u0010*\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010+\u001a\u00020\u001aH\u0016J\b\u0010,\u001a\u00020\u0004H\u0016R\u001e\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001e\u0010\b\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u001e\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0003\u001a\u00020\n@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001e\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0003\u001a\u00020\u000e@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001e\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0007R\u001e\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0003\u001a\u00020\u000e@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0011R\u001e\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0003\u001a\u00020\u0016@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u001e\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u0003\u001a\u00020\u001a@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u001e\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u0003\u001a\u00020\u001a@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u001dR\u001b\u0010 \u001a\u00020!8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b$\u0010%\u001a\u0004\b\"\u0010#R\u0010\u0010&\u001a\u0004\u0018\u00010!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020\u000eX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020\u0016X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lde/fhg/aisec/ids/idscp2/defaultdrivers/securechannel/tls13/NativeTlsConfiguration;", "", "()V", "<set-?>", "", "certificateAlias", "getCertificateAlias", "()Ljava/lang/String;", "host", "getHost", "", "hostnameVerificationEnabled", "getHostnameVerificationEnabled", "()Z", "", "keyPassword", "getKeyPassword", "()[C", "keyStoreKeyType", "getKeyStoreKeyType", "keyStorePassword", "getKeyStorePassword", "Ljava/nio/file/Path;", "keyStorePath", "getKeyStorePath", "()Ljava/nio/file/Path;", "", "serverPort", "getServerPort", "()I", "socketTimeout", "getSocketTimeout", "trustManager", "Ljavax/net/ssl/TrustManager;", "getTrustManager", "()Ljavax/net/ssl/TrustManager;", "trustManager$delegate", "Lkotlin/Lazy;", "trustManagerInstance", "trustStorePassword", "trustStorePath", "equals", "other", "hashCode", "toString", "Builder", "Companion", "idscp2"})
public final class NativeTlsConfiguration {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int serverPort = 29292;
    @NotNull
    private String host = "localhost";
    private Path trustStorePath;
    private char[] trustStorePassword;
    @Nullable
    private TrustManager trustManagerInstance;
    private char[] keyPassword;
    private Path keyStorePath;
    private char[] keyStorePassword;
    private String certificateAlias;
    @NotNull
    private String keyStoreKeyType = "RSA";
    private int socketTimeout = 5000;
    private boolean hostnameVerificationEnabled = true;
    @NotNull
    private final Lazy trustManager$delegate = LazyKt.lazy((Function0)((Function0)new Function0<TrustManager>(this){
        final /* synthetic */ NativeTlsConfiguration this$0;
        {
            this.this$0 = $receiver;
            super(0);
        }

        @NotNull
        public final TrustManager invoke() {
            TrustManager trustManager2 = NativeTlsConfiguration.access$getTrustManagerInstance$p(this.this$0);
            if (trustManager2 == null) {
                char[] cArray;
                Path path = NativeTlsConfiguration.access$getTrustStorePath$p(this.this$0);
                if (path == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"trustStorePath");
                    path = null;
                }
                if ((cArray = NativeTlsConfiguration.access$getTrustStorePassword$p(this.this$0)) == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"trustStorePassword");
                    cArray = null;
                }
                trustManager2 = PreConfiguration.INSTANCE.getX509ExtTrustManager(path, cArray);
            }
            return trustManager2;
        }
    }));
    public static final int DEFAULT_SERVER_PORT = 29292;
    public static final int DEFAULT_SOCKET_TIMEOUT = 5000;

    private NativeTlsConfiguration() {
    }

    public final int getServerPort() {
        return this.serverPort;
    }

    @NotNull
    public final String getHost() {
        return this.host;
    }

    @NotNull
    public final char[] getKeyPassword() {
        if (this.keyPassword != null) {
            return this.keyPassword;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"keyPassword");
        return null;
    }

    @NotNull
    public final Path getKeyStorePath() {
        Path path = this.keyStorePath;
        if (path != null) {
            return path;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"keyStorePath");
        return null;
    }

    @NotNull
    public final char[] getKeyStorePassword() {
        if (this.keyStorePassword != null) {
            return this.keyStorePassword;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"keyStorePassword");
        return null;
    }

    @NotNull
    public final String getCertificateAlias() {
        String string = this.certificateAlias;
        if (string != null) {
            return string;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"certificateAlias");
        return null;
    }

    @NotNull
    public final String getKeyStoreKeyType() {
        return this.keyStoreKeyType;
    }

    public final int getSocketTimeout() {
        return this.socketTimeout;
    }

    public final boolean getHostnameVerificationEnabled() {
        return this.hostnameVerificationEnabled;
    }

    @NotNull
    public final TrustManager getTrustManager() {
        Lazy lazy = this.trustManager$delegate;
        return (TrustManager)lazy.getValue();
    }

    public boolean equals(@Nullable Object other) {
        Path path;
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type de.fhg.aisec.ids.idscp2.defaultdrivers.securechannel.tls13.NativeTlsConfiguration");
        NativeTlsConfiguration cfr_ignored_0 = (NativeTlsConfiguration)other;
        if (this.serverPort != ((NativeTlsConfiguration)other).serverPort) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.host, (Object)((NativeTlsConfiguration)other).host)) {
            return false;
        }
        Path path2 = this.trustStorePath;
        if (path2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"trustStorePath");
            path2 = null;
        }
        if ((path = ((NativeTlsConfiguration)other).trustStorePath) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"trustStorePath");
            path = null;
        }
        if (!Intrinsics.areEqual((Object)path2, (Object)path)) {
            return false;
        }
        char[] cArray = this.trustStorePassword;
        if (this.trustStorePassword == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"trustStorePassword");
            cArray = null;
        }
        char[] cArray2 = cArray;
        char[] cArray3 = ((NativeTlsConfiguration)other).trustStorePassword;
        if (((NativeTlsConfiguration)other).trustStorePassword == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"trustStorePassword");
            cArray3 = null;
        }
        if (!Arrays.equals(cArray2, cArray3)) {
            return false;
        }
        if (!Arrays.equals(this.getKeyPassword(), ((NativeTlsConfiguration)other).getKeyPassword())) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.getKeyStorePath(), (Object)((NativeTlsConfiguration)other).getKeyStorePath())) {
            return false;
        }
        if (!Arrays.equals(this.getKeyStorePassword(), ((NativeTlsConfiguration)other).getKeyStorePassword())) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.getCertificateAlias(), (Object)((NativeTlsConfiguration)other).getCertificateAlias())) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.keyStoreKeyType, (Object)((NativeTlsConfiguration)other).keyStoreKeyType)) {
            return false;
        }
        if (this.socketTimeout != ((NativeTlsConfiguration)other).socketTimeout) {
            return false;
        }
        return this.hostnameVerificationEnabled == ((NativeTlsConfiguration)other).hostnameVerificationEnabled;
    }

    public int hashCode() {
        int result = this.serverPort;
        result = 31 * result + this.host.hashCode();
        Path path = this.trustStorePath;
        if (path == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"trustStorePath");
            path = null;
        }
        result = 31 * result + ((Object)path).hashCode();
        char[] cArray = this.trustStorePassword;
        if (this.trustStorePassword == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"trustStorePassword");
            cArray = null;
        }
        result = 31 * result + Arrays.hashCode(cArray);
        result = 31 * result + Arrays.hashCode(this.getKeyPassword());
        result = 31 * result + ((Object)this.getKeyStorePath()).hashCode();
        result = 31 * result + Arrays.hashCode(this.getKeyStorePassword());
        result = 31 * result + this.getCertificateAlias().hashCode();
        result = 31 * result + this.keyStoreKeyType.hashCode();
        result = 31 * result + Integer.hashCode(this.socketTimeout);
        result = 31 * result + Boolean.hashCode(this.hostnameVerificationEnabled);
        return result;
    }

    @NotNull
    public String toString() {
        Path path = this.trustStorePath;
        if (path == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"trustStorePath");
            path = null;
        }
        char[] cArray = this.trustStorePassword;
        if (this.trustStorePassword == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"trustStorePassword");
            cArray = null;
        }
        String string = Arrays.toString(cArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(this)");
        Path path2 = this.getKeyStorePath();
        String string2 = Arrays.toString(this.getKeyStorePassword());
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(this)");
        return "Idscp2Configuration(serverPort=" + this.serverPort + ", host='" + this.host + "', trustStorePath=" + path + ", trustStorePassword=" + string + ", keyStorePath=" + path2 + ", keyStorePassword=" + string2 + ", certificateAlias='" + this.getCertificateAlias() + "', keyStoreKeyType='" + this.keyStoreKeyType + "', socketTimeout='" + this.socketTimeout + "', hostnameVerificationEnabled='" + this.hostnameVerificationEnabled + "'";
    }

    public /* synthetic */ NativeTlsConfiguration(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0019\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0005\u001a\u00020\u0004J\u000e\u0010\u0006\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\t\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\bJ\u000e\u0010\u000b\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\bJ\u000e\u0010\u0010\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0014\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u0016J\u000e\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\u001bJ\u000e\u0010\u001c\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u0013J\u0006\u0010\u001e\u001a\u00020\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lde/fhg/aisec/ids/idscp2/defaultdrivers/securechannel/tls13/NativeTlsConfiguration$Builder;", "", "()V", "config", "Lde/fhg/aisec/ids/idscp2/defaultdrivers/securechannel/tls13/NativeTlsConfiguration;", "build", "setCertificateAlias", "alias", "", "setHost", "host", "setKeyPassword", "pwd", "", "setKeyStoreKeyType", "keyType", "setKeyStorePassword", "setKeyStorePath", "path", "Ljava/nio/file/Path;", "setServerPort", "serverPort", "", "setServerSocketTimeout", "timeout", "setTrustManager", "trustManager", "Ljavax/net/ssl/TrustManager;", "setTrustStorePassword", "setTrustStorePath", "unsafeDisableHostnameVerification", "idscp2"})
    public static final class Builder {
        @NotNull
        private final NativeTlsConfiguration config = new NativeTlsConfiguration(null);

        @NotNull
        public final Builder setHost(@NotNull String host) {
            Intrinsics.checkNotNullParameter((Object)host, (String)"host");
            this.config.host = host;
            return this;
        }

        @NotNull
        public final Builder setServerPort(int serverPort) {
            this.config.serverPort = serverPort;
            return this;
        }

        @NotNull
        public final Builder setTrustStorePath(@NotNull Path path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            this.config.trustStorePath = path;
            return this;
        }

        @NotNull
        public final Builder setTrustStorePassword(@NotNull char[] pwd) {
            Intrinsics.checkNotNullParameter((Object)pwd, (String)"pwd");
            this.config.trustStorePassword = pwd;
            return this;
        }

        @NotNull
        public final Builder setTrustManager(@NotNull TrustManager trustManager2) {
            Intrinsics.checkNotNullParameter((Object)trustManager2, (String)"trustManager");
            this.config.trustManagerInstance = trustManager2;
            return this;
        }

        @NotNull
        public final Builder setKeyPassword(@NotNull char[] pwd) {
            Intrinsics.checkNotNullParameter((Object)pwd, (String)"pwd");
            this.config.keyPassword = pwd;
            return this;
        }

        @NotNull
        public final Builder setKeyStorePath(@NotNull Path path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            this.config.keyStorePath = path;
            return this;
        }

        @NotNull
        public final Builder setKeyStorePassword(@NotNull char[] pwd) {
            Intrinsics.checkNotNullParameter((Object)pwd, (String)"pwd");
            this.config.keyStorePassword = pwd;
            return this;
        }

        @NotNull
        public final Builder setCertificateAlias(@NotNull String alias) {
            Intrinsics.checkNotNullParameter((Object)alias, (String)"alias");
            this.config.certificateAlias = alias;
            return this;
        }

        @NotNull
        public final Builder setKeyStoreKeyType(@NotNull String keyType) {
            Intrinsics.checkNotNullParameter((Object)keyType, (String)"keyType");
            this.config.keyStoreKeyType = keyType;
            return this;
        }

        @NotNull
        public final Builder setServerSocketTimeout(int timeout) {
            this.config.socketTimeout = timeout;
            return this;
        }

        @NotNull
        public final Builder unsafeDisableHostnameVerification() {
            this.config.hostnameVerificationEnabled = false;
            return this;
        }

        @NotNull
        public final NativeTlsConfiguration build() {
            if (this.config.trustManagerInstance == null && (this.config.trustStorePath == null || this.config.trustStorePassword == null)) {
                throw new Idscp2Exception("Cannot build NativeTlsConfiguration: Neither trustManager, nor trustStorePath + trustStorePassword have been set!");
            }
            if (this.config.keyPassword == null) {
                throw new Idscp2Exception("Cannot build NativeTlsConfiguration: keyPassword has not been set!");
            }
            if (this.config.keyStorePath == null) {
                throw new Idscp2Exception("Cannot build NativeTlsConfiguration: keyStorePath has not been set!");
            }
            if (this.config.keyStorePassword == null) {
                throw new Idscp2Exception("Cannot build NativeTlsConfiguration: keyStorePassword has not been set!");
            }
            if (this.config.certificateAlias == null) {
                throw new Idscp2Exception("Cannot build NativeTlsConfiguration: certificateAlias has not been set!");
            }
            return this.config;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lde/fhg/aisec/ids/idscp2/defaultdrivers/securechannel/tls13/NativeTlsConfiguration$Companion;", "", "()V", "DEFAULT_SERVER_PORT", "", "DEFAULT_SOCKET_TIMEOUT", "idscp2"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

