/*
 * Decompiled with CFR 0.152.
 */
package de.fhg.aisec.ids.idscp2.defaultdrivers.keystores;

import de.fhg.aisec.ids.idscp2.defaultdrivers.keystores.CustomX509ExtendedKeyManager;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509ExtendedTrustManager;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0019\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\bJ&\u0010\u0012\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u0010J9\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u0014\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\b\u00a2\u0006\u0002\u0010\u001aJ\u0016\u0010\u001b\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\u0010J\u0016\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000RN\u0010\u0006\u001aB\u0012\f\u0012\n \u0005*\u0004\u0018\u00010\b0\b\u0012\f\u0012\n \u0005*\u0004\u0018\u00010\t0\t \u0005* \u0012\f\u0012\n \u0005*\u0004\u0018\u00010\b0\b\u0012\f\u0012\n \u0005*\u0004\u0018\u00010\t0\t\u0018\u00010\n0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lde/fhg/aisec/ids/idscp2/defaultdrivers/keystores/PreConfiguration;", "", "()V", "LOG", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "TRUST_MANAGERS", "", "", "Ljavax/net/ssl/X509ExtendedTrustManager;", "", "getCertificate", "Ljava/security/cert/X509Certificate;", "keyStorePath", "Ljava/nio/file/Path;", "keyStorePassword", "", "keyAlias", "getKey", "Ljava/security/Key;", "keyPassword", "getX509ExtKeyManager", "", "Ljavax/net/ssl/KeyManager;", "certAlias", "keyType", "([CLjava/nio/file/Path;[CLjava/lang/String;Ljava/lang/String;)[Ljavax/net/ssl/KeyManager;", "getX509ExtTrustManager", "trustStorePath", "trustStorePassword", "loadKeyStore", "Ljava/security/KeyStore;", "idscp2"})
public final class PreConfiguration {
    @NotNull
    public static final PreConfiguration INSTANCE = new PreConfiguration();
    private static final Logger LOG = LoggerFactory.getLogger(PreConfiguration.class);
    private static final Map<String, X509ExtendedTrustManager> TRUST_MANAGERS = Collections.synchronizedMap(new LinkedHashMap());

    private PreConfiguration() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final KeyStore loadKeyStore(@NotNull Path keyStorePath, @NotNull char[] keyStorePassword) {
        KeyStore keyStore;
        Intrinsics.checkNotNullParameter((Object)keyStorePath, (String)"keyStorePath");
        Intrinsics.checkNotNullParameter((Object)keyStorePassword, (String)"keyStorePassword");
        KeyStore ks = null;
        String pathString = ((Object)keyStorePath).toString();
        if (StringsKt.endsWith$default((String)pathString, (String)".jks", (boolean)false, (int)2, null)) {
            KeyStore keyStore2 = KeyStore.getInstance("JKS");
            keyStore = keyStore2;
            Intrinsics.checkNotNullExpressionValue((Object)keyStore2, (String)"{\n                KeySto\u2026ance(\"JKS\")\n            }");
        } else if (StringsKt.endsWith$default((String)pathString, (String)".p12", (boolean)false, (int)2, null)) {
            KeyStore keyStore3 = KeyStore.getInstance("PKCS12");
            keyStore = keyStore3;
            Intrinsics.checkNotNullExpressionValue((Object)keyStore3, (String)"{\n                KeySto\u2026e(\"PKCS12\")\n            }");
        } else {
            String string = pathString.substring(StringsKt.lastIndexOf$default((CharSequence)pathString, (char)'.', (int)0, (boolean)false, (int)6, null));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
            throw new KeyStoreException("Unknown file extension \"" + string + "\", only JKS (.jks) and PKCS12 (.p12) are supported.");
        }
        ks = keyStore;
        Closeable closeable = Files.newInputStream(keyStorePath, new OpenOption[0]);
        Throwable throwable = null;
        try {
            InputStream keyStoreInputStream = (InputStream)closeable;
            boolean bl = false;
            if (LOG.isTraceEnabled()) {
                LOG.trace("Loading key store: " + pathString);
            }
            ks.load(keyStoreInputStream, keyStorePassword);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return ks;
    }

    @NotNull
    public final X509ExtendedTrustManager getX509ExtTrustManager(@NotNull Path trustStorePath, @NotNull char[] trustStorePassword) {
        Intrinsics.checkNotNullParameter((Object)trustStorePath, (String)"trustStorePath");
        Intrinsics.checkNotNullParameter((Object)trustStorePassword, (String)"trustStorePassword");
        X509ExtendedTrustManager x509ExtendedTrustManager = TRUST_MANAGERS.computeIfAbsent(((Object)trustStorePath.toAbsolutePath()).toString(), arg_0 -> PreConfiguration.getX509ExtTrustManager$lambda-2(trustStorePath, trustStorePassword, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)x509ExtendedTrustManager, (String)"TRUST_MANAGERS.computeIf\u2026)\n            }\n        }");
        return x509ExtendedTrustManager;
    }

    @NotNull
    public final KeyManager[] getX509ExtKeyManager(@NotNull char[] keyPassword, @NotNull Path keyStorePath, @NotNull char[] keyStorePassword, @NotNull String certAlias, @NotNull String keyType) {
        Object[] objectArray;
        Intrinsics.checkNotNullParameter((Object)keyPassword, (String)"keyPassword");
        Intrinsics.checkNotNullParameter((Object)keyStorePath, (String)"keyStorePath");
        Intrinsics.checkNotNullParameter((Object)keyStorePassword, (String)"keyStorePassword");
        Intrinsics.checkNotNullParameter((Object)certAlias, (String)"certAlias");
        Intrinsics.checkNotNullParameter((Object)keyType, (String)"keyType");
        try {
            Object[] myKeyManager = null;
            KeyStore keystore = this.loadKeyStore(keyStorePath, keyStorePassword);
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance("PKIX");
            keyManagerFactory.init(keystore, keyPassword);
            Object[] objectArray2 = keyManagerFactory.getKeyManagers();
            Intrinsics.checkNotNullExpressionValue((Object)objectArray2, (String)"keyManagerFactory.keyManagers");
            myKeyManager = objectArray2;
            if (myKeyManager.length != 1 || !(myKeyManager[0] instanceof X509ExtendedKeyManager)) {
                String string = Arrays.toString(myKeyManager);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(this)");
                throw new IllegalStateException("Unexpected default key managers:" + string);
            }
            Object object = myKeyManager[0];
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type javax.net.ssl.X509ExtendedKeyManager");
            myKeyManager[0] = new CustomX509ExtendedKeyManager(certAlias, keyType, (X509ExtendedKeyManager)object);
            objectArray = myKeyManager;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (KeyStoreException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        catch (UnrecoverableKeyException e) {
            throw new RuntimeException(e);
        }
        catch (CertificateException e) {
            throw new RuntimeException(e);
        }
        return objectArray;
    }

    @NotNull
    public final Key getKey(@NotNull Path keyStorePath, @NotNull char[] keyStorePassword, @NotNull String keyAlias, @NotNull char[] keyPassword) {
        Key key;
        Intrinsics.checkNotNullParameter((Object)keyStorePath, (String)"keyStorePath");
        Intrinsics.checkNotNullParameter((Object)keyStorePassword, (String)"keyStorePassword");
        Intrinsics.checkNotNullParameter((Object)keyAlias, (String)"keyAlias");
        Intrinsics.checkNotNullParameter((Object)keyPassword, (String)"keyPassword");
        try {
            Key key2;
            KeyStore keyStore = this.loadKeyStore(keyStorePath, keyStorePassword);
            Key key3 = key2 = keyStore.getKey(keyAlias, keyPassword);
            if (key3 == null) {
                throw new RuntimeException("No key was found in keystore for given alias");
            }
            key = key3;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (KeyStoreException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        catch (CertificateException e) {
            throw new RuntimeException(e);
        }
        catch (UnrecoverableKeyException e) {
            throw new RuntimeException(e);
        }
        return key;
    }

    @NotNull
    public final X509Certificate getCertificate(@NotNull Path keyStorePath, @NotNull char[] keyStorePassword, @NotNull String keyAlias) {
        X509Certificate x509Certificate;
        Intrinsics.checkNotNullParameter((Object)keyStorePath, (String)"keyStorePath");
        Intrinsics.checkNotNullParameter((Object)keyStorePassword, (String)"keyStorePassword");
        Intrinsics.checkNotNullParameter((Object)keyAlias, (String)"keyAlias");
        try {
            KeyStore keystore = this.loadKeyStore(keyStorePath, keyStorePassword);
            Certificate certificate = keystore.getCertificate(keyAlias);
            Intrinsics.checkNotNull((Object)certificate, (String)"null cannot be cast to non-null type java.security.cert.X509Certificate");
            X509Certificate cert = (X509Certificate)certificate;
            keystore.getKey(keyAlias, keyStorePassword);
            x509Certificate = cert;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (KeyStoreException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        catch (CertificateException e) {
            throw new RuntimeException(e);
        }
        catch (UnrecoverableKeyException e) {
            throw new RuntimeException(e);
        }
        return x509Certificate;
    }

    private static final X509ExtendedTrustManager getX509ExtTrustManager$lambda-2(Path $trustStorePath, char[] $trustStorePassword, String it) {
        TrustManagerFactory trustManagerFactory;
        Intrinsics.checkNotNullParameter((Object)$trustStorePath, (String)"$trustStorePath");
        Intrinsics.checkNotNullParameter((Object)$trustStorePassword, (String)"$trustStorePassword");
        TrustManagerFactory $this$getX509ExtTrustManager_u24lambda_u2d2_u24lambda_u2d1 = trustManagerFactory = TrustManagerFactory.getInstance("PKIX");
        boolean bl = false;
        $this$getX509ExtTrustManager_u24lambda_u2d2_u24lambda_u2d1.init(INSTANCE.loadKeyStore($trustStorePath, $trustStorePassword));
        Object[] trustManagers = trustManagerFactory.getTrustManagers();
        if (trustManagers.length != 1 || !(trustManagers[0] instanceof X509ExtendedTrustManager)) {
            String string = Arrays.toString(trustManagers);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(this)");
            throw new IllegalStateException("Unexpected default trust manager(s): " + string);
        }
        Object object = trustManagers[0];
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type javax.net.ssl.X509ExtendedTrustManager");
        return (X509ExtendedTrustManager)object;
    }
}

