/*
 * Decompiled with CFR 0.152.
 */
package de.fhg.aisec.ids.idscp2.defaultdrivers.daps.aisecdaps;

import de.fhg.aisec.ids.idscp2.core.error.Idscp2Exception;
import de.fhg.aisec.ids.idscp2.defaultdrivers.daps.aisecdaps.SecurityRequirements;
import de.fhg.aisec.ids.idscp2.defaultdrivers.keystores.PreConfiguration;
import java.nio.file.Path;
import javax.net.ssl.TrustManager;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0019\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u0000 )2\u00020\u0001:\u0002()B\u0005\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001e\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001e\u0010\u000e\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u001e\u0010\u0011\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\u0010@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001e\u0010\u0014\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\u0010@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0013R\u001e\u0010\u0017\u001a\u00020\u00162\u0006\u0010\t\u001a\u00020\u0016@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\"\u0010\u001b\u001a\u0004\u0018\u00010\u001a2\b\u0010\t\u001a\u0004\u0018\u00010\u001a@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u001b\u0010\u001e\u001a\u00020\u001f8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\"\u0010#\u001a\u0004\b \u0010!R\u0010\u0010$\u001a\u0004\u0018\u00010\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\u0010X\u0082.\u00a2\u0006\u0002\n\u0000R\u001e\u0010&\u001a\u00020\u00162\u0006\u0010\t\u001a\u00020\u0016@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010\u0019\u00a8\u0006*"}, d2={"Lde/fhg/aisec/ids/idscp2/defaultdrivers/daps/aisecdaps/AisecDapsDriverConfig;", "", "()V", "dapsTokenRenewalThreshold", "", "getDapsTokenRenewalThreshold", "()F", "setDapsTokenRenewalThreshold", "(F)V", "<set-?>", "", "dapsUrl", "getDapsUrl", "()Ljava/lang/String;", "keyAlias", "getKeyAlias", "", "keyPassword", "getKeyPassword", "()[C", "keyStorePassword", "getKeyStorePassword", "Ljava/nio/file/Path;", "keyStorePath", "getKeyStorePath", "()Ljava/nio/file/Path;", "Lde/fhg/aisec/ids/idscp2/defaultdrivers/daps/aisecdaps/SecurityRequirements;", "securityRequirements", "getSecurityRequirements", "()Lde/fhg/aisec/ids/idscp2/defaultdrivers/daps/aisecdaps/SecurityRequirements;", "trustManager", "Ljavax/net/ssl/TrustManager;", "getTrustManager", "()Ljavax/net/ssl/TrustManager;", "trustManager$delegate", "Lkotlin/Lazy;", "trustManagerInstance", "trustStorePassword", "trustStorePath", "getTrustStorePath", "Builder", "Companion", "idscp2"})
public final class AisecDapsDriverConfig {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private String dapsUrl = "https://daps.aisec.fraunhofer.de/v3";
    private Path trustStorePath;
    private char[] trustStorePassword;
    @Nullable
    private TrustManager trustManagerInstance;
    private char[] keyPassword;
    private Path keyStorePath;
    private char[] keyStorePassword;
    private String keyAlias;
    @Nullable
    private SecurityRequirements securityRequirements;
    private float dapsTokenRenewalThreshold = 0.666f;
    @NotNull
    private final Lazy trustManager$delegate = LazyKt.lazy((Function0)((Function0)new Function0<TrustManager>(this){
        final /* synthetic */ AisecDapsDriverConfig this$0;
        {
            this.this$0 = $receiver;
            super(0);
        }

        @NotNull
        public final TrustManager invoke() {
            TrustManager trustManager2 = AisecDapsDriverConfig.access$getTrustManagerInstance$p(this.this$0);
            if (trustManager2 == null) {
                Path path = this.this$0.getTrustStorePath();
                char[] cArray = AisecDapsDriverConfig.access$getTrustStorePassword$p(this.this$0);
                if (cArray == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"trustStorePassword");
                    cArray = null;
                }
                trustManager2 = PreConfiguration.INSTANCE.getX509ExtTrustManager(path, cArray);
            }
            return trustManager2;
        }
    }));
    public static final float DEFAULT_TOKEN_RENEWAL_THRESHOLD = 0.666f;

    @NotNull
    public final String getDapsUrl() {
        return this.dapsUrl;
    }

    @NotNull
    public final Path getTrustStorePath() {
        Path path = this.trustStorePath;
        if (path != null) {
            return path;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"trustStorePath");
        return null;
    }

    @NotNull
    public final char[] getKeyPassword() {
        if (this.keyPassword != null) {
            return this.keyPassword;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"keyPassword");
        return null;
    }

    @NotNull
    public final Path getKeyStorePath() {
        Path path = this.keyStorePath;
        if (path != null) {
            return path;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"keyStorePath");
        return null;
    }

    @NotNull
    public final char[] getKeyStorePassword() {
        if (this.keyStorePassword != null) {
            return this.keyStorePassword;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"keyStorePassword");
        return null;
    }

    @NotNull
    public final String getKeyAlias() {
        String string = this.keyAlias;
        if (string != null) {
            return string;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"keyAlias");
        return null;
    }

    @Nullable
    public final SecurityRequirements getSecurityRequirements() {
        return this.securityRequirements;
    }

    public final float getDapsTokenRenewalThreshold() {
        return this.dapsTokenRenewalThreshold;
    }

    public final void setDapsTokenRenewalThreshold(float f) {
        this.dapsTokenRenewalThreshold = f;
    }

    @NotNull
    public final TrustManager getTrustManager() {
        Lazy lazy = this.trustManager$delegate;
        return (TrustManager)lazy.getValue();
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0019\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0005\u001a\u00020\u0004J\u000e\u0010\u0006\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\t\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\bJ\u000e\u0010\u000b\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u000e\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u000f\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0012\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u001aJ\u000e\u0010\u001b\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u0011R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lde/fhg/aisec/ids/idscp2/defaultdrivers/daps/aisecdaps/AisecDapsDriverConfig$Builder;", "", "()V", "config", "Lde/fhg/aisec/ids/idscp2/defaultdrivers/daps/aisecdaps/AisecDapsDriverConfig;", "build", "setDapsUrl", "dapsUrl", "", "setKeyAlias", "alias", "setKeyPassword", "password", "", "setKeyStorePassword", "setKeyStorePath", "path", "Ljava/nio/file/Path;", "setSecurityRequirements", "securityRequirements", "Lde/fhg/aisec/ids/idscp2/defaultdrivers/daps/aisecdaps/SecurityRequirements;", "setTokenRenewalThreshold", "threshold", "", "setTrustManager", "trustManager", "Ljavax/net/ssl/TrustManager;", "setTrustStorePassword", "setTrustStorePath", "idscp2"})
    public static final class Builder {
        @NotNull
        private final AisecDapsDriverConfig config = new AisecDapsDriverConfig();

        @NotNull
        public final Builder setDapsUrl(@NotNull String dapsUrl) {
            Intrinsics.checkNotNullParameter((Object)dapsUrl, (String)"dapsUrl");
            this.config.dapsUrl = dapsUrl;
            return this;
        }

        @NotNull
        public final Builder setKeyStorePath(@NotNull Path path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            this.config.keyStorePath = path;
            return this;
        }

        @NotNull
        public final Builder setKeyStorePassword(@NotNull char[] password) {
            Intrinsics.checkNotNullParameter((Object)password, (String)"password");
            this.config.keyStorePassword = password;
            return this;
        }

        @NotNull
        public final Builder setKeyAlias(@NotNull String alias) {
            Intrinsics.checkNotNullParameter((Object)alias, (String)"alias");
            this.config.keyAlias = alias;
            return this;
        }

        @NotNull
        public final Builder setKeyPassword(@NotNull char[] password) {
            Intrinsics.checkNotNullParameter((Object)password, (String)"password");
            this.config.keyPassword = password;
            return this;
        }

        @NotNull
        public final Builder setTrustStorePath(@NotNull Path path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            this.config.trustStorePath = path;
            return this;
        }

        @NotNull
        public final Builder setTrustStorePassword(@NotNull char[] password) {
            Intrinsics.checkNotNullParameter((Object)password, (String)"password");
            this.config.trustStorePassword = password;
            return this;
        }

        @NotNull
        public final Builder setTrustManager(@NotNull TrustManager trustManager2) {
            Intrinsics.checkNotNullParameter((Object)trustManager2, (String)"trustManager");
            this.config.trustManagerInstance = trustManager2;
            return this;
        }

        @NotNull
        public final Builder setSecurityRequirements(@NotNull SecurityRequirements securityRequirements) {
            Intrinsics.checkNotNullParameter((Object)securityRequirements, (String)"securityRequirements");
            this.config.securityRequirements = securityRequirements;
            return this;
        }

        @NotNull
        public final Builder setTokenRenewalThreshold(float threshold) {
            if (0.0f < threshold && 1.0f >= threshold) {
                this.config.setDapsTokenRenewalThreshold(threshold);
            }
            return this;
        }

        @NotNull
        public final AisecDapsDriverConfig build() {
            if (this.config.trustManagerInstance == null && (this.config.trustStorePath == null || this.config.trustStorePassword == null)) {
                throw new Idscp2Exception("Cannot build AisecDapsDriverConfig: Neither trustManager, nor trustStorePath + trustStorePassword have been set!");
            }
            if (this.config.keyPassword == null) {
                throw new Idscp2Exception("Cannot build AisecDapsDriverConfig: keyPassword has not been set!");
            }
            if (this.config.keyStorePath == null) {
                throw new Idscp2Exception("Cannot build AisecDapsDriverConfig: keyStorePath has not been set!");
            }
            if (this.config.keyStorePassword == null) {
                throw new Idscp2Exception("Cannot build AisecDapsDriverConfig: keyStorePassword has not been set!");
            }
            if (this.config.keyAlias == null) {
                throw new Idscp2Exception("Cannot build AisecDapsDriverConfig: keyAlias has not been set!");
            }
            return this.config;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lde/fhg/aisec/ids/idscp2/defaultdrivers/daps/aisecdaps/AisecDapsDriverConfig$Companion;", "", "()V", "DEFAULT_TOKEN_RENEWAL_THRESHOLD", "", "idscp2"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

