/*
 * Decompiled with CFR 0.152.
 */
package de.fhg.aisec.ids.idscp2.core.fsm;

import de.fhg.aisec.ids.idscp2.core.drivers.DapsDriver;
import de.fhg.aisec.ids.idscp2.core.drivers.RaProverDriver;
import de.fhg.aisec.ids.idscp2.core.fsm.DynamicTimer;
import de.fhg.aisec.ids.idscp2.core.fsm.Event;
import de.fhg.aisec.ids.idscp2.core.fsm.FSM;
import de.fhg.aisec.ids.idscp2.core.fsm.InternalControlMessage;
import de.fhg.aisec.ids.idscp2.core.fsm.State;
import de.fhg.aisec.ids.idscp2.core.fsm.StaticTimer;
import de.fhg.aisec.ids.idscp2.core.fsm.Transition;
import de.fhg.aisec.ids.idscp2.core.messages.Idscp2MessageHelper;
import de.fhg.aisec.ids.idscp2.messages.IDSCP2;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u0002\u001a\u00020\u0003H\u0016\u00a8\u0006\u000f"}, d2={"Lde/fhg/aisec/ids/idscp2/core/fsm/StateWaitForDatAndRa;", "Lde/fhg/aisec/ids/idscp2/core/fsm/State;", "fsm", "Lde/fhg/aisec/ids/idscp2/core/fsm/FSM;", "handshakeTimer", "Lde/fhg/aisec/ids/idscp2/core/fsm/StaticTimer;", "proverHandshakeTimer", "datTimer", "Lde/fhg/aisec/ids/idscp2/core/fsm/DynamicTimer;", "dapsDriver", "Lde/fhg/aisec/ids/idscp2/core/drivers/DapsDriver;", "(Lde/fhg/aisec/ids/idscp2/core/fsm/FSM;Lde/fhg/aisec/ids/idscp2/core/fsm/StaticTimer;Lde/fhg/aisec/ids/idscp2/core/fsm/StaticTimer;Lde/fhg/aisec/ids/idscp2/core/fsm/DynamicTimer;Lde/fhg/aisec/ids/idscp2/core/drivers/DapsDriver;)V", "runEntryCode", "", "Companion", "idscp2"})
public final class StateWaitForDatAndRa
extends State {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final Logger LOG = LoggerFactory.getLogger(StateWaitForDatAndRa.class);

    public StateWaitForDatAndRa(final @NotNull FSM fsm, final @NotNull StaticTimer handshakeTimer, final @NotNull StaticTimer proverHandshakeTimer, final @NotNull DynamicTimer datTimer, final @NotNull DapsDriver dapsDriver) {
        Intrinsics.checkNotNullParameter((Object)fsm, (String)"fsm");
        Intrinsics.checkNotNullParameter((Object)handshakeTimer, (String)"handshakeTimer");
        Intrinsics.checkNotNullParameter((Object)proverHandshakeTimer, (String)"proverHandshakeTimer");
        Intrinsics.checkNotNullParameter((Object)datTimer, (String)"datTimer");
        Intrinsics.checkNotNullParameter((Object)dapsDriver, (String)"dapsDriver");
        this.addTransition(InternalControlMessage.IDSCP_STOP.getValue(), new Transition((Function1<? super Event, FSM.FsmResult>)((Function1)new Function1<Event, FSM.FsmResult>(){

            @NotNull
            public final FSM.FsmResult invoke(@NotNull Event it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Send IDSC_CLOSE");
                }
                fsm.sendFromFSM(Idscp2MessageHelper.INSTANCE.createIdscpCloseMessage("User close", IDSCP2.IdscpClose.CloseCause.USER_SHUTDOWN));
                return new FSM.FsmResult(FSM.FsmResultCode.OK, fsm.getState(FSM.FsmState.STATE_CLOSED));
            }
        })));
        this.addTransition(InternalControlMessage.ERROR.getValue(), new Transition((Function1<? super Event, FSM.FsmResult>)((Function1)new Function1<Event, FSM.FsmResult>(){

            @NotNull
            public final FSM.FsmResult invoke(@NotNull Event it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                LOG.warn("An internal control error occurred");
                return new FSM.FsmResult(FSM.FsmResultCode.OK, fsm.getState(FSM.FsmState.STATE_CLOSED));
            }
        })));
        this.addTransition(InternalControlMessage.REPEAT_RA.getValue(), new Transition((Function1<? super Event, FSM.FsmResult>)((Function1)new Function1<Event, FSM.FsmResult>(){

            @NotNull
            public final FSM.FsmResult invoke(@NotNull Event it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return new FSM.FsmResult(FSM.FsmResultCode.OK, this);
            }
        })));
        this.addTransition(InternalControlMessage.SEND_DATA.getValue(), new Transition((Function1<? super Event, FSM.FsmResult>)((Function1)new Function1<Event, FSM.FsmResult>(){

            @NotNull
            public final FSM.FsmResult invoke(@NotNull Event it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return new FSM.FsmResult(FSM.FsmResultCode.NOT_CONNECTED, this);
            }
        })));
        this.addTransition(InternalControlMessage.TIMEOUT.getValue(), new Transition((Function1<? super Event, FSM.FsmResult>)((Function1)new Function1<Event, FSM.FsmResult>(){

            @NotNull
            public final FSM.FsmResult invoke(@NotNull Event it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                LOG.warn("Handshake timeout occurred. Send IDSCP_CLOSE");
                fsm.sendFromFSM(Idscp2MessageHelper.INSTANCE.createIdscpCloseMessage("Handshake timeout", IDSCP2.IdscpClose.CloseCause.TIMEOUT));
                return new FSM.FsmResult(FSM.FsmResultCode.OK, fsm.getState(FSM.FsmState.STATE_CLOSED));
            }
        })));
        this.addTransition(InternalControlMessage.RA_PROVER_OK.getValue(), new Transition((Function1<? super Event, FSM.FsmResult>)((Function1)new Function1<Event, FSM.FsmResult>(){

            @NotNull
            public final FSM.FsmResult invoke(@NotNull Event it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Received RA_PROVER OK");
                }
                proverHandshakeTimer.cancelTimeout();
                return new FSM.FsmResult(FSM.FsmResultCode.OK, fsm.getState(FSM.FsmState.STATE_WAIT_FOR_DAT_AND_RA_VERIFIER));
            }
        })));
        this.addTransition(InternalControlMessage.RA_PROVER_FAILED.getValue(), new Transition((Function1<? super Event, FSM.FsmResult>)((Function1)new Function1<Event, FSM.FsmResult>(){

            @NotNull
            public final FSM.FsmResult invoke(@NotNull Event it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                LOG.warn("RA_PROVER failed. Send IDSCP_CLOSE");
                fsm.sendFromFSM(Idscp2MessageHelper.INSTANCE.createIdscpCloseMessage("RA_PROVER failed", IDSCP2.IdscpClose.CloseCause.RA_PROVER_FAILED));
                return new FSM.FsmResult(FSM.FsmResultCode.OK, fsm.getState(FSM.FsmState.STATE_CLOSED));
            }
        })));
        this.addTransition(InternalControlMessage.RA_PROVER_MSG.getValue(), new Transition((Function1<? super Event, FSM.FsmResult>)((Function1)new Function1<Event, FSM.FsmResult>(){

            @NotNull
            public final FSM.FsmResult invoke(@NotNull Event event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Send IDSCP_RA_PROVER");
                }
                if (!fsm.sendFromFSM(event.getIdscpMessage())) {
                    LOG.warn("Cannot send RA prover message");
                    return new FSM.FsmResult(FSM.FsmResultCode.IO_ERROR, fsm.getState(FSM.FsmState.STATE_CLOSED));
                }
                return new FSM.FsmResult(FSM.FsmResultCode.OK, this);
            }
        })));
        this.addTransition(2, new Transition((Function1<? super Event, FSM.FsmResult>)((Function1)new Function1<Event, FSM.FsmResult>(){

            @NotNull
            public final FSM.FsmResult invoke(@NotNull Event it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Received IDSCP_CLOSE");
                }
                return new FSM.FsmResult(FSM.FsmResultCode.OK, fsm.getState(FSM.FsmState.STATE_CLOSED));
            }
        })));
        this.addTransition(4, new Transition((Function1<? super Event, FSM.FsmResult>)((Function1)new Function1<Event, FSM.FsmResult>(){

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final FSM.FsmResult invoke(@NotNull Event event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                handshakeTimer.cancelTimeout();
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Verify received DAT");
                }
                byte[] dat = event.getIdscpMessage().getIdscpDat().getToken().toByteArray();
                long datValidityPeriod = 0L;
                try {
                    void it;
                    long l;
                    Intrinsics.checkNotNullExpressionValue((Object)dat, (String)"dat");
                    long l2 = l = dapsDriver.verifyToken(dat, fsm.getRemotePeerCertificate());
                    long l3 = 0L;
                    boolean bl = false;
                    datValidityPeriod = it;
                    Unit unit = Unit.INSTANCE;
                    if (l3 > l) {
                        if (LOG.isTraceEnabled()) {
                            LOG.trace("No valid remote DAT is available. Send IDSCP_CLOSE");
                        }
                        fsm.sendFromFSM(Idscp2MessageHelper.INSTANCE.createIdscpCloseMessage("No valid DAT", IDSCP2.IdscpClose.CloseCause.NO_VALID_DAT));
                        return new FSM.FsmResult(FSM.FsmResultCode.INVALID_DAT, fsm.getState(FSM.FsmState.STATE_CLOSED));
                    }
                }
                catch (Exception e) {
                    LOG.warn("DapsDriver has thrown Exception while validating remote DAT. Send IDSCP_CLOSE.", (Throwable)e);
                    fsm.sendFromFSM(Idscp2MessageHelper.INSTANCE.createIdscpCloseMessage("No valid DAT", IDSCP2.IdscpClose.CloseCause.NO_VALID_DAT));
                    return new FSM.FsmResult(FSM.FsmResultCode.INVALID_DAT, fsm.getState(FSM.FsmState.STATE_CLOSED));
                }
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Remote DAT is valid. Set dat timeout");
                }
                fsm.setPeerDat(dat);
                datTimer.resetTimeout(datValidityPeriod * (long)1000);
                if (!fsm.restartRaVerifierDriver()) {
                    LOG.warn("Cannot run RA verifier, close idscp connection");
                    return new FSM.FsmResult(FSM.FsmResultCode.RA_ERROR, fsm.getState(FSM.FsmState.STATE_CLOSED));
                }
                return new FSM.FsmResult(FSM.FsmResultCode.OK, fsm.getState(FSM.FsmState.STATE_WAIT_FOR_RA));
            }
        })));
        this.addTransition(3, new Transition((Function1<? super Event, FSM.FsmResult>)((Function1)new Function1<Event, FSM.FsmResult>(){

            @NotNull
            public final FSM.FsmResult invoke(@NotNull Event it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Peer is requesting a new DAT, followed by a re-attestation");
                }
                if (!fsm.sendFromFSM(Idscp2MessageHelper.INSTANCE.createIdscpDatMessage(fsm.getDynamicAttributeToken()))) {
                    LOG.warn("Cannot send Dat message");
                    return new FSM.FsmResult(FSM.FsmResultCode.IO_ERROR, fsm.getState(FSM.FsmState.STATE_CLOSED));
                }
                if (!fsm.restartRaProverDriver()) {
                    LOG.warn("Cannot run RA prover, close idscp connection");
                    return new FSM.FsmResult(FSM.FsmResultCode.RA_ERROR, fsm.getState(FSM.FsmState.STATE_CLOSED));
                }
                return new FSM.FsmResult(FSM.FsmResultCode.OK, this);
            }
        })));
        this.addTransition(7, new Transition((Function1<? super Event, FSM.FsmResult>)((Function1)new Function1<Event, FSM.FsmResult>(){

            @NotNull
            public final FSM.FsmResult invoke(@NotNull Event event) {
                CompletableFuture<Void> completableFuture;
                CompletableFuture<Void> completableFuture2;
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Delegate received IDSCP_RA_VERIFIER to RA_PROVER");
                }
                if (!event.getIdscpMessage().hasIdscpRaVerifier()) {
                    LOG.warn("IDSCP_RA_VERIFIER Message not available");
                    return new FSM.FsmResult(FSM.FsmResultCode.RA_ERROR, fsm.getState(FSM.FsmState.STATE_CLOSED));
                }
                RaProverDriver<?> raProverDriver = fsm.getRaProverDriver();
                if (raProverDriver != null) {
                    RaProverDriver<?> it = raProverDriver;
                    boolean bl = false;
                    completableFuture2 = CompletableFuture.runAsync(() -> 12.invoke$lambda-1$lambda-0(it, event));
                } else {
                    completableFuture2 = completableFuture = null;
                }
                if (completableFuture == null) {
                    StateWaitForDatAndRa stateWaitForDatAndRa = this;
                    FSM fSM = fsm;
                    StateWaitForDatAndRa $this$invoke_u24lambda_u2d2 = stateWaitForDatAndRa;
                    boolean bl = false;
                    LOG.warn("RaProverDriver not available");
                    return new FSM.FsmResult(FSM.FsmResultCode.RA_ERROR, fSM.getState(FSM.FsmState.STATE_CLOSED));
                }
                return new FSM.FsmResult(FSM.FsmResultCode.OK, this);
            }

            private static final void invoke$lambda-1$lambda-0(RaProverDriver $it, Event $event) {
                Intrinsics.checkNotNullParameter((Object)$it, (String)"$it");
                Intrinsics.checkNotNullParameter((Object)$event, (String)"$event");
                byte[] byArray = $event.getIdscpMessage().getIdscpRaVerifier().getData().toByteArray();
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"event.idscpMessage.idscp\u2026rifier.data.toByteArray()");
                $it.delegate(byArray);
            }
        })));
        this.addTransition(5, new Transition((Function1<? super Event, FSM.FsmResult>)((Function1)new Function1<Event, FSM.FsmResult>(){

            @NotNull
            public final FSM.FsmResult invoke(@NotNull Event it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Peer is requesting a re-attestation");
                }
                if (!fsm.restartRaProverDriver()) {
                    LOG.warn("Cannot run RA prover, close idscp connection");
                    return new FSM.FsmResult(FSM.FsmResultCode.RA_ERROR, fsm.getState(FSM.FsmState.STATE_CLOSED));
                }
                return new FSM.FsmResult(FSM.FsmResultCode.OK, this);
            }
        })));
        this.addTransition(9, new Transition((Function1<? super Event, FSM.FsmResult>)((Function1)new Function1<Event, FSM.FsmResult>(){

            @NotNull
            public final FSM.FsmResult invoke(@NotNull Event it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                IDSCP2.IdscpAck idscpAck = it.getIdscpMessage().getIdscpAck();
                Intrinsics.checkNotNullExpressionValue((Object)idscpAck, (String)"it.idscpMessage.idscpAck");
                fsm.recvAck(idscpAck);
                return new FSM.FsmResult(FSM.FsmResultCode.OK, this);
            }
        })));
        this.setNoTransitionHandler(arg_0 -> StateWaitForDatAndRa._init_$lambda-0(this, arg_0));
    }

    @Override
    public void runEntryCode(@NotNull FSM fsm) {
        Intrinsics.checkNotNullParameter((Object)fsm, (String)"fsm");
        if (LOG.isTraceEnabled()) {
            LOG.trace("Switched to state STATE_WAIT_FOR_DAT_AND_RA");
        }
    }

    private static final FSM.FsmResult _init_$lambda-0(StateWaitForDatAndRa this$0, Event it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (LOG.isTraceEnabled()) {
            LOG.trace("No transition available for given event " + it);
        }
        return new FSM.FsmResult(FSM.FsmResultCode.UNKNOWN_TRANSITION, this$0);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lde/fhg/aisec/ids/idscp2/core/fsm/StateWaitForDatAndRa$Companion;", "", "()V", "LOG", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "idscp2"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

