/*
 * Decompiled with CFR 0.152.
 */
package de.fhg.aisec.ids.idscp2.core.fsm;

import de.fhg.aisec.ids.idscp2.core.fsm.AlternatingBit;
import de.fhg.aisec.ids.idscp2.core.fsm.Event;
import de.fhg.aisec.ids.idscp2.core.fsm.FSM;
import de.fhg.aisec.ids.idscp2.core.fsm.InternalControlMessage;
import de.fhg.aisec.ids.idscp2.core.fsm.State;
import de.fhg.aisec.ids.idscp2.core.fsm.StaticTimer;
import de.fhg.aisec.ids.idscp2.core.fsm.Transition;
import de.fhg.aisec.ids.idscp2.core.messages.Idscp2MessageHelper;
import de.fhg.aisec.ids.idscp2.messages.IDSCP2;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 \r2\u00020\u0001:\u0001\rB-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0002\u001a\u00020\u0003H\u0016\u00a8\u0006\u000e"}, d2={"Lde/fhg/aisec/ids/idscp2/core/fsm/StateEstablished;", "Lde/fhg/aisec/ids/idscp2/core/fsm/State;", "fsm", "Lde/fhg/aisec/ids/idscp2/core/fsm/FSM;", "raTimer", "Lde/fhg/aisec/ids/idscp2/core/fsm/StaticTimer;", "handshakeTimer", "ackTimer", "alternatingBit", "Lde/fhg/aisec/ids/idscp2/core/fsm/AlternatingBit;", "(Lde/fhg/aisec/ids/idscp2/core/fsm/FSM;Lde/fhg/aisec/ids/idscp2/core/fsm/StaticTimer;Lde/fhg/aisec/ids/idscp2/core/fsm/StaticTimer;Lde/fhg/aisec/ids/idscp2/core/fsm/StaticTimer;Lde/fhg/aisec/ids/idscp2/core/fsm/AlternatingBit;)V", "runEntryCode", "", "Companion", "idscp2"})
public final class StateEstablished
extends State {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final Logger LOG = LoggerFactory.getLogger(StateEstablished.class);

    public StateEstablished(final @NotNull FSM fsm, final @NotNull StaticTimer raTimer, final @NotNull StaticTimer handshakeTimer, final @NotNull StaticTimer ackTimer, final @NotNull AlternatingBit alternatingBit) {
        Intrinsics.checkNotNullParameter((Object)fsm, (String)"fsm");
        Intrinsics.checkNotNullParameter((Object)raTimer, (String)"raTimer");
        Intrinsics.checkNotNullParameter((Object)handshakeTimer, (String)"handshakeTimer");
        Intrinsics.checkNotNullParameter((Object)ackTimer, (String)"ackTimer");
        Intrinsics.checkNotNullParameter((Object)alternatingBit, (String)"alternatingBit");
        this.addTransition(InternalControlMessage.ERROR.getValue(), new Transition((Function1<? super Event, FSM.FsmResult>)((Function1)new Function1<Event, FSM.FsmResult>(){

            @NotNull
            public final FSM.FsmResult invoke(@NotNull Event it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                LOG.warn("Error occurred, close idscp connection");
                return new FSM.FsmResult(FSM.FsmResultCode.OK, fsm.getState(FSM.FsmState.STATE_CLOSED));
            }
        })));
        this.addTransition(InternalControlMessage.IDSCP_STOP.getValue(), new Transition((Function1<? super Event, FSM.FsmResult>)((Function1)new Function1<Event, FSM.FsmResult>(){

            @NotNull
            public final FSM.FsmResult invoke(@NotNull Event it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Send IDSCP_CLOSE");
                }
                fsm.sendFromFSM(Idscp2MessageHelper.INSTANCE.createIdscpCloseMessage("User close", IDSCP2.IdscpClose.CloseCause.USER_SHUTDOWN));
                return new FSM.FsmResult(FSM.FsmResultCode.OK, fsm.getState(FSM.FsmState.STATE_CLOSED));
            }
        })));
        this.addTransition(InternalControlMessage.SEND_DATA.getValue(), new Transition((Function1<? super Event, FSM.FsmResult>)((Function1)new Function1<Event, FSM.FsmResult>(){

            @NotNull
            public final FSM.FsmResult invoke(@NotNull Event it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                IDSCP2.IdscpMessage idscpMessage = Idscp2MessageHelper.INSTANCE.createIdscpDataMessageWithAltBit(it.getIdscpMessage().getIdscpData().getData().toByteArray(), alternatingBit);
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Send IdscpData");
                }
                if (fsm.sendFromFSM(idscpMessage)) {
                    fsm.setAckFlag(true);
                    fsm.setBufferedIdscpData(idscpMessage);
                    ackTimer.start();
                    return new FSM.FsmResult(FSM.FsmResultCode.OK, fsm.getState(FSM.FsmState.STATE_WAIT_FOR_ACK));
                }
                LOG.warn("Cannot send IdscpData, shutdown FSM");
                return new FSM.FsmResult(FSM.FsmResultCode.IO_ERROR, fsm.getState(FSM.FsmState.STATE_CLOSED));
            }
        })));
        this.addTransition(InternalControlMessage.REPEAT_RA.getValue(), new Transition((Function1<? super Event, FSM.FsmResult>)((Function1)new Function1<Event, FSM.FsmResult>(){

            @NotNull
            public final FSM.FsmResult invoke(@NotNull Event it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Re-Attestation triggered");
                }
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Send IDSCP_RERA, start RA_VERIFIER");
                }
                raTimer.cancelTimeout();
                if (!fsm.sendFromFSM(Idscp2MessageHelper.INSTANCE.createIdscpReRaMessage(""))) {
                    LOG.warn("Cannot send ReRa message");
                    return new FSM.FsmResult(FSM.FsmResultCode.IO_ERROR, fsm.getState(FSM.FsmState.STATE_CLOSED));
                }
                if (!fsm.restartRaVerifierDriver()) {
                    LOG.warn("Cannot run Ra verifier, close idscp connection");
                    return new FSM.FsmResult(FSM.FsmResultCode.RA_ERROR, fsm.getState(FSM.FsmState.STATE_CLOSED));
                }
                return new FSM.FsmResult(FSM.FsmResultCode.OK, fsm.getState(FSM.FsmState.STATE_WAIT_FOR_RA_VERIFIER));
            }
        })));
        this.addTransition(InternalControlMessage.DAT_TIMER_EXPIRED.getValue(), new Transition((Function1<? super Event, FSM.FsmResult>)((Function1)new Function1<Event, FSM.FsmResult>(){

            @NotNull
            public final FSM.FsmResult invoke(@NotNull Event it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                raTimer.cancelTimeout();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("DAT expired, request new DAT from peer and trigger a re-attestation");
                }
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Send IDSCP_DAT_EXPIRED");
                }
                if (!fsm.sendFromFSM(Idscp2MessageHelper.INSTANCE.createIdscpDatExpiredMessage())) {
                    LOG.warn("Cannot send DatExpired message");
                    return new FSM.FsmResult(FSM.FsmResultCode.IO_ERROR, fsm.getState(FSM.FsmState.STATE_CLOSED));
                }
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Set handshake timeout");
                }
                handshakeTimer.resetTimeout();
                return new FSM.FsmResult(FSM.FsmResultCode.OK, fsm.getState(FSM.FsmState.STATE_WAIT_FOR_DAT_AND_RA_VERIFIER));
            }
        })));
        this.addTransition(5, new Transition((Function1<? super Event, FSM.FsmResult>)((Function1)new Function1<Event, FSM.FsmResult>(){

            @NotNull
            public final FSM.FsmResult invoke(@NotNull Event it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Peer is requesting a re-attestation");
                }
                if (!fsm.restartRaProverDriver()) {
                    LOG.warn("Cannot run Ra prover, close idscp connection");
                    return new FSM.FsmResult(FSM.FsmResultCode.RA_ERROR, fsm.getState(FSM.FsmState.STATE_CLOSED));
                }
                return new FSM.FsmResult(FSM.FsmResultCode.OK, fsm.getState(FSM.FsmState.STATE_WAIT_FOR_RA_PROVER));
            }
        })));
        this.addTransition(3, new Transition((Function1<? super Event, FSM.FsmResult>)((Function1)new Function1<Event, FSM.FsmResult>(){

            @NotNull
            public final FSM.FsmResult invoke(@NotNull Event it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Peer is requesting a new DAT, followed by a re-attestation");
                }
                if (!fsm.sendFromFSM(Idscp2MessageHelper.INSTANCE.createIdscpDatMessage(fsm.getDynamicAttributeToken()))) {
                    LOG.warn("Cannot send Dat message");
                    return new FSM.FsmResult(FSM.FsmResultCode.IO_ERROR, fsm.getState(FSM.FsmState.STATE_CLOSED));
                }
                if (!fsm.restartRaProverDriver()) {
                    LOG.warn("Cannot run Ra prover, close idscp connection");
                    return new FSM.FsmResult(FSM.FsmResultCode.RA_ERROR, fsm.getState(FSM.FsmState.STATE_CLOSED));
                }
                return new FSM.FsmResult(FSM.FsmResultCode.OK, fsm.getState(FSM.FsmState.STATE_WAIT_FOR_RA_PROVER));
            }
        })));
        this.addTransition(8, new Transition((Function1<? super Event, FSM.FsmResult>)((Function1)new Function1<Event, FSM.FsmResult>(){

            @NotNull
            public final FSM.FsmResult invoke(@NotNull Event it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                IDSCP2.IdscpData idscpData = it.getIdscpMessage().getIdscpData();
                Intrinsics.checkNotNullExpressionValue((Object)idscpData, (String)"it.idscpMessage.idscpData");
                fsm.recvData(idscpData);
                return new FSM.FsmResult(FSM.FsmResultCode.OK, this);
            }
        })));
        this.addTransition(2, new Transition((Function1<? super Event, FSM.FsmResult>)((Function1)new Function1<Event, FSM.FsmResult>(){

            @NotNull
            public final FSM.FsmResult invoke(@NotNull Event it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Receive IDSCP_CLOSED");
                }
                return new FSM.FsmResult(FSM.FsmResultCode.OK, fsm.getState(FSM.FsmState.STATE_CLOSED));
            }
        })));
        this.setNoTransitionHandler(arg_0 -> StateEstablished._init_$lambda-0(this, arg_0));
    }

    @Override
    public void runEntryCode(@NotNull FSM fsm) {
        Intrinsics.checkNotNullParameter((Object)fsm, (String)"fsm");
        if (LOG.isTraceEnabled()) {
            LOG.trace("Switched to state STATE_ESTABLISHED");
        }
        fsm.notifyHandshakeCompleteLock();
    }

    private static final FSM.FsmResult _init_$lambda-0(StateEstablished this$0, Event it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (LOG.isTraceEnabled()) {
            LOG.trace("No transition available for given event " + it + ", stay in state STATE_ESTABLISHED");
        }
        return new FSM.FsmResult(FSM.FsmResultCode.UNKNOWN_TRANSITION, this$0);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lde/fhg/aisec/ids/idscp2/core/fsm/StateEstablished$Companion;", "", "()V", "LOG", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "idscp2"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

