/*
 * Decompiled with CFR 0.152.
 */
package de.fhg.aisec.ids.idscp2.idscp_core.api.idscp_server;

import de.fhg.aisec.ids.idscp2.idscp_core.api.Idscp2EndpointListener;
import de.fhg.aisec.ids.idscp2.idscp_core.api.configuration.Idscp2Configuration;
import de.fhg.aisec.ids.idscp2.idscp_core.api.idscp_connection.Idscp2Connection;
import de.fhg.aisec.ids.idscp2.idscp_core.api.idscp_server.Idscp2Server;
import de.fhg.aisec.ids.idscp2.idscp_core.drivers.SecureChannelDriver;
import de.fhg.aisec.ids.idscp2.idscp_core.drivers.SecureServer;
import de.fhg.aisec.ids.idscp2.idscp_core.error.Idscp2Exception;
import de.fhg.aisec.ids.idscp2.idscp_core.fsm.FSM;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u0014*\b\b\u0000\u0010\u0001*\u00020\u0002*\u0004\b\u0001\u0010\u00032\u00020\u0004:\u0001\u0014BQ\u0012\u0018\u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00028\u00000\u0006\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u000e\u0012\u0006\u0010\u000f\u001a\u00028\u0001\u00a2\u0006\u0002\u0010\u0010J\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00000\u0013R \u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00028\u00000\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u00028\u0001X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0011R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lde/fhg/aisec/ids/idscp2/idscp_core/api/idscp_server/Idscp2ServerFactory;", "CC", "Lde/fhg/aisec/ids/idscp2/idscp_core/api/idscp_connection/Idscp2Connection;", "SecureChannelConfiguration", "", "connectionFactory", "Lkotlin/Function2;", "Lde/fhg/aisec/ids/idscp2/idscp_core/fsm/FSM;", "", "endpointListener", "Lde/fhg/aisec/ids/idscp2/idscp_core/api/Idscp2EndpointListener;", "serverConfiguration", "Lde/fhg/aisec/ids/idscp2/idscp_core/api/configuration/Idscp2Configuration;", "secureChannelDriver", "Lde/fhg/aisec/ids/idscp2/idscp_core/drivers/SecureChannelDriver;", "secureChannelConfig", "(Lkotlin/jvm/functions/Function2;Lde/fhg/aisec/ids/idscp2/idscp_core/api/Idscp2EndpointListener;Lde/fhg/aisec/ids/idscp2/idscp_core/api/configuration/Idscp2Configuration;Lde/fhg/aisec/ids/idscp2/idscp_core/drivers/SecureChannelDriver;Ljava/lang/Object;)V", "Ljava/lang/Object;", "listen", "Lde/fhg/aisec/ids/idscp2/idscp_core/api/idscp_server/Idscp2Server;", "Companion", "idscp2"})
public final class Idscp2ServerFactory<CC extends Idscp2Connection, SecureChannelConfiguration> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Function2<FSM, String, CC> connectionFactory;
    @NotNull
    private final Idscp2EndpointListener<CC> endpointListener;
    @NotNull
    private final Idscp2Configuration serverConfiguration;
    @NotNull
    private final SecureChannelDriver<CC, SecureChannelConfiguration> secureChannelDriver;
    private final SecureChannelConfiguration secureChannelConfig;
    private static final Logger LOG = LoggerFactory.getLogger(Idscp2ServerFactory.class);

    public Idscp2ServerFactory(@NotNull Function2<? super FSM, ? super String, ? extends CC> connectionFactory, @NotNull Idscp2EndpointListener<CC> endpointListener, @NotNull Idscp2Configuration serverConfiguration, @NotNull SecureChannelDriver<CC, SecureChannelConfiguration> secureChannelDriver, SecureChannelConfiguration secureChannelConfig) {
        Intrinsics.checkNotNullParameter(connectionFactory, (String)"connectionFactory");
        Intrinsics.checkNotNullParameter(endpointListener, (String)"endpointListener");
        Intrinsics.checkNotNullParameter((Object)serverConfiguration, (String)"serverConfiguration");
        Intrinsics.checkNotNullParameter(secureChannelDriver, (String)"secureChannelDriver");
        this.connectionFactory = connectionFactory;
        this.endpointListener = endpointListener;
        this.serverConfiguration = serverConfiguration;
        this.secureChannelDriver = secureChannelDriver;
        this.secureChannelConfig = secureChannelConfig;
    }

    @NotNull
    public final Idscp2Server<CC> listen() throws Idscp2Exception {
        if (LOG.isInfoEnabled()) {
            LOG.info("Starting new IDSCP2 server");
        }
        CompletableFuture connectionListenerPromise = new CompletableFuture();
        SecureServer secureServer = this.secureChannelDriver.listen(connectionListenerPromise, this.secureChannelConfig, this.serverConfiguration, this.connectionFactory);
        Idscp2Server<CC> server = new Idscp2Server<CC>(secureServer, this.endpointListener);
        connectionListenerPromise.complete(server);
        return server;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lde/fhg/aisec/ids/idscp2/idscp_core/api/idscp_server/Idscp2ServerFactory$Companion;", "", "()V", "LOG", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "idscp2"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

