/*
 * Decompiled with CFR 0.152.
 */
package de.fhg.aisec.ids.idscp2.default_drivers.secure_channel.tlsv1_3.server;

import de.fhg.aisec.ids.idscp2.default_drivers.secure_channel.tlsv1_3.NativeTlsConfiguration;
import de.fhg.aisec.ids.idscp2.default_drivers.secure_channel.tlsv1_3.TLSSessionVerificationHelper;
import de.fhg.aisec.ids.idscp2.idscp_core.FastLatch;
import de.fhg.aisec.ids.idscp2.idscp_core.api.configuration.Idscp2Configuration;
import de.fhg.aisec.ids.idscp2.idscp_core.api.idscp_connection.Idscp2Connection;
import de.fhg.aisec.ids.idscp2.idscp_core.drivers.SecureChannelEndpoint;
import de.fhg.aisec.ids.idscp2.idscp_core.error.Idscp2Exception;
import de.fhg.aisec.ids.idscp2.idscp_core.fsm.AsyncIdscp2Factory;
import de.fhg.aisec.ids.idscp2.idscp_core.fsm.FSM;
import de.fhg.aisec.ids.idscp2.idscp_core.secure_channel.SecureChannel;
import de.fhg.aisec.ids.idscp2.idscp_core.secure_channel.SecureChannelListener;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.concurrent.CompletableFuture;
import javax.net.ssl.HandshakeCompletedEvent;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0005\u0018\u0000 0*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u00032\u00020\u00042\u00020\u00052\u00020\u0006:\u00010BG\b\u0000\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0018\u0010\u000f\u001a\u0014\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00028\u00000\u0010\u00a2\u0006\u0002\u0010\u0013J\b\u0010 \u001a\u00020!H\u0016J\b\u0010\"\u001a\u00020!H\u0002J\u0010\u0010#\u001a\u00020!2\u0006\u0010$\u001a\u00020%H\u0016J\b\u0010&\u001a\u00020!H\u0002J\u0010\u0010'\u001a\u00020!2\u0006\u0010(\u001a\u00020)H\u0002J\u000e\u0010*\u001a\u00020!2\u0006\u0010+\u001a\u00020,J\b\u0010-\u001a\u00020!H\u0016J\b\u0010.\u001a\u00020!H\u0002J\u0010\u0010/\u001a\u00020\u00172\u0006\u0010+\u001a\u00020,H\u0016R \u0010\u000f\u001a\u0014\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00028\u00000\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\u00020\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0018R\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lde/fhg/aisec/ids/idscp2/default_drivers/secure_channel/tlsv1_3/server/TLSServerThread;", "CC", "Lde/fhg/aisec/ids/idscp2/idscp_core/api/idscp_connection/Idscp2Connection;", "Ljava/lang/Thread;", "Ljavax/net/ssl/HandshakeCompletedListener;", "Lde/fhg/aisec/ids/idscp2/idscp_core/drivers/SecureChannelEndpoint;", "Ljava/io/Closeable;", "sslSocket", "Ljavax/net/ssl/SSLSocket;", "connectionFuture", "Ljava/util/concurrent/CompletableFuture;", "nativeTlsConfiguration", "Lde/fhg/aisec/ids/idscp2/default_drivers/secure_channel/tlsv1_3/NativeTlsConfiguration;", "serverConfiguration", "Lde/fhg/aisec/ids/idscp2/idscp_core/api/configuration/Idscp2Configuration;", "connectionFactory", "Lkotlin/Function2;", "Lde/fhg/aisec/ids/idscp2/idscp_core/fsm/FSM;", "", "(Ljavax/net/ssl/SSLSocket;Ljava/util/concurrent/CompletableFuture;Lde/fhg/aisec/ids/idscp2/default_drivers/secure_channel/tlsv1_3/NativeTlsConfiguration;Lde/fhg/aisec/ids/idscp2/idscp_core/api/configuration/Idscp2Configuration;Lkotlin/jvm/functions/Function2;)V", "in", "Ljava/io/DataInputStream;", "isConnected", "", "()Z", "listenerPromise", "Lde/fhg/aisec/ids/idscp2/idscp_core/secure_channel/SecureChannelListener;", "out", "Ljava/io/DataOutputStream;", "running", "tlsVerificationLatch", "Lde/fhg/aisec/ids/idscp2/idscp_core/FastLatch;", "close", "", "closeSockets", "handshakeCompleted", "handshakeCompletedEvent", "Ljavax/net/ssl/HandshakeCompletedEvent;", "onClose", "onError", "t", "", "onMessage", "bytes", "", "run", "safeStop", "send", "Companion", "idscp2"})
public final class TLSServerThread<CC extends Idscp2Connection>
extends Thread
implements HandshakeCompletedListener,
SecureChannelEndpoint,
Closeable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SSLSocket sslSocket;
    @NotNull
    private final CompletableFuture<CC> connectionFuture;
    @NotNull
    private final NativeTlsConfiguration nativeTlsConfiguration;
    @NotNull
    private final Idscp2Configuration serverConfiguration;
    @NotNull
    private final Function2<FSM, String, CC> connectionFactory;
    private volatile boolean running;
    @NotNull
    private final DataInputStream in;
    @NotNull
    private final DataOutputStream out;
    @NotNull
    private final CompletableFuture<SecureChannelListener> listenerPromise;
    @NotNull
    private final FastLatch tlsVerificationLatch;
    private static final Logger LOG = LoggerFactory.getLogger(TLSServerThread.class);

    public TLSServerThread(@NotNull SSLSocket sslSocket, @NotNull CompletableFuture<CC> connectionFuture, @NotNull NativeTlsConfiguration nativeTlsConfiguration, @NotNull Idscp2Configuration serverConfiguration, @NotNull Function2<? super FSM, ? super String, ? extends CC> connectionFactory) {
        Intrinsics.checkNotNullParameter((Object)sslSocket, (String)"sslSocket");
        Intrinsics.checkNotNullParameter(connectionFuture, (String)"connectionFuture");
        Intrinsics.checkNotNullParameter((Object)nativeTlsConfiguration, (String)"nativeTlsConfiguration");
        Intrinsics.checkNotNullParameter((Object)serverConfiguration, (String)"serverConfiguration");
        Intrinsics.checkNotNullParameter(connectionFactory, (String)"connectionFactory");
        this.sslSocket = sslSocket;
        this.connectionFuture = connectionFuture;
        this.nativeTlsConfiguration = nativeTlsConfiguration;
        this.serverConfiguration = serverConfiguration;
        this.connectionFactory = connectionFactory;
        this.running = true;
        this.listenerPromise = new CompletableFuture();
        this.tlsVerificationLatch = new FastLatch();
        this.sslSocket.setSoTimeout(this.nativeTlsConfiguration.getSocketTimeout());
        this.in = new DataInputStream(this.sslSocket.getInputStream());
        this.out = new DataOutputStream(this.sslSocket.getOutputStream());
    }

    @Override
    public void run() {
        try {
            this.sslSocket.startHandshake();
            this.tlsVerificationLatch.await();
        }
        catch (Exception e) {
            this.running = false;
            this.connectionFuture.completeExceptionally(new Idscp2Exception("TLS handshake failed", e));
            return;
        }
        byte[] buf = null;
        while (this.running) {
            try {
                int len = this.in.readInt();
                buf = new byte[len];
                this.in.readFully(buf, 0, len);
                this.onMessage(buf);
            }
            catch (SocketTimeoutException len) {
            }
            catch (EOFException e) {
                this.onClose();
                this.running = false;
            }
            catch (Exception e) {
                this.onError(e);
                this.running = false;
            }
        }
        this.closeSockets();
    }

    private final void closeSockets() {
        try {
            this.out.close();
            this.in.close();
            this.sslSocket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public boolean send(@NotNull byte[] bytes) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        if (!this.isConnected()) {
            LOG.warn("Server cannot send data because socket is not connected");
            this.closeSockets();
            bl = false;
        } else {
            boolean bl2;
            try {
                this.out.writeInt(bytes.length);
                this.out.write(bytes);
                this.out.flush();
                bl2 = true;
            }
            catch (Exception e) {
                LOG.warn("Server could not send data", (Throwable)e);
                bl2 = false;
            }
            bl = bl2;
        }
        return bl;
    }

    private final void onClose() {
        this.listenerPromise.thenAccept(TLSServerThread::onClose$lambda-0);
    }

    private final void onError(Throwable t) {
        this.listenerPromise.thenAccept(arg_0 -> TLSServerThread.onError$lambda-1(t, arg_0));
    }

    public final void onMessage(@NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        this.listenerPromise.thenAccept(arg_0 -> TLSServerThread.onMessage$lambda-2(bytes, arg_0));
    }

    @Override
    public void close() {
        this.safeStop();
    }

    private final void safeStop() {
        this.running = false;
    }

    @Override
    public boolean isConnected() {
        return this.sslSocket.isConnected();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handshakeCompleted(@NotNull HandshakeCompletedEvent handshakeCompletedEvent) {
        Intrinsics.checkNotNullParameter((Object)handshakeCompletedEvent, (String)"handshakeCompletedEvent");
        if (LOG.isTraceEnabled()) {
            LOG.trace("TLS Handshake was successful");
        }
        try {
            SSLSession sslSession = handshakeCompletedEvent.getSession();
            Certificate[] certificates = sslSession.getPeerCertificates();
            Intrinsics.checkNotNullExpressionValue((Object)certificates, (String)"certificates");
            if (certificates.length == 0) {
                throw new SSLPeerUnverifiedException("Missing peer certificate");
            }
            Certificate certificate = certificates[0];
            if (certificate == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.security.cert.X509Certificate");
            }
            X509Certificate peerCert = (X509Certificate)certificate;
            String string = sslSession.getPeerHost();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sslSession.peerHost");
            TLSSessionVerificationHelper.INSTANCE.verifyTlsSession(string, sslSession.getPeerPort(), peerCert, this.nativeTlsConfiguration.getHostnameVerificationEnabled(), false);
            if (LOG.isTraceEnabled()) {
                LOG.trace("TLS session is valid");
            }
            SecureChannel secureChannel = new SecureChannel(this, peerCert);
            this.listenerPromise.complete(secureChannel);
            AsyncIdscp2Factory.INSTANCE.initiateIdscp2Connection(secureChannel, this.serverConfiguration, this.connectionFactory, this.connectionFuture);
        }
        catch (Exception e) {
            this.running = false;
            this.connectionFuture.completeExceptionally(new Idscp2Exception("TLS session was not valid", e));
        }
        finally {
            this.tlsVerificationLatch.unlock();
        }
    }

    private static final void onClose$lambda-0(SecureChannelListener obj) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        obj.onClose();
    }

    private static final void onError$lambda-1(Throwable $t, SecureChannelListener obj) {
        Intrinsics.checkNotNullParameter((Object)$t, (String)"$t");
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        obj.onError($t);
    }

    private static final void onMessage$lambda-2(byte[] $bytes, SecureChannelListener listener) {
        Intrinsics.checkNotNullParameter((Object)$bytes, (String)"$bytes");
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        listener.onMessage($bytes);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lde/fhg/aisec/ids/idscp2/default_drivers/secure_channel/tlsv1_3/server/TLSServerThread$Companion;", "", "()V", "LOG", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "idscp2"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

