/*
 * Decompiled with CFR 0.152.
 */
package de.fhg.aisec.ids.idscp2.default_drivers.secure_channel.tlsv1_3.client;

import de.fhg.aisec.ids.idscp2.default_drivers.secure_channel.tlsv1_3.client.DataAvailableListener;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.InputStream;
import java.net.SocketTimeoutException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000b\u001a\u00020\fH\u0016J\u0006\u0010\r\u001a\u00020\fR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lde/fhg/aisec/ids/idscp2/default_drivers/secure_channel/tlsv1_3/client/InputListenerThread;", "Ljava/lang/Thread;", "inputStream", "Ljava/io/InputStream;", "listener", "Lde/fhg/aisec/ids/idscp2/default_drivers/secure_channel/tlsv1_3/client/DataAvailableListener;", "(Ljava/io/InputStream;Lde/fhg/aisec/ids/idscp2/default_drivers/secure_channel/tlsv1_3/client/DataAvailableListener;)V", "dataInputStream", "Ljava/io/DataInputStream;", "running", "", "run", "", "safeStop", "idscp2"})
public final class InputListenerThread
extends Thread {
    @NotNull
    private DataAvailableListener listener;
    @NotNull
    private final DataInputStream dataInputStream;
    private volatile boolean running;

    public InputListenerThread(@NotNull InputStream inputStream, @NotNull DataAvailableListener listener) {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.listener = listener;
        this.dataInputStream = new DataInputStream(inputStream);
        this.running = true;
    }

    @Override
    public void run() {
        byte[] buf = null;
        while (this.running) {
            try {
                int len = this.dataInputStream.readInt();
                buf = new byte[len];
                this.dataInputStream.readFully(buf, 0, len);
                this.listener.onMessage(buf);
            }
            catch (SocketTimeoutException len) {
            }
            catch (EOFException e) {
                this.listener.onClose();
                this.running = false;
            }
            catch (Exception e) {
                this.listener.onError(e);
                this.running = false;
            }
        }
        try {
            this.dataInputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public final void safeStop() {
        this.running = false;
    }
}

