/*
 * Decompiled with CFR 0.152.
 */
package de.fhg.aisec.ids.idscp2.default_drivers.secure_channel.tlsv1_3;

import java.net.InetAddress;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.SSLPeerUnverifiedException;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00070\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00070\fH\u0002J\u0010\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0007H\u0002J2\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\n2\b\b\u0002\u0010\u0017\u001a\u00020\nH\u0007R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lde/fhg/aisec/ids/idscp2/default_drivers/secure_channel/tlsv1_3/TLSSessionVerificationHelper;", "", "()V", "LOG", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "ipv4Pattern", "", "ipv6Pattern", "checkHostname", "", "dnsNameLabels", "", "hostNameLabels", "isIpAddress", "host", "verifyTlsSession", "", "port", "", "peerCert", "Ljava/security/cert/X509Certificate;", "hostnameVerificationEnabled", "peerIsServer", "idscp2"})
public final class TLSSessionVerificationHelper {
    @NotNull
    public static final TLSSessionVerificationHelper INSTANCE = new TLSSessionVerificationHelper();
    private static final Logger LOG = LoggerFactory.getLogger(TLSSessionVerificationHelper.class);
    @NotNull
    private static final String ipv4Pattern = "(([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.){3}([01]?\\d\\d?|2[0-4]\\d|25[0-5])";
    @NotNull
    private static final String ipv6Pattern = "([0-9a-f]{1,4}:){7}([0-9a-f]){1,4}";

    private TLSSessionVerificationHelper() {
    }

    @JvmOverloads
    public final void verifyTlsSession(@NotNull String host, int port, @NotNull X509Certificate peerCert, boolean hostnameVerificationEnabled, boolean peerIsServer) throws SSLPeerUnverifiedException {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Intrinsics.checkNotNullParameter((Object)peerCert, (String)"peerCert");
        if (LOG.isTraceEnabled()) {
            LOG.trace("Connected to {}:{}", (Object)host, (Object)port);
        }
        try {
            if (hostnameVerificationEnabled) {
                String[] $this$map$iv;
                Collection<List<?>> collection = peerCert.getSubjectAlternativeNames();
                if (collection == null) {
                    throw new SSLPeerUnverifiedException("No Subject alternative names for hostname verification provided");
                }
                Collection<List<?>> sans = collection;
                ArrayList<Object> acceptedDnsNames = new ArrayList<Object>();
                ArrayList<Object> acceptedIpAddresses = new ArrayList<Object>();
                for (List<?> subjectAltName : sans) {
                    Integer object;
                    if (subjectAltName.size() != 2) continue;
                    Object value = subjectAltName.get(1);
                    Integer n = object = (Integer)subjectAltName.get(0);
                    int n2 = 2;
                    if (n != null && n == n2) {
                        if (value instanceof String) {
                            acceptedDnsNames.add(value);
                            continue;
                        }
                        if (!(value instanceof byte[])) continue;
                        acceptedDnsNames.add(new String((byte[])value, Charsets.UTF_8));
                        continue;
                    }
                    Integer n3 = object;
                    n2 = 7;
                    if (n3 != null && n3 == n2) {
                        if (value instanceof String) {
                            acceptedIpAddresses.add(value);
                            continue;
                        }
                        if (!(value instanceof byte[])) continue;
                        acceptedIpAddresses.add(new String((byte[])value, Charsets.UTF_8));
                        continue;
                    }
                    if (!LOG.isTraceEnabled()) continue;
                    LOG.trace("Unhandled SAN type \"{}\" with value \"{}\"", subjectAltName.get(0), value);
                }
                if (this.isIpAddress(host)) {
                    if (!acceptedIpAddresses.contains(host)) {
                        Object list$iv$iv;
                        boolean bl;
                        String it;
                        Iterable $this$flatMap$iv = acceptedDnsNames;
                        boolean $i$f$flatMap = false;
                        Iterable iterable = $this$flatMap$iv;
                        Collection destination$iv$iv = new ArrayList();
                        boolean $i$f$flatMapTo = false;
                        for (Object t : iterable) {
                            Object object;
                            it = (String)t;
                            bl = false;
                            try {
                                object = InetAddress.getAllByName(it);
                                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getAllByName(it)");
                                object = ArraysKt.toList((Object[])object);
                            }
                            catch (Throwable e) {
                                object = CollectionsKt.emptyList();
                            }
                            list$iv$iv = (Iterable)object;
                            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                        }
                        $this$flatMap$iv = (List)destination$iv$iv;
                        boolean $i$f$map = false;
                        String[] stringArray = $this$map$iv;
                        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        for (Object t : stringArray) {
                            list$iv$iv = (InetAddress)t;
                            Collection collection2 = destination$iv$iv;
                            bl = false;
                            collection2.add(((InetAddress)((Object)it)).getHostAddress());
                        }
                        List resolvedIps = (List)destination$iv$iv;
                        if (LOG.isTraceEnabled()) {
                            LOG.trace("Resolved IPs: {}", (Object)CollectionsKt.joinToString$default((Iterable)CollectionsKt.toSet((Iterable)resolvedIps), null, null, null, (int)0, null, null, (int)63, null));
                        }
                        if (!resolvedIps.contains(host)) {
                            throw new SSLPeerUnverifiedException("Hostname verification failed. Peer certificate does not belong to peer host");
                        }
                    }
                } else {
                    $this$map$iv = new String[]{"."};
                    List hostLabels = StringsKt.split$default((CharSequence)host, (String[])$this$map$iv, (boolean)false, (int)0, (int)6, null);
                    boolean found = false;
                    for (String string : acceptedDnsNames) {
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"entry");
                        Object[] objectArray = new char[]{'.'};
                        CharSequence charSequence = StringsKt.trimEnd((String)string, (char[])objectArray);
                        objectArray = new String[1];
                        objectArray[0] = (char)".";
                        if (!this.checkHostname(StringsKt.split$default((CharSequence)charSequence, (String[])objectArray, (boolean)false, (int)0, (int)6, null), hostLabels)) continue;
                        found = true;
                        break;
                    }
                    if (!found) {
                        throw new SSLPeerUnverifiedException("Hostname verification failed. Peer certificate does not belong to peer host");
                    }
                }
            } else if (peerIsServer) {
                LOG.warn("DANGER: TLS server hostname verification of is disabled. This is strongly discouraged except for testing purposes!.");
            } else {
                LOG.info("Client hostname verification is disabled. This may reduce connection security, please consider enabling it when applicable.");
            }
            Date oneDay = new Date();
            oneDay.setTime(oneDay.getTime() + (long)86400000);
            peerCert.checkValidity();
            peerCert.checkValidity(oneDay);
        }
        catch (CertificateParsingException e) {
            throw new SSLPeerUnverifiedException("TLS Session Verification failed " + e);
        }
        catch (CertificateNotYetValidException e) {
            throw new SSLPeerUnverifiedException("TLS Session Verification failed " + e);
        }
        catch (CertificateExpiredException e) {
            throw new SSLPeerUnverifiedException("TLS Session Verification failed " + e);
        }
    }

    public static /* synthetic */ void verifyTlsSession$default(TLSSessionVerificationHelper tLSSessionVerificationHelper, String string, int n, X509Certificate x509Certificate, boolean bl, boolean bl2, int n2, Object object) throws SSLPeerUnverifiedException {
        if ((n2 & 0x10) != 0) {
            bl2 = true;
        }
        tLSSessionVerificationHelper.verifyTlsSession(string, n, x509Certificate, bl, bl2);
    }

    private final boolean isIpAddress(String host) {
        Matcher ip4 = Pattern.compile(ipv4Pattern, 2).matcher(host);
        if (ip4.matches()) {
            return true;
        }
        Matcher ip6 = Pattern.compile(ipv6Pattern, 2).matcher(host);
        return ip6.matches();
    }

    private final boolean checkHostname(List<String> dnsNameLabels, List<String> hostNameLabels) {
        if (dnsNameLabels.size() == hostNameLabels.size()) {
            int n = 1;
            int n2 = dnsNameLabels.size();
            while (n < n2) {
                int i;
                if (Intrinsics.areEqual((Object)dnsNameLabels.get(i = n++), (Object)hostNameLabels.get(i))) continue;
                return false;
            }
            CharSequence charSequence = hostNameLabels.get(0);
            return new Regex(StringsKt.replace$default((String)dnsNameLabels.get(0), (String)"*", (String)".*", (boolean)false, (int)4, null)).matches(charSequence);
        }
        return false;
    }

    @JvmOverloads
    public final void verifyTlsSession(@NotNull String host, int port, @NotNull X509Certificate peerCert, boolean hostnameVerificationEnabled) throws SSLPeerUnverifiedException {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Intrinsics.checkNotNullParameter((Object)peerCert, (String)"peerCert");
        TLSSessionVerificationHelper.verifyTlsSession$default(this, host, port, peerCert, hostnameVerificationEnabled, false, 16, null);
    }
}

