/*
 * Decompiled with CFR 0.152.
 */
package de.fhg.aisec.ids.idscp2.default_drivers.keystores;

import de.fhg.aisec.ids.idscp2.default_drivers.keystores.CustomX509ExtendedKeyManager;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509ExtendedTrustManager;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0019\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ&\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u000bJ9\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\r\u00a2\u0006\u0002\u0010\u0016J!\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u00122\u0006\u0010\u0019\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\u001bJ\u0016\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bR\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lde/fhg/aisec/ids/idscp2/default_drivers/keystores/PreConfiguration;", "", "()V", "LOG", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getCertificate", "Ljava/security/cert/X509Certificate;", "keyStorePath", "Ljava/nio/file/Path;", "keyStorePassword", "", "keyAlias", "", "getKey", "Ljava/security/Key;", "keyPassword", "getX509ExtKeyManager", "", "Ljavax/net/ssl/KeyManager;", "certAlias", "keyType", "([CLjava/nio/file/Path;[CLjava/lang/String;Ljava/lang/String;)[Ljavax/net/ssl/KeyManager;", "getX509ExtTrustManager", "Ljavax/net/ssl/TrustManager;", "trustStorePath", "trustStorePassword", "(Ljava/nio/file/Path;[C)[Ljavax/net/ssl/TrustManager;", "loadKeyStore", "Ljava/security/KeyStore;", "idscp2"})
public final class PreConfiguration {
    @NotNull
    public static final PreConfiguration INSTANCE = new PreConfiguration();
    private static final Logger LOG = LoggerFactory.getLogger(PreConfiguration.class);

    private PreConfiguration() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final KeyStore loadKeyStore(@NotNull Path keyStorePath, @NotNull char[] keyStorePassword) throws KeyStoreException, IOException, CertificateException, NoSuchAlgorithmException {
        KeyStore keyStore;
        Object object;
        Intrinsics.checkNotNullParameter((Object)keyStorePath, (String)"keyStorePath");
        Intrinsics.checkNotNullParameter((Object)keyStorePassword, (String)"keyStorePassword");
        KeyStore ks = null;
        String pathString = ((Object)keyStorePath).toString();
        if (StringsKt.endsWith$default((String)pathString, (String)".jks", (boolean)false, (int)2, null)) {
            object = KeyStore.getInstance("JKS");
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"{\n                KeySto\u2026ance(\"JKS\")\n            }");
            keyStore = object;
        } else if (StringsKt.endsWith$default((String)pathString, (String)".p12", (boolean)false, (int)2, null)) {
            object = KeyStore.getInstance("PKCS12");
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"{\n                KeySto\u2026e(\"PKCS12\")\n            }");
            keyStore = object;
        } else {
            String string = pathString.substring(StringsKt.lastIndexOf$default((CharSequence)pathString, (char)'.', (int)0, (boolean)false, (int)6, null));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
            throw new KeyStoreException("Unknown file extension \"" + string + "\", only JKS (.jks) and PKCS12 (.p12) are supported.");
        }
        ks = keyStore;
        object = Files.newInputStream(keyStorePath, new OpenOption[0]);
        Throwable throwable = null;
        try {
            InputStream keyStoreInputStream = (InputStream)object;
            boolean bl = false;
            if (LOG.isTraceEnabled()) {
                LOG.trace("Loading key store: " + pathString);
            }
            ks.load(keyStoreInputStream, keyStorePassword);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
        return ks;
    }

    @NotNull
    public final TrustManager[] getX509ExtTrustManager(@NotNull Path trustStorePath, @NotNull char[] trustStorePassword) {
        Object[] objectArray;
        Intrinsics.checkNotNullParameter((Object)trustStorePath, (String)"trustStorePath");
        Intrinsics.checkNotNullParameter((Object)trustStorePassword, (String)"trustStorePassword");
        try {
            Object[] myTrustManager = null;
            KeyStore trustStore = this.loadKeyStore(trustStorePath, trustStorePassword);
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance("PKIX");
            trustManagerFactory.init(trustStore);
            Object[] objectArray2 = trustManagerFactory.getTrustManagers();
            Intrinsics.checkNotNullExpressionValue((Object)objectArray2, (String)"trustManagerFactory.trustManagers");
            myTrustManager = objectArray2;
            if (myTrustManager.length != 1 || !(myTrustManager[0] instanceof X509ExtendedTrustManager)) {
                String string = Arrays.toString(myTrustManager);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(this)");
                throw new IllegalStateException("Unexpected default trust managers:" + string);
            }
            objectArray = myTrustManager;
        }
        catch (KeyStoreException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        catch (CertificateException e) {
            throw new RuntimeException(e);
        }
        return objectArray;
    }

    @NotNull
    public final KeyManager[] getX509ExtKeyManager(@NotNull char[] keyPassword, @NotNull Path keyStorePath, @NotNull char[] keyStorePassword, @NotNull String certAlias, @NotNull String keyType) {
        Object[] objectArray;
        Intrinsics.checkNotNullParameter((Object)keyPassword, (String)"keyPassword");
        Intrinsics.checkNotNullParameter((Object)keyStorePath, (String)"keyStorePath");
        Intrinsics.checkNotNullParameter((Object)keyStorePassword, (String)"keyStorePassword");
        Intrinsics.checkNotNullParameter((Object)certAlias, (String)"certAlias");
        Intrinsics.checkNotNullParameter((Object)keyType, (String)"keyType");
        try {
            Object[] myKeyManager = null;
            KeyStore keystore = this.loadKeyStore(keyStorePath, keyStorePassword);
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance("PKIX");
            keyManagerFactory.init(keystore, keyPassword);
            Object[] objectArray2 = keyManagerFactory.getKeyManagers();
            Intrinsics.checkNotNullExpressionValue((Object)objectArray2, (String)"keyManagerFactory.keyManagers");
            myKeyManager = objectArray2;
            if (myKeyManager.length != 1 || !(myKeyManager[0] instanceof X509ExtendedKeyManager)) {
                String string = Arrays.toString(myKeyManager);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(this)");
                throw new IllegalStateException("Unexpected default key managers:" + string);
            }
            myKeyManager[0] = new CustomX509ExtendedKeyManager(certAlias, keyType, (X509ExtendedKeyManager)myKeyManager[0]);
            objectArray = myKeyManager;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (KeyStoreException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        catch (UnrecoverableKeyException e) {
            throw new RuntimeException(e);
        }
        catch (CertificateException e) {
            throw new RuntimeException(e);
        }
        return objectArray;
    }

    @NotNull
    public final Key getKey(@NotNull Path keyStorePath, @NotNull char[] keyStorePassword, @NotNull String keyAlias, @NotNull char[] keyPassword) {
        Key key;
        Intrinsics.checkNotNullParameter((Object)keyStorePath, (String)"keyStorePath");
        Intrinsics.checkNotNullParameter((Object)keyStorePassword, (String)"keyStorePassword");
        Intrinsics.checkNotNullParameter((Object)keyAlias, (String)"keyAlias");
        Intrinsics.checkNotNullParameter((Object)keyPassword, (String)"keyPassword");
        try {
            Key key2;
            KeyStore keyStore = this.loadKeyStore(keyStorePath, keyStorePassword);
            Key key3 = key2 = keyStore.getKey(keyAlias, keyPassword);
            if (key3 == null) {
                throw new RuntimeException("No key was found in keystore for given alias");
            }
            key = key3;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (KeyStoreException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        catch (CertificateException e) {
            throw new RuntimeException(e);
        }
        catch (UnrecoverableKeyException e) {
            throw new RuntimeException(e);
        }
        return key;
    }

    @NotNull
    public final X509Certificate getCertificate(@NotNull Path keyStorePath, @NotNull char[] keyStorePassword, @NotNull String keyAlias) {
        X509Certificate x509Certificate;
        Intrinsics.checkNotNullParameter((Object)keyStorePath, (String)"keyStorePath");
        Intrinsics.checkNotNullParameter((Object)keyStorePassword, (String)"keyStorePassword");
        Intrinsics.checkNotNullParameter((Object)keyAlias, (String)"keyAlias");
        try {
            KeyStore keystore = this.loadKeyStore(keyStorePath, keyStorePassword);
            Certificate certificate = keystore.getCertificate(keyAlias);
            if (certificate == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.security.cert.X509Certificate");
            }
            X509Certificate cert = (X509Certificate)certificate;
            keystore.getKey(keyAlias, keyStorePassword);
            x509Certificate = cert;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (KeyStoreException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        catch (CertificateException e) {
            throw new RuntimeException(e);
        }
        catch (UnrecoverableKeyException e) {
            throw new RuntimeException(e);
        }
        return x509Certificate;
    }
}

