/*
 * Decompiled with CFR 0.152.
 */
package de.fhg.aisec.ids.cmc.verifier;

import com.google.gson.Gson;
import de.fhg.aisec.ids.cmc.CmcConfig;
import de.fhg.aisec.ids.cmc.CmcException;
import de.fhg.aisec.ids.cmc.CmcHelper;
import de.fhg.aisec.ids.cmc.CmcSocket;
import de.fhg.aisec.ids.cmc.UtilsKt;
import de.fhg.aisec.ids.cmc.messages.AttestationRequest;
import de.fhg.aisec.ids.cmc.messages.AttestationResult;
import de.fhg.aisec.ids.cmc.messages.VerificationRequest;
import de.fhg.aisec.ids.cmc.messages.VerificationResult;
import de.fhg.aisec.ids.cmc.verifier.CmcVerifierConfig;
import de.fhg.aisec.ids.idscp2.idscp_core.drivers.RaVerifierDriver;
import de.fhg.aisec.ids.idscp2.idscp_core.fsm.InternalControlMessage;
import de.fhg.aisec.ids.idscp2.idscp_core.fsm.fsmListeners.RaVerifierFsmListener;
import java.io.Closeable;
import java.nio.charset.Charset;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u00162\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0016B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000bH\u0016J\b\u0010\u000f\u001a\u00020\rH\u0016J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u0002H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0002R\u000e\u0010\u0006\u001a\u00020\u0002X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lde/fhg/aisec/ids/cmc/verifier/CmcVerifier;", "Lde/fhg/aisec/ids/idscp2/idscp_core/drivers/RaVerifierDriver;", "Lde/fhg/aisec/ids/cmc/verifier/CmcVerifierConfig;", "fsmListener", "Lde/fhg/aisec/ids/idscp2/idscp_core/fsm/fsmListeners/RaVerifierFsmListener;", "(Lde/fhg/aisec/ids/idscp2/idscp_core/fsm/fsmListeners/RaVerifierFsmListener;)V", "config", "gson", "Lcom/google/gson/Gson;", "queue", "Ljava/util/concurrent/BlockingQueue;", "", "delegate", "", "message", "run", "sendRaResult", "result", "", "setConfig", "waitForAttestationReport", "", "Companion", "idscp2-rat-cmc"})
public final class CmcVerifier
extends RaVerifierDriver<CmcVerifierConfig> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BlockingQueue<byte[]> queue;
    @NotNull
    private final Gson gson;
    private CmcVerifierConfig config;
    @NotNull
    public static final String ID = "CMC";
    private static final Logger LOG = LoggerFactory.getLogger(CmcVerifier.class);

    public CmcVerifier(@NotNull RaVerifierFsmListener fsmListener) {
        Intrinsics.checkNotNullParameter((Object)fsmListener, (String)"fsmListener");
        super(fsmListener);
        this.queue = new LinkedBlockingQueue();
        this.gson = new Gson();
    }

    public void setConfig(@NotNull CmcVerifierConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.config = config;
    }

    public void delegate(@NotNull byte[] message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        if (LOG.isTraceEnabled()) {
            LOG.trace("Delegated CMC prover message to CMC verifier");
        }
        this.queue.add(message);
    }

    private final String waitForAttestationReport() {
        try {
            byte[] byArray = this.queue.take();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"queue.take()");
            boolean bl = false;
            return new String(byArray, Charsets.UTF_8);
        }
        catch (Exception e) {
            if (this.getRunning()) {
                this.getFsmListener().onRaVerifierMessage(InternalControlMessage.RA_VERIFIER_FAILED);
            }
            throw new CmcException("Interrupted or invalid message", e);
        }
    }

    private final void sendRaResult(boolean result) {
        String string = this.gson.toJson((Object)new AttestationResult(true));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"gson.toJson(AttestationResult(true))");
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] ratResult = byArray;
        this.getFsmListener().onRaVerifierMessage(InternalControlMessage.RA_VERIFIER_MSG, ratResult);
        if (result) {
            this.getFsmListener().onRaVerifierMessage(InternalControlMessage.RA_VERIFIER_OK);
        } else {
            this.getFsmListener().onRaVerifierMessage(InternalControlMessage.RA_VERIFIER_FAILED);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            VerificationResult verificationResult;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Generate and send challenge to remote prover");
            }
            String nonce = UtilsKt.toHexString(CmcHelper.INSTANCE.generateNonce(20));
            if (LOG.isDebugEnabled()) {
                LOG.debug("Challenge nonce is: " + nonce);
            }
            AttestationRequest attestationRequest = new AttestationRequest("Attestation Report Request", nonce);
            String ratRequest = this.gson.toJson((Object)attestationRequest);
            if (LOG.isTraceEnabled()) {
                boolean bl = false;
                System.out.println((Object)ratRequest);
            }
            RaVerifierFsmListener raVerifierFsmListener = this.getFsmListener();
            Intrinsics.checkNotNullExpressionValue((Object)ratRequest, (String)"ratRequest");
            String string = ratRequest;
            Charset charset = Charsets.UTF_8;
            boolean bl = false;
            byte[] byArray = string.getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
            raVerifierFsmListener.onRaVerifierMessage(InternalControlMessage.RA_VERIFIER_MSG, byArray);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Wait for RAT prover message with attestation response");
            }
            String attestationReport = this.waitForAttestationReport();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Got challenge response. Start validation...");
            }
            VerificationRequest verificationRequest = new VerificationRequest("Verification Request", attestationReport, nonce);
            String verificationRequestJson = this.gson.toJson((Object)verificationRequest);
            if (LOG.isTraceEnabled()) {
                boolean bl2 = false;
                System.out.println((Object)verificationRequestJson);
            }
            String resultJson = null;
            Object object = this.config;
            if (object == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"config");
                throw null;
            }
            String string2 = ((CmcConfig)object).getCmcHost();
            object = this.config;
            if (object == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"config");
                throw null;
            }
            object = new CmcSocket(string2, ((CmcConfig)object).getCmcPort());
            boolean bl3 = false;
            boolean bl4 = false;
            Throwable throwable = null;
            try {
                CmcSocket cmcSocket = (CmcSocket)object;
                boolean bl5 = false;
                Intrinsics.checkNotNullExpressionValue((Object)verificationRequestJson, (String)"verificationRequestJson");
                Object object2 = verificationRequestJson;
                Charset charset2 = Charsets.UTF_8;
                boolean bl6 = false;
                byte[] byArray2 = ((String)object2).getBytes(charset2);
                Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"(this as java.lang.String).getBytes(charset)");
                object2 = cmcSocket.request(byArray2);
                boolean bl7 = false;
                resultJson = new String((byte[])object2, Charsets.UTF_8);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
            if (LOG.isTraceEnabled()) {
                object = resultJson;
                bl3 = false;
                System.out.println(object);
            }
            if ((verificationResult = (VerificationResult)this.gson.fromJson(resultJson, VerificationResult.class)).getRaSuccessful()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("CMC verification succeed");
                }
                this.sendRaResult(true);
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("CMC verification failed");
                }
                this.sendRaResult(false);
            }
        }
        catch (Throwable t) {
            LOG.error("Error in CMC Verifier", t);
            throw t;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lde/fhg/aisec/ids/cmc/verifier/CmcVerifier$Companion;", "", "()V", "ID", "", "LOG", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "idscp2-rat-cmc"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

