/*
 * Decompiled with CFR 0.152.
 */
package de.fhg.aisec.ids.cmc.prover;

import com.google.gson.Gson;
import de.fhg.aisec.ids.cmc.CmcConfig;
import de.fhg.aisec.ids.cmc.CmcException;
import de.fhg.aisec.ids.cmc.CmcSocket;
import de.fhg.aisec.ids.cmc.messages.AttestationResult;
import de.fhg.aisec.ids.cmc.prover.CmcProverConfig;
import de.fhg.aisec.ids.idscp2.idscp_core.drivers.RaProverDriver;
import de.fhg.aisec.ids.idscp2.idscp_core.fsm.InternalControlMessage;
import de.fhg.aisec.ids.idscp2.idscp_core.fsm.fsmListeners.RaProverFsmListener;
import java.io.Closeable;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u0000 \u00122\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0012B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000bH\u0016J\b\u0010\u000f\u001a\u00020\rH\u0016J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u0002H\u0016J\b\u0010\u0011\u001a\u00020\u000bH\u0002R\u000e\u0010\u0006\u001a\u00020\u0002X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lde/fhg/aisec/ids/cmc/prover/CmcProver;", "Lde/fhg/aisec/ids/idscp2/idscp_core/drivers/RaProverDriver;", "Lde/fhg/aisec/ids/cmc/prover/CmcProverConfig;", "fsmListener", "Lde/fhg/aisec/ids/idscp2/idscp_core/fsm/fsmListeners/RaProverFsmListener;", "(Lde/fhg/aisec/ids/idscp2/idscp_core/fsm/fsmListeners/RaProverFsmListener;)V", "config", "gson", "Lcom/google/gson/Gson;", "queue", "Ljava/util/concurrent/BlockingQueue;", "", "delegate", "", "message", "run", "setConfig", "waitForVerifierMsg", "Companion", "idscp2-rat-cmc"})
public final class CmcProver
extends RaProverDriver<CmcProverConfig> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BlockingQueue<byte[]> queue;
    private CmcProverConfig config;
    @NotNull
    private final Gson gson;
    @NotNull
    public static final String ID = "CMC";
    private static final Logger LOG = LoggerFactory.getLogger(CmcProver.class);

    public CmcProver(@NotNull RaProverFsmListener fsmListener) {
        Intrinsics.checkNotNullParameter((Object)fsmListener, (String)"fsmListener");
        super(fsmListener);
        this.queue = new LinkedBlockingQueue();
        this.gson = new Gson();
    }

    public void setConfig(@NotNull CmcProverConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.config = config;
        if (LOG.isDebugEnabled()) {
            LOG.debug("CMC expected at " + config.getCmcHost() + ":" + config.getCmcPort());
        }
    }

    public void delegate(@NotNull byte[] message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        if (LOG.isTraceEnabled()) {
            LOG.trace("Delegated CMC verifier message to CMC prover");
        }
        this.queue.add(message);
    }

    private final byte[] waitForVerifierMsg() {
        try {
            byte[] byArray = this.queue.take();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"queue.take()");
            return byArray;
        }
        catch (Exception e) {
            if (this.getRunning()) {
                this.getFsmListener().onRaProverMessage(InternalControlMessage.RA_PROVER_FAILED);
            }
            throw new CmcException("Interrupted or invalid message", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            AttestationResult ratResult;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Wait for challenge from verifier");
            }
            byte[] ratVerifierMsg = this.waitForVerifierMsg();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Got rat challenge from rat verifier. Starting communication...");
            }
            byte[] resultBytes = null;
            Object object = this.config;
            if (object == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"config");
                throw null;
            }
            String string = ((CmcConfig)object).getCmcHost();
            object = this.config;
            if (object == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"config");
                throw null;
            }
            object = new CmcSocket(string, ((CmcConfig)object).getCmcPort());
            boolean bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                CmcSocket cmcSocket = (CmcSocket)object;
                boolean bl3 = false;
                resultBytes = cmcSocket.request(ratVerifierMsg);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Got CMC response, send response to verifier");
            }
            this.getFsmListener().onRaProverMessage(InternalControlMessage.RA_PROVER_MSG, resultBytes);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Wait for RAT result from RAT verifier");
            }
            byte[] byArray = this.waitForVerifierMsg();
            boolean bl4 = false;
            String ratResultJson = new String(byArray, Charsets.UTF_8);
            if (LOG.isTraceEnabled()) {
                LOG.trace(ratResultJson);
            }
            if ((ratResult = (AttestationResult)this.gson.fromJson(ratResultJson, AttestationResult.class)).getResult()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("CMC attestation succeed");
                }
                this.getFsmListener().onRaProverMessage(InternalControlMessage.RA_PROVER_OK);
            } else {
                if (LOG.isWarnEnabled()) {
                    LOG.warn("CMC attestation failed");
                }
                this.getFsmListener().onRaProverMessage(InternalControlMessage.RA_PROVER_FAILED);
            }
        }
        catch (Throwable t) {
            LOG.error("Error in CMC prover", t);
            throw t;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lde/fhg/aisec/ids/cmc/prover/CmcProver$Companion;", "", "()V", "ID", "", "LOG", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "idscp2-rat-cmc"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

