/*
 * Decompiled with CFR 0.152.
 */
package de.fhg.aisec.ids.tpm2d.verifier;

import de.fhg.aisec.ids.idscp2.api.drivers.RaVerifierDriver;
import de.fhg.aisec.ids.idscp2.api.fsm.InternalControlMessage;
import de.fhg.aisec.ids.idscp2.api.fsm.RaVerifierFsmListener;
import de.fhg.aisec.ids.tpm2d.TpmException;
import de.fhg.aisec.ids.tpm2d.TpmHelper;
import de.fhg.aisec.ids.tpm2d.TpmMessageFactory;
import de.fhg.aisec.ids.tpm2d.UtilsKt;
import de.fhg.aisec.ids.tpm2d.messages.TpmAttestation;
import de.fhg.aisec.ids.tpm2d.verifier.PcrValues;
import de.fhg.aisec.ids.tpm2d.verifier.TpmVerifierConfig;
import java.io.ByteArrayInputStream;
import java.security.MessageDigest;
import java.security.Signature;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tss.tpm.TPMS_ATTEST;
import tss.tpm.TPMS_QUOTE_INFO;
import tss.tpm.TPMS_SIGNATURE_RSAPSS;
import tss.tpm.TPMS_SIGNATURE_RSASSA;
import tss.tpm.TPMT_SIGNATURE;
import tss.tpm.TPMU_ATTEST;
import tss.tpm.TPMU_SIGNATURE;
import tss.tpm.TPM_ALG_ID;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u001a2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001aB\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\n\u001a\u00020\u0002H\u0016J\u0010\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\tH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\b\u0010\u0014\u001a\u00020\fH\u0016J\u0010\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0018\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\tH\u0002R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0002X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lde/fhg/aisec/ids/tpm2d/verifier/TpmVerifier;", "Lde/fhg/aisec/ids/idscp2/api/drivers/RaVerifierDriver;", "Lde/fhg/aisec/ids/tpm2d/verifier/TpmVerifierConfig;", "fsmListener", "Lde/fhg/aisec/ids/idscp2/api/fsm/RaVerifierFsmListener;", "<init>", "(Lde/fhg/aisec/ids/idscp2/api/fsm/RaVerifierFsmListener;)V", "queue", "Ljava/util/concurrent/BlockingQueue;", "", "config", "setConfig", "", "delegate", "message", "waitForProverMsg", "Lde/fhg/aisec/ids/tpm2d/messages/TpmAttestation$TpmMessage;", "sendRaResult", "result", "", "run", "checkPcrValues", "response", "Lde/fhg/aisec/ids/tpm2d/messages/TpmAttestation$TpmResponse;", "checkSignature", "hash", "Companion", "idscp2-ra-tpm2d"})
@SourceDebugExtension(value={"SMAP\nTpmVerifier.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TpmVerifier.kt\nde/fhg/aisec/ids/tpm2d/verifier/TpmVerifier\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,342:1\n1863#2,2:343\n*S KotlinDebug\n*F\n+ 1 TpmVerifier.kt\nde/fhg/aisec/ids/tpm2d/verifier/TpmVerifier\n*L\n274#1:343,2\n*E\n"})
public final class TpmVerifier
extends RaVerifierDriver<TpmVerifierConfig> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BlockingQueue<byte[]> queue;
    private TpmVerifierConfig config;
    @NotNull
    public static final String ID = "TPM";
    private static final Logger LOG = LoggerFactory.getLogger(TpmVerifier.class);

    public TpmVerifier(@NotNull RaVerifierFsmListener fsmListener) {
        Intrinsics.checkNotNullParameter((Object)fsmListener, (String)"fsmListener");
        super(fsmListener);
        this.queue = new LinkedBlockingQueue();
    }

    public void setConfig(@NotNull TpmVerifierConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.config = config;
    }

    public void delegate(@NotNull byte[] message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        if (LOG.isTraceEnabled()) {
            LOG.trace("Delegated TPM prover message to TPM verifier");
        }
        this.queue.add(message);
    }

    private final TpmAttestation.TpmMessage waitForProverMsg() {
        try {
            byte[] msg = this.queue.take();
            TpmAttestation.TpmMessage tpmMessage = TpmAttestation.TpmMessage.parseFrom(msg);
            Intrinsics.checkNotNullExpressionValue((Object)tpmMessage, (String)"parseFrom(...)");
            return tpmMessage;
        }
        catch (Exception e) {
            if (this.getRunning()) {
                this.getFsmListener().onRaVerifierMessage(InternalControlMessage.RA_VERIFIER_FAILED);
            }
            throw new TpmException("Interrupted or invalid message", e);
        }
    }

    private final void sendRaResult(boolean result) {
        byte[] ratResult = TpmMessageFactory.INSTANCE.getAttestationResultMessage(result).toByteArray();
        RaVerifierFsmListener raVerifierFsmListener = this.getFsmListener();
        Intrinsics.checkNotNull((Object)ratResult);
        raVerifierFsmListener.onRaVerifierMessage(InternalControlMessage.RA_VERIFIER_MSG, ratResult);
        if (result) {
            this.getFsmListener().onRaVerifierMessage(InternalControlMessage.RA_VERIFIER_OK);
        } else {
            this.getFsmListener().onRaVerifierMessage(InternalControlMessage.RA_VERIFIER_FAILED);
        }
    }

    public void run() {
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Generate and send TPM challenge to remote TPM prover");
            }
            byte[] nonce = TpmHelper.INSTANCE.generateNonce(20);
            String string = Arrays.toString(nonce);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            LOG.debug("Challenge nonce is: " + string);
            TpmVerifierConfig tpmVerifierConfig = this.config;
            if (tpmVerifierConfig == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"config");
                tpmVerifierConfig = null;
            }
            TpmAttestation.IdsAttestationType idsAttestationType = tpmVerifierConfig.getExpectedAType();
            TpmVerifierConfig tpmVerifierConfig2 = this.config;
            if (tpmVerifierConfig2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"config");
                tpmVerifierConfig2 = null;
            }
            byte[] ratChallenge = TpmMessageFactory.INSTANCE.getAttestationChallengeMessage(nonce, idsAttestationType, tpmVerifierConfig2.getExpectedAttestationMask()).toByteArray();
            RaVerifierFsmListener raVerifierFsmListener = this.getFsmListener();
            Intrinsics.checkNotNull((Object)ratChallenge);
            raVerifierFsmListener.onRaVerifierMessage(InternalControlMessage.RA_VERIFIER_MSG, ratChallenge);
            LOG.debug("Wait for RAT prover message with TPM attestation response");
            TpmAttestation.TpmMessage ratProverMsg = this.waitForProverMsg();
            if (!ratProverMsg.hasRatResponse()) {
                this.getFsmListener().onRaVerifierMessage(InternalControlMessage.RA_VERIFIER_FAILED);
                throw new TpmException("Missing TPM challenge response");
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Got TPM challenge response. Start validation ...");
            }
            TpmAttestation.TpmResponse resp = ratProverMsg.getRatResponse();
            Intrinsics.checkNotNull((Object)resp);
            TpmVerifierConfig tpmVerifierConfig3 = this.config;
            if (tpmVerifierConfig3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"config");
                tpmVerifierConfig3 = null;
            }
            if (!this.checkSignature(resp, TpmHelper.INSTANCE.calculateHash(nonce, tpmVerifierConfig3.getLocalCertificate()))) {
                this.sendRaResult(false);
                throw new TpmException("Invalid TPM signature");
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("TPM signature valid and certificate trusted");
            }
            if (!this.checkPcrValues(resp)) {
                this.sendRaResult(false);
                throw new TpmException("Mismatch between PCR values and golden values");
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("PCR values trusted");
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("TPM verification succeed");
            }
            this.sendRaResult(true);
        }
        catch (Throwable t) {
            LOG.error("Error in TPM Verifier", t);
            throw t;
        }
    }

    private final boolean checkPcrValues(TpmAttestation.TpmResponse response) {
        try {
            TpmVerifierConfig tpmVerifierConfig;
            List<TpmAttestation.Pcr> list = response.getPcrValuesList();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getPcrValuesList(...)");
            PcrValues pcrValues = new PcrValues(list);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Peer PCR values from TPM response: " + pcrValues);
            }
            PcrValues goldenValues = new PcrValues(this.getFsmListener().getRemotePeerDat().getBytes());
            if (LOG.isDebugEnabled()) {
                LOG.debug("Golden values from DAPS: " + goldenValues);
            }
            if ((tpmVerifierConfig = this.config) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"config");
                tpmVerifierConfig = null;
            }
            TpmAttestation.IdsAttestationType idsAttestationType = tpmVerifierConfig.getExpectedAType();
            TpmVerifierConfig tpmVerifierConfig2 = this.config;
            if (tpmVerifierConfig2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"config");
                tpmVerifierConfig2 = null;
            }
            return pcrValues.isTrusted(goldenValues, idsAttestationType, tpmVerifierConfig2.getExpectedAttestationMask());
        }
        catch (Exception e) {
            LOG.error("Cannot check PCR values against golden values", (Throwable)e);
            return false;
        }
    }

    private final boolean checkSignature(TpmAttestation.TpmResponse response, byte[] hash) {
        boolean bl;
        byte[] byteQuoted;
        byte[] byteCert;
        byte[] byteSignature;
        block25: {
            block24: {
                byteSignature = response.getSignature().toByteArray();
                byteCert = response.getCertificate().toByteArray();
                byteQuoted = response.getQuoted().toByteArray();
                if (LOG.isTraceEnabled()) {
                    Intrinsics.checkNotNull((Object)byteSignature);
                    LOG.trace("signature: {}", (Object)UtilsKt.toHexString(byteSignature));
                    Intrinsics.checkNotNull((Object)byteCert);
                    LOG.trace("cert: {}", (Object)UtilsKt.toHexString(byteCert));
                    Intrinsics.checkNotNull((Object)byteQuoted);
                    LOG.trace("quoted: {}", (Object)UtilsKt.toHexString(byteQuoted));
                }
                Intrinsics.checkNotNull((Object)byteSignature);
                if (byteSignature.length == 0) break block24;
                Intrinsics.checkNotNull((Object)byteCert);
                if (byteCert.length == 0) break block24;
                Intrinsics.checkNotNull((Object)byteQuoted);
                if (!(byteQuoted.length == 0)) break block25;
            }
            LOG.warn("Some required part (signature, cert or quoted) is empty!");
            return false;
        }
        try {
            byte[] extraBytes;
            MessageDigest messageDigest;
            TPMS_ATTEST ex2;
            X509Certificate caCert2;
            CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
            Certificate certificate = certFactory.generateCertificate(new ByteArrayInputStream(byteCert));
            Intrinsics.checkNotNull((Object)certificate, (String)"null cannot be cast to non-null type java.security.cert.X509Certificate");
            X509Certificate certificate2 = (X509Certificate)certificate;
            TpmVerifierConfig tpmVerifierConfig = this.config;
            if (tpmVerifierConfig == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"config");
                tpmVerifierConfig = null;
            }
            List<X509Certificate> rootCertificates = tpmVerifierConfig.getCaCertificates();
            String certificateIssuer = certificate2.getIssuerX500Principal().getName();
            boolean trusted = false;
            for (X509Certificate caCert2 : rootCertificates) {
                if (!Intrinsics.areEqual((Object)caCert2.getSubjectX500Principal().getName(), (Object)certificateIssuer)) continue;
                try {
                    certificate2.verify(caCert2.getPublicKey());
                    trusted = true;
                    break;
                }
                catch (Exception exception) {
                }
            }
            if (!trusted) {
                LOG.warn("TPM Certificate is not trusted");
                return false;
            }
            try {
                caCert2 = TPMT_SIGNATURE.fromBytes((byte[])byteSignature);
            }
            catch (Exception ex2) {
                LOG.warn(StringsKt.trimIndent((String)("\n                Could not create a TPMT_SIGNATURE from bytes:\n                " + UtilsKt.toHexString(byteSignature) + "\n                    ")), (Throwable)ex2);
                return false;
            }
            X509Certificate tpmtSignature = caCert2;
            try {
                ex2 = TPMS_ATTEST.fromBytes((byte[])byteQuoted);
            }
            catch (Exception ex3) {
                LOG.warn(StringsKt.trimIndent((String)("\n                Could not create a TPMS_ATTEST from bytes:\n                " + UtilsKt.toHexString(byteQuoted) + "\n                    ")), (Throwable)ex3);
                return false;
            }
            TPMS_ATTEST tpmsAttest = ex2;
            TPMU_ATTEST tPMU_ATTEST = tpmsAttest.attested;
            Intrinsics.checkNotNull((Object)tPMU_ATTEST, (String)"null cannot be cast to non-null type tss.tpm.TPMS_QUOTE_INFO");
            TPMS_QUOTE_INFO attested = (TPMS_QUOTE_INFO)tPMU_ATTEST;
            MessageDigest $this$checkSignature_u24lambda_u241 = messageDigest = MessageDigest.getInstance("SHA-256");
            boolean bl2 = false;
            List<TpmAttestation.Pcr> list = response.getPcrValuesList();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getPcrValuesList(...)");
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach22 = false;
            for (Object element$iv : $this$forEach$iv) {
                TpmAttestation.Pcr it = (TpmAttestation.Pcr)element$iv;
                boolean bl3 = false;
                $this$checkSignature_u24lambda_u241.update(it.getValue().toByteArray());
            }
            byte[] digest = messageDigest.digest();
            if (!Arrays.equals(digest, attested.pcrDigest)) {
                Intrinsics.checkNotNullExpressionValue((Object)attested.pcrDigest, (String)"pcrDigest");
                String string = UtilsKt.toHexString(attested.pcrDigest);
                Intrinsics.checkNotNull((Object)digest);
                LOG.warn("PCR digest {} does not match SHA-256 hash {} over PCR list", (Object)string, (Object)UtilsKt.toHexString(digest));
            }
            if (!Arrays.equals(extraBytes = tpmsAttest.extraData, hash)) {
                Intrinsics.checkNotNull((Object)extraBytes);
                LOG.warn("The hash (extra data) in TPMS_ATTEST structure is invalid!\nextra data: {}\nhash: {}", (Object)UtilsKt.toHexString(extraBytes), (Object)UtilsKt.toHexString(hash));
                return false;
            }
            TPM_ALG_ID tpmSigAlg = tpmtSignature.sigAlg();
            int tpmSigHashAlg = 0;
            byte[] tpmSig = null;
            TPM_ALG_ID $i$f$forEach22 = tpmSigAlg;
            if (Intrinsics.areEqual((Object)$i$f$forEach22, (Object)TPM_ALG_ID.RSAPSS)) {
                TPMU_SIGNATURE tPMU_SIGNATURE = ((TPMT_SIGNATURE)tpmtSignature).signature;
                Intrinsics.checkNotNull((Object)tPMU_SIGNATURE, (String)"null cannot be cast to non-null type tss.tpm.TPMS_SIGNATURE_RSAPSS");
                tpmSigHashAlg = ((TPMS_SIGNATURE_RSAPSS)tPMU_SIGNATURE).hash.toInt();
                TPMU_SIGNATURE tPMU_SIGNATURE2 = ((TPMT_SIGNATURE)tpmtSignature).signature;
                Intrinsics.checkNotNull((Object)tPMU_SIGNATURE2, (String)"null cannot be cast to non-null type tss.tpm.TPMS_SIGNATURE_RSAPSS");
                tpmSig = ((TPMS_SIGNATURE_RSAPSS)tPMU_SIGNATURE2).sig;
            } else if (Intrinsics.areEqual((Object)$i$f$forEach22, (Object)TPM_ALG_ID.RSASSA)) {
                TPMU_SIGNATURE tPMU_SIGNATURE = ((TPMT_SIGNATURE)tpmtSignature).signature;
                Intrinsics.checkNotNull((Object)tPMU_SIGNATURE, (String)"null cannot be cast to non-null type tss.tpm.TPMS_SIGNATURE_RSASSA");
                tpmSigHashAlg = ((TPMS_SIGNATURE_RSASSA)tPMU_SIGNATURE).hash.toInt();
                TPMU_SIGNATURE tPMU_SIGNATURE3 = ((TPMT_SIGNATURE)tpmtSignature).signature;
                Intrinsics.checkNotNull((Object)tPMU_SIGNATURE3, (String)"null cannot be cast to non-null type tss.tpm.TPMS_SIGNATURE_RSASSA");
                tpmSig = ((TPMS_SIGNATURE_RSASSA)tPMU_SIGNATURE3).sig;
            } else {
                LOG.warn("Unknown or unimplemented signature scheme: " + ((TPMT_SIGNATURE)tpmtSignature).signature.getClass());
                return false;
            }
            if (tpmSigHashAlg != TPM_ALG_ID.SHA256.toInt()) {
                LOG.warn("Only SHA256withRSA TPM signature hash algorithm is allowed");
                return false;
            }
            Signature sig = Signature.getInstance("SHA256withRSA");
            sig.initVerify(certificate2.getPublicKey());
            sig.update(byteQuoted);
            boolean result = sig.verify(tpmSig);
            if (!result && LOG.isWarnEnabled()) {
                LOG.warn("Attestation signature invalid!");
            }
            bl = result;
        }
        catch (Exception ex) {
            LOG.warn("Error during attestation validation", (Throwable)ex);
            bl = false;
        }
        return bl;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\t\u00a8\u0006\n"}, d2={"Lde/fhg/aisec/ids/tpm2d/verifier/TpmVerifier$Companion;", "", "<init>", "()V", "ID", "", "LOG", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "Lorg/slf4j/Logger;", "idscp2-ra-tpm2d"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

