/*
 * Decompiled with CFR 0.152.
 */
package de.fhg.aisec.ids.tpm2d.verifier;

import de.fhg.aisec.ids.tpm2d.UtilsKt;
import de.fhg.aisec.ids.tpm2d.messages.TpmAttestation;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jose4j.base64url.Base64;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.consumer.JwtConsumer;
import org.jose4j.jwt.consumer.JwtConsumerBuilder;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0014B\u0017\b\u0016\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006B\u0011\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\u0005\u0010\tJ\u001e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\b\u0010\u0012\u001a\u00020\u0013H\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\n0\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lde/fhg/aisec/ids/tpm2d/verifier/PcrValues;", "", "pcrValues", "", "Lde/fhg/aisec/ids/tpm2d/messages/TpmAttestation$Pcr;", "<init>", "(Ljava/util/List;)V", "dat", "", "([B)V", "Lde/fhg/aisec/ids/tpm2d/verifier/PcrValues$PcrEntry;", "isTrusted", "", "goldenValues", "aType", "Lde/fhg/aisec/ids/tpm2d/messages/TpmAttestation$IdsAttestationType;", "mask", "", "toString", "", "PcrEntry", "idscp2-ra-tpm2d"})
@SourceDebugExtension(value={"SMAP\nPcrValues.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PcrValues.kt\nde/fhg/aisec/ids/tpm2d/verifier/PcrValues\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,132:1\n1557#2:133\n1628#2,3:134\n1053#2:137\n1567#2:138\n1598#2,4:139\n1863#2,2:143\n*S KotlinDebug\n*F\n+ 1 PcrValues.kt\nde/fhg/aisec/ids/tpm2d/verifier/PcrValues\n*L\n61#1:133\n61#1:134,3\n61#1:137\n85#1:138\n85#1:139,4\n113#1:143,2\n*E\n"})
public final class PcrValues {
    @NotNull
    private final List<PcrEntry> pcrValues;

    /*
     * WARNING - void declaration
     */
    public PcrValues(@NotNull List<TpmAttestation.Pcr> pcrValues) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(pcrValues, (String)"pcrValues");
        if (pcrValues.size() > 24) {
            throw new IllegalArgumentException("Invalid number of pcr registers in TpmResponse");
        }
        Iterable iterable = pcrValues;
        PcrValues pcrValues2 = this;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            TpmAttestation.Pcr pcr = (TpmAttestation.Pcr)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            int n = it.getNumber();
            byte[] byArray = it.getValue().toByteArray();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toByteArray(...)");
            collection.add(new PcrEntry(n, byArray));
        }
        Iterable $this$sortedBy$iv = (List)destination$iv$iv;
        boolean $i$f$sortedBy = false;
        pcrValues2.pcrValues = Collections.unmodifiableList(CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                PcrEntry it = (PcrEntry)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getNumber());
                it = (PcrEntry)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getNumber()));
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    public PcrValues(@NotNull byte[] dat) {
        void $this$mapIndexedTo$iv$iv;
        void $this$mapIndexed$iv;
        Intrinsics.checkNotNullParameter((Object)dat, (String)"dat");
        JwtConsumer jwtConsumer = new JwtConsumerBuilder().setSkipSignatureVerification().setSkipAllValidators().build();
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
        Charset charset2 = charset;
        JwtClaims claims = jwtConsumer.processToClaims(new String(dat, charset2));
        if (!claims.isClaimValueStringList("pcrGoldenValues")) {
            throw new IllegalArgumentException("DAT does not contain golden values");
        }
        List goldenValueList = claims.getStringListClaimValue("pcrGoldenValues");
        if (goldenValueList.size() != 24) {
            throw new IllegalArgumentException("Golden values are not complete");
        }
        Intrinsics.checkNotNull((Object)goldenValueList);
        Iterable iterable = goldenValueList;
        PcrValues pcrValues = this;
        boolean $i$f$mapIndexed = false;
        void var7_8 = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void n;
            void v;
            int n2;
            if ((n2 = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            String string = (String)item$iv$iv;
            int n3 = n2;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            byte[] byArray = Base64.decode((String)v);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"decode(...)");
            collection.add(new PcrEntry((int)n, byArray));
        }
        pcrValues.pcrValues = Collections.unmodifiableList((List)destination$iv$iv);
    }

    public final boolean isTrusted(@NotNull PcrValues goldenValues, @NotNull TpmAttestation.IdsAttestationType aType, int mask) {
        int n;
        Intrinsics.checkNotNullParameter((Object)goldenValues, (String)"goldenValues");
        Intrinsics.checkNotNullParameter((Object)((Object)aType), (String)"aType");
        switch (WhenMappings.$EnumSwitchMapping$0[aType.ordinal()]) {
            case 1: {
                n = 12;
                break;
            }
            case 2: {
                n = 24;
                break;
            }
            case 3: {
                if (mask < 1) {
                    throw new IllegalArgumentException("Requested advanced PCR comparison with invalid PCR mask");
                }
                n = Integer.bitCount(mask);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        int count = n;
        if (this.pcrValues.size() < count) {
            throw new IllegalArgumentException("Expected " + count + " PCR values, but only " + this.pcrValues.size() + " values are available.");
        }
        if (aType == TpmAttestation.IdsAttestationType.ADVANCED) {
            BigInteger bigInteger = BigInteger.valueOf(mask);
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"valueOf(...)");
            BigInteger biMask = bigInteger;
            Iterable $this$forEach$iv = this.pcrValues;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PcrEntry it = (PcrEntry)element$iv;
                boolean bl = false;
                if (!biMask.testBit(it.getNumber()) || Intrinsics.areEqual((Object)it, (Object)goldenValues.pcrValues.get(it.getNumber()))) continue;
                return false;
            }
        } else {
            for (int i = 0; i < count; ++i) {
                if (Intrinsics.areEqual((Object)this.pcrValues.get(i), (Object)goldenValues.pcrValues.get(i))) continue;
                return false;
            }
        }
        return true;
    }

    @NotNull
    public String toString() {
        return "PCR {\n" + CollectionsKt.joinToString$default((Iterable)this.pcrValues, (CharSequence)"\n", null, null, (int)0, null, PcrValues::toString$lambda$4, (int)30, null) + "\n}";
    }

    private static final CharSequence toString$lambda$4(PcrEntry it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return "pcr_" + it.getNumber() + ": " + UtilsKt.toHexString(it.getValue());
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u000f\u001a\u00020\u0003H\u0016J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lde/fhg/aisec/ids/tpm2d/verifier/PcrValues$PcrEntry;", "", "number", "", "value", "", "<init>", "(I[B)V", "getNumber", "()I", "getValue", "()[B", "equals", "", "other", "hashCode", "component1", "component2", "copy", "toString", "", "idscp2-ra-tpm2d"})
    public static final class PcrEntry {
        private final int number;
        @NotNull
        private final byte[] value;

        public PcrEntry(int number, @NotNull byte[] value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            this.number = number;
            this.value = value;
        }

        public final int getNumber() {
            return this.number;
        }

        @NotNull
        public final byte[] getValue() {
            return this.value;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            Object object = other;
            if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
                return false;
            }
            Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type de.fhg.aisec.ids.tpm2d.verifier.PcrValues.PcrEntry");
            PcrEntry cfr_ignored_0 = (PcrEntry)other;
            if (this.number != ((PcrEntry)other).number) {
                return false;
            }
            return Arrays.equals(this.value, ((PcrEntry)other).value);
        }

        public int hashCode() {
            int result = this.number;
            result = 31 * result + Arrays.hashCode(this.value);
            return result;
        }

        public final int component1() {
            return this.number;
        }

        @NotNull
        public final byte[] component2() {
            return this.value;
        }

        @NotNull
        public final PcrEntry copy(int number, @NotNull byte[] value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return new PcrEntry(number, value);
        }

        public static /* synthetic */ PcrEntry copy$default(PcrEntry pcrEntry, int n, byte[] byArray, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = pcrEntry.number;
            }
            if ((n2 & 2) != 0) {
                byArray = pcrEntry.value;
            }
            return pcrEntry.copy(n, byArray);
        }

        @NotNull
        public String toString() {
            return "PcrEntry(number=" + this.number + ", value=" + Arrays.toString(this.value) + ")";
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TpmAttestation.IdsAttestationType.values().length];
            try {
                nArray[TpmAttestation.IdsAttestationType.BASIC.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TpmAttestation.IdsAttestationType.ALL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TpmAttestation.IdsAttestationType.ADVANCED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

