/*
 * Decompiled with CFR 0.152.
 */
package de.fhg.aisec.ids.tpm2d.prover;

import de.fhg.aisec.ids.idscp2.api.drivers.RaProverDriver;
import de.fhg.aisec.ids.idscp2.api.fsm.InternalControlMessage;
import de.fhg.aisec.ids.idscp2.api.fsm.RaProverFsmListener;
import de.fhg.aisec.ids.tpm2d.TpmException;
import de.fhg.aisec.ids.tpm2d.TpmHelper;
import de.fhg.aisec.ids.tpm2d.TpmMessageFactory;
import de.fhg.aisec.ids.tpm2d.TpmSocket;
import de.fhg.aisec.ids.tpm2d.messages.TpmAttestation;
import de.fhg.aisec.ids.tpm2d.prover.TpmProverConfig;
import java.io.IOException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00122\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0012B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\n\u001a\u00020\u0002H\u0016J\u0010\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\tH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0002J\b\u0010\u0011\u001a\u00020\fH\u0016R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0002X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lde/fhg/aisec/ids/tpm2d/prover/TpmProver;", "Lde/fhg/aisec/ids/idscp2/api/drivers/RaProverDriver;", "Lde/fhg/aisec/ids/tpm2d/prover/TpmProverConfig;", "fsmListener", "Lde/fhg/aisec/ids/idscp2/api/fsm/RaProverFsmListener;", "<init>", "(Lde/fhg/aisec/ids/idscp2/api/fsm/RaProverFsmListener;)V", "queue", "Ljava/util/concurrent/BlockingQueue;", "", "config", "setConfig", "", "delegate", "message", "waitForVerifierMsg", "Lde/fhg/aisec/ids/tpm2d/messages/TpmAttestation$TpmMessage;", "run", "Companion", "idscp2-ra-tpm2d"})
public final class TpmProver
extends RaProverDriver<TpmProverConfig> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BlockingQueue<byte[]> queue;
    private TpmProverConfig config;
    @NotNull
    public static final String ID = "TPM";
    private static final Logger LOG = LoggerFactory.getLogger(TpmProver.class);

    public TpmProver(@NotNull RaProverFsmListener fsmListener) {
        Intrinsics.checkNotNullParameter((Object)fsmListener, (String)"fsmListener");
        super(fsmListener);
        this.queue = new LinkedBlockingQueue();
    }

    public void setConfig(@NotNull TpmProverConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.config = config;
        LOG.debug("TPM2d expected at " + config.getTpmHost() + ":" + config.getTpmPort());
    }

    public void delegate(@NotNull byte[] message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        if (LOG.isTraceEnabled()) {
            LOG.trace("Delegated TPM verifier message to TPM prover");
        }
        this.queue.add(message);
    }

    private final TpmAttestation.TpmMessage waitForVerifierMsg() {
        try {
            byte[] msg = this.queue.take();
            TpmAttestation.TpmMessage tpmMessage = TpmAttestation.TpmMessage.parseFrom(msg);
            Intrinsics.checkNotNullExpressionValue((Object)tpmMessage, (String)"parseFrom(...)");
            return tpmMessage;
        }
        catch (Exception e) {
            if (this.getRunning()) {
                this.getFsmListener().onRaProverMessage(InternalControlMessage.RA_PROVER_FAILED);
            }
            throw new TpmException("Interrupted or invalid message", e);
        }
    }

    public void run() {
        try {
            Object tpmSocket;
            LOG.debug("Wait for TPM challenge from RAT verifier");
            TpmAttestation.TpmMessage ratVerifierMsg = this.waitForVerifierMsg();
            if (!ratVerifierMsg.hasRatChallenge()) {
                this.getFsmListener().onRaProverMessage(InternalControlMessage.RA_PROVER_FAILED);
                throw new TpmException("Missing TPM challenge");
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Got rat challenge from rat verifier. Start TPM communication");
            }
            TpmAttestation.TpmChallenge ratChallenge = ratVerifierMsg.getRatChallenge();
            LOG.debug("Generate hash of peer's transport certificate and nonce from the TPM challenge");
            X509Certificate x509Certificate = this.getFsmListener().getRemotePeerCertificate();
            if (x509Certificate == null) {
                throw new TpmException("Peer transport certificate not available");
            }
            X509Certificate remoteTransportCert = x509Certificate;
            LOG.debug("Nonce: " + Arrays.toString(ratChallenge.getNonce().toByteArray()));
            if (LOG.isTraceEnabled()) {
                LOG.trace("Peer's certificate: " + remoteTransportCert);
            }
            byte[] byArray = ratChallenge.getNonce().toByteArray();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toByteArray(...)");
            byte[] hash = TpmHelper.INSTANCE.calculateHash(byArray, remoteTransportCert);
            TpmAttestation.IdsAttestationType idsAttestationType = ratChallenge.getAtype();
            Intrinsics.checkNotNullExpressionValue((Object)((Object)idsAttestationType), (String)"getAtype(...)");
            TpmAttestation.RemoteToTpm tpmRequest = TpmMessageFactory.INSTANCE.getRemoteToTPM2dMessage(idsAttestationType, hash, ratChallenge.hasPcrIndices() ? ratChallenge.getPcrIndices() : 0);
            try {
                LOG.debug("Send TPM request message to TPM2d");
                TpmProverConfig tpmProverConfig = this.config;
                if (tpmProverConfig == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"config");
                    tpmProverConfig = null;
                }
                String string = tpmProverConfig.getTpmHost();
                TpmProverConfig tpmProverConfig2 = this.config;
                if (tpmProverConfig2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"config");
                    tpmProverConfig2 = null;
                }
                tpmSocket = new TpmSocket(string, tpmProverConfig2.getTpmPort());
                tpmSocket = ((TpmSocket)tpmSocket).requestAttestation(tpmRequest);
            }
            catch (IOException e) {
                this.getFsmListener().onRaProverMessage(InternalControlMessage.RA_PROVER_FAILED);
                throw new TpmException("Cannot request attestation from TPM", e);
            }
            Object tpmResponse = tpmSocket;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Got TPM response, send TPM response to verifier");
            }
            byte[] response = TpmMessageFactory.INSTANCE.getAttestationResponseMessage((TpmAttestation.TpmToRemote)tpmResponse).toByteArray();
            RaProverFsmListener raProverFsmListener = this.getFsmListener();
            Intrinsics.checkNotNull((Object)response);
            raProverFsmListener.onRaProverMessage(InternalControlMessage.RA_PROVER_MSG, response);
            LOG.debug("Wait for RAT result from RAT verifier");
            ratVerifierMsg = this.waitForVerifierMsg();
            if (!ratVerifierMsg.hasRatResult()) {
                this.getFsmListener().onRaProverMessage(InternalControlMessage.RA_PROVER_FAILED);
                throw new TpmException("Missing TPM result in RAT verifier message");
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Got TPM result from TPM verifier");
            }
            if (ratVerifierMsg.getRatResult().getResult()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("TPM attestation succeed");
                }
                this.getFsmListener().onRaProverMessage(InternalControlMessage.RA_PROVER_OK);
            } else {
                if (LOG.isWarnEnabled()) {
                    LOG.warn("TPM attestation failed");
                }
                this.getFsmListener().onRaProverMessage(InternalControlMessage.RA_PROVER_FAILED);
            }
        }
        catch (Throwable t) {
            LOG.error("Error in TPM prover", t);
            throw t;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\t\u00a8\u0006\n"}, d2={"Lde/fhg/aisec/ids/tpm2d/prover/TpmProver$Companion;", "", "<init>", "()V", "ID", "", "LOG", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "Lorg/slf4j/Logger;", "idscp2-ra-tpm2d"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

