/*
 * Decompiled with CFR 0.152.
 */
package de.fhg.aisec.ids.tpm2d;

import de.fhg.aisec.ids.tpm2d.messages.TpmAttestation;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fR\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lde/fhg/aisec/ids/tpm2d/TpmSocket;", "Ljava/net/Socket;", "host", "", "port", "", "<init>", "(Ljava/lang/String;I)V", "ins", "Ljava/io/DataInputStream;", "outs", "Ljava/io/DataOutputStream;", "requestAttestation", "Lde/fhg/aisec/ids/tpm2d/messages/TpmAttestation$TpmToRemote;", "request", "Lde/fhg/aisec/ids/tpm2d/messages/TpmAttestation$RemoteToTpm;", "idscp2-ra-tpm2d"})
public final class TpmSocket
extends Socket {
    @NotNull
    private final DataInputStream ins;
    @NotNull
    private final DataOutputStream outs;

    public TpmSocket(@NotNull String host, int port) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        super(host, port);
        this.ins = new DataInputStream(this.getInputStream());
        this.outs = new DataOutputStream(this.getOutputStream());
    }

    @NotNull
    public final TpmAttestation.TpmToRemote requestAttestation(@NotNull TpmAttestation.RemoteToTpm request) throws IOException {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        byte[] requestBytes = request.toByteArray();
        this.outs.writeInt(requestBytes.length);
        this.outs.write(requestBytes);
        byte[] resultBytes = new byte[this.ins.readInt()];
        this.ins.readFully(resultBytes);
        TpmAttestation.TpmToRemote tpmToRemote = TpmAttestation.TpmToRemote.parseFrom(resultBytes);
        Intrinsics.checkNotNullExpressionValue((Object)tpmToRemote, (String)"parseFrom(...)");
        return tpmToRemote;
    }
}

