/*
 * Decompiled with CFR 0.152.
 */
package de.fhg.aisec.ids.tpm2d;

import com.google.protobuf.ByteString;
import de.fhg.aisec.ids.tpm2d.messages.TpmAttestation;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0011J\u001e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\u0015"}, d2={"Lde/fhg/aisec/ids/tpm2d/TpmMessageFactory;", "", "<init>", "()V", "getAttestationChallengeMessage", "Lde/fhg/aisec/ids/tpm2d/messages/TpmAttestation$TpmMessage;", "nonce", "", "aType", "Lde/fhg/aisec/ids/tpm2d/messages/TpmAttestation$IdsAttestationType;", "pcrIndices", "", "getAttestationResponseMessage", "response", "Lde/fhg/aisec/ids/tpm2d/messages/TpmAttestation$TpmToRemote;", "getAttestationResultMessage", "result", "", "getRemoteToTPM2dMessage", "Lde/fhg/aisec/ids/tpm2d/messages/TpmAttestation$RemoteToTpm;", "hash", "idscp2-ra-tpm2d"})
public final class TpmMessageFactory {
    @NotNull
    public static final TpmMessageFactory INSTANCE = new TpmMessageFactory();

    private TpmMessageFactory() {
    }

    @NotNull
    public final TpmAttestation.TpmMessage getAttestationChallengeMessage(@NotNull byte[] nonce, @NotNull TpmAttestation.IdsAttestationType aType, int pcrIndices) {
        Intrinsics.checkNotNullParameter((Object)nonce, (String)"nonce");
        Intrinsics.checkNotNullParameter((Object)((Object)aType), (String)"aType");
        TpmAttestation.TpmMessage tpmMessage = TpmAttestation.TpmMessage.newBuilder().setRatChallenge(TpmAttestation.TpmChallenge.newBuilder().setAtype(aType).setNonce(ByteString.copyFrom((byte[])nonce)).setPcrIndices(pcrIndices).build()).build();
        Intrinsics.checkNotNullExpressionValue((Object)tpmMessage, (String)"build(...)");
        return tpmMessage;
    }

    @NotNull
    public final TpmAttestation.TpmMessage getAttestationResponseMessage(@NotNull TpmAttestation.TpmToRemote response) {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        TpmAttestation.TpmMessage tpmMessage = TpmAttestation.TpmMessage.newBuilder().setRatResponse(TpmAttestation.TpmResponse.newBuilder().setAtype(response.getAtype()).setHashAlg(response.getHalg().name()).setQuoted(response.getQuoted()).setSignature(response.getSignature()).addAllPcrValues((Iterable<? extends TpmAttestation.Pcr>)response.getPcrValuesList()).setCertificate(response.getCertificate()).build()).build();
        Intrinsics.checkNotNullExpressionValue((Object)tpmMessage, (String)"build(...)");
        return tpmMessage;
    }

    @NotNull
    public final TpmAttestation.TpmMessage getAttestationResultMessage(boolean result) {
        TpmAttestation.TpmMessage tpmMessage = TpmAttestation.TpmMessage.newBuilder().setRatResult(TpmAttestation.TpmResult.newBuilder().setResult(result).build()).build();
        Intrinsics.checkNotNullExpressionValue((Object)tpmMessage, (String)"build(...)");
        return tpmMessage;
    }

    @NotNull
    public final TpmAttestation.RemoteToTpm getRemoteToTPM2dMessage(@NotNull TpmAttestation.IdsAttestationType aType, @NotNull byte[] hash, int pcrIndices) {
        Intrinsics.checkNotNullParameter((Object)((Object)aType), (String)"aType");
        Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
        TpmAttestation.RemoteToTpm remoteToTpm = TpmAttestation.RemoteToTpm.newBuilder().setAtype(aType).setQualifyingData(ByteString.copyFrom((byte[])hash)).setCode(TpmAttestation.RemoteToTpm.Code.ATTESTATION_REQ).setPcrs(pcrIndices).build();
        Intrinsics.checkNotNullExpressionValue((Object)remoteToTpm, (String)"build(...)");
        return remoteToTpm;
    }
}

