/*
 * Decompiled with CFR 0.152.
 */
package de.fhg.aisec.ids.tpm2d;

import java.io.Closeable;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.PKIXParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0019\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0016\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0011J\u001c\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018J\u001e\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u001dJ\u000e\u0010\u001e\u001a\u00020\u00142\u0006\u0010\u001f\u001a\u00020\u0016R\u0018\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lde/fhg/aisec/ids/tpm2d/TpmHelper;", "", "<init>", "()V", "LOG", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "Lorg/slf4j/Logger;", "sr", "Ljava/security/SecureRandom;", "generateNonce", "", "numBytes", "", "calculateHash", "nonce", "certificate", "Ljava/security/cert/Certificate;", "loadCertificatesFromTruststore", "", "Ljava/security/cert/X509Certificate;", "trustStorePath", "Ljava/nio/file/Path;", "trustStorePassword", "", "loadCertificateFromKeystore", "keyStorePath", "keyStorePassword", "keyAlias", "", "loadCertificateFromPem", "path", "idscp2-ra-tpm2d"})
public final class TpmHelper {
    @NotNull
    public static final TpmHelper INSTANCE = new TpmHelper();
    private static final Logger LOG = LoggerFactory.getLogger(TpmHelper.class);
    @NotNull
    private static final SecureRandom sr = new SecureRandom();

    private TpmHelper() {
    }

    @NotNull
    public final byte[] generateNonce(int numBytes) {
        byte[] randBytes = new byte[numBytes];
        sr.nextBytes(randBytes);
        return randBytes;
    }

    @NotNull
    public final byte[] calculateHash(@NotNull byte[] nonce, @NotNull Certificate certificate) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)nonce, (String)"nonce");
        Intrinsics.checkNotNullParameter((Object)certificate, (String)"certificate");
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-1");
            digest.update(nonce);
            digest.update(certificate.getEncoded());
            byArray = digest.digest();
        }
        catch (Exception e1) {
            LOG.error("Could not create hash of own nonce and local certificate", (Throwable)e1);
            byArray = nonce;
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final List<X509Certificate> loadCertificatesFromTruststore(@NotNull Path trustStorePath, @NotNull char[] trustStorePassword) {
        Intrinsics.checkNotNullParameter((Object)trustStorePath, (String)"trustStorePath");
        Intrinsics.checkNotNullParameter((Object)trustStorePassword, (String)"trustStorePassword");
        KeyStore keyStore = KeyStore.getInstance("PKCS12");
        Intrinsics.checkNotNullExpressionValue((Object)keyStore, (String)"getInstance(...)");
        KeyStore ks = keyStore;
        Closeable closeable = Files.newInputStream(trustStorePath, new OpenOption[0]);
        Throwable throwable = null;
        try {
            InputStream keyStoreInputStream = (InputStream)closeable;
            boolean bl = false;
            ks.load(keyStoreInputStream, trustStorePassword);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        Set<TrustAnchor> trustAnchors = new PKIXParameters(ks).getTrustAnchors();
        List<X509Certificate> list = trustAnchors.stream().map(arg_0 -> TpmHelper.loadCertificatesFromTruststore$lambda$2(TpmHelper::loadCertificatesFromTruststore$lambda$1, arg_0)).collect(Collectors.toList());
        Intrinsics.checkNotNullExpressionValue(list, (String)"collect(...)");
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final X509Certificate loadCertificateFromKeystore(@NotNull Path keyStorePath, @NotNull char[] keyStorePassword, @NotNull String keyAlias) {
        Intrinsics.checkNotNullParameter((Object)keyStorePath, (String)"keyStorePath");
        Intrinsics.checkNotNullParameter((Object)keyStorePassword, (String)"keyStorePassword");
        Intrinsics.checkNotNullParameter((Object)keyAlias, (String)"keyAlias");
        KeyStore ks = KeyStore.getInstance("PKCS12");
        Closeable closeable = Files.newInputStream(keyStorePath, new OpenOption[0]);
        Throwable throwable = null;
        try {
            InputStream keyStoreInputStream = (InputStream)closeable;
            boolean bl = false;
            ks.load(keyStoreInputStream, keyStorePassword);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        Certificate certificate = ks.getCertificate(keyAlias);
        Intrinsics.checkNotNull((Object)certificate, (String)"null cannot be cast to non-null type java.security.cert.X509Certificate");
        X509Certificate cert = (X509Certificate)certificate;
        ks.getKey(keyAlias, keyStorePassword);
        return cert;
    }

    @NotNull
    public final X509Certificate loadCertificateFromPem(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        CertificateFactory factory = CertificateFactory.getInstance("X.509");
        FileInputStream ins = new FileInputStream(path.toFile());
        Certificate certificate = factory.generateCertificate(ins);
        Intrinsics.checkNotNull((Object)certificate, (String)"null cannot be cast to non-null type java.security.cert.X509Certificate");
        return (X509Certificate)certificate;
    }

    private static final X509Certificate loadCertificatesFromTruststore$lambda$1(TrustAnchor it) {
        return it.getTrustedCert();
    }

    private static final X509Certificate loadCertificatesFromTruststore$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (X509Certificate)$tmp0.invoke(p0);
    }
}

