/*
 * Decompiled with CFR 0.152.
 */
package de.fhg.aisec.ids.snp;

import com.google.gson.Gson;
import com.google.protobuf.ByteString;
import de.fhg.aisec.ids.idscp2.api.drivers.RaVerifierDriver;
import de.fhg.aisec.ids.idscp2.api.fsm.InternalControlMessage;
import de.fhg.aisec.ids.idscp2.api.fsm.RaVerifierFsmListener;
import de.fhg.aisec.ids.snp.SnpAttestdProto;
import de.fhg.aisec.ids.snp.SnpAttestdServiceGrpcKt;
import de.fhg.aisec.ids.snp.SnpConfig;
import de.fhg.aisec.ids.snp.SnpException;
import de.fhg.aisec.ids.snp.SnpVerifierProverProto;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Base64;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.MalformedClaimException;
import org.jose4j.jwt.consumer.JwtConsumer;
import org.jose4j.jwt.consumer.JwtConsumerBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u0000 \u00142\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0014B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\tH\u0016J\u0010\u0010\u000e\u001a\u00020\f2\u0006\u0010\n\u001a\u00020\u0002H\u0016J\b\u0010\u000f\u001a\u00020\tH\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\tH\u0002J\b\u0010\u0013\u001a\u00020\fH\u0016R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0002X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lde/fhg/aisec/ids/snp/SnpVerifier;", "Lde/fhg/aisec/ids/idscp2/api/drivers/RaVerifierDriver;", "Lde/fhg/aisec/ids/snp/SnpConfig;", "fsmListener", "Lde/fhg/aisec/ids/idscp2/api/fsm/RaVerifierFsmListener;", "<init>", "(Lde/fhg/aisec/ids/idscp2/api/fsm/RaVerifierFsmListener;)V", "messages", "Ljava/util/concurrent/LinkedBlockingQueue;", "", "config", "delegate", "", "message", "setConfig", "waitForMessage", "extendPoliciesFromDat", "", "referenceValue", "run", "Companion", "idscp2-ra-snp"})
public final class SnpVerifier
extends RaVerifierDriver<SnpConfig> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LinkedBlockingQueue<byte[]> messages;
    private SnpConfig config;
    private static final Logger LOG = LoggerFactory.getLogger(SnpVerifier.class);
    @NotNull
    public static final String SNP_RA_VERIFIER_ID = "SEV-SNP";
    @NotNull
    private static final SecureRandom secureRandomInstance = new SecureRandom();

    public SnpVerifier(@NotNull RaVerifierFsmListener fsmListener) {
        Intrinsics.checkNotNullParameter((Object)fsmListener, (String)"fsmListener");
        super(fsmListener);
        this.messages = new LinkedBlockingQueue();
    }

    public void delegate(@NotNull byte[] message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.messages.add(message);
    }

    public void setConfig(@NotNull SnpConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        LOG.trace("Got config");
        this.config = config;
    }

    private final byte[] waitForMessage() {
        try {
            byte[] byArray = this.messages.take();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"take(...)");
            return byArray;
        }
        catch (Exception e) {
            if (this.getRunning()) {
                this.getFsmListener().onRaVerifierMessage(InternalControlMessage.RA_VERIFIER_FAILED);
            }
            throw new SnpException("Failed to obtain a message from the prover.", e);
        }
    }

    private final String extendPoliciesFromDat(byte[] referenceValue) {
        Pair[] pairArray;
        JwtConsumer jwtConsumer = new JwtConsumerBuilder().setSkipSignatureVerification().setSkipAllValidators().build();
        byte[] byArray = this.getFsmListener().getRemotePeerDat().getBytes();
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
        Charset charset2 = charset;
        JwtClaims claims = jwtConsumer.processToClaims(new String(byArray, charset2));
        try {
            pairArray = TypeIntrinsics.asMutableList((Object)claims.getClaimValue("snpPolicies", List.class));
        }
        catch (MalformedClaimException e) {
            throw new SnpException("Could not parse the SNP policies from the DAT", e);
        }
        if (pairArray == null) {
            throw new SnpException("The DAT does not contain any SEV-SNP policies", null, 2, null);
        }
        Pair[] snpPolicies = pairArray;
        byte[] extendedReferenceValue = new byte[64];
        ArraysKt.copyInto$default((byte[])referenceValue, (byte[])extendedReferenceValue, (int)0, (int)0, (int)0, (int)14, null);
        pairArray = new Pair[3];
        pairArray[0] = TuplesKt.to((Object)"type", (Object)"equals");
        pairArray[1] = TuplesKt.to((Object)"id", (Object)"Report Data matches expected value");
        Pair[] pairArray2 = new Pair[]{TuplesKt.to((Object)"field", (Object)"REPORT_DATA"), TuplesKt.to((Object)"referenceValue", (Object)Base64.getEncoder().encodeToString(extendedReferenceValue))};
        pairArray[2] = TuplesKt.to((Object)"params", (Object)MapsKt.mapOf((Pair[])pairArray2));
        snpPolicies.add(MapsKt.mapOf((Pair[])pairArray));
        String string = new Gson().toJson((Object)snpPolicies);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toJson(...)");
        return string;
    }

    public void run() {
        SnpAttestdProto.VerifyResponse verifyResponse2;
        SnpVerifierProverProto.ProverResponse proverResponse;
        if (this.getFsmListener().getRemotePeerCertificate() == null) {
            this.getFsmListener().onRaVerifierMessage(InternalControlMessage.RA_VERIFIER_FAILED);
            throw new SnpException("SNP Remote attestation requires the peer certificate to be present.", null, 2, null);
        }
        LOG.debug("Starting the attestation process");
        byte[] nonce = Companion.getNonce(32);
        SnpVerifierProverProto.VerifierChallenge verifierChallenge = SnpVerifierProverProto.VerifierChallenge.newBuilder().setNonce(ByteString.copyFrom((byte[])nonce)).build();
        RaVerifierFsmListener raVerifierFsmListener = this.getFsmListener();
        byte[] byArray = verifierChallenge.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toByteArray(...)");
        raVerifierFsmListener.onRaVerifierMessage(InternalControlMessage.RA_VERIFIER_MSG, byArray);
        byte[] proverResponseBytes = this.waitForMessage();
        LOG.trace("Got a response message from the prover");
        try {
            proverResponse = SnpVerifierProverProto.ProverResponse.parseFrom(proverResponseBytes);
        }
        catch (Exception e) {
            this.getFsmListener().onRaVerifierMessage(InternalControlMessage.RA_VERIFIER_FAILED);
            throw new SnpException("Got an unexpected or invalid message from the prover. Expected a prover challenge response.", e);
        }
        SnpVerifierProverProto.ProverResponse proverResponse2 = proverResponse;
        MessageDigest md = MessageDigest.getInstance("SHA3-512");
        md.update(nonce);
        SnpConfig snpConfig = this.config;
        if (snpConfig == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"config");
            snpConfig = null;
        }
        md.update(snpConfig.getCertificate().getEncoded());
        X509Certificate x509Certificate = this.getFsmListener().getRemotePeerCertificate();
        Intrinsics.checkNotNull((Object)x509Certificate);
        md.update(x509Certificate.getEncoded());
        byte[] digest = md.digest();
        Intrinsics.checkNotNull((Object)digest);
        String policies = this.extendPoliciesFromDat(digest);
        SnpAttestdProto.VerifyRequest verifyRequest = SnpAttestdProto.VerifyRequest.newBuilder().setReport(proverResponse2.getReport()).setVcekCert(proverResponse2.getVcek()).setPolicies(policies).build();
        try {
            verifyResponse2 = (SnpAttestdProto.VerifyResponse)BuildersKt.runBlocking((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super SnpAttestdProto.VerifyResponse>, Object>(this, verifyRequest, null){
                Object L$0;
                int label;
                final /* synthetic */ SnpVerifier this$0;
                final /* synthetic */ SnpAttestdProto.VerifyRequest $verifyRequest;
                {
                    this.this$0 = $receiver;
                    this.$verifyRequest = $verifyRequest;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                public final Object invokeSuspend(Object var1_1) {
                    var5_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            v0 = SnpVerifier.access$getConfig$p(this.this$0);
                            if (v0 == null) {
                                Intrinsics.throwUninitializedPropertyAccessException((String)"config");
                                v0 = null;
                            }
                            v1 = v0.getSnpAttestdHost();
                            v2 = SnpVerifier.access$getConfig$p(this.this$0);
                            if (v2 == null) {
                                Intrinsics.throwUninitializedPropertyAccessException((String)"config");
                                v2 = null;
                            }
                            channel = ManagedChannelBuilder.forAddress((String)v1, (int)v2.getSnpAttestdPort()).usePlaintext().build();
                            Intrinsics.checkNotNull((Object)channel);
                            v3 = new SnpAttestdServiceGrpcKt.SnpAttestdServiceCoroutineStub((Channel)channel, null, 2, null);
                            var4_4 = this.$verifyRequest;
                            Intrinsics.checkNotNull((Object)var4_4);
                            this.L$0 = channel;
                            this.label = 1;
                            v4 = SnpAttestdServiceGrpcKt.SnpAttestdServiceCoroutineStub.verifyReport$default(v3, var4_4, null, (Continuation)this, 2, null);
                            if (v4 == var5_2) {
                                return var5_2;
                            }
                            ** GOTO lbl29
                        }
                        case 1: {
                            channel = (ManagedChannel)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v4 = $result;
lbl29:
                            // 2 sources

                            verificationResponse = (SnpAttestdProto.VerifyResponse)v4;
                            channel.shutdown().awaitTermination(5L, TimeUnit.SECONDS);
                            return verificationResponse;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super SnpAttestdProto.VerifyResponse> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }));
        }
        catch (Exception e) {
            this.getFsmListener().onRaVerifierMessage(InternalControlMessage.RA_VERIFIER_FAILED);
            throw new SnpException("Error communicating with snp-attestd", e);
        }
        SnpAttestdProto.VerifyResponse verifyResponse3 = verifyResponse2;
        LOG.trace("Got a verification result from snp-attestd");
        SnpVerifierProverProto.VerifierResult verifierResult = SnpVerifierProverProto.VerifierResult.newBuilder().setOk(verifyResponse3.getOk()).build();
        RaVerifierFsmListener raVerifierFsmListener2 = this.getFsmListener();
        byte[] byArray2 = verifierResult.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"toByteArray(...)");
        raVerifierFsmListener2.onRaVerifierMessage(InternalControlMessage.RA_VERIFIER_MSG, byArray2);
        if (verifyResponse3.getOk()) {
            LOG.debug("Attestation succeeded");
            this.getFsmListener().onRaVerifierMessage(InternalControlMessage.RA_VERIFIER_OK);
        } else {
            LOG.debug("Attestation failed");
            this.getFsmListener().onRaVerifierMessage(InternalControlMessage.RA_VERIFIER_FAILED);
        }
    }

    public static final /* synthetic */ SnpConfig access$getConfig$p(SnpVerifier $this) {
        return $this.config;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fR\u0018\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lde/fhg/aisec/ids/snp/SnpVerifier$Companion;", "", "<init>", "()V", "LOG", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "Lorg/slf4j/Logger;", "SNP_RA_VERIFIER_ID", "", "secureRandomInstance", "Ljava/security/SecureRandom;", "getNonce", "", "len", "", "idscp2-ra-snp"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final byte[] getNonce(int len) {
            byte[] bytes = new byte[len];
            secureRandomInstance.nextBytes(bytes);
            return bytes;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

