/*
 * Decompiled with CFR 0.152.
 */
package de.fhg.aisec.ids.snp;

import com.google.protobuf.ByteString;
import de.fhg.aisec.ids.idscp2.api.drivers.RaProverDriver;
import de.fhg.aisec.ids.idscp2.api.fsm.InternalControlMessage;
import de.fhg.aisec.ids.idscp2.api.fsm.RaProverFsmListener;
import de.fhg.aisec.ids.snp.SnpAttestdProto;
import de.fhg.aisec.ids.snp.SnpAttestdServiceGrpcKt;
import de.fhg.aisec.ids.snp.SnpConfig;
import de.fhg.aisec.ids.snp.SnpException;
import de.fhg.aisec.ids.snp.SnpVerifierProverProto;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import java.security.MessageDigest;
import java.security.cert.X509Certificate;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u0000 \u00112\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0011B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\tH\u0016J\u0010\u0010\u000e\u001a\u00020\f2\u0006\u0010\n\u001a\u00020\u0002H\u0016J\b\u0010\u000f\u001a\u00020\tH\u0002J\b\u0010\u0010\u001a\u00020\fH\u0016R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0002X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lde/fhg/aisec/ids/snp/SnpProver;", "Lde/fhg/aisec/ids/idscp2/api/drivers/RaProverDriver;", "Lde/fhg/aisec/ids/snp/SnpConfig;", "fsmListener", "Lde/fhg/aisec/ids/idscp2/api/fsm/RaProverFsmListener;", "<init>", "(Lde/fhg/aisec/ids/idscp2/api/fsm/RaProverFsmListener;)V", "messages", "Ljava/util/concurrent/LinkedBlockingQueue;", "", "config", "delegate", "", "message", "setConfig", "waitForMessage", "run", "Companion", "idscp2-ra-snp"})
public final class SnpProver
extends RaProverDriver<SnpConfig> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LinkedBlockingQueue<byte[]> messages;
    private SnpConfig config;
    private static final Logger LOG = LoggerFactory.getLogger(SnpProver.class);
    @NotNull
    public static final String SNP_RA_PROVER_ID = "SEV-SNP";

    public SnpProver(@NotNull RaProverFsmListener fsmListener) {
        Intrinsics.checkNotNullParameter((Object)fsmListener, (String)"fsmListener");
        super(fsmListener);
        this.messages = new LinkedBlockingQueue();
    }

    public void delegate(@NotNull byte[] message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.messages.add(message);
    }

    public void setConfig(@NotNull SnpConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        LOG.trace("Got config");
        this.config = config;
    }

    private final byte[] waitForMessage() {
        try {
            byte[] byArray = this.messages.take();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"take(...)");
            return byArray;
        }
        catch (Exception e) {
            if (this.getRunning()) {
                this.getFsmListener().onRaProverMessage(InternalControlMessage.RA_PROVER_FAILED);
            }
            throw new SnpException("Failed to obtain a message from the verifier.", e);
        }
    }

    public void run() {
        SnpVerifierProverProto.VerifierResult verifierResult;
        SnpAttestdProto.ReportResponse reportResponse2;
        SnpVerifierProverProto.VerifierChallenge verifierChallenge;
        if (this.getFsmListener().getRemotePeerCertificate() == null) {
            this.getFsmListener().onRaProverMessage(InternalControlMessage.RA_PROVER_FAILED);
            throw new SnpException("SNP Remote attestation requires the peer certificate to be present.", null, 2, null);
        }
        LOG.debug("Started the attestation process");
        byte[] verifierChallengeBytes = this.waitForMessage();
        LOG.trace("Got a challenge from the verifier");
        try {
            verifierChallenge = SnpVerifierProverProto.VerifierChallenge.parseFrom(verifierChallengeBytes);
        }
        catch (Exception e) {
            this.getFsmListener().onRaProverMessage(InternalControlMessage.RA_PROVER_FAILED);
            throw new SnpException("Encountered unexpected or invalid message from verifier. Expected a verifier challenge.", e);
        }
        SnpVerifierProverProto.VerifierChallenge verifierChallenge2 = verifierChallenge;
        MessageDigest md = MessageDigest.getInstance("SHA3-512");
        md.update(verifierChallenge2.getNonce().toByteArray());
        X509Certificate x509Certificate = this.getFsmListener().getRemotePeerCertificate();
        Intrinsics.checkNotNull((Object)x509Certificate);
        md.update(x509Certificate.getEncoded());
        SnpConfig snpConfig = this.config;
        if (snpConfig == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"config");
            snpConfig = null;
        }
        md.update(snpConfig.getCertificate().getEncoded());
        byte[] digest = md.digest();
        SnpAttestdProto.ReportRequest reportRequest = SnpAttestdProto.ReportRequest.newBuilder().setReportData(ByteString.copyFrom((byte[])digest)).setIncludeVcekCert(true).build();
        try {
            reportResponse2 = (SnpAttestdProto.ReportResponse)BuildersKt.runBlocking((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super SnpAttestdProto.ReportResponse>, Object>(this, reportRequest, null){
                Object L$0;
                int label;
                final /* synthetic */ SnpProver this$0;
                final /* synthetic */ SnpAttestdProto.ReportRequest $reportRequest;
                {
                    this.this$0 = $receiver;
                    this.$reportRequest = $reportRequest;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                public final Object invokeSuspend(Object var1_1) {
                    var5_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            v0 = SnpProver.access$getConfig$p(this.this$0);
                            if (v0 == null) {
                                Intrinsics.throwUninitializedPropertyAccessException((String)"config");
                                v0 = null;
                            }
                            v1 = v0.getSnpAttestdHost();
                            v2 = SnpProver.access$getConfig$p(this.this$0);
                            if (v2 == null) {
                                Intrinsics.throwUninitializedPropertyAccessException((String)"config");
                                v2 = null;
                            }
                            channel = ManagedChannelBuilder.forAddress((String)v1, (int)v2.getSnpAttestdPort()).usePlaintext().build();
                            Intrinsics.checkNotNull((Object)channel);
                            v3 = new SnpAttestdServiceGrpcKt.SnpAttestdServiceCoroutineStub((Channel)channel, null, 2, null);
                            var4_4 = this.$reportRequest;
                            Intrinsics.checkNotNull((Object)var4_4);
                            this.L$0 = channel;
                            this.label = 1;
                            v4 = SnpAttestdServiceGrpcKt.SnpAttestdServiceCoroutineStub.getReport$default(v3, var4_4, null, (Continuation)this, 2, null);
                            if (v4 == var5_2) {
                                return var5_2;
                            }
                            ** GOTO lbl29
                        }
                        case 1: {
                            channel = (ManagedChannel)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v4 = $result;
lbl29:
                            // 2 sources

                            attestationResponse = (SnpAttestdProto.ReportResponse)v4;
                            channel.shutdown().awaitTermination(5L, TimeUnit.SECONDS);
                            return attestationResponse;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super SnpAttestdProto.ReportResponse> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }));
        }
        catch (Exception e) {
            this.getFsmListener().onRaProverMessage(InternalControlMessage.RA_PROVER_FAILED);
            throw new SnpException("Error while communicating with the snp-attestd instance.", e);
        }
        SnpAttestdProto.ReportResponse reportResponse3 = reportResponse2;
        LOG.trace("Got an Attestation Report from snp-attestd");
        SnpVerifierProverProto.ProverResponse proverResponse = SnpVerifierProverProto.ProverResponse.newBuilder().setReport(reportResponse3.getReport()).setVcek(reportResponse3.getVcekCert()).build();
        RaProverFsmListener raProverFsmListener = this.getFsmListener();
        byte[] byArray = proverResponse.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toByteArray(...)");
        raProverFsmListener.onRaProverMessage(InternalControlMessage.RA_PROVER_MSG, byArray);
        byte[] verifierResultBytes = this.waitForMessage();
        LOG.trace("Got a response from the verifier");
        try {
            verifierResult = SnpVerifierProverProto.VerifierResult.parseFrom(verifierResultBytes);
        }
        catch (Exception e) {
            this.getFsmListener().onRaProverMessage(InternalControlMessage.RA_PROVER_FAILED);
            throw new SnpException("Got an unexpected or invalid message from the verifier. Expected a verifier result message.", e);
        }
        SnpVerifierProverProto.VerifierResult verifierResult2 = verifierResult;
        if (verifierResult2.getOk()) {
            LOG.debug("Attestation succeeded");
            this.getFsmListener().onRaProverMessage(InternalControlMessage.RA_PROVER_OK);
        } else {
            LOG.debug("Attestation failed");
            this.getFsmListener().onRaProverMessage(InternalControlMessage.RA_PROVER_FAILED);
        }
    }

    public static final /* synthetic */ SnpConfig access$getConfig$p(SnpProver $this) {
        return $this.config;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0018\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lde/fhg/aisec/ids/snp/SnpProver$Companion;", "", "<init>", "()V", "LOG", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "Lorg/slf4j/Logger;", "SNP_RA_PROVER_ID", "", "idscp2-ra-snp"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

